 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


NvV32
grChangeState (NvDeviceInfo *device, int state)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               status = 0;

	;
	switch (state)
	{
		case 3:;
			break;
		case 1:
			(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] = (NvV32) (0x0);
			(hwreg)->Reg32[(NV_PGRAPH_DEBUG_1) / 4] =
				(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
			(hwreg)->Reg32[(NV_PGRAPH_DEBUG_0) / 4] =
				(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
			(hwreg)->Reg32[(NV_PGRAPH_DEBUG_1) / 4] =
				(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_DEBUG_1) /
							4]) & ~((0xFFFFFFFF >> (31 -
								((1 ? 4 : 4) % 32) +
								((0 ? 4 : 4) %
									32))) << ((0 ? 4 : 4) %
							32))) | ((0x00000001) << ((0 ? 4 : 4) %
						32)));
			(hwreg)->Reg32[(NV_PGRAPH_DEBUG_0) / 4] =
				(NvV32) (hwdev->info.Graphics.Debug0);
			(hwreg)->Reg32[(NV_PGRAPH_DEBUG_1) / 4] =
				(NvV32) (hwdev->info.Graphics.Debug1);
			(hwreg)->Reg32[(NV_PGRAPH_DEBUG_2) / 4] =
				(NvV32) (hwdev->info.Graphics.Debug2);
			(hwreg)->Reg32[(NV_PGRAPH_DEBUG_3) / 4] =
				(NvV32) (hwdev->info.Graphics.Debug3);
			(hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH1) / 4] = (NvV32) (0);
			(hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH1) / 4] = (NvV32) (0);
			(hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH1) / 4] = (NvV32) (0);
			(hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH1) / 4] = (NvV32) (0);
			(hwreg)->Reg32[(NV_PGRAPH_CTX_CONTROL) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 1 : 0) %
						32)) | ((NV_PMC_BOOT_0) << ((0 ? 8 : 8) %
						32)) | ((NV_PMC_BOOT_0) << ((0 ? 16 : 16) %
						32)) | ((NV_PMC_BOOT_0) << ((0 ? 24 : 24) %
						32)) | ((0x00000001) << ((0 ? 28 : 28) % 32)));
			(hwreg)->Reg32[(NV_PGRAPH_FFINTFC_ST2) / 4] =
				(NvV32) (((0x00000001) << ((0 ? 19 : 19) % 32)));
			grLoadChannelContext (device, hwdev->info.Graphics.CurrentChID);
			(hwreg)->Reg32[(NV_PGRAPH_INTR) / 4] = (NvV32) (0x11111111);
			(hwreg)->Reg32[(NV_PGRAPH_INTR_EN) / 4] = (NvV32) (0x11111111);
			hwdev->info.Graphics.Enabled = 1;
			break;
		case 2:
			if (hwdev->info.Graphics.Enabled == 1)
			{
				hwdev->info.Graphics.Enabled = 0;
				grLoadChannelContext (device, (-1));
				(hwreg)->Reg32[(NV_PGRAPH_CTX_CONTROL) / 4] =
					(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 1 : 0) %
							32)) | ((NV_PMC_BOOT_0) << ((0 ? 8 : 8) %
							32)) | ((NV_PMC_BOOT_0) << ((0 ? 16 : 16) %
							32)) | ((NV_PMC_BOOT_0) << ((0 ? 24 : 24) %
							32)) | ((0x00000001) << ((0 ? 28 : 28) %
							32)));
				(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] = (NvV32) (0);
				(hwreg)->Reg32[(NV_PGRAPH_INTR_EN) / 4] = (NvV32) (0);
			}
			break;
		case 0:
			grInit (device);
			break;
		case 4:
			break;
	}
	return status;
}
