 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


extern NvV32        mthdUnimplemented (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdGrNoOperation (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdGrResend (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdGrRenderResend (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaNotifies (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaScaledImage (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaTexture (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaA (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaB (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        nvFunc539 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        nvFunc536 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        nvFunc537 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextSurfaces2d (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextSurfaces3d (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextClipRectangle (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextColorKey (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextPattern (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextRop (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextBeta1 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetColorFormat (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetMonochromeFormat (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetOperation (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdGrNotify (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaBufferIn (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaBufferOut (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderLin (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderTriangle (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdDx3Control0 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderRectangle (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdImageBlt (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdImageTransfer (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdMemoryToMemoryFormat (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderDx3TexturedTriangle (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderGdiRectangleText (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdImageFromMem (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern int          grRenderObjectValidForRendering (EngineObj *engObj);
extern int          grRenderObjectValidForHardware (EngineObj *engObj);
extern int          grImageBlitValidForRendering (EngineObj *engObj);
extern int          grImageBlitValidForHardware (EngineObj *engObj);
extern int          grImageObjectValidForRendering (EngineObj *engObj);
extern int          grImageObjectValidForHardware (EngineObj *engObj);
extern int          grImageFromMemValidForRendering (EngineObj *engObj);
extern int          grImageFromMemValidForHardware (EngineObj *engObj);
extern int          grMemoryToMemoryFormatValidForHardware (EngineObj *engObj);
extern int          grContextObjectValidForHardware (EngineObj *engObj);
extern int          grDx3TexturedTriangleValidForRendering (EngineObj *engObj);
extern int          grDx3TexturedTriangleValidForHardware (EngineObj *engObj);
extern int          grGdiRectObjectValidForRendering (EngineObj *engObj);
extern int          grGdiRectObjectValidForHardware (EngineObj *engObj);
extern void         grValidateObject (EngineObj *obj);
NvV32
grAttachObject (EngineObj *engObj)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	EngineObjInfo      *engObjInfo = ((engObj)->base.classInfo->objectInfo);
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	int                 chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               instMemLoc;
	NvV32               instMemSize;
	NvV32               status;

	;
	if (engObjInfo->channelAllocMask && (hwchan->allocMask & engObjInfo->channelAllocMask))
	{
		;
		return 2;
	}
	instMemSize = 1;
	status = fbAllocInstMem (device, &instMemLoc, &instMemSize, 0);
	if (status != 0)
	{
		;
		return 2;
	}
	if (((hwdev->info.Chip.Architecture > 0x00000004)
			|| (hwdev->info.Chip.Architecture == 0x00000004
				&& hwdev->info.Chip.MaskRevision >= 0x00000001)))
	{
		engObjInfo->instanceMem[0] |= ((0x00000001) << ((0 ? 24 : 24) % 32));
	}
	(hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((instMemLoc) << 4) + ((((0 ? (0 * 32 +
									31) : (0 * 32 +
									0)) / 32) << 2)))) / 4] =
		(NvV32) ((engObjInfo->instanceMem[0]));
	(hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((instMemLoc) << 4) + ((((0 ? (1 * 32 +
									31) : (1 * 32 +
									0)) / 32) << 2)))) / 4] =
		(NvV32) ((engObjInfo->instanceMem[1]));
	(hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((instMemLoc) << 4) + ((((0 ? (2 * 32 +
									31) : (2 * 32 +
									0)) / 32) << 2)))) / 4] =
		(NvV32) ((engObjInfo->instanceMem[2]));
	engObj->instMemLoc = instMemLoc;
	;
	engObj->context =
		engObjInfo->hashContextMask | (((instMemLoc) & (0xFFFFFFFF >> (31 - (1 ? (1 * 32 +
							15) : (1 * 32 + 0)) + (0 ? (1 * 32 +
							15) : (1 * 32 + 0))))) << ((0 ? (1 * 32 +
					15) : (1 * 32 + 0)) & 31)) | (((chid) & (0xFFFFFFFF >> (31 -
					(1 ? (1 * 32 + 27) : (1 * 32 + 24)) + (0 ? (1 * 32 +
							27) : (1 * 32 + 24))))) << ((0 ? (1 * 32 +
					27) : (1 * 32 + 24)) & 31));
	engObj->hashEntry = (~0);
	engObj->notifyCtxDma = (void *) 0;
	hwchan->allocMask |= engObjInfo->channelAllocMask;
	fifoAddHashEntry (device, engObj);
	return 0;
}

NvV32
grDetachObject (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	EngineObjInfo      *engObjInfo = ((engObj)->base.classInfo->objectInfo);
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	int                 chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];

	;
	;
	if (engObj->base.refcnt > 0)
	{
		;
		return 5;
	}
	;
	fifoRemoveHashEntry (device, engObj);
	fbFreeInstMem (device, engObj->instMemLoc, 1);
	fifoRemoveObjectFromSubChannelCache (engObj);
	if (engObjInfo->channelAllocMask)
	{
		hwchan->allocMask &= ~engObjInfo->channelAllocMask;
	}
	if (engObj->notifyCtxDma)
	{
		engObj->notifyCtxDma->base.refcnt--;
		;
		engObj->notifyCtxDma = (void *) 0;
	}
	return 0;
}

NvV32
grAttachContextColorKey (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               chID = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chID];
	NvV32               status;

	;
	if ((status = grAttachObject (engObj)) != 0)
	{
		;
		return status;
	}
	if (chID == hwdev->info.Graphics.CurrentChID)
	{
		while ((volatile) ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]))
		{
			NvU32               pmc;

			pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);
			if (pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
			{
				grService (device);
			}
		};
		(hwreg)->Reg32[(NV_PGRAPH_CHROMA) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 16 : 16) % 32) +
							((0 ? 16 : 16) % 32))) << ((0 ? 16 : 16) %
						32))) | ((0x00000001) << ((0 ? 16 : 16) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 17 : 17) % 32) +
							((0 ? 17 : 17) % 32))) << ((0 ? 17 : 17) %
						32))) | ((0x00000001) << ((0 ? 17 : 17) % 32)));
		;
	}
	else
	{
		hwchan->gr.chroma = 0;
		hwchan->gr.state |=
			(((0x00000001) << ((0 ? 16 : 16) % 32)) | ((0x00000001) << ((0 ? 17 : 17) %
					32)));
		;
	}
	return status;
}

NvV32
grDetachContextColorKey (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               chID = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chID];

	;
	if (chID == hwdev->info.Graphics.CurrentChID)
	{
		while ((volatile) ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]))
		{
			NvU32               pmc;

			pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);
			if (pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
			{
				grService (device);
			}
		};
		(hwreg)->Reg32[(NV_PGRAPH_CHROMA) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 16 : 16) % 32) +
							((0 ? 16 : 16) % 32))) << ((0 ? 16 : 16) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 16 : 16) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 17 : 17) % 32) +
							((0 ? 17 : 17) % 32))) << ((0 ? 17 : 17) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 17 : 17) % 32)));
	}
	else
	{
		hwchan->gr.chroma = 0;
		hwchan->gr.state &=
			~(((0x00000001) << ((0 ? 16 : 16) % 32)) | ((0x00000001) << ((0 ? 17 : 17) %
					32)));
		;
	}
	return grDetachObject (genObj);
}
static MethodInfo   Nv01ContextColorKeyMethods[] = {
	{mthdGrResend, "NoOperation", 0x100, 0x103}, {mthdGrResend, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183}, {mthdGrResend,
			"SetColorFormat", 0x300, 0x303}, {mthdGrResend, "SetColor", 0x304, 0x307},
};
EngineObjInfo       Nv01ContextColorKeyEngineObjInfo = {
	((0x00000001) << ((0 ? (1 * 32 + 17) : (1 * 32 + 16)) & 31)), 0x0002, {0x00000017,
			NV_PMC_ENABLE, 0x0}, grContextObjectValidForHardware
};
ClassInfo           Nv01ContextColorKeyClassInfo = {
	(0x00000017), "context color key", sizeof (EngineObj), 0x1, 1,
		&Nv01ContextColorKeyEngineObjInfo, (void *) 0, (void *) 0, grAttachContextColorKey,
		(void *) 0, (void *) 0, grDetachContextColorKey, (void *) 0, 0, (void *) 0,
		(sizeof (Nv01ContextColorKeyMethods) / sizeof (Nv01ContextColorKeyMethods[0])),
		Nv01ContextColorKeyMethods
};
NvV32
grAttachContextBeta (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               chID = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chID];
	NvV32               status;

	;
	if ((status = grAttachObject (engObj)) != 0)
	{
		;
		return status;
	}
	if (chID == hwdev->info.Graphics.CurrentChID)
	{
		while ((volatile) ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]))
		{
			NvU32               pmc;

			pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);
			if (pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
			{
				grService (device);
			}
		};
		(hwreg)->Reg32[(NV_PGRAPH_BETA_AND) / 4] = (NvV32) (0);
	}
	else
	{
		hwchan->gr.beta_and = 0;
	}
	return status;
}
static MethodInfo   Nv01ContextBetaMethods[] = {
	{mthdGrResend, "NoOperation", 0x100, 0x103}, {mthdGrResend, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183}, {mthdGrResend,
			"SetBeta1d31", 0x300, 0x303},
};
EngineObjInfo       Nv01ContextBeta1EngineObjInfo = {
	((0x00000001) << ((0 ? (1 * 32 + 17) : (1 * 32 + 16)) & 31)), 0x0001, {0x00000012, 0x0,
			0x0}, grContextObjectValidForHardware
};
ClassInfo           Nv01ContextBeta1ClassInfo = {
	(0x00000012), "context beta", sizeof (EngineObj), 0x1, 1, &Nv01ContextBeta1EngineObjInfo,
		(void *) 0, (void *) 0, grAttachContextBeta, (void *) 0, (void *) 0, grDetachObject,
		(void *) 0, 0, (void *) 0,
		(sizeof (Nv01ContextBetaMethods) / sizeof (Nv01ContextBetaMethods[0])),
		Nv01ContextBetaMethods
};
NvV32
grAttachContextPattern (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               chID = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chID];
	NvV32               status;

	;
	if ((status = grAttachObject (engObj)) != 0)
	{
		;
		return status;
	}
	if (chID == hwdev->info.Graphics.CurrentChID)
	{
		while ((volatile) ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]))
		{
			NvU32               pmc;

			pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);
			if (pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
			{
				grService (device);
			}
		};
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 20 : 20) % 32) +
							((0 ? 20 : 20) % 32))) << ((0 ? 20 : 20) %
						32))) | ((0x00000001) << ((0 ? 20 : 20) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 21 : 21) % 32) +
							((0 ? 21 : 21) % 32))) << ((0 ? 21 : 21) %
						32))) | ((0x00000001) << ((0 ? 21 : 21) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_PATTERN_SHAPE) / 4] = (NvV32) (NV_PMC_BOOT_0);
		(hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR0) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 24 : 24) % 32) +
							((0 ? 24 : 24) % 32))) << ((0 ? 24 : 24) %
						32))) | ((0x00000001) << ((0 ? 24 : 24) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR1) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 25 : 25) % 32) +
							((0 ? 25 : 25) % 32))) << ((0 ? 25 : 25) %
						32))) | ((0x00000001) << ((0 ? 25 : 25) % 32)));
		(hwreg)->Reg32[((0x00400808 + (0) * 4)) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 26 : 26) % 32) +
							((0 ? 26 : 26) % 32))) << ((0 ? 26 : 26) %
						32))) | ((0x00000001) << ((0 ? 26 : 26) % 32)));
		(hwreg)->Reg32[((0x00400808 + (1) * 4)) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 27 : 27) % 32) +
							((0 ? 27 : 27) % 32))) << ((0 ? 27 : 27) %
						32))) | ((0x00000001) << ((0 ? 27 : 27) % 32)));
	}
	else
	{
		hwchan->gr.state |=
			(((0x00000001) << ((0 ? 20 : 20) % 32)) | ((0x00000001) << ((0 ? 21 : 21) %
					32)));
		hwchan->gr.pattern_shape = NV_PMC_BOOT_0;
		hwchan->gr.patt_color0 = 0;
		hwchan->gr.patt_color1 = 0;
		hwchan->gr.pattern[0] = 0;
		hwchan->gr.pattern[1] = 0;
		hwchan->gr.state |=
			(((0x00000001) << ((0 ? 24 : 24) % 32)) | ((0x00000001) << ((0 ? 25 : 25) %
					32)) | ((0x00000001) << ((0 ? 26 : 26) %
					32)) | ((0x00000001) << ((0 ? 27 : 27) % 32)));
	}
	return status;
}

NvV32
grDetachContextPattern (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               chID = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chID];

	;
	if (chID == hwdev->info.Graphics.CurrentChID)
	{
		while ((volatile) ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]))
		{
			NvU32               pmc;

			pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);
			if (pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
			{
				grService (device);
			}
		};
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 20 : 20) % 32) +
							((0 ? 20 : 20) % 32))) << ((0 ? 20 : 20) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 20 : 20) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 21 : 21) % 32) +
							((0 ? 21 : 21) % 32))) << ((0 ? 21 : 21) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 21 : 21) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_PATTERN_SHAPE) / 4] = (NvV32) (NV_PMC_BOOT_0);
		(hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR0) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 24 : 24) % 32) +
							((0 ? 24 : 24) % 32))) << ((0 ? 24 : 24) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 24 : 24) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR1) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 25 : 25) % 32) +
							((0 ? 25 : 25) % 32))) << ((0 ? 25 : 25) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 25 : 25) % 32)));
		(hwreg)->Reg32[((0x00400808 + (0) * 4)) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 26 : 26) % 32) +
							((0 ? 26 : 26) % 32))) << ((0 ? 26 : 26) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 26 : 26) % 32)));
		(hwreg)->Reg32[((0x00400808 + (1) * 4)) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 27 : 27) % 32) +
							((0 ? 27 : 27) % 32))) << ((0 ? 27 : 27) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 27 : 27) % 32)));
	}
	else
	{
		hwchan->gr.state &=
			~(((0x00000001) << ((0 ? 20 : 20) % 32)) | ((0x00000001) << ((0 ? 21 : 21) %
					32)));
		hwchan->gr.pattern_shape = NV_PMC_BOOT_0;
		hwchan->gr.patt_color0 = 0;
		hwchan->gr.patt_color1 = 0;
		hwchan->gr.pattern[0] = 0;
		hwchan->gr.pattern[1] = 0;
		hwchan->gr.state &=
			~(((0x00000001) << ((0 ? 24 : 24) % 32)) | ((0x00000001) << ((0 ? 25 : 25) %
					32)) | ((0x00000001) << ((0 ? 26 : 26) %
					32)) | ((0x00000001) << ((0 ? 27 : 27) % 32)));
	}
	return grDetachObject (genObj);
}
static MethodInfo   Nv01ContextPatternMethods[] = {
	{mthdGrResend, "NoOperation", 0x100, 0x103}, {mthdGrResend, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183}, {mthdGrResend,
			"SetColorFormat", 0x300, 0x303}, {mthdGrResend, "SetMonochromeFormat",
			0x304, 0x307}, {mthdGrResend, "SetMonochromeShape", 0x308, 0x30b},
		{mthdGrResend, "SetMonochromeColor0", 0x310, 0x313}, {mthdGrResend,
			"SetMonochromeColor1", 0x314, 0x317}, {mthdGrResend,
			"SetMonochromePattern0", 0x318, 0x31b}, {mthdGrResend,
			"SetMonochromePattern1", 0x31c, 0x31f},
};
EngineObjInfo       Nv01ContextPatternEngineObjInfo = {
	((0x00000001) << ((0 ? (1 * 32 + 17) : (1 * 32 + 16)) & 31)), 0x0004, {0x00000018,
			0x00000201, 0x0}, grContextObjectValidForHardware
};
ClassInfo           Nv01ContextPatternClassInfo = {
	(0x00000018), "context pattern", sizeof (EngineObj), 0x1, 1,
		&Nv01ContextPatternEngineObjInfo, (void *) 0, (void *) 0, grAttachContextPattern,
		(void *) 0, (void *) 0, grDetachContextPattern, (void *) 0, 0, (void *) 0,
		(sizeof (Nv01ContextPatternMethods) / sizeof (Nv01ContextPatternMethods[0])),
		Nv01ContextPatternMethods
};
NvV32
grAttachContextClipRect (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               chID = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chID];
	NvV32               status;

	;
	if ((status = grAttachObject (engObj)) != 0)
	{
		;
		return status;
	}
	if (chID == hwdev->info.Graphics.CurrentChID)
	{
		while ((volatile) ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]))
		{
			NvU32               pmc;

			pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);
			if (pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
			{
				grService (device);
			}
		};
		(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_XMIN) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_YMIN) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_XMAX) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_YMAX) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PGRAPH_VALID1) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_VALID1) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 28 : 28) % 32) +
							((0 ? 28 : 28) % 32))) << ((0 ? 28 : 28) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 28 : 28) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_VALID1) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_VALID1) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 30 : 30) % 32) +
							((0 ? 30 : 30) % 32))) << ((0 ? 30 : 30) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 30 : 30) % 32)));
	}
	else
	{
		hwchan->gr.abs_uclip_xmin = 0;
		hwchan->gr.abs_uclip_ymin = 0;
		hwchan->gr.abs_uclip_xmax = 0;
		hwchan->gr.abs_uclip_ymax = 0;
		hwchan->gr.valid1 |=
			(((NV_PMC_BOOT_0) << ((0 ? 28 : 28) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 30 : 30) % 32)));
	}
	return status;
}
static MethodInfo   Nv01ContextClipRectMethods[] = {
	{mthdGrResend, "NoOperation", 0x100, 0x103}, {mthdGrResend, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183}, {mthdGrResend,
			"SetPoint", 0x300, 0x303}, {mthdGrResend, "SetSize", 0x304, 0x307},
};
EngineObjInfo       Nv01ContextClipRectEngineObjInfo = {
	((0x00000001) << ((0 ? (1 * 32 + 17) : (1 * 32 + 16)) & 31)), 0x0008, {0x00000019, 0x0,
			0x0}, grContextObjectValidForHardware
};
ClassInfo           Nv01ContextClipRectClassInfo = {
	(0x00000019), "context clip rectangle", sizeof (EngineObj), 0x1, 1,
		&Nv01ContextClipRectEngineObjInfo, (void *) 0, (void *) 0, grAttachContextClipRect,
		(void *) 0, (void *) 0, grDetachObject, (void *) 0, 0, (void *) 0,
		(sizeof (Nv01ContextClipRectMethods) / sizeof (Nv01ContextClipRectMethods[0])),
		Nv01ContextClipRectMethods
};
NvV32
grAttachRenderObj (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrRenderObj        *renderObj = (GrRenderObj *) engObj;
	NvV32               status;

	;
	if ((status = grAttachObject (engObj)) != 0)
	{
		;
		return status;
	}
	renderObj->ctxSwitch = ((NV_PMC_BOOT_0) << ((0 ? 17 : 15) % 32));
	renderObj->ctxBeta1 = (void *) 0;
	renderObj->ctxPattern = (void *) 0;
	renderObj->ctxClip = (void *) 0;
	renderObj->ctxRop = (void *) 0;
	renderObj->ctxSurfaces2d = (void *) 0;
	return status;
}

NvV32
grAttachImageObj (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrImageObj         *imageObj = (GrImageObj *) engObj;
	NvV32               status;

	;
	if ((status = grAttachRenderObj (&engObj->base, alloc)) != 0)
	{
		;
		return status;
	}
	imageObj->ctxColorKey = (void *) 0;
	return status;
}

NvV32
grDetachRenderObj (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrRenderObj        *renderObj = (GrRenderObj *) engObj;
	NvV32               status;

	;
	if ((status = grDetachObject (genObj)) != 0)
	{
		;
		return status;
	}
	if (renderObj->ctxBeta1)
	{
		;
		;
		renderObj->ctxBeta1->base.refcnt--;
		;
		renderObj->ctxBeta1 = (void *) 0;
	}
	if (renderObj->ctxPattern)
	{
		;
		;
		renderObj->ctxPattern->base.refcnt--;
		;
		renderObj->ctxPattern = (void *) 0;
	}
	if (renderObj->ctxClip)
	{
		;
		;
		renderObj->ctxClip->base.refcnt--;
		;
		renderObj->ctxClip = (void *) 0;
	}
	if (renderObj->ctxRop)
	{
		;
		;
		renderObj->ctxRop->base.refcnt--;
		;
		renderObj->ctxRop = (void *) 0;
	}
	if (renderObj->ctxSurfaces2d)
	{
		;
		;
		renderObj->ctxSurfaces2d->base.refcnt--;
		;
		renderObj->ctxSurfaces2d = (void *) 0;
	}
	return status;
}

NvV32
grDetachImageObj (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrImageObj         *imageObj = (GrImageObj *) engObj;
	NvV32               status;

	;
	if ((status = grDetachRenderObj (genObj)) != 0)
	{
		;
		return status;
	}
	if (imageObj->ctxColorKey)
	{
		;
		;
		imageObj->ctxColorKey->base.refcnt--;
		;
		imageObj->ctxColorKey = (void *) 0;
	}
	return status;
}
static MethodInfo   grRenderLinMethods[] = {
	{mthdGrResend, "NoOperation", 0x100, 0x103}, {mthdGrResend, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetContextClipRectangle, "SetContextClipRectangle", 0x184, 0x187},
		{mthdSetContextPattern, "SetContextPattern", 0x188, 0x18b}, {mthdSetContextRop,
			"SetContextRop", 0x18c, 0x18f}, {mthdSetContextBeta1, "SetContextBeta1",
			0x190, 0x193}, {mthdSetContextSurfaces2d, "SetContextSurface", 0x194,
			0x197}, {mthdSetOperation, "SetOperation", 0x2fc, 0x2ff}, {mthdGrResend,
			"SetColorFormat", 0x300, 0x303}, {mthdGrResend, "Color", 0x304, 0x307},
		{mthdGrResend, "Lin", 0x400, 0x47f}, {mthdGrResend, "Lin32", 0x480, 0x4ff},
		{mthdGrResend, "PolyLin", 0x500, 0x57f}, {mthdGrResend, "PolyLin32", 0x580, 0x5ff},
		{mthdGrResend, "ColorPolyLin", 0x600, 0x67f},
};
EngineObjInfo       Nv01SolidLinEngineObjInfo = {
	((0x00000001) << ((0 ? (1 * 32 + 17) : (1 * 32 + 16)) & 31)), 0, {0x0000001C, 0x00000300,
			0x0}, grRenderObjectValidForHardware
};
ClassInfo           Nv01RenderSolidLinClassInfo = {
	(0x0000001C), "render solid lin", sizeof (GrRenderObj), 0x1, 1, &Nv01SolidLinEngineObjInfo,
		(void *) 0, (void *) 0, grAttachRenderObj, (void *) 0, (void *) 0,
		grDetachRenderObj, (void *) 0, 0, (void *) 0,
		(sizeof (grRenderLinMethods) / sizeof (grRenderLinMethods[0])), grRenderLinMethods
};
static MethodInfo   grRenderTriangleMethods[] = {
	{mthdGrResend, "NoOperation", 0x100, 0x103}, {mthdGrResend, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetContextClipRectangle, "SetContextClipRectangle", 0x184, 0x187},
		{mthdSetContextPattern, "SetContextPattern", 0x188, 0x18b}, {mthdSetContextRop,
			"SetContextRop", 0x18c, 0x18f}, {mthdSetContextBeta1, "SetContextBeta1",
			0x190, 0x193}, {mthdSetContextSurfaces2d, "SetContextSurface", 0x194,
			0x197}, {mthdSetOperation, "SetOperation", 0x2fc, 0x2ff}, {mthdGrResend,
			"SetColorFormat", 0x300, 0x303}, {mthdGrResend, "Color", 0x304, 0x307},
		{mthdGrResend, "TrianglePoint0", 0x310, 0x313}, {mthdGrResend, "TrianglePoint1",
			0x314, 0x317}, {mthdGrResend, "TrianglePoint2", 0x318, 0x31b},
		{mthdGrResend, "Triangle32Point0X", 0x320, 0x323}, {mthdGrResend,
			"Triangle32Point0Y", 0x324, 0x327}, {mthdGrResend, "Triangle32Point1X",
			0x328, 0x32b}, {mthdGrResend, "Triangle32Point1Y", 0x32c, 0x32f},
		{mthdGrResend, "Triangle32Point2X", 0x330, 0x333}, {mthdGrResend,
			"Triangle32Point2Y", 0x334, 0x337}, {mthdGrResend, "Trimesh", 0x400, 0x47f},
		{mthdGrResend, "Trimesh32", 0x480, 0x4ff}, {mthdGrResend, "ColorTriangle", 0x500,
			0x57f}, {mthdGrResend, "ColorTrimesh", 0x580, 0x5ff},
};
EngineObjInfo       Nv01SolidTriEngineObjInfo = {
	((0x00000001) << ((0 ? (1 * 32 + 17) : (1 * 32 + 16)) & 31)), 0, {0x0000001D, 0x00000300,
			0x0}, grRenderObjectValidForHardware
};
ClassInfo           Nv01RenderSolidTriClassInfo = {
	(0x0000001D), "render solid triangle", sizeof (GrRenderObj), 0x1, 1,
		&Nv01SolidTriEngineObjInfo, (void *) 0, (void *) 0, grAttachRenderObj, (void *) 0,
		(void *) 0, grDetachRenderObj, (void *) 0, 0, (void *) 0,
		(sizeof (grRenderTriangleMethods) / sizeof (grRenderTriangleMethods[0])),
		grRenderTriangleMethods
};
static MethodInfo   grRenderRectangleMethods[] = {
	{mthdGrResend, "NoOperation", 0x100, 0x103}, {mthdGrResend, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetContextClipRectangle, "SetContextClipRectangle", 0x184, 0x187},
		{mthdSetContextPattern, "SetContextPattern", 0x188, 0x18b}, {mthdSetContextRop,
			"SetContextRop", 0x18c, 0x18f}, {mthdSetContextBeta1, "SetContextBeta1",
			0x190, 0x193}, {mthdSetContextSurfaces2d, "SetContextSurface", 0x194,
			0x197}, {mthdSetOperation, "SetOperation", 0x2fc, 0x2ff}, {mthdGrResend,
			"SetColorFormat", 0x300, 0x303}, {mthdGrResend, "Color", 0x304, 0x307},
		{mthdGrResend, "Rectangle", 0x400, 0x47f},
};
EngineObjInfo       Nv01SolidRectEngineObjInfo = {
	((0x00000001) << ((0 ? (1 * 32 + 17) : (1 * 32 + 16)) & 31)), 0, {0x0000001E, 0x00000300,
			0x0}, grRenderObjectValidForHardware
};
ClassInfo           Nv01RenderSolidRectClassInfo = {
	(0x0000001E), "render solid rectangle", sizeof (GrRenderObj), 0x1, 1,
		&Nv01SolidRectEngineObjInfo, (void *) 0, (void *) 0, grAttachRenderObj, (void *) 0,
		(void *) 0, grDetachRenderObj, (void *) 0, 0, (void *) 0,
		(sizeof (grRenderRectangleMethods) / sizeof (grRenderRectangleMethods[0])),
		grRenderRectangleMethods
};
static MethodInfo   grImageFromCpuMethods[] = {
	{mthdGrResend, "NoOperation", 0x100, 0x103}, {mthdGrResend, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetContextColorKey, "SetContextColorKey", 0x184, 0x187},
		{mthdSetContextClipRectangle, "SetContextClipRectangle", 0x188, 0x18b},
		{mthdSetContextPattern, "SetContextPattern", 0x18c, 0x18f}, {mthdSetContextRop,
			"SetContextRop", 0x190, 0x193}, {mthdSetContextBeta1, "SetContextBeta1",
			0x194, 0x197}, {mthdSetContextSurfaces2d, "SetContextSurface", 0x198,
			0x19b}, {mthdSetOperation, "SetOperation", 0x2fc, 0x2ff}, {mthdGrResend,
			"SetColorFormat", 0x300, 0x303}, {mthdGrResend, "Point", 0x304, 0x307},
		{mthdGrResend, "SizeOut", 0x308, 0x30b}, {mthdGrResend, "SizeIn", 0x30c, 0x30f},
		{mthdGrResend, "Color", 0x400, 0x47f},
};
EngineObjInfo       Nv01ImageFromCpuEngineObjInfo = {
	((0x00000001) << ((0 ? (1 * 32 + 17) : (1 * 32 + 16)) & 31)), 0, {0x00000021, NV_PMC_INTR_0,
			0x0}, grImageObjectValidForHardware,
};
ClassInfo           Nv01ImageFromCpuClassInfo = {
	(0x00000021), "image from CPU", sizeof (GrImageObj), 0x1,
	1, &Nv01ImageFromCpuEngineObjInfo,
	(void *) 0, (void *) 0,
	grAttachRenderObj,
	(void *) 0,
	(void *) 0,
	grDetachRenderObj,
	(void *) 0,
	0,
	(void *) 0,
	(sizeof (grImageFromCpuMethods) / sizeof (grImageFromCpuMethods[0])),
	grImageFromCpuMethods
};
NvV32
grAttachContextRop (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               chID = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chID];
	NvV32               status;

	;
	if ((status = grAttachObject (engObj)) != 0)
	{
		;
		return status;
	}
	if (chID == hwdev->info.Graphics.CurrentChID)
	{
		while ((volatile) ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]))
		{
			NvU32               pmc;

			pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);
			if (pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
			{
				grService (device);
			}
		};
		(hwreg)->Reg32[(NV_PGRAPH_ROP3) / 4] = (NvV32) (0);
	}
	else
	{
		hwchan->gr.rop3 = 0;
	}
	return status;
}
static MethodInfo   Nv03ContextRopMethods[] = {
	{mthdGrResend, "NoOperation", 0x100, 0x103}, {mthdGrResend, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183}, {mthdGrResend,
			"SetRop", 0x300, 0x303},
};
EngineObjInfo       Nv03ContextRopEngineObjInfo = {
	((0x00000001) << ((0 ? (1 * 32 + 17) : (1 * 32 + 16)) & 31)), 0x0010, {0x00000043, 0x0,
			0x0}, grContextObjectValidForHardware,
};
ClassInfo           Nv01ContextRopClassInfo = {
	(0x00000043), "context rop", sizeof (EngineObj), 0x1, 1, &Nv03ContextRopEngineObjInfo,
		(void *) 0, (void *) 0, grAttachContextRop, (void *) 0, (void *) 0, grDetachObject,
		(void *) 0, 0, (void *) 0,
		(sizeof (Nv03ContextRopMethods) / sizeof (Nv03ContextRopMethods[0])),
		Nv03ContextRopMethods
};
static MethodInfo   Nv01ImageBlitMethods[] = {
	{mthdGrResend, "NoOperation", 0x100, 0x103}, {mthdGrResend, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetContextColorKey, "SetContextColorKey", 0x184, 0x187},
		{mthdSetContextClipRectangle, "SetContextClipRectangle", 0x188, 0x18b},
		{mthdSetContextPattern, "SetContextPattern", 0x18c, 0x18f}, {mthdSetContextRop,
			"SetContextRop", 0x190, 0x193}, {mthdSetContextBeta1, "SetContextBeta1",
			0x194, 0x197}, {mthdSetContextSurfaces2d, "SetContextSurface", 0x19c,
			0x19f}, {mthdSetOperation, "SetOperation", 0x2fc, 0x2ff}, {mthdGrResend,
			"ControlPointIn", 0x300, 0x303}, {mthdGrResend, "ControlPointOut", 0x304,
			0x307}, {mthdGrResend, "Size", 0x308, 0x30b}
};
EngineObjInfo       Nv01ImageBlitEngineObjInfo = {
	((0x00000001) << ((0 ? (1 * 32 + 17) : (1 * 32 + 16)) & 31)), 0, {0x0000001F, 0x0, 0x0},
		grImageBlitValidForHardware,
};
ClassInfo           Nv01ImageBlitClassInfo = {
	(0x0000001F), "NV01 Image BLIT", sizeof (GrImageObj), 0x1, 1, &Nv01ImageBlitEngineObjInfo,
		(void *) 0, (void *) 0, grAttachImageObj, (void *) 0, (void *) 0, grDetachImageObj,
		(void *) 0, 0, (void *) 0,
		(sizeof (Nv01ImageBlitMethods) / sizeof (Nv01ImageBlitMethods[0])),
		Nv01ImageBlitMethods
};
static MethodInfo   Nv03StretchedImageFromCpuMethods[] = {
	{mthdGrResend, "NoOperation", 0x100, 0x103}, {mthdGrResend, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetContextColorKey, "SetContextColorKey", 0x184, 0x187},
		{mthdSetContextPattern, "SetContextPattern", 0x188, 0x18b}, {mthdSetContextRop,
			"SetContextRop", 0x18c, 0x18f}, {mthdSetContextBeta1, "SetContextBeta1",
			0x190, 0x193}, {mthdSetContextSurfaces2d, "SetContextSurface", 0x194,
			0x197}, {mthdSetOperation, "SetOperation", 0x2fc, 0x2ff}, {mthdGrResend,
			"SetColorFormat", 0x300, 0x303}, {mthdGrResend, "SizeIn", 0x304, 0x307},
		{mthdGrResend, "DxDs", 0x308, 0x30b}, {mthdGrResend, "DyDt", 0x30c, 0x30f},
		{mthdGrResend, "ClipPoint", 0x310, 0x313}, {mthdGrResend, "ClipSize", 0x314, 0x317},
		{mthdGrResend, "Point12d4", 0x318, 0x31b}, {mthdGrResend, "Color", 0x400, 0x1fff},
};
EngineObjInfo       Nv03StretchedImageFromCpuEngineObjInfo = {
	((0x00000001) << ((0 ? (1 * 32 + 17) : (1 * 32 + 16)) & 31)), 0,
	{0x00000036, NV_PMC_INTR_0, 0x0}, grImageObjectValidForHardware
};
ClassInfo           Nv03StretchedImageFromCpuClassInfo = {
	(0x00000036), "NV03 Stretched Image From CPU", sizeof (GrImageObj), 0x1, 1,
		&Nv03StretchedImageFromCpuEngineObjInfo, (void *) 0, (void *) 0, grAttachImageObj,
		(void *) 0, (void *) 0, grDetachImageObj, (void *) 0, 0, (void *) 0,
		(sizeof (Nv03StretchedImageFromCpuMethods) /
		sizeof (Nv03StretchedImageFromCpuMethods[0])), Nv03StretchedImageFromCpuMethods
};
NvV32
grAttachImageFromMem (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrImageFromMemObj  *imageFromMemObj = (GrImageFromMemObj *) engObj;
	NvV32               status;

	;
	if ((status = grAttachRenderObj (&engObj->base, alloc)) != 0)
	{
		;
		return status;
	}
	imageFromMemObj->ctxDmaImage = (void *) 0;
	return status;
}

NvV32
grDetachImageFromMem (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrImageFromMemObj  *imageFromMemObj = (GrImageFromMemObj *) engObj;
	NvV32               status;

	;
	if ((status = grDetachRenderObj (genObj)) != 0)
	{
		;
		return status;
	}
	if (imageFromMemObj->ctxDmaImage)
	{
		;
		imageFromMemObj->ctxDmaImage->base.refcnt--;
		;
		imageFromMemObj->ctxDmaImage = (void *) 0;
	}
	return status;
}
static MethodInfo   Nv03ScaledImageFromMemoryMethods[] = {
	{mthdGrResend, "NoOperation", 0x100, 0x103}, {mthdGrResend, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetContextDmaScaledImage, "SetContextDmaImage", 0x184, 0x187},
		{mthdSetContextPattern, "SetContextPattern", 0x188, 0x18b}, {mthdSetContextRop,
			"SetContextRop", 0x18c, 0x18f}, {mthdSetContextBeta1, "SetContextBeta1",
			0x190, 0x193}, {mthdSetContextSurfaces2d, "SetContextSurface", 0x194,
			0x197}, {mthdGrResend, "SetColorFormat", 0x300, 0x303}, {mthdSetOperation,
			"SetOperation", 0x304, 0x307}, {mthdGrResend, "ClipPoint", 0x308, 0x30b},
		{mthdGrResend, "ClipSize", 0x30c, 0x30f}, {mthdGrResend, "ImageOutPoint", 0x310,
			0x313}, {mthdGrResend, "ImageOutPoint", 0x314, 0x317}, {mthdGrResend,
			"DsDx", 0x318, 0x31b}, {mthdGrResend, "DtDy", 0x31c, 0x31f}, {mthdGrResend,
			"ImageInSize", 0x400, 0x403}, {mthdGrResend, "ImageInPitch", 0x404, 0x407},
		{mthdGrResend, "ImageInOffset", 0x408, 0x40b}, {mthdGrResend, "ImageInPoint", 0x40c,
			0x40f},
};
EngineObjInfo       Nv03ScaledImageFromMemoryEngineObjInfo = {
	((0x00000001) << ((0 ? (1 * 32 + 17) : (1 * 32 + 16)) & 31)), 0,
	{0x00000037, 0x00000600, 0x0}, grImageFromMemValidForHardware
};
ClassInfo           Nv03ScaledImageFromMemoryClassInfo = {
	(0x00000037), "NV03 Scaled Image From Memory", sizeof (GrImageFromMemObj), 0x1, 1,
		&Nv03ScaledImageFromMemoryEngineObjInfo, (void *) 0, (void *) 0,
		grAttachImageFromMem, (void *) 0, (void *) 0, grDetachImageFromMem, (void *) 0, 0,
		(void *) 0,
		(sizeof (Nv03ScaledImageFromMemoryMethods) /
		sizeof (Nv03ScaledImageFromMemoryMethods[0])), Nv03ScaledImageFromMemoryMethods
};
NvV32
grAttachDx3TexTriObj (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrDxTexTriObj      *dxTexTriObj = (GrDxTexTriObj *) engObj;
	GrDx3TexTriObj     *dx3TexTriObj = (GrDx3TexTriObj *) dxTexTriObj;
	NvV32               status;

	;
	if ((status = grAttachObject (engObj)) != 0)
	{
		;
		return status;
	}
	dx3TexTriObj->ctxClip = (void *) 0;
	dx3TexTriObj->ctxDmaTexture = (void *) 0;
	dxTexTriObj->ctxSurfaces3d = (void *) 0;
	return status;
}

NvV32
grDetachDx3TexTriObj (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrDxTexTriObj      *dxTexTriObj = (GrDxTexTriObj *) engObj;
	GrDx3TexTriObj     *dx3TexTriObj = (GrDx3TexTriObj *) dxTexTriObj;
	NvV32               status;

	;
	if ((status = grDetachObject (genObj)) != 0)
	{
		;
		return status;
	}
	if (dx3TexTriObj->ctxClip)
	{
		;
		;
		dx3TexTriObj->ctxClip->base.refcnt--;
		;
		dx3TexTriObj->ctxClip = (void *) 0;
	}
	if (dx3TexTriObj->ctxDmaTexture)
	{
		;
		;
		dx3TexTriObj->ctxDmaTexture->base.refcnt--;
		;
		dx3TexTriObj->ctxDmaTexture = (void *) 0;
	}
	if (dxTexTriObj->ctxSurfaces3d)
	{
		;
		;
		dxTexTriObj->ctxSurfaces3d->base.refcnt--;
		;
		dxTexTriObj->ctxSurfaces3d = (void *) 0;
	}
	return status;
}
static MethodInfo   Nv03Dx3TexturedTriangleMethods[] = {
	{mthdGrResend, "NoOperation", 0x100, 0x103}, {mthdGrResend, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetContextDmaTexture, "SetContextDmaTexture", 0x184, 0x187},
		{mthdSetContextClipRectangle, "SetContextClipRectangle", 0x188, 0x18b},
		{mthdSetContextSurfaces3d, "SetContextSurfaces", 0x18c, 0x18f}, {mthdGrResend,
			"TextureOffset", 0x304, 0x307}, {mthdGrResend, "TextureFormat", 0x308,
			0x30b}, {mthdGrResend, "TextureFilter", 0x30c, 0x30f}, {mthdGrResend,
			"FogColor", 0x310, 0x313}, {mthdDx3Control0, "Control0", 0x314, 0x317},
		{mthdGrResend, "Control1", 0x318, 0x31b}, {mthdGrResend, "Tlvertex", 0x1000,
			0x1fff},
};
EngineObjInfo       Nv03Dx3TexturedTriangleEngineObjInfo = {
	((0x00000001) << ((0 ? (1 * 32 + 17) : (1 * 32 + 16)) & 31)), 0,
	{0x00000048, 0x0, 0x0}, grDx3TexturedTriangleValidForHardware
};
ClassInfo           Nv03Dx3TexturedTriangleClassInfo = {
	(0x00000048), "NV03 DX3 Textured Triangle", sizeof (GrDx3TexTriObj), 0x1, 1,
		&Nv03Dx3TexturedTriangleEngineObjInfo, (void *) 0, (void *) 0, grAttachDx3TexTriObj,
		(void *) 0, (void *) 0, grDetachDx3TexTriObj, (void *) 0, 0, (void *) 0,
		(sizeof (Nv03Dx3TexturedTriangleMethods) /
		sizeof (Nv03Dx3TexturedTriangleMethods[0])), Nv03Dx3TexturedTriangleMethods
};
static MethodInfo   Nv03GdiRectangleTextMethods[] = {
	{mthdGrResend, "NoOperation", 0x100, 0x103}, {mthdGrResend, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetContextPattern, "SetContextPattern", 0x184, 0x187}, {mthdSetContextRop,
			"SetContextRop", 0x188, 0x18b}, {mthdSetContextBeta1, "SetContextBeta1",
			0x18c, 0x18f}, {mthdSetContextSurfaces2d, "SetContextSurface", 0x190,
			0x193}, {mthdSetOperation, "SetOperation", 0x2fc, 0x2ff}, {mthdGrResend,
			"SetColorFormat", 0x300, 0x303}, {mthdGrResend, "SetMonochromeFormat",
			0x304, 0x307}, {mthdGrResend, "Color1A", 0x3fc, 0x3ff}, {mthdGrResend,
			"UnclippedRectangle", 0x400, 0x5ff}, {mthdGrResend, "ClipPoint0B", 0x7f4,
			0x7f7}, {mthdGrResend, "ClipPoint1B", 0x7f8, 0x7fb}, {mthdGrResend,
			"Color1B", 0x7fc, 0x7ff}, {mthdGrResend, "ClippedRectangle", 0x800, 0x9ff},
		{mthdGrResend, "ClipPoint0C", 0xbec, 0xbef}, {mthdGrResend, "ClipPoint1C", 0xbf0,
			0xbf3}, {mthdGrResend, "Color1C", 0xbf4, 0xbf7}, {mthdGrResend, "SizeC",
			0xbf8, 0xbfb}, {mthdGrResend, "PointC", 0xbfc, 0xbff}, {mthdGrResend,
			"MonochromeColor1C", 0xc00, 0xdff}, {mthdGrResend, "ClipPoint0D", 0xfe8,
			0xfeb}, {mthdGrResend, "ClipPoint1D", 0xfec, 0xfef}, {mthdGrResend,
			"Color1D", 0xff0, 0xff3}, {mthdGrResend, "SizeInD", 0xff4, 0xff7},
		{mthdGrResend, "SizeOutD", 0xff8, 0xffb}, {mthdGrResend, "PointD", 0xffc, 0xfff},
		{mthdGrResend, "MonochromeColor1D", 0x1000, 0x11ff}, {mthdGrResend, "ClipPoint0E",
			0x13e4, 0x13e7}, {mthdGrResend, "ClipPoint1E", 0x13e8, 0x13eb},
		{mthdGrResend, "Color0E", 0x13ec, 0x13ef}, {mthdGrResend, "Color1E", 0x13f0,
			0x13f3}, {mthdGrResend, "SizeInE", 0x13f4, 0x13f7}, {mthdGrResend,
			"SizeOutE", 0x13f8, 0x13fb}, {mthdGrResend, "PointE", 0x13fc, 0x13ff},
		{mthdGrResend, "MonochromeColor01E", 0x1400, 0x15ff},
};
EngineObjInfo       Nv03GdiRectangleTextEngineObjInfo = {
	((0x00000001) << ((0 ? (1 * 32 + 17) : (1 * 32 + 16)) & 31)), 0,
	{0x0000004B, 0x00000301, 0x0}, grGdiRectObjectValidForHardware,
};
ClassInfo           Nv03GdiRectangleTextClassInfo = {
	(0x0000004B), "NV03 GDI Rectangle Text", sizeof (GrRenderObj), 0x1, 1,
		&Nv03GdiRectangleTextEngineObjInfo, (void *) 0, (void *) 0, grAttachRenderObj,
		(void *) 0, (void *) 0, grDetachRenderObj, (void *) 0, 0, (void *) 0,
		(sizeof (Nv03GdiRectangleTextMethods) / sizeof (Nv03GdiRectangleTextMethods[0])),
		Nv03GdiRectangleTextMethods
};
NvV32
grAttachDx5TexTriObj (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	NvV32               status;

	;
	if ((status = grAttachObject (engObj)) != 0)
	{
		;
		return status;
	}
	return status;
}

NvV32
grDetachDx5TexTriObj (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	NvV32               status;

	;
	if ((status = grDetachObject (&engObj->base)) != 0)
	{
		;
		return status;
	}
	return status;
}
static MethodInfo   Nv04Dx5TexturedTriangleMethods[] = {
	{mthdGrResend, "NoOperation", 0x100, 0x103}, {mthdGrResend, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetContextDmaA, "SetContextDmaA", 0x184, 0x187}, {mthdSetContextDmaB,
			"SetContextDmaB", 0x188, 0x18c}, {mthdSetContextSurfaces3d,
			"SetContextSurfaces", 0x18c, 0x18f}, {mthdGrResend, "ColorKeyValue", 0x300,
			0x303}, {mthdGrResend, "TextureOffset", 0x304, 0x307}, {mthdGrResend,
			"TextureFormat", 0x308, 0x30b}, {mthdGrResend, "TextureFilter", 0x30c,
			0x30f}, {mthdGrResend, "Blend", 0x310, 0x313}, {mthdGrResend, "Control",
			0x314, 0x317}, {mthdGrResend, "FogColor", 0x318, 0x31c}, {mthdGrResend,
			"Tlvertex", 0x400, 0x5ff}, {mthdGrResend, "DrawPrimitive", 0x600, 0x6ff},
};
EngineObjInfo       Nv04Dx5TexturedTriangleEngineObjInfo = {
	((0x00000001) << ((0 ? (1 * 32 + 17) : (1 * 32 + 16)) & 31)), 0,
	{0x00000054, 0x0, 0x0}
};
ClassInfo           Nv04Dx5TexturedTriangleClassInfo = {
	(0x00000054), "NV04 DX5 Textured Triangle", sizeof (GrDx5TexTriObj), 0x1, 1,
		&Nv04Dx5TexturedTriangleEngineObjInfo, (void *) 0, (void *) 0, grAttachDx5TexTriObj,
		(void *) 0, (void *) 0, grDetachDx5TexTriObj, (void *) 0, 0, (void *) 0,
		(sizeof (Nv04Dx5TexturedTriangleMethods) /
		sizeof (Nv04Dx5TexturedTriangleMethods[0])), Nv04Dx5TexturedTriangleMethods
};
