 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


extern NvV32        mthdUnimplemented (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdGrNoOperation (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdGrResend (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdGrRenderResend (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaNotifies (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaScaledImage (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaTexture (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        nvFunc539 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        nvFunc536 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        nvFunc537 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextSurfaces2d (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextSurfaces3d (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextClipRectangle (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextColorKey (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextPattern (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextRop (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextBeta1 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetColorFormat (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetMonochromeFormat (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetOperation (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdGrNotify (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaBufferIn (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaBufferOut (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderLin (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderTriangle (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdDx3Control0 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderRectangle (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdImageBlt (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdImageTransfer (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdMemoryToMemoryFormat (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderDx3TexturedTriangle (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderGdiRectangleText (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdImageFromMem (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern int          grRenderObjectValidForRendering (EngineObj *engObj);
extern int          grRenderObjectValidForHardware (EngineObj *engObj);
extern int          grImageBlitValidForRendering (EngineObj *engObj);
extern int          grImageBlitValidForHardware (EngineObj *engObj);
extern int          grImageObjectValidForRendering (EngineObj *engObj);
extern int          grImageObjectValidForHardware (EngineObj *engObj);
extern int          grImageFromMemValidForRendering (EngineObj *engObj);
extern int          grImageFromMemValidForHardware (EngineObj *engObj);
extern int          grMemoryToMemoryFormatValidForHardware (EngineObj *engObj);
extern int          grContextObjectValidForHardware (EngineObj *engObj);
extern int          grDx3TexturedTriangleValidForRendering (EngineObj *engObj);
extern int          grDx3TexturedTriangleValidForHardware (EngineObj *engObj);
extern int          grGdiRectObjectValidForRendering (EngineObj *engObj);
extern int          grGdiRectObjectValidForHardware (EngineObj *engObj);
extern void         grValidateObject (EngineObj *obj);
NvV32
grAttachObject (EngineObj *engObj)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	EngineObjInfo      *engObjInfo = ((engObj)->base.classInfo->objectInfo);
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	int                 chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	HwReg              *hwram = ((hwdev)->base.imAddr);
	NvU32               instMemLoc;
	NvV32               instMemSize;
	NvV32               status;

	;
	if (engObjInfo->channelAllocMask && (hwchan->allocMask & engObjInfo->channelAllocMask))
	{
		;
		return 2;
	}
	instMemSize = 1;
	status = fbAllocInstMem (device, &instMemLoc, &instMemSize, 0);
	if (status != 0)
	{
		;
		return 2;
	}
	(hwram)->Reg32[((0 ? 0x01FFFFFF : 0x01C00000) + ((instMemLoc) << 4) + ((((0 ? (0 * 32 +
								31) : (0 * 32 + 0)) / 32) << 2)) -
			(0 ? 0x01FFFFFF : 0x01C00000)) / 4] =
		(NvV32) ((engObjInfo->instanceMem[0]));
	(hwram)->Reg32[((0 ? 0x01FFFFFF : 0x01C00000) + ((instMemLoc) << 4) + ((((0 ? (1 * 32 +
								31) : (1 * 32 + 0)) / 32) << 2)) -
			(0 ? 0x01FFFFFF : 0x01C00000)) / 4] =
		(NvV32) ((engObjInfo->instanceMem[1]));
	(hwram)->Reg32[((0 ? 0x01FFFFFF : 0x01C00000) + ((instMemLoc) << 4) + ((((0 ? (2 * 32 +
								31) : (2 * 32 + 0)) / 32) << 2)) -
			(0 ? 0x01FFFFFF : 0x01C00000)) / 4] =
		(NvV32) ((engObjInfo->instanceMem[2]));
	engObj->instMemLoc = instMemLoc;
	;
	engObj->context =
		engObjInfo->hashContextMask | (((instMemLoc) & (0xFFFFFFFF >> (31 - (1 ? (1 * 32 +
							15) : (1 * 32 + 0)) + (0 ? (1 * 32 +
							15) : (1 * 32 + 0))))) << ((0 ? (1 * 32 +
					15) : (1 * 32 + 0)) & 31)) | (((chid) & (0xFFFFFFFF >> (31 -
					(1 ? (1 * 32 + 30) : (1 * 32 + 24)) + (0 ? (1 * 32 +
							30) : (1 * 32 + 24))))) << ((0 ? (1 * 32 +
					30) : (1 * 32 + 24)) & 31));
	engObj->hashEntry = (~0);
	engObj->notifyCtxDma = (void *) 0;
	engObj->base.mask |= 0x1000;
	hwchan->allocMask |= engObjInfo->channelAllocMask;
	return 0;
}

NvV32
grDetachObject (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	EngineObjInfo      *engObjInfo = ((engObj)->base.classInfo->objectInfo);
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	int                 chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];

	;
	;
	if (engObj->base.refcnt > 0)
	{
		;
		return 5;
	}
	;
	fifoRemoveHashEntry (device, engObj);
	fbFreeInstMem (device, engObj->instMemLoc, 1);
	fifoRemoveObjectFromSubChannelCache (engObj);
	if (engObjInfo->channelAllocMask)
	{
		hwchan->allocMask &= ~engObjInfo->channelAllocMask;
	}
	if (engObj->notifyCtxDma)
	{
		engObj->notifyCtxDma->base.refcnt--;
		;
		engObj->notifyCtxDma = (void *) 0;
	}
	return 0;
}

NvV32
grAttachContextColorKey (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               chID = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chID];
	NvV32               status;

	;
	if ((status = grAttachObject (engObj)) != 0)
	{
		;
		return status;
	}
	if (chID == hwdev->info.Graphics.CurrentChID)
	{
		{
			NvV32               _status;

			_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
			while (_status)
			{
				NvV32               _pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);

				if (_pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
				{
					grService (device);
				}
				_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
			}
		};
		(hwreg)->Reg32[(NV_PGRAPH_CHROMA) / 4] = (NvV32) (0);
	}
	else
	{
		hwchan->gr.chroma = 0;
	}
	return status;
}

NvV32
grDetachContextColorKey (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               chID = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chID];

	;
	if (chID == hwdev->info.Graphics.CurrentChID)
	{
		{
			NvV32               _status;

			_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
			while (_status)
			{
				NvV32               _pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);

				if (_pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
				{
					grService (device);
				}
				_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
			}
		};
		(hwreg)->Reg32[(NV_PGRAPH_CHROMA) / 4] = (NvV32) (0);
	}
	else
	{
		hwchan->gr.chroma = 0;
	}
	return grDetachObject (genObj);
}
static MethodInfo   Nv01ContextColorKeyMethods[] = {
	{mthdGrNoOperation, "NoOperation", 0x100, 0x103}, {mthdGrNotify, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetColorFormat, "SetColorFormat", 0x300, 0x303}, {mthdGrResend, "SetColor",
			0x304, 0x307},
};
EngineObjInfo       Nv01ContextColorKeyEngineObjInfo = {
	(((((0 ? 0x00431FFF : 0x00430000) >> 16) & (0xFFFFFFFF >> (31 - (1 ? (1 * 32 +
								22) : (1 * 32 + 16)) +
						(0 ? (1 * 32 + 22) : (1 * 32 +
								16))))) << ((0 ? (1 * 32 +
						22) : (1 * 32 +
						16)) & 31)) | ((0x00000001) << ((0 ? (1 * 32 +
						23) : (1 * 32 + 23)) & 31))), 0x0002, {0x0000000B,
			0x0, 0x0}, grContextObjectValidForHardware
};
ClassInfo           Nv01ContextColorKeyClassInfo = {
	(0x00000017), "context color key", sizeof (EngineObj), 0x1, 1,
		&Nv01ContextColorKeyEngineObjInfo, (void *) 0, (void *) 0, grAttachContextColorKey,
		(void *) 0, (void *) 0, grDetachContextColorKey, (void *) 0, 0, (void *) 0,
		(sizeof (Nv01ContextColorKeyMethods) / sizeof (Nv01ContextColorKeyMethods[0])),
		Nv01ContextColorKeyMethods
};
NvV32
grAttachContextBeta (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               chID = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chID];
	NvV32               status;

	;
	if ((status = grAttachObject (engObj)) != 0)
	{
		;
		return status;
	}
	if (chID == hwdev->info.Graphics.CurrentChID)
	{
		{
			NvV32               _status;

			_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
			while (_status)
			{
				NvV32               _pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);

				if (_pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
				{
					grService (device);
				}
				_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
			}
		};
		(hwreg)->Reg32[(NV_PGRAPH_BETA) / 4] = (NvV32) (0);
	}
	else
	{
		hwchan->gr.beta = 0;
	}
	return status;
}
static MethodInfo   Nv01ContextBetaMethods[] = {
	{mthdGrNoOperation, "NoOperation", 0x100, 0x103}, {mthdGrNotify, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183}, {mthdGrResend,
			"SetBeta1d31", 0x300, 0x303},
};
EngineObjInfo       Nv01ContextBeta1EngineObjInfo = {
	(((((0 ? 0x00411FFF : 0x00410000) >> 16) & (0xFFFFFFFF >> (31 - (1 ? (1 * 32 +
								22) : (1 * 32 + 16)) +
						(0 ? (1 * 32 + 22) : (1 * 32 +
								16))))) << ((0 ? (1 * 32 +
						22) : (1 * 32 +
						16)) & 31)) | ((0x00000001) << ((0 ? (1 * 32 +
						23) : (1 * 32 + 23)) & 31))), 0x0001, {0x0, 0x0,
			0x0}, grContextObjectValidForHardware
};
ClassInfo           Nv01ContextBeta1ClassInfo = {
	(0x00000012), "context beta", sizeof (EngineObj), 0x1, 1, &Nv01ContextBeta1EngineObjInfo,
		(void *) 0, (void *) 0, grAttachContextBeta, (void *) 0, (void *) 0, grDetachObject,
		(void *) 0, 0, (void *) 0,
		(sizeof (Nv01ContextBetaMethods) / sizeof (Nv01ContextBetaMethods[0])),
		Nv01ContextBetaMethods
};
NvV32
grAttachContextPattern (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               chID = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chID];
	NvV32               status;

	;
	if ((status = grAttachObject (engObj)) != 0)
	{
		;
		return status;
	}
	if (chID == hwdev->info.Graphics.CurrentChID)
	{
		{
			NvV32               _status;

			_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
			while (_status)
			{
				NvV32               _pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);

				if (_pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
				{
					grService (device);
				}
				_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
			}
		};
		(hwreg)->Reg32[(NV_PGRAPH_PATTERN_SHAPE) / 4] = (NvV32) (NV_PMC_BOOT_0);
		(hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR0_0) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR0_1) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR1_0) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR1_1) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[((0x00400610 + (0) * 4)) / 4] = (NvV32) (0);
		(hwreg)->Reg32[((0x00400610 + (1) * 4)) / 4] = (NvV32) (0);
	}
	else
	{
		hwchan->gr.pattern_shape = NV_PMC_BOOT_0;
		hwchan->gr.patt_color0_0 = 0;
		hwchan->gr.patt_color0_1 = 0;
		hwchan->gr.patt_color1_0 = 0;
		hwchan->gr.patt_color1_1 = 0;
		hwchan->gr.pattern[0] = 0;
		hwchan->gr.pattern[1] = 0;
	}
	return status;
}

NvV32
grDetachContextPattern (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               chID = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chID];

	;
	if (chID == hwdev->info.Graphics.CurrentChID)
	{
		{
			NvV32               _status;

			_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
			while (_status)
			{
				NvV32               _pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);

				if (_pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
				{
					grService (device);
				}
				_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
			}
		};
		(hwreg)->Reg32[(NV_PGRAPH_PATTERN_SHAPE) / 4] = (NvV32) (NV_PMC_BOOT_0);
		(hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR0_0) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR0_1) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR1_0) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR1_1) / 4] = (NvV32) (0x0);
		(hwreg)->Reg32[((0x00400610 + (0) * 4)) / 4] = (NvV32) (0);
		(hwreg)->Reg32[((0x00400610 + (1) * 4)) / 4] = (NvV32) (0);
	}
	else
	{
		hwchan->gr.pattern_shape = NV_PMC_BOOT_0;
		hwchan->gr.patt_color0_0 = 0;
		hwchan->gr.patt_color0_1 = 0;
		hwchan->gr.patt_color1_0 = 0;
		hwchan->gr.patt_color1_1 = 0;
		hwchan->gr.pattern[0] = 0;
		hwchan->gr.pattern[1] = 0;
	}
	return grDetachObject (genObj);
}
static MethodInfo   Nv01ContextPatternMethods[] = {
	{mthdGrNoOperation, "NoOperation", 0x100, 0x103}, {mthdGrNotify, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetColorFormat, "SetColorFormat", 0x300, 0x303}, {mthdSetMonochromeFormat,
			"SetMonochromeFormat", 0x304, 0x307}, {mthdGrResend, "SetMonochromeShape",
			0x308, 0x30b}, {mthdGrResend, "SetMonochromeColor0", 0x310, 0x313},
		{mthdGrResend, "SetMonochromeColor1", 0x314, 0x317}, {mthdGrResend,
			"SetMonochromePattern0", 0x318, 0x31b}, {mthdGrResend,
			"SetMonochromePattern1", 0x31c, 0x31f},
};
EngineObjInfo       Nv01ContextPatternEngineObjInfo = {
	(((((0 ? 0x00461FFF : 0x00460000) >> 16) & (0xFFFFFFFF >> (31 - (1 ? (1 * 32 +
								22) : (1 * 32 + 16)) +
						(0 ? (1 * 32 + 22) : (1 * 32 +
								16))))) << ((0 ? (1 * 32 +
						22) : (1 * 32 +
						16)) & 31)) | ((0x00000001) << ((0 ? (1 * 32 +
						23) : (1 * 32 + 23)) & 31))), 0x0004, {0x0000010B,
			0x0, 0x0}, grContextObjectValidForHardware
};
ClassInfo           Nv01ContextPatternClassInfo = {
	(0x00000018), "context pattern", sizeof (EngineObj), 0x1, 1,
		&Nv01ContextPatternEngineObjInfo, (void *) 0, (void *) 0, grAttachContextPattern,
		(void *) 0, (void *) 0, grDetachContextPattern, (void *) 0, 0, (void *) 0,
		(sizeof (Nv01ContextPatternMethods) / sizeof (Nv01ContextPatternMethods[0])),
		Nv01ContextPatternMethods
};
NvV32
grAttachContextClipRect (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               chID = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chID];
	NvV32               status;

	;
	if ((status = grAttachObject (engObj)) != 0)
	{
		;
		return status;
	}
	if (chID == hwdev->info.Graphics.CurrentChID)
	{
		{
			NvV32               _status;

			_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
			while (_status)
			{
				NvV32               _pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);

				if (_pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
				{
					grService (device);
				}
				_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
			}
		};
		(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_XMIN) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_YMIN) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_XMAX) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_YMAX) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PGRAPH_EXCEPTIONS) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_EXCEPTIONS) /
						4]) & ~((0xFFFFFFFF >> (31 - ((1 ? 28 : 28) % 32) +
							((0 ? 28 : 28) % 32))) << ((0 ? 28 : 28) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 28 : 28) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_EXCEPTIONS) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_EXCEPTIONS) /
						4]) & ~((0xFFFFFFFF >> (31 - ((1 ? 30 : 30) % 32) +
							((0 ? 30 : 30) % 32))) << ((0 ? 30 : 30) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 30 : 30) % 32)));
	}
	else
	{
		hwchan->gr.abs_uclip_xmin = 0;
		hwchan->gr.abs_uclip_ymin = 0;
		hwchan->gr.abs_uclip_xmax = 0;
		hwchan->gr.abs_uclip_ymax = 0;
		hwchan->gr.exceptions |=
			(((NV_PMC_BOOT_0) << ((0 ? 28 : 28) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 30 : 30) % 32)));
	}
	return status;
}
static MethodInfo   Nv01ContextClipRectMethods[] = {
	{mthdGrNoOperation, "NoOperation", 0x100, 0x103}, {mthdGrNotify, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183}, {mthdGrResend,
			"SetPoint", 0x300, 0x303}, {mthdGrResend, "SetSize", 0x304, 0x307},
};
EngineObjInfo       Nv01ContextClipRectEngineObjInfo = {
	(((((0 ? 0x00451FFF : 0x00450000) >> 16) & (0xFFFFFFFF >> (31 - (1 ? (1 * 32 +
								22) : (1 * 32 + 16)) +
						(0 ? (1 * 32 + 22) : (1 * 32 +
								16))))) << ((0 ? (1 * 32 +
						22) : (1 * 32 +
						16)) & 31)) | ((0x00000001) << ((0 ? (1 * 32 +
						23) : (1 * 32 + 23)) & 31))), 0x0008, {0x0, 0x0,
			0x0}, grContextObjectValidForHardware
};
ClassInfo           Nv01ContextClipRectClassInfo = {
	(0x00000019), "context clip rectangle", sizeof (EngineObj), 0x1, 1,
		&Nv01ContextClipRectEngineObjInfo, (void *) 0, (void *) 0, grAttachContextClipRect,
		(void *) 0, (void *) 0, grDetachObject, (void *) 0, 0, (void *) 0,
		(sizeof (Nv01ContextClipRectMethods) / sizeof (Nv01ContextClipRectMethods[0])),
		Nv01ContextClipRectMethods
};
NvV32
grAttachRenderObj (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrRenderObj        *renderObj = (GrRenderObj *) engObj;
	NvV32               status;

	;
	if ((status = grAttachObject (engObj)) != 0)
	{
		;
		return status;
	}
	renderObj->ctxSwitch = ((0x00000017) << ((0 ? 28 : 24) % 32));
	renderObj->next = (void *) 0;
	renderObj->prev = (void *) 0;
	renderObj->ctxBeta1 = (void *) 0;
	renderObj->ctxPattern = (void *) 0;
	renderObj->ctxClip = (void *) 0;
	renderObj->ctxRop = (void *) 0;
	renderObj->ctxSurfaces2d = (void *) 0;
	return status;
}

NvV32
grAttachImageObj (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrImageObj         *imageObj = (GrImageObj *) engObj;
	NvV32               status;

	;
	if ((status = grAttachRenderObj (&engObj->base, alloc)) != 0)
	{
		;
		return status;
	}
	imageObj->ctxColorKey = (void *) 0;
	return status;
}

NvV32
grDetachRenderObj (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrRenderObj        *renderObj = (GrRenderObj *) engObj;
	GrNv03Surfaces2dObj *surfaces2dObj;
	NvV32               status;

	;
	if ((status = grDetachObject (genObj)) != 0)
	{
		;
		return status;
	}
	if (renderObj->ctxBeta1)
	{
		;
		;
		renderObj->ctxBeta1->base.refcnt--;
		;
		renderObj->ctxBeta1 = (void *) 0;
	}
	if (renderObj->ctxPattern)
	{
		;
		;
		renderObj->ctxPattern->base.refcnt--;
		;
		renderObj->ctxPattern = (void *) 0;
	}
	if (renderObj->ctxClip)
	{
		;
		;
		renderObj->ctxClip->base.refcnt--;
		;
		renderObj->ctxClip = (void *) 0;
	}
	if (renderObj->ctxRop)
	{
		;
		;
		renderObj->ctxRop->base.refcnt--;
		;
		renderObj->ctxRop = (void *) 0;
	}
	if (renderObj->ctxSurfaces2d)
	{
		;
		;
		surfaces2dObj = (GrNv03Surfaces2dObj *) renderObj->ctxSurfaces2d;
		if (renderObj->prev != (void *) 0)
			renderObj->prev->next = renderObj->next;
		if (renderObj->next != (void *) 0)
			renderObj->next->prev = renderObj->prev;
		if (surfaces2dObj->surfaceUsers == renderObj)
		{
			;
			surfaces2dObj->surfaceUsers = renderObj->next;
		}
		renderObj->ctxSurfaces2d->base.refcnt--;
		;
		renderObj->ctxSurfaces2d = (void *) 0;
	}
	return status;
}

NvV32
grDetachImageObj (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrImageObj         *imageObj = (GrImageObj *) engObj;
	NvV32               status;

	;
	if ((status = grDetachRenderObj (genObj)) != 0)
	{
		;
		return status;
	}
	if (imageObj->ctxColorKey)
	{
		;
		;
		imageObj->ctxColorKey->base.refcnt--;
		;
		imageObj->ctxColorKey = (void *) 0;
	}
	return status;
}
static MethodInfo   grRenderLinMethods[] = {
	{mthdGrNoOperation, "NoOperation", 0x100, 0x103}, {mthdGrNotify, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetContextClipRectangle, "SetContextClipRectangle", 0x184, 0x187},
		{mthdSetContextPattern, "SetContextPattern", 0x188, 0x18b}, {mthdSetContextRop,
			"SetContextRop", 0x18c, 0x18f}, {mthdSetContextBeta1, "SetContextBeta1",
			0x190, 0x193}, {mthdSetContextSurfaces2d, "SetContextSurface", 0x194,
			0x197}, {mthdSetOperation, "SetOperation", 0x2fc, 0x2ff},
		{mthdSetColorFormat, "SetColorFormat", 0x300, 0x303}, {mthdGrRenderResend, "Color",
			0x304, 0x307}, {mthdRenderLin, "Lin", 0x400, 0x47f}, {mthdRenderLin,
			"Lin32", 0x480, 0x4ff}, {mthdRenderLin, "PolyLin", 0x500, 0x57f},
		{mthdRenderLin, "PolyLin32", 0x580, 0x5ff}, {mthdRenderLin, "ColorPolyLin", 0x600,
			0x67f},
};
EngineObjInfo       Nv01SolidLinEngineObjInfo = {
	(((((0 ? 0x004A1FFF : 0x004A0000) >> 16) & (0xFFFFFFFF >> (31 - (1 ? (1 * 32 +
								22) : (1 * 32 + 16)) +
						(0 ? (1 * 32 + 22) : (1 * 32 +
								16))))) << ((0 ? (1 * 32 +
						22) : (1 * 32 +
						16)) & 31)) | ((0x00000001) << ((0 ? (1 * 32 +
						23) : (1 * 32 + 23)) & 31))), 0, {0x17100003, 0x0,
			0x0}, grRenderObjectValidForHardware
};
ClassInfo           Nv01RenderSolidLinClassInfo = {
	(0x0000001C), "render solid lin", sizeof (GrRenderObj), 0x1, 1, &Nv01SolidLinEngineObjInfo,
		(void *) 0, (void *) 0, grAttachRenderObj, (void *) 0, (void *) 0,
		grDetachRenderObj, (void *) 0, 0, (void *) 0,
		(sizeof (grRenderLinMethods) / sizeof (grRenderLinMethods[0])), grRenderLinMethods
};
static MethodInfo   grRenderTriangleMethods[] = {
	{mthdGrNoOperation, "NoOperation", 0x100, 0x103}, {mthdGrNotify, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetContextClipRectangle, "SetContextClipRectangle", 0x184, 0x187},
		{mthdSetContextPattern, "SetContextPattern", 0x188, 0x18b}, {mthdSetContextRop,
			"SetContextRop", 0x18c, 0x18f}, {mthdSetContextBeta1, "SetContextBeta1",
			0x190, 0x193}, {mthdSetContextSurfaces2d, "SetContextSurface", 0x194,
			0x197}, {mthdSetOperation, "SetOperation", 0x2fc, 0x2ff},
		{mthdSetColorFormat, "SetColorFormat", 0x300, 0x303}, {mthdGrRenderResend, "Color",
			0x304, 0x307}, {mthdGrRenderResend, "TrianglePoint0", 0x310, 0x313},
		{mthdGrRenderResend, "TrianglePoint1", 0x314, 0x317}, {mthdRenderTriangle,
			"TrianglePoint2", 0x318, 0x31b}, {mthdGrRenderResend, "Triangle32Point0X",
			0x320, 0x323}, {mthdGrRenderResend, "Triangle32Point0Y", 0x324, 0x327},
		{mthdGrRenderResend, "Triangle32Point1X", 0x328, 0x32b}, {mthdGrRenderResend,
			"Triangle32Point1Y", 0x32c, 0x32f}, {mthdGrRenderResend,
			"Triangle32Point2X", 0x330, 0x333}, {mthdRenderTriangle,
			"Triangle32Point2Y", 0x334, 0x337}, {mthdRenderTriangle, "Trimesh", 0x400,
			0x47f}, {mthdRenderTriangle, "Trimesh32", 0x480, 0x4ff},
		{mthdRenderTriangle, "ColorTriangle", 0x500, 0x57f}, {mthdRenderTriangle,
			"ColorTrimesh", 0x580, 0x5ff},
};
EngineObjInfo       Nv01SolidTriEngineObjInfo = {
	(((((0 ? 0x004B1FFF : 0x004B0000) >> 16) & (0xFFFFFFFF >> (31 - (1 ? (1 * 32 +
								22) : (1 * 32 + 16)) +
						(0 ? (1 * 32 + 22) : (1 * 32 +
								16))))) << ((0 ? (1 * 32 +
						22) : (1 * 32 +
						16)) & 31)) | ((0x00000001) << ((0 ? (1 * 32 +
						23) : (1 * 32 + 23)) & 31))), 0, {0x17100003, 0x0,
			0x0}, grRenderObjectValidForHardware
};
ClassInfo           Nv01RenderSolidTriClassInfo = {
	(0x0000001D), "render solid triangle", sizeof (GrRenderObj), 0x1, 1,
		&Nv01SolidTriEngineObjInfo, (void *) 0, (void *) 0, grAttachRenderObj, (void *) 0,
		(void *) 0, grDetachRenderObj, (void *) 0, 0, (void *) 0,
		(sizeof (grRenderTriangleMethods) / sizeof (grRenderTriangleMethods[0])),
		grRenderTriangleMethods
};
static MethodInfo   grRenderRectangleMethods[] = {
	{mthdGrNoOperation, "NoOperation", 0x100, 0x103}, {mthdGrNotify, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetContextClipRectangle, "SetContextClipRectangle", 0x184, 0x187},
		{mthdSetContextPattern, "SetContextPattern", 0x188, 0x18b}, {mthdSetContextRop,
			"SetContextRop", 0x18c, 0x18f}, {mthdSetContextBeta1, "SetContextBeta1",
			0x190, 0x193}, {mthdSetContextSurfaces2d, "SetContextSurface", 0x194,
			0x197}, {mthdSetOperation, "SetOperation", 0x2fc, 0x2ff},
		{mthdSetColorFormat, "SetColorFormat", 0x300, 0x303}, {mthdGrRenderResend, "Color",
			0x304, 0x307}, {mthdRenderRectangle, "Rectangle", 0x400, 0x47f},
};
EngineObjInfo       Nv01SolidRectEngineObjInfo = {
	(((((0 ? 0x00471FFF : 0x00470000) >> 16) & (0xFFFFFFFF >> (31 - (1 ? (1 * 32 +
								22) : (1 * 32 + 16)) +
						(0 ? (1 * 32 + 22) : (1 * 32 +
								16))))) << ((0 ? (1 * 32 +
						22) : (1 * 32 +
						16)) & 31)) | ((0x00000001) << ((0 ? (1 * 32 +
						23) : (1 * 32 + 23)) & 31))), 0, {0x17100003, 0x0,
			0x0}, grRenderObjectValidForHardware
};
ClassInfo           Nv01RenderSolidRectClassInfo = {
	(0x0000001E), "render solid rectangle", sizeof (GrRenderObj), 0x1, 1,
		&Nv01SolidRectEngineObjInfo, (void *) 0, (void *) 0, grAttachRenderObj, (void *) 0,
		(void *) 0, grDetachRenderObj, (void *) 0, 0, (void *) 0,
		(sizeof (grRenderRectangleMethods) / sizeof (grRenderRectangleMethods[0])),
		grRenderRectangleMethods
};
static MethodInfo   grImageFromCpuMethods[] = {
	{mthdGrNoOperation, "NoOperation", 0x100, 0x103}, {mthdGrNotify, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetContextColorKey, "SetContextColorKey", 0x184, 0x187},
		{mthdSetContextClipRectangle, "SetContextClipRectangle", 0x188, 0x18b},
		{mthdSetContextPattern, "SetContextPattern", 0x18c, 0x18f}, {mthdSetContextRop,
			"SetContextRop", 0x190, 0x193}, {mthdSetContextBeta1, "SetContextBeta1",
			0x194, 0x197}, {mthdSetContextSurfaces2d, "SetContextSurface", 0x198,
			0x19b}, {mthdSetOperation, "SetOperation", 0x2fc, 0x2ff},
		{mthdSetColorFormat, "SetColorFormat", 0x300, 0x303}, {mthdGrRenderResend, "Point",
			0x304, 0x307}, {mthdGrRenderResend, "SizeOut", 0x308, 0x30b},
		{mthdGrRenderResend, "SizeIn", 0x30c, 0x30f}, {mthdImageTransfer, "Color", 0x400,
			0x47f},
};
EngineObjInfo       Nv01ImageFromCpuEngineObjInfo = {
	(((((0 ? 0x00511FFF : 0x00510000) >> 16) & (0xFFFFFFFF >> (31 - (1 ? (1 * 32 +
								22) : (1 * 32 + 16)) +
						(0 ? (1 * 32 + 22) : (1 * 32 +
								16))))) << ((0 ? (1 * 32 +
						22) : (1 * 32 +
						16)) & 31)) | ((0x00000001) << ((0 ? (1 * 32 +
						23) : (1 * 32 + 23)) & 31))), 0, {0x17100003, 0x0,
			0x0}, grImageObjectValidForHardware,
};
ClassInfo           Nv01ImageFromCpuClassInfo = {
	(0x00000021), "image from CPU", sizeof (GrImageObj), 0x1,
	1, &Nv01ImageFromCpuEngineObjInfo,
	(void *) 0, (void *) 0,
	grAttachRenderObj,
	(void *) 0,
	(void *) 0,
	grDetachRenderObj,
	(void *) 0,
	0,
	(void *) 0,
	(sizeof (grImageFromCpuMethods) / sizeof (grImageFromCpuMethods[0])),
	grImageFromCpuMethods
};
NvV32
grAttachContextRop (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               chID = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chID];
	NvV32               status;

	;
	if ((status = grAttachObject (engObj)) != 0)
	{
		;
		return status;
	}
	if (chID == hwdev->info.Graphics.CurrentChID)
	{
		{
			NvV32               _status;

			_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
			while (_status)
			{
				NvV32               _pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);

				if (_pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
				{
					grService (device);
				}
				_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
			}
		};
		(hwreg)->Reg32[(NV_PGRAPH_ROP3) / 4] = (NvV32) (0);
	}
	else
	{
		hwchan->gr.rop3 = 0;
	}
	return status;
}
static MethodInfo   Nv03ContextRopMethods[] = {
	{mthdGrNoOperation, "NoOperation", 0x100, 0x103}, {mthdGrNotify, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183}, {mthdGrResend,
			"SetRop", 0x300, 0x303},
};
EngineObjInfo       Nv03ContextRopEngineObjInfo = {
	(((((0 ? 0x00421FFF : 0x00420000) >> 16) & (0xFFFFFFFF >> (31 - (1 ? (1 * 32 +
								22) : (1 * 32 + 16)) +
						(0 ? (1 * 32 + 22) : (1 * 32 +
								16))))) << ((0 ? (1 * 32 +
						22) : (1 * 32 +
						16)) & 31)) | ((0x00000001) << ((0 ? (1 * 32 +
						23) : (1 * 32 + 23)) & 31))), 0x0010, {0x0, 0x0,
			0x0}, grContextObjectValidForHardware,
};
ClassInfo           Nv01ContextRopClassInfo = {
	(0x00000043), "context rop", sizeof (EngineObj), 0x1, 1, &Nv03ContextRopEngineObjInfo,
		(void *) 0, (void *) 0, grAttachContextRop, (void *) 0, (void *) 0, grDetachObject,
		(void *) 0, 0, (void *) 0,
		(sizeof (Nv03ContextRopMethods) / sizeof (Nv03ContextRopMethods[0])),
		Nv03ContextRopMethods
};
static MethodInfo   Nv01ImageBlitMethods[] = {
	{mthdGrNoOperation, "NoOperation", 0x100, 0x103}, {mthdGrNotify, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetContextColorKey, "SetContextColorKey", 0x184, 0x187},
		{mthdSetContextClipRectangle, "SetContextClipRectangle", 0x188, 0x18b},
		{mthdSetContextPattern, "SetContextPattern", 0x18c, 0x18f}, {mthdSetContextRop,
			"SetContextRop", 0x190, 0x193}, {mthdSetContextBeta1, "SetContextBeta1",
			0x194, 0x197}, {mthdSetContextSurfaces2d, "SetContextSurface", 0x19c,
			0x19f}, {mthdSetOperation, "SetOperation", 0x2fc, 0x2ff},
		{mthdGrRenderResend, "ControlPointIn", 0x300, 0x303}, {mthdGrRenderResend,
			"ControlPointOut", 0x304, 0x307}, {mthdImageBlt, "Size", 0x308, 0x30b}
};
EngineObjInfo       Nv01ImageBlitEngineObjInfo = {
	(((((0 ? 0x00501FFF : 0x00500000) >> 16) & (0xFFFFFFFF >> (31 - (1 ? (1 * 32 +
								22) : (1 * 32 + 16)) +
						(0 ? (1 * 32 + 22) : (1 * 32 +
								16))))) << ((0 ? (1 * 32 +
						22) : (1 * 32 +
						16)) & 31)) | ((0x00000001) << ((0 ? (1 * 32 +
						23) : (1 * 32 + 23)) & 31))), 0, {0x17110003, 0x0,
			0x0}, grImageBlitValidForHardware,
};
ClassInfo           Nv01ImageBlitClassInfo = {
	(0x0000001F), "NV01 Image BLIT", sizeof (GrImageObj), 0x1, 1, &Nv01ImageBlitEngineObjInfo,
		(void *) 0, (void *) 0, grAttachImageObj, (void *) 0, (void *) 0, grDetachImageObj,
		(void *) 0, 0, (void *) 0,
		(sizeof (Nv01ImageBlitMethods) / sizeof (Nv01ImageBlitMethods[0])),
		Nv01ImageBlitMethods
};
static MethodInfo   Nv03StretchedImageFromCpuMethods[] = {
	{mthdGrNoOperation, "NoOperation", 0x100, 0x103}, {mthdGrNotify, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetContextColorKey, "SetContextColorKey", 0x184, 0x187},
		{mthdSetContextPattern, "SetContextPattern", 0x188, 0x18b}, {mthdSetContextRop,
			"SetContextRop", 0x18c, 0x18f}, {mthdSetContextBeta1, "SetContextBeta1",
			0x190, 0x193}, {mthdSetContextSurfaces2d, "SetContextSurface", 0x194,
			0x197}, {mthdSetOperation, "SetOperation", 0x2fc, 0x2ff},
		{mthdSetColorFormat, "SetColorFormat", 0x300, 0x303}, {mthdGrRenderResend, "SizeIn",
			0x304, 0x307}, {mthdGrRenderResend, "DxDs", 0x308, 0x30b},
		{mthdGrRenderResend, "DyDt", 0x30c, 0x30f}, {mthdGrRenderResend, "ClipPoint", 0x310,
			0x313}, {mthdGrRenderResend, "ClipSize", 0x314, 0x317}, {mthdGrRenderResend,
			"Point12d4", 0x318, 0x31b}, {mthdImageTransfer, "Color", 0x400, 0x1fff},
};
EngineObjInfo       Nv03StretchedImageFromCpuEngineObjInfo = {
	(((((0 ? 0x00551FFF : 0x00550000) >> 16) & (0xFFFFFFFF >> (31 - (1 ? (1 * 32 +
								22) : (1 * 32 + 16)) +
						(0 ? (1 * 32 + 22) : (1 * 32 +
								16))))) << ((0 ? (1 * 32 +
						22) : (1 * 32 +
						16)) & 31)) | ((0x00000001) << ((0 ? (1 * 32 +
						23) : (1 * 32 + 23)) & 31))), 0,
	{0x17100003, 0x0, 0x0}, grImageObjectValidForHardware
};
ClassInfo           Nv03StretchedImageFromCpuClassInfo = {
	(0x00000036), "NV03 Stretched Image From CPU", sizeof (GrImageObj), 0x1, 1,
		&Nv03StretchedImageFromCpuEngineObjInfo, (void *) 0, (void *) 0, grAttachImageObj,
		(void *) 0, (void *) 0, grDetachImageObj, (void *) 0, 0, (void *) 0,
		(sizeof (Nv03StretchedImageFromCpuMethods) /
		sizeof (Nv03StretchedImageFromCpuMethods[0])), Nv03StretchedImageFromCpuMethods
};
NvV32
grAttachImageFromMem (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrImageFromMemObj  *imageFromMemObj = (GrImageFromMemObj *) engObj;
	NvV32               status;

	;
	if ((status = grAttachRenderObj (&engObj->base, alloc)) != 0)
	{
		;
		return status;
	}
	imageFromMemObj->ctxDmaImage = (void *) 0;
	return status;
}

NvV32
grDetachImageFromMem (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrImageFromMemObj  *imageFromMemObj = (GrImageFromMemObj *) engObj;
	NvV32               status;

	;
	if ((status = grDetachRenderObj (genObj)) != 0)
	{
		;
		return status;
	}
	if (imageFromMemObj->ctxDmaImage)
	{
		;
		imageFromMemObj->ctxDmaImage->base.refcnt--;
		;
		imageFromMemObj->ctxDmaImage = (void *) 0;
	}
	return status;
}
static MethodInfo   Nv03ScaledImageFromMemoryMethods[] = {
	{mthdGrNoOperation, "NoOperation", 0x100, 0x103}, {mthdGrNotify, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetContextDmaScaledImage, "SetContextDmaImage", 0x184, 0x187},
		{mthdSetContextPattern, "SetContextPattern", 0x188, 0x18b}, {mthdSetContextRop,
			"SetContextRop", 0x18c, 0x18f}, {mthdSetContextBeta1, "SetContextBeta1",
			0x190, 0x193}, {mthdSetContextSurfaces2d, "SetContextSurface", 0x194,
			0x197}, {mthdSetColorFormat, "SetColorFormat", 0x300, 0x303},
		{mthdSetOperation, "SetOperation", 0x304, 0x307}, {mthdGrRenderResend, "ClipPoint",
			0x308, 0x30b}, {mthdGrRenderResend, "ClipSize", 0x30c, 0x30f},
		{mthdGrRenderResend, "ImageOutPoint", 0x310, 0x313}, {mthdGrRenderResend,
			"ImageOutPoint", 0x314, 0x317}, {mthdGrRenderResend, "DsDx", 0x318, 0x31b},
		{mthdGrRenderResend, "DtDy", 0x31c, 0x31f}, {mthdGrRenderResend, "ImageInSize",
			0x400, 0x403}, {mthdGrRenderResend, "ImageInPitch", 0x404, 0x407},
		{mthdGrRenderResend, "ImageInOffset", 0x408, 0x40b}, {mthdImageFromMem,
			"ImageInPoint", 0x40c, 0x40f}
};
EngineObjInfo       Nv03ScaledImageFromMemoryEngineObjInfo = {
	(((((0 ? 0x004E1FFF : 0x004E0000) >> 16) & (0xFFFFFFFF >> (31 - (1 ? (1 * 32 +
								22) : (1 * 32 + 16)) +
						(0 ? (1 * 32 + 22) : (1 * 32 +
								16))))) << ((0 ? (1 * 32 +
						22) : (1 * 32 +
						16)) & 31)) | ((0x00000001) << ((0 ? (1 * 32 +
						23) : (1 * 32 + 23)) & 31))), 0,
	{0x17100008, 0x0, 0x0}, grImageFromMemValidForHardware
};
ClassInfo           Nv03ScaledImageFromMemoryClassInfo = {
	(0x00000037), "NV03 Scaled Image From Memory", sizeof (GrImageFromMemObj), 0x1, 1,
		&Nv03ScaledImageFromMemoryEngineObjInfo, (void *) 0, (void *) 0,
		grAttachImageFromMem, (void *) 0, (void *) 0, grDetachImageFromMem, (void *) 0, 0,
		(void *) 0,
		(sizeof (Nv03ScaledImageFromMemoryMethods) /
		sizeof (Nv03ScaledImageFromMemoryMethods[0])), Nv03ScaledImageFromMemoryMethods
};
NvV32
grAttachDx3TexTriObj (GenericObj *genObj, NvClassAllocParameters *alloc)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrDxTexTriObj      *dxTexTriObj = (GrDxTexTriObj *) engObj;
	GrDx3TexTriObj     *dx3TexTriObj = (GrDx3TexTriObj *) dxTexTriObj;
	NvV32               status;

	;
	if ((status = grAttachObject (engObj)) != 0)
	{
		;
		return status;
	}
	dx3TexTriObj->ctxClip = (void *) 0;
	dx3TexTriObj->ctxDmaTexture = (void *) 0;
	dxTexTriObj->ctxSurfaces3d = (void *) 0;
	dxTexTriObj->next = (void *) 0;
	dxTexTriObj->prev = (void *) 0;
	return status;
}

NvV32
grDetachDx3TexTriObj (GenericObj *genObj)
{
	EngineObj          *engObj = (EngineObj *) genObj;
	GrDxTexTriObj      *dxTexTriObj = (GrDxTexTriObj *) engObj;
	GrDx3TexTriObj     *dx3TexTriObj = (GrDx3TexTriObj *) dxTexTriObj;
	GrNv03Surfaces3dObj *surfaces3dObj;
	NvV32               status;

	;
	if ((status = grDetachObject (genObj)) != 0)
	{
		;
		return status;
	}
	if (dx3TexTriObj->ctxClip)
	{
		;
		;
		dx3TexTriObj->ctxClip->base.refcnt--;
		;
		dx3TexTriObj->ctxClip = (void *) 0;
	}
	if (dx3TexTriObj->ctxDmaTexture)
	{
		;
		;
		dx3TexTriObj->ctxDmaTexture->base.refcnt--;
		;
		dx3TexTriObj->ctxDmaTexture = (void *) 0;
	}
	if (dxTexTriObj->ctxSurfaces3d)
	{
		;
		;
		surfaces3dObj = (GrNv03Surfaces3dObj *) dxTexTriObj->ctxSurfaces3d;
		if (dxTexTriObj->prev)
			dxTexTriObj->prev->next = dxTexTriObj->next;
		if (dxTexTriObj->next)
			dxTexTriObj->next->prev = dxTexTriObj->prev;
		if (surfaces3dObj->surfaceUsers == dxTexTriObj)
		{
			;
			surfaces3dObj->surfaceUsers = dxTexTriObj->next;
		}
		dxTexTriObj->ctxSurfaces3d->base.refcnt--;
		;
		dxTexTriObj->ctxSurfaces3d = (void *) 0;
	}
	return status;
}
static MethodInfo   Nv03Dx3TexturedTriangleMethods[] = {
	{mthdGrNoOperation, "NoOperation", 0x100, 0x103}, {mthdGrNotify, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetContextDmaTexture, "SetContextDmaTexture", 0x184, 0x187},
		{mthdSetContextClipRectangle, "SetContextClipRectangle", 0x188, 0x18b},
		{mthdSetContextSurfaces3d, "SetContextSurfaces", 0x18c, 0x18f}, {mthdGrRenderResend,
			"TextureOffset", 0x304, 0x307}, {mthdGrRenderResend, "TextureFormat", 0x308,
			0x30b}, {mthdGrRenderResend, "TextureFilter", 0x30c, 0x30f},
		{mthdGrRenderResend, "FogColor", 0x310, 0x313}, {mthdDx3Control0, "Control0", 0x314,
			0x317}, {mthdGrRenderResend, "Control1", 0x318, 0x31b},
		{mthdRenderDx3TexturedTriangle, "Tlvertex", 0x1000, 0x1fff},
};
EngineObjInfo       Nv03Dx3TexturedTriangleEngineObjInfo = {
	(((((0 ? 0x00571FFF : 0x00570000) >> 16) & (0xFFFFFFFF >> (31 - (1 ? (1 * 32 +
								22) : (1 * 32 + 16)) +
						(0 ? (1 * 32 + 22) : (1 * 32 +
								16))))) << ((0 ? (1 * 32 +
						22) : (1 * 32 +
						16)) & 31)) | ((0x00000001) << ((0 ? (1 * 32 +
						23) : (1 * 32 + 23)) & 31))), 0,
	{0x00401000, 0x0, 0x0}, grDx3TexturedTriangleValidForHardware
};
ClassInfo           Nv03Dx3TexturedTriangleClassInfo = {
	(0x00000048), "NV03 DX3 Textured Triangle", sizeof (GrDx3TexTriObj), 0x1, 1,
		&Nv03Dx3TexturedTriangleEngineObjInfo, (void *) 0, (void *) 0, grAttachDx3TexTriObj,
		(void *) 0, (void *) 0, grDetachDx3TexTriObj, (void *) 0, 0, (void *) 0,
		(sizeof (Nv03Dx3TexturedTriangleMethods) /
		sizeof (Nv03Dx3TexturedTriangleMethods[0])), Nv03Dx3TexturedTriangleMethods
};
static MethodInfo   Nv03GdiRectangleTextMethods[] = {
	{mthdGrNoOperation, "NoOperation", 0x100, 0x103}, {mthdGrNotify, "Notify", 0x104, 0x107},
		{mthdSetContextDmaNotifies, "SetContextDmaNotifies", 0x180, 0x183},
		{mthdSetContextPattern, "SetContextPattern", 0x184, 0x187}, {mthdSetContextRop,
			"SetContextRop", 0x188, 0x18b}, {mthdSetContextBeta1, "SetContextBeta1",
			0x18c, 0x18f}, {mthdSetContextSurfaces2d, "SetContextSurface", 0x190,
			0x193}, {mthdSetOperation, "SetOperation", 0x2fc, 0x2ff},
		{mthdSetColorFormat, "SetColorFormat", 0x300, 0x303}, {mthdSetMonochromeFormat,
			"SetMonochromeFormat", 0x304, 0x307}, {mthdGrRenderResend, "Color1A", 0x3fc,
			0x3ff}, {mthdRenderGdiRectangleText, "UnclippedRectangle", 0x400, 0x5ff},
		{mthdGrRenderResend, "ClipPoint0B", 0x7f4, 0x7f7}, {mthdGrRenderResend,
			"ClipPoint1B", 0x7f8, 0x7fb}, {mthdGrRenderResend, "Color1B", 0x7fc, 0x7ff},
		{mthdRenderGdiRectangleText, "ClippedRectangle", 0x800, 0x9ff}, {mthdGrRenderResend,
			"ClipPoint0C", 0xbec, 0xbef}, {mthdGrRenderResend, "ClipPoint1C", 0xbf0,
			0xbf3}, {mthdGrRenderResend, "Color1C", 0xbf4, 0xbf7}, {mthdGrRenderResend,
			"SizeC", 0xbf8, 0xbfb}, {mthdGrRenderResend, "PointC", 0xbfc, 0xbff},
		{mthdRenderGdiRectangleText, "MonochromeColor1C", 0xc00, 0xdff},
		{mthdGrRenderResend, "ClipPoint0D", 0xfe8, 0xfeb}, {mthdGrRenderResend,
			"ClipPoint1D", 0xfec, 0xfef}, {mthdGrRenderResend, "Color1D", 0xff0, 0xff3},
		{mthdGrRenderResend, "SizeInD", 0xff4, 0xff7}, {mthdGrRenderResend, "SizeOutD",
			0xff8, 0xffb}, {mthdGrRenderResend, "PointD", 0xffc, 0xfff},
		{mthdRenderGdiRectangleText, "MonochromeColor1D", 0x1000, 0x11ff},
		{mthdGrRenderResend, "ClipPoint0E", 0x13e4, 0x13e7}, {mthdGrRenderResend,
			"ClipPoint1E", 0x13e8, 0x13eb}, {mthdGrRenderResend, "Color0E", 0x13ec,
			0x13ef}, {mthdGrRenderResend, "Color1E", 0x13f0, 0x13f3},
		{mthdGrRenderResend, "SizeInE", 0x13f4, 0x13f7}, {mthdGrRenderResend, "SizeOutE",
			0x13f8, 0x13fb}, {mthdGrRenderResend, "PointE", 0x13fc, 0x13ff},
		{mthdRenderGdiRectangleText, "MonochromeColor01E", 0x1400, 0x15ff},
};
EngineObjInfo       Nv03GdiRectangleTextEngineObjInfo = {
	(((((0 ? 0x004C1FFF : 0x004C0000) >> 16) & (0xFFFFFFFF >> (31 - (1 ? (1 * 32 +
								22) : (1 * 32 + 16)) +
						(0 ? (1 * 32 + 22) : (1 * 32 +
								16))))) << ((0 ? (1 * 32 +
						22) : (1 * 32 +
						16)) & 31)) | ((0x00000001) << ((0 ? (1 * 32 +
						23) : (1 * 32 + 23)) & 31))), 0,
	{0x17100103, 0x0, 0x0}, grGdiRectObjectValidForHardware,
};
ClassInfo           Nv03GdiRectangleTextClassInfo = {
	(0x0000004B), "NV03 GDI Rectangle Text", sizeof (GrRenderObj), 0x1, 1,
		&Nv03GdiRectangleTextEngineObjInfo, (void *) 0, (void *) 0, grAttachRenderObj,
		(void *) 0, (void *) 0, grDetachRenderObj, (void *) 0, 0, (void *) 0,
		(sizeof (Nv03GdiRectangleTextMethods) / sizeof (Nv03GdiRectangleTextMethods[0])),
		Nv03GdiRectangleTextMethods
};
