 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


extern int          grRenderObjectValidForRendering (EngineObj *engObj);
extern int          grRenderObjectValidForHardware (EngineObj *engObj);
extern int          grImageBlitValidForRendering (EngineObj *engObj);
extern int          grImageBlitValidForHardware (EngineObj *engObj);
extern int          grImageObjectValidForRendering (EngineObj *engObj);
extern int          grImageObjectValidForHardware (EngineObj *engObj);
extern int          grImageFromMemValidForRendering (EngineObj *engObj);
extern int          grImageFromMemValidForHardware (EngineObj *engObj);
extern int          grMemoryToMemoryFormatValidForHardware (EngineObj *engObj);
extern int          grContextObjectValidForHardware (EngineObj *engObj);
extern int          grDx3TexturedTriangleValidForRendering (EngineObj *engObj);
extern int          grDx3TexturedTriangleValidForHardware (EngineObj *engObj);
extern int          grGdiRectObjectValidForRendering (EngineObj *engObj);
extern int          grGdiRectObjectValidForHardware (EngineObj *engObj);
extern void         grValidateObject (EngineObj *obj);
extern NvV32        mthdUnimplemented (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdGrNoOperation (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdGrResend (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdGrRenderResend (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaNotifies (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaScaledImage (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaTexture (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaA (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaB (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        nvFunc539 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        nvFunc536 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        nvFunc537 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextSurfaces2d (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextSurfaces3d (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextClipRectangle (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextColorKey (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextPattern (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextRop (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextBeta1 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetColorFormat (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetMonochromeFormat (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetOperation (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdGrNotify (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaBufferIn (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSetContextDmaBufferOut (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderLin (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderTriangle (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdDx3Control0 (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderRectangle (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdImageBlt (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdImageTransfer (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdMemoryToMemoryFormat (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderDx3TexturedTriangle (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdRenderGdiRectangleText (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdImageFromMem (EngineObj *, MethodInfo *, NvV32, NvV32, int);
void
grUpdateContextSwitch1 (EngineObj *engObj, NvV32 ctxSwitch)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	unsigned int        chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvU32               fifo;
	int                 i;

	;
	;
	(hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
				((((0 ? (0 * 32 + 31) : (0 * 32 + 0)) / 32) << 2)))) / 4] =
		(NvV32) ((ctxSwitch));
	fifo = ((hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4]);
	(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] = (NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	if (hwdev->info.Graphics.CurrentChID == chid)
	{
		for (i = 0; i < 8; i++)
		{
			if (engObj->instMemLoc == ((hwreg)->Reg32[((0x004001e0 + (i) * 4)) / 4]))
			{
				;
				;
				(hwreg)->Reg32[((0x00400180 + (i) * 4)) / 4] = (NvV32) (ctxSwitch);
			}
		}
		if (engObj->instMemLoc ==
			(((((hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH4) / 4])) >> ((0 ? 15 : 0) %
						32)) & (0xFFFFFFFF >> (31 - ((1 ? 15 : 0) % 32) +
						((0 ? 15 : 0) % 32)))))
		{
			;
			(hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH1) / 4] = (NvV32) (ctxSwitch);
		}
	}
	else
	{
		for (i = 0; i < 8; i++)
		{
			if (engObj->instMemLoc == hwchan->gr.ctx_cache4[i])
			{
				;
				;
				hwchan->gr.ctx_cache1[i] = ctxSwitch;
			}
		}
		if (engObj->instMemLoc == hwchan->gr.ctx_switch4)
		{
			;
			hwchan->gr.ctx_switch1 = ctxSwitch;
		}
	}
	(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] = (NvV32) (fifo);
}

void
grUpdateContextSwitch2 (EngineObj *engObj, NvV32 ctxSwitch)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	unsigned int        chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvU32               fifo;
	int                 i;

	;
	;
	(hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
				((((0 ? (1 * 32 + 31) : (1 * 32 + 0)) / 32) << 2)))) / 4] =
		(NvV32) ((ctxSwitch));
	fifo = ((hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4]);
	(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] = (NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	if (hwdev->info.Graphics.CurrentChID == chid)
	{
		for (i = 0; i < 8; i++)
		{
			if (engObj->instMemLoc == ((hwreg)->Reg32[((0x004001e0 + (i) * 4)) / 4]))
			{
				;
				;
				(hwreg)->Reg32[((0x004001a0 + (i) * 4)) / 4] = (NvV32) (ctxSwitch);
			}
		}
		if (engObj->instMemLoc ==
			(((((hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH4) / 4])) >> ((0 ? 15 : 0) %
						32)) & (0xFFFFFFFF >> (31 - ((1 ? 15 : 0) % 32) +
						((0 ? 15 : 0) % 32)))))
		{
			;
			(hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH2) / 4] = (NvV32) (ctxSwitch);
		}
	}
	else
	{
		for (i = 0; i < 8; i++)
		{
			if (engObj->instMemLoc == hwchan->gr.ctx_cache4[i])
			{
				;
				;
				hwchan->gr.ctx_cache2[i] = ctxSwitch;
			}
		}
		if (engObj->instMemLoc == hwchan->gr.ctx_switch4)
		{
			;
			hwchan->gr.ctx_switch2 = ctxSwitch;
		}
	}
	(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] = (NvV32) (fifo);
}

void
grUpdateContextSwitch3 (EngineObj *engObj, NvV32 ctxSwitch)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	unsigned int        chid = objectToChID (engObj);
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvU32               fifo;
	int                 i;

	;
	;
	(hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
				((((0 ? (2 * 32 + 31) : (2 * 32 + 0)) / 32) << 2)))) / 4] =
		(NvV32) ((ctxSwitch));
	fifo = ((hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4]);
	(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] = (NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	if (hwdev->info.Graphics.CurrentChID == chid)
	{
		for (i = 0; i < 8; i++)
		{
			if (engObj->instMemLoc == ((hwreg)->Reg32[((0x004001e0 + (i) * 4)) / 4]))
			{
				;
				;
				(hwreg)->Reg32[((0x004001c0 + (i) * 4)) / 4] = (NvV32) (ctxSwitch);
			}
		}
		if (engObj->instMemLoc ==
			(((((hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH4) / 4])) >> ((0 ? 15 : 0) %
						32)) & (0xFFFFFFFF >> (31 - ((1 ? 15 : 0) % 32) +
						((0 ? 15 : 0) % 32)))))
		{
			;
			(hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH3) / 4] = (NvV32) (ctxSwitch);
		}
	}
	else
	{
		for (i = 0; i < 8; i++)
		{
			if (engObj->instMemLoc == hwchan->gr.ctx_cache4[i])
			{
				;
				;
				hwchan->gr.ctx_cache3[i] = ctxSwitch;
			}
		}
		if (engObj->instMemLoc == hwchan->gr.ctx_switch4)
		{
			;
			hwchan->gr.ctx_switch3 = ctxSwitch;
		}
	}
	(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] = (NvV32) (fifo);
}

void
grNotifyIfNeeded (EngineObj *engObj)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               notify;

	notify = ((hwreg)->Reg32[(NV_PGRAPH_NOTIFY) / 4]);
	;
	if (notify & ((0x00000001) << ((0 ? 16 : 16) % 32)))
	{
		NvContextDmaObj    *contextDmaObj;
		NvU32               ctx2,
		                    instMemLoc;

		(hwreg)->Reg32[(NV_PGRAPH_NOTIFY) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_NOTIFY) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 16 : 16) % 32) +
							((0 ? 16 : 16) % 32))) << ((0 ? 16 : 16) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 16 : 16) % 32)));
		ctx2 = ((hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH2) / 4]);
		instMemLoc =
			(((ctx2) >> ((0 ? 31 : 16) % 32)) & (0xFFFFFFFF >> (31 -
					((1 ? 31 : 16) % 32) + ((0 ? 31 : 16) % 32))));
		contextDmaObj =
			fifoInstMemLocToContextDma (device, objectToChID (engObj), instMemLoc);
		if (contextDmaObj)
		{
			NvV32               style;

			style = (((notify) >> ((0 ? 20 : 20) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 20 : 20) % 32) + ((0 ? 20 : 20) % 32))));
			grNotify (engObj, (style == 0x00000001), 0, 0);
		}
		else
		{
			;
		}
	}
}
NvV32
mthdUnimplemented (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	;
	return 0;
}

NvV32
mthdGrResend (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);

	;
	if (cause == 1)
	{
		(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
	}
	fifoResend (device, engObj, offset, data);
	if (cause == 1)
	{
		(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
	}
	return 0;
}
static NvV8         sourceColor[14] = {
	0x0, 0x1, 0x5, 0x9, 0x4, 0x5, 0xd, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd,
};
static NvV8         zWriteEnable[6] = {
	0x0, 0x1, 0x2, 0x3, 0x4, 0x0,
};
static NvV8         rop[3] = {
	0x0, 0x2, 0x2,
};
static NvV32        blend[32] = {
	0x65, 0x56, 0x56, 0x12, 0xa9, 0xa9, 0xa9, 0xa9, 0x15, 0x16, 0x16, 0x12, 0x19, 0x19, 0x19,
		0x19, 0x61, 0x51, 0x51, 0x11, 0xa1, 0xa1, 0xa1, 0xa1, 0x11, 0x11, 0x11, 0x11, 0x11,
		0x11, 0x11, 0x11,
};
NvV32
mthdDx3Control0 (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               status;

	;
	if (((data & 0x0000000f) >= 0x03) || ((data & 0x00000030) & 0x0)
		|| ((data & 0x000000c0) & 0x0) || ((data & 0x00000f00) == 0x0700)
		|| ((data & 0x00000f00) == 0x0a00) || ((data & 0x00000f00) == 0x0b00)
		|| ((data & 0x00000f00) >= 0x0e00) || ((data & 0x00007000) == 0x0)
		|| ((data & 0x00007000) >= 0x4000) || ((data & 0x00008000) & 0x0)
		|| ((data & 0x000f0000) == 0x0) || ((data & 0x000f0000) >= 0x00090000)
		|| ((data & 0x00f00000) >= 0x00600000) || ((data & 0x07000000) >= 0x05000000)
		|| ((data & 0x18000000) == 0x18000000) || ((data & 0x20000000) & 0x0)
		|| ((data & 0x40000000) & 0x0) || ((data & 0x80000000) & 0x0))
	{
		return (0x02000000);
	}
	data = (data & ~0x18f00f00) | (sourceColor[(data & 0x0f00) >> 8] << 8) | (zWriteEnable[(data
				& 0x00f00000) >> 20] << 20) | (rop[(data & 0x18000000) >> 27] <<
		27);
	status = mthdGrResend (engObj, method, offset, data, cause);
	if (status != 0)
		return status;
	while ((volatile) ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]))
	{
		NvU32               pmc;

		pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);
		if (pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
		{
			grService (device);
		}
	};
	(hwreg)->Reg32[(NV_PGRAPH_CONTROL0) / 4] = (NvV32) (((0x00000001) << ((0 ? 14 : 14) % 32)));
	(hwreg)->Reg32[(NV_PGRAPH_BLEND) / 4] =
		(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_BLEND) /
					4]) & ~0xff000000) | data & 0x10000000 ? 0x22000000 :
		blend[((data >> (29 - 2)) & 0x1c) | ((data >> 10) & 0x03)] << 24);
	(hwreg)->Reg32[(NV_PGRAPH_CONTROL0) / 4] = (NvV32) (((0x00000001) << ((0 ? 14 : 14) % 32)));
	(hwreg)->Reg32[(0x00400590) / 4] = (NvV32) (0x24100c10);
	(hwreg)->Reg32[(0x00400598) / 4] = (NvV32) (0x24100c10);
	return status;
}

NvV32
mthdImageBlt (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;

	;
	if (((hwdev->info.Chip.Architecture > 0x00000004)
			|| (hwdev->info.Chip.Architecture == 0x00000004
				&& hwdev->info.Chip.MaskRevision >= 0x00000001)))
	{
		;
	}
	return mthdGrResend (engObj, method, offset, data, cause);
}

NvV32
mthdSetContextDmaNotifies (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data,
	int cause)
{
	NvDeviceInfo       *dev =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	EngineObjInfo      *engObjInfo;
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) dev;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GenericObj         *dataObj;
	NvContextDmaObj    *ctxDmaObj;
	NvU32               ctx1,
	                    ctx2;

	;
	;
	if (data != (NV_PMC_BOOT_0))
	{
		dataObj = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
		if (dataObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (dataObj->classInfo->num != (0x00000002))
		{
			;
			return (0x02000000);
		}
		engObjInfo = (EngineObjInfo *) ((engObj)->base.classInfo->objectInfo);
		ctxDmaObj = (NvContextDmaObj *) dataObj;
		if (((((ctxDmaObj->memoryObj->base.classInfo->num) != (0x00000040))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (((ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003D))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003E))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) ==
						(0x00000001))))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(0x00000002)))))
		{
			;
			;
			return (0x01000000);
		}
		ctx2 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) +
						((engObj->instMemLoc) << 4) + ((((0 ? (1 * 32 +
											31) : (1 *
											32 +
											0)) /
									32) << 2)))) / 4]);
		ctx2 &= ~((0xFFFFFFFF >> (31 - ((1 ? 31 : 16) % 32) +
					((0 ? 31 : 16) % 32))) << ((0 ? 31 : 16) % 32));
		ctx2 |= (((ctxDmaObj->instOffset) & (0xFFFFFFFF >> (31 - ((1 ? 31 : 16) % 32) +
						((0 ? 31 : 16) % 32)))) << ((0 ? 31 : 16) % 32));
		if (engObj->notifyCtxDma != (void *) 0)
		{
			engObj->notifyCtxDma->base.refcnt--;
			;
		}
		ctxDmaObj->base.refcnt++;
		;
		engObj->notifyCtxDma = ctxDmaObj;
	}
	else
	{
		ctx2 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) +
						((engObj->instMemLoc) << 4) + ((((0 ? (1 * 32 +
											31) : (1 *
											32 +
											0)) /
									32) << 2)))) / 4]);
		ctx2 &= ~((0xFFFFFFFF >> (31 - ((1 ? 31 : 16) % 32) +
					((0 ? 31 : 16) % 32))) << ((0 ? 31 : 16) % 32));
		ctxDmaObj = engObj->notifyCtxDma;
		if (ctxDmaObj != (void *) 0)
		{
			ctxDmaObj->base.refcnt--;
			;
			engObj->notifyCtxDma = (void *) 0;
		}
	}
	;
	grUpdateContextSwitch2 (engObj, ctx2);
	ctx1 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
					((((0 ? (0 * 32 + 31) : (0 * 32 + 0)) / 32) << 2)))) / 4]);
	;
	if ((((EngineObjInfo *) ((engObj)->base.classInfo->objectInfo))->
			validateForHardware (engObj)))
	{
		if (!(ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32))))
		{
			ctx1 |= ((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	else
	{
		if (ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32)))
		{
			ctx1 &= ~((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	grNotifyIfNeeded (engObj);
	return 0;
}

NvV32
mthdSetContextDmaScaledImage (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data,
	int cause)
{
	NvDeviceInfo       *dev =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	GrImageFromMemObj  *imageFromMemObj = (GrImageFromMemObj *) engObj;
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) dev;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GenericObj         *dataObj;
	NvContextDmaObj    *ctxDmaObj;
	NvU32               ctx1,
	                    ctx3;

	;
	;
	;
	;
	;
	if (data != (NV_PMC_BOOT_0))
	{
		dataObj = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
		if (dataObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (dataObj->classInfo->num != (0x00000002))
		{
			;
			return (0x02000000);
		}
		ctxDmaObj = (NvContextDmaObj *) dataObj;
		if (((((ctxDmaObj->memoryObj->base.classInfo->num) != (0x00000040))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (((ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003D))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003E))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) ==
						(0x00000001))))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(0x00000002)))))
		{
			;
			;
			return (0x01000000);
		}
		ctx3 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) +
						((engObj->instMemLoc) << 4) + ((((0 ? (2 * 32 +
											31) : (2 *
											32 +
											0)) /
									32) << 2)))) / 4]);
		ctx3 &= ~((0xFFFFFFFF >> (31 - ((1 ? 15 : 0) % 32) +
					((0 ? 15 : 0) % 32))) << ((0 ? 15 : 0) % 32));
		ctx3 |= (((ctxDmaObj->instOffset) & (0xFFFFFFFF >> (31 - ((1 ? 15 : 0) % 32) +
						((0 ? 15 : 0) % 32)))) << ((0 ? 15 : 0) % 32));
		if (imageFromMemObj->ctxDmaImage != (void *) 0)
		{
			imageFromMemObj->ctxDmaImage->base.refcnt--;
			;
		}
		ctxDmaObj->base.refcnt++;
		;
		imageFromMemObj->ctxDmaImage = ctxDmaObj;
	}
	else
	{
		ctx3 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) +
						((engObj->instMemLoc) << 4) + ((((0 ? (2 * 32 +
											31) : (2 *
											32 +
											0)) /
									32) << 2)))) / 4]);
		ctx3 &= ~((0xFFFFFFFF >> (31 - ((1 ? 15 : 0) % 32) +
					((0 ? 15 : 0) % 32))) << ((0 ? 15 : 0) % 32));
		ctxDmaObj = imageFromMemObj->ctxDmaImage;
		if (ctxDmaObj != (void *) 0)
		{
			ctxDmaObj->base.refcnt--;
			;
			imageFromMemObj->ctxDmaImage = (void *) 0;
		}
	}
	grUpdateContextSwitch3 (engObj, ctx3);
	ctx1 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
					((((0 ? (0 * 32 + 31) : (0 * 32 + 0)) / 32) << 2)))) / 4]);
	if ((((EngineObjInfo *) ((engObj)->base.classInfo->objectInfo))->
			validateForHardware (engObj)))
	{
		if (!(ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32))))
		{
			ctx1 |= ((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	else
	{
		if (ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32)))
		{
			ctx1 &= ~((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	grNotifyIfNeeded (engObj);
	;
	return 0;
}

NvV32
mthdSetContextDmaTexture (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data,
	int cause)
{
	NvDeviceInfo       *dev =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	GrDx3TexTriObj     *dx3TexTriObj = (GrDx3TexTriObj *) engObj;
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) dev;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GenericObj         *dataObj;
	NvContextDmaObj    *ctxDmaObj;
	NvU32               ctx1,
	                    ctx3;

	;
	if (data != (NV_PMC_BOOT_0))
	{
		dataObj = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
		if (dataObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (dataObj->classInfo->num != (0x00000002))
		{
			;
			return (0x02000000);
		}
		ctxDmaObj = (NvContextDmaObj *) dataObj;
		;
		;
		if (((((ctxDmaObj->memoryObj->base.classInfo->num) != (0x00000040))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (((ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003D))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003E))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) ==
						(0x00000001))))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(0x00000001))))
			|| ((((unsigned long) (&ctxDmaObj->offset)->low) & 0xff) != 0)
			|| ((((unsigned long) (&ctxDmaObj->limit)->low) & 0xff) != 0xff))
		{
			;
			;
			;
			return (0x01000000);
		}
		ctx3 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) +
						((engObj->instMemLoc) << 4) + ((((0 ? (2 * 32 +
											31) : (2 *
											32 +
											0)) /
									32) << 2)))) / 4]);
		ctx3 &= ~((0xFFFFFFFF >> (31 - ((1 ? 15 : 0) % 32) +
					((0 ? 15 : 0) % 32))) << ((0 ? 15 : 0) % 32));
		ctx3 &= ~((0xFFFFFFFF >> (31 - ((1 ? 31 : 16) % 32) +
					((0 ? 31 : 16) % 32))) << ((0 ? 31 : 16) % 32));
		ctx3 |= (((ctxDmaObj->instOffset) & (0xFFFFFFFF >> (31 - ((1 ? 15 : 0) % 32) +
						((0 ? 15 : 0) % 32)))) << ((0 ? 15 : 0) % 32));
		ctx3 |= (((ctxDmaObj->instOffset) & (0xFFFFFFFF >> (31 - ((1 ? 31 : 16) % 32) +
						((0 ? 31 : 16) % 32)))) << ((0 ? 31 : 16) % 32));
		if (dx3TexTriObj->ctxDmaTexture != (void *) 0)
		{
			dx3TexTriObj->ctxDmaTexture->base.refcnt--;
			;
		}
		ctxDmaObj->base.refcnt++;
		;
		dx3TexTriObj->ctxDmaTexture = ctxDmaObj;
	}
	else
	{
		ctx3 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) +
						((engObj->instMemLoc) << 4) + ((((0 ? (2 * 32 +
											31) : (2 *
											32 +
											0)) /
									32) << 2)))) / 4]);
		ctx3 &= ~((0xFFFFFFFF >> (31 - ((1 ? 15 : 0) % 32) +
					((0 ? 15 : 0) % 32))) << ((0 ? 15 : 0) % 32));
		ctx3 &= ~((0xFFFFFFFF >> (31 - ((1 ? 31 : 16) % 32) +
					((0 ? 31 : 16) % 32))) << ((0 ? 31 : 16) % 32));
		ctxDmaObj = dx3TexTriObj->ctxDmaTexture;
		if (ctxDmaObj != (void *) 0)
		{
			ctxDmaObj->base.refcnt--;
			;
			dx3TexTriObj->ctxDmaTexture = (void *) 0;
		}
	}
	grUpdateContextSwitch3 (engObj, ctx3);
	ctx1 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
					((((0 ? (0 * 32 + 31) : (0 * 32 + 0)) / 32) << 2)))) / 4]);
	if ((((EngineObjInfo *) ((engObj)->base.classInfo->objectInfo))->
			validateForHardware (engObj)))
	{
		if (!(ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32))))
		{
			ctx1 |= ((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	else
	{
		if (ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32)))
		{
			ctx1 &= ~((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	grNotifyIfNeeded (engObj);
	;
	return 0;
}

NvV32
mthdSetContextDmaA (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvDeviceInfo       *dev =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	GrDx5TexTriObj     *dx5TexTriObj = (GrDx5TexTriObj *) engObj;
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) dev;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GenericObj         *dataObj;
	NvContextDmaObj    *ctxDmaObj;
	NvU32               ctx1,
	                    ctx3;

	;
	if (data != (NV_PMC_BOOT_0))
	{
		dataObj = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
		if (dataObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (dataObj->classInfo->num != (0x00000002))
		{
			;
			return (0x02000000);
		}
		ctxDmaObj = (NvContextDmaObj *) dataObj;
		;
		if (((((ctxDmaObj->memoryObj->base.classInfo->num) != (0x00000040))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (((ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003D))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003E))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) ==
						(0x00000001))))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(0x00000001))))
			|| ((((unsigned long) (&ctxDmaObj->offset)->low) & 0xff) != 0)
			|| ((((unsigned long) (&ctxDmaObj->limit)->low) & 0xff) != 0xff))
		{
			;
			;
			;
			return (0x01000000);
		}
		ctx3 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) +
						((engObj->instMemLoc) << 4) + ((((0 ? (2 * 32 +
											31) : (2 *
											32 +
											0)) /
									32) << 2)))) / 4]);
		ctx3 &= ~((0xFFFFFFFF >> (31 - ((1 ? 15 : 0) % 32) +
					((0 ? 15 : 0) % 32))) << ((0 ? 15 : 0) % 32));
		ctx3 |= (((ctxDmaObj->instOffset) & (0xFFFFFFFF >> (31 - ((1 ? 15 : 0) % 32) +
						((0 ? 15 : 0) % 32)))) << ((0 ? 15 : 0) % 32));
		if (dx5TexTriObj->ctxDmaA != (void *) 0)
		{
			dx5TexTriObj->ctxDmaA->base.refcnt--;
			;
		}
		ctxDmaObj->base.refcnt++;
		;
		dx5TexTriObj->ctxDmaA = ctxDmaObj;
	}
	else
	{
		ctx3 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) +
						((engObj->instMemLoc) << 4) + ((((0 ? (2 * 32 +
											31) : (2 *
											32 +
											0)) /
									32) << 2)))) / 4]);
		ctx3 &= ~((0xFFFFFFFF >> (31 - ((1 ? 15 : 0) % 32) +
					((0 ? 15 : 0) % 32))) << ((0 ? 15 : 0) % 32));
		ctxDmaObj = dx5TexTriObj->ctxDmaB;
		if (ctxDmaObj != (void *) 0)
		{
			ctxDmaObj->base.refcnt--;
			;
			dx5TexTriObj->ctxDmaB = (void *) 0;
		}
	}
	grUpdateContextSwitch3 (engObj, ctx3);
	ctx1 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
					((((0 ? (0 * 32 + 31) : (0 * 32 + 0)) / 32) << 2)))) / 4]);
	if ((((EngineObjInfo *) ((engObj)->base.classInfo->objectInfo))->
			validateForHardware (engObj)))
	{
		if (!(ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32))))
		{
			ctx1 |= ((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	else
	{
		if (ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32)))
		{
			ctx1 &= ~((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	grNotifyIfNeeded (engObj);
	;
	return 0;
}

NvV32
mthdSetContextDmaB (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvDeviceInfo       *dev =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	GrDx5TexTriObj     *dx5TexTriObj = (GrDx5TexTriObj *) engObj;
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) dev;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GenericObj         *dataObj;
	NvContextDmaObj    *ctxDmaObj;
	NvU32               ctx1,
	                    ctx3;

	;
	if (data != (NV_PMC_BOOT_0))
	{
		dataObj = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
		if (dataObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (dataObj->classInfo->num != (0x00000002))
		{
			;
			return (0x02000000);
		}
		ctxDmaObj = (NvContextDmaObj *) dataObj;
		;
		if (((((ctxDmaObj->memoryObj->base.classInfo->num) != (0x00000040))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (((ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003D))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003E))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) ==
						(0x00000001))))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(0x00000001))))
			|| ((((unsigned long) (&ctxDmaObj->offset)->low) & 0xff) != 0)
			|| ((((unsigned long) (&ctxDmaObj->limit)->low) & 0xff) != 0xff))
		{
			;
			;
			;
			return (0x01000000);
		}
		ctx3 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) +
						((engObj->instMemLoc) << 4) + ((((0 ? (2 * 32 +
											31) : (2 *
											32 +
											0)) /
									32) << 2)))) / 4]);
		ctx3 &= ~((0xFFFFFFFF >> (31 - ((1 ? 31 : 16) % 32) +
					((0 ? 31 : 16) % 32))) << ((0 ? 31 : 16) % 32));
		ctx3 |= (((ctxDmaObj->instOffset) & (0xFFFFFFFF >> (31 - ((1 ? 31 : 16) % 32) +
						((0 ? 31 : 16) % 32)))) << ((0 ? 31 : 16) % 32));
		if (dx5TexTriObj->ctxDmaB != (void *) 0)
		{
			dx5TexTriObj->ctxDmaB->base.refcnt--;
			;
		}
		ctxDmaObj->base.refcnt++;
		;
		dx5TexTriObj->ctxDmaB = ctxDmaObj;
	}
	else
	{
		ctx3 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) +
						((engObj->instMemLoc) << 4) + ((((0 ? (2 * 32 +
											31) : (2 *
											32 +
											0)) /
									32) << 2)))) / 4]);
		ctx3 &= ~((0xFFFFFFFF >> (31 - ((1 ? 31 : 16) % 32) +
					((0 ? 31 : 16) % 32))) << ((0 ? 31 : 16) % 32));
		ctxDmaObj = dx5TexTriObj->ctxDmaB;
		if (ctxDmaObj != (void *) 0)
		{
			ctxDmaObj->base.refcnt--;
			;
			dx5TexTriObj->ctxDmaB = (void *) 0;
		}
	}
	grUpdateContextSwitch3 (engObj, ctx3);
	ctx1 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
					((((0 ? (0 * 32 + 31) : (0 * 32 + 0)) / 32) << 2)))) / 4]);
	if ((((EngineObjInfo *) ((engObj)->base.classInfo->objectInfo))->
			validateForHardware (engObj)))
	{
		if (!(ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32))))
		{
			ctx1 |= ((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	else
	{
		if (ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32)))
		{
			ctx1 &= ~((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	grNotifyIfNeeded (engObj);
	;
	return 0;
}

NvV32
mthdSetContextSurfaces2d (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data,
	int cause)
{
	NvDeviceInfo       *dev =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) dev;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               ctx1;
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GrRenderObj        *renderObj = (GrRenderObj *) engObj;
	EngineObj          *surfaceObj;

	;
	if (data != (NV_PMC_BOOT_0))
	{
		surfaceObj =
			(EngineObj *) (nvArchDevFuncTable->nvArchLookupObjectByName) (session,
			data);
		if (surfaceObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (((surfaceObj)->base.classInfo->num) != (0x00000058))
		{
			;
			return (0x02000000);
		}
		if (surfaceObj->base.parent != renderObj->base.base.parent)
		{
			;
			return (0x02000000);
		}
		if (renderObj->ctxSurfaces2d != (void *) 0)
		{
			renderObj->ctxSurfaces2d->base.refcnt--;
			;
		}
		renderObj->ctxSurfaces2d = surfaceObj;
		surfaceObj->base.refcnt++;
		;
	}
	else
	{
		surfaceObj = renderObj->ctxSurfaces2d;
		if (surfaceObj != (void *) 0)
		{
			surfaceObj->base.refcnt--;
			;
			renderObj->ctxSurfaces2d = (void *) 0;
		}
	}
	ctx1 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
					((((0 ? (0 * 32 + 31) : (0 * 32 + 0)) / 32) << 2)))) / 4]);
	;
	if ((((EngineObjInfo *) ((engObj)->base.classInfo->objectInfo))->
			validateForHardware (engObj)))
	{
		if (!(ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32))))
		{
			ctx1 |= ((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	else
	{
		if (ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32)))
		{
			ctx1 &= ~((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	grNotifyIfNeeded (engObj);
	return 0;
}

NvV32
mthdSetContextSurfaces3d (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data,
	int cause)
{
	NvDeviceInfo       *dev =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) dev;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               ctx1;
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GrDxTexTriObj      *triObj = (GrDxTexTriObj *) engObj;
	EngineObj          *surfaceObj;

	;
	if (data != (NV_PMC_BOOT_0))
	{
		surfaceObj =
			(EngineObj *) (nvArchDevFuncTable->nvArchLookupObjectByName) (session,
			data);
		if (surfaceObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if ((((surfaceObj)->base.classInfo->num) != (0x0000005A))
			&& ((((engObj)->base.classInfo->num) == (0x00000054))
				&& (((surfaceObj)->base.classInfo->num) != (0x00000053))))
		{
			;
			return (0x02000000);
		}
		if (surfaceObj->base.parent != triObj->base.base.parent)
		{
			;
			return (0x02000000);
		}
		if (triObj->ctxSurfaces3d != (void *) 0)
		{
			triObj->ctxSurfaces3d->base.refcnt--;
			;
		}
		triObj->ctxSurfaces3d = surfaceObj;
		surfaceObj->base.refcnt++;
		;
	}
	else
	{
		surfaceObj = triObj->ctxSurfaces3d;
		if (surfaceObj != (void *) 0)
		{
			surfaceObj->base.refcnt--;
			;
			triObj->ctxSurfaces3d = (void *) 0;
		}
	}
	ctx1 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
					((((0 ? (0 * 32 + 31) : (0 * 32 + 0)) / 32) << 2)))) / 4]);
	if ((((EngineObjInfo *) ((engObj)->base.classInfo->objectInfo))->
			validateForHardware (engObj)))
	{
		if (!(ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32))))
		{
			ctx1 |= ((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	else
	{
		if (ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32)))
		{
			ctx1 &= ~((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	grNotifyIfNeeded (engObj);
	return 0;
}

NvV32
mthdSetContextClipRectangle (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data,
	int cause)
{
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	EngineObj          *clipObj,
	                  **ctxClip;
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               ctx1;

	;
	if (((engObj)->base.classInfo->num) == (0x00000048))
		ctxClip = &(((GrDx3TexTriObj *) engObj)->ctxClip);
	else
		ctxClip = &(((GrRenderObj *) engObj)->ctxClip);
	if (data != (NV_PMC_BOOT_0))
	{
		clipObj =
			(EngineObj *) (nvArchDevFuncTable->nvArchLookupObjectByName) (session,
			data);
		if (clipObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (((clipObj)->base.classInfo->num) != (0x00000019))
		{
			;
			return (0x02000000);
		}
		if (clipObj->base.parent != engObj->base.parent)
		{
			;
			return (0x02000000);
		}
		if (*ctxClip)
		{
			(*ctxClip)->base.refcnt--;
			;
		}
		*ctxClip = clipObj;
		clipObj->base.refcnt++;
		;
		ctx1 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) +
						((engObj->instMemLoc) << 4) + ((((0 ? (0 * 32 +
											31) : (0 *
											32 +
											0)) /
									32) << 2)))) / 4]);
		ctx1 |= ((0x00000001) << ((0 ? 13 : 13) % 32));
	}
	else
	{
		ctx1 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) +
						((engObj->instMemLoc) << 4) + ((((0 ? (0 * 32 +
											31) : (0 *
											32 +
											0)) /
									32) << 2)))) / 4]);
		ctx1 &= ~((0x00000001) << ((0 ? 13 : 13) % 32));
		if (*ctxClip)
		{
			(*ctxClip)->base.refcnt--;
			;
			*ctxClip = (void *) 0;
		}
	}
	if ((((EngineObjInfo *) ((engObj)->base.classInfo->objectInfo))->
			validateForHardware (engObj)))
		ctx1 |= ((0x00000001) << ((0 ? 24 : 24) % 32));
	else
		ctx1 &= ~((0x00000001) << ((0 ? 24 : 24) % 32));
	grUpdateContextSwitch1 (engObj, ctx1);
	grNotifyIfNeeded (engObj);
	return 0;
}

NvV32
mthdSetContextColorKey (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GrImageObj         *imageObj = (GrImageObj *) engObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	EngineObj          *colorKeyObj;
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               ctx1;

	;
	if (data != (NV_PMC_BOOT_0))
	{
		colorKeyObj =
			(EngineObj *) (nvArchDevFuncTable->nvArchLookupObjectByName) (session,
			data);
		if (colorKeyObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (((colorKeyObj)->base.classInfo->num) != (0x00000017))
		{
			;
			return (0x02000000);
		}
		if (colorKeyObj->base.parent != imageObj->base.base.base.parent)
		{
			;
			return (0x02000000);
		}
		if (imageObj->ctxColorKey)
		{
			imageObj->ctxColorKey->base.refcnt--;
			;
		}
		imageObj->ctxColorKey = colorKeyObj;
		colorKeyObj->base.refcnt++;
		;
		ctx1 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) +
						((engObj->instMemLoc) << 4) + ((((0 ? (0 * 32 +
											31) : (0 *
											32 +
											0)) /
									32) << 2)))) / 4]);
		ctx1 |= ((0x00000001) << ((0 ? 12 : 12) % 32));
	}
	else
	{
		ctx1 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) +
						((engObj->instMemLoc) << 4) + ((((0 ? (0 * 32 +
											31) : (0 *
											32 +
											0)) /
									32) << 2)))) / 4]);
		ctx1 &= ~((0x00000001) << ((0 ? 12 : 12) % 32));
		if (imageObj->ctxColorKey)
		{
			imageObj->ctxColorKey->base.refcnt--;
			;
			imageObj->ctxColorKey = (void *) 0;
		}
	}
	if ((((EngineObjInfo *) ((engObj)->base.classInfo->objectInfo))->
			validateForHardware (engObj)))
		ctx1 |= ((0x00000001) << ((0 ? 24 : 24) % 32));
	else
		ctx1 &= ~((0x00000001) << ((0 ? 24 : 24) % 32));
	grUpdateContextSwitch1 (engObj, ctx1);
	grNotifyIfNeeded (engObj);
	return 0;
}

NvV32
mthdSetContextPattern (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GrRenderObj        *renderObj = (GrRenderObj *) engObj;
	EngineObj          *patternObj;
	HwDeviceInfo       *hwdev =
		(HwDeviceInfo *) ((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->
					parent))->device->deviceInfo));
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               ctx1;

	;
	if (data != (NV_PMC_BOOT_0))
	{
		patternObj =
			(EngineObj *) (nvArchDevFuncTable->nvArchLookupObjectByName) (session,
			data);
		if (patternObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (((patternObj)->base.classInfo->num) != (0x00000018))
		{
			;
			return (0x02000000);
		}
		if (patternObj->base.parent != renderObj->base.base.parent)
		{
			;
			return (0x02000000);
		}
		if (renderObj->ctxPattern)
		{
			renderObj->ctxPattern->base.refcnt--;
			;
		}
		renderObj->ctxPattern = patternObj;
		patternObj->base.refcnt++;
		;
	}
	else
	{
		if (renderObj->ctxPattern)
		{
			renderObj->ctxPattern->base.refcnt--;
			;
			renderObj->ctxPattern = (void *) 0;
		}
	}
	ctx1 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
					((((0 ? (0 * 32 + 31) : (0 * 32 + 0)) / 32) << 2)))) / 4]);
	if ((((EngineObjInfo *) ((engObj)->base.classInfo->objectInfo))->
			validateForHardware (engObj)))
	{
		if (!(ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32))))
		{
			ctx1 |= ((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	else
	{
		if (ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32)))
		{
			ctx1 &= ~((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	grNotifyIfNeeded (engObj);
	return 0;
}

NvV32
mthdSetContextRop (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GrRenderObj        *renderObj = (GrRenderObj *) engObj;
	EngineObj          *ropObj;
	HwDeviceInfo       *hwdev =
		(HwDeviceInfo *) ((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->
					parent))->device->deviceInfo));
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               ctx1;

	;
	if (data != (NV_PMC_BOOT_0))
	{
		ropObj = (EngineObj *) (nvArchDevFuncTable->nvArchLookupObjectByName) (session,
			data);
		if (ropObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (((ropObj)->base.classInfo->num) != (0x00000043))
		{
			;
			return (0x02000000);
		}
		if (ropObj->base.parent != renderObj->base.base.parent)
		{
			;
			return (0x02000000);
		}
		if (renderObj->ctxRop)
		{
			renderObj->ctxRop->base.refcnt--;
			;
		}
		renderObj->ctxRop = ropObj;
		ropObj->base.refcnt++;
		;
	}
	else
	{
		if (renderObj->ctxRop)
		{
			renderObj->ctxRop->base.refcnt--;
			;
			renderObj->ctxRop = (void *) 0;
		}
	}
	ctx1 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
					((((0 ? (0 * 32 + 31) : (0 * 32 + 0)) / 32) << 2)))) / 4]);
	if ((((EngineObjInfo *) ((engObj)->base.classInfo->objectInfo))->
			validateForHardware (engObj)))
	{
		if (!(ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32))))
		{
			ctx1 |= ((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	else
	{
		if (ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32)))
		{
			ctx1 &= ~((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	grNotifyIfNeeded (engObj);
	return 0;
}

NvV32
mthdSetContextBeta1 (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GrRenderObj        *renderObj = (GrRenderObj *) engObj;
	EngineObj          *betaObj;
	HwDeviceInfo       *hwdev =
		(HwDeviceInfo *) ((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->
					parent))->device->deviceInfo));
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               ctx1;

	;
	if (data != (NV_PMC_BOOT_0))
	{
		betaObj =
			(EngineObj *) (nvArchDevFuncTable->nvArchLookupObjectByName) (session,
			data);
		if (betaObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (((betaObj)->base.classInfo->num) != (0x00000012))
		{
			;
			return (0x02000000);
		}
		if (betaObj->base.parent != renderObj->base.base.parent)
		{
			;
			return (0x02000000);
		}
		if (renderObj->ctxBeta1)
		{
			renderObj->ctxBeta1->base.refcnt--;
			;
			renderObj->ctxBeta1 = (void *) 0;
		}
		renderObj->ctxBeta1 = betaObj;
		betaObj->base.refcnt++;
		;
	}
	else
	{
		if (renderObj->ctxBeta1)
		{
			renderObj->ctxBeta1->base.refcnt--;
			;
			renderObj->ctxBeta1 = (void *) 0;
		}
	}
	ctx1 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
					((((0 ? (0 * 32 + 31) : (0 * 32 + 0)) / 32) << 2)))) / 4]);
	if ((((EngineObjInfo *) ((engObj)->base.classInfo->objectInfo))->
			validateForHardware (engObj)))
	{
		if (!(ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32))))
		{
			ctx1 |= ((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	else
	{
		if (ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32)))
		{
			ctx1 &= ~((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	grUpdateContextSwitch1 (engObj, ctx1);
	grNotifyIfNeeded (engObj);
	return 0;
}

NvV32
mthdSetOperation (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	GrRenderObj        *renderObj = (GrRenderObj *) engObj;
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	NvU32               srcCopyAnd,
	                    ropAnd,
	                    blendAnd;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               ctx1,
	                    patchConfig;

	;
	switch (((engObj)->base.classInfo->num))
	{
		case (0x0000001C):
			srcCopyAnd = (NV_PMC_BOOT_0);
			ropAnd = (0x00000001);
			blendAnd = (0x00000002);
			break;
		case (0x0000001D):
			srcCopyAnd = (NV_PMC_BOOT_0);
			ropAnd = (0x00000001);
			blendAnd = (0x00000002);
			break;
		case (0x0000001E):
			srcCopyAnd = (NV_PMC_BOOT_0);
			ropAnd = (0x00000001);
			blendAnd = (0x00000002);
			break;
		case (0x0000001F):
			srcCopyAnd = (NV_PMC_BOOT_0);
			ropAnd = (0x00000001);
			blendAnd = (0x00000002);
			break;
		case (0x00000021):
			srcCopyAnd = (NV_PMC_BOOT_0);
			ropAnd = (0x00000001);
			blendAnd = (0x00000002);
			break;
		case (0x00000036):
			srcCopyAnd = (NV_PMC_BOOT_0);
			ropAnd = (0x00000001);
			blendAnd = (0x00000002);
			break;
		case (0x00000037):
			srcCopyAnd = (NV_PMC_BOOT_0);
			ropAnd = (0x00000001);
			blendAnd = (0x00000002);
			break;
		case (0x0000004B):
			srcCopyAnd = (NV_PMC_BOOT_0);
			ropAnd = (0x00000001);
			blendAnd = (0x00000002);
			break;
		default:;
			;
	}
	if (data == srcCopyAnd)
		patchConfig = ((NV_PMC_BOOT_0) << ((0 ? 17 : 15) % 32));
	else if (data == ropAnd)
		patchConfig = ((0x00000001) << ((0 ? 17 : 15) % 32));
	else if (data == blendAnd)
		patchConfig = ((0x00000002) << ((0 ? 17 : 15) % 32));
	else
		return (0x02000000);
	renderObj->ctxSwitch &=
		~((0xFFFFFFFF >> (31 - ((1 ? 17 : 15) % 32) +
				((0 ? 17 : 15) % 32))) << ((0 ? 17 : 15) % 32));
	renderObj->ctxSwitch |= patchConfig;
	ctx1 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
					((((0 ? (0 * 32 + 31) : (0 * 32 + 0)) / 32) << 2)))) / 4]);
	ctx1 &= ~((0xFFFFFFFF >> (31 - ((1 ? 17 : 15) % 32) +
				((0 ? 17 : 15) % 32))) << ((0 ? 17 : 15) % 32));
	ctx1 |= patchConfig;
	if ((((EngineObjInfo *) ((engObj)->base.classInfo->objectInfo))->
			validateForHardware (engObj)))
		ctx1 |= ((0x00000001) << ((0 ? 24 : 24) % 32));
	else
		ctx1 &= ~((0x00000001) << ((0 ? 24 : 24) % 32));
	grUpdateContextSwitch1 (engObj, ctx1);
	grNotifyIfNeeded (engObj);
	return 0;
}

NvV32
mthdSetContextDmaBufferIn (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data,
	int cause)
{
	NvDeviceInfo       *dev =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	GrMemToMemObj      *memToMemObj = (GrMemToMemObj *) engObj;
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) dev;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GenericObj         *dataObj;
	NvContextDmaObj    *ctxDmaObj;

	;
	if (data != (NV_PMC_BOOT_0))
	{
		dataObj = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
		if (dataObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (dataObj->classInfo->num != (0x00000002))
		{
			;
			return (0x02000000);
		}
		ctxDmaObj = (NvContextDmaObj *) dataObj;
		if (((((ctxDmaObj->memoryObj->base.classInfo->num) != (0x00000040))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (((ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003D))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003E))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) ==
						(0x00000001))))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(0x00000001)))))
		{
			;
			;
			return (0x01000000);
		}
		(hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
					((((0 ? 15 : 0) / 32) << 2)))) / 4] =
			(NvV32) (((((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) +
									((engObj->instMemLoc) << 4)
									+
									((((0 ? 15 : 0) / 32) <<
											2)))) /
							4]) & ~((0xFFFFFFFF >> (31 - (1 ? 15 : 0) +
								(0 ? 15 : 0))) << ((0 ? 15 : 0) &
							31))) | (((ctxDmaObj->
							instOffset) & (0xFFFFFFFF >> (31 -
								(1 ? 15 : 0) +
								(0 ? 15 : 0)))) << ((0 ? 15 : 0) &
						31))));
		if (memToMemObj->ctxDmaBufferIn != (void *) 0)
		{
			memToMemObj->ctxDmaBufferIn->base.refcnt--;
			;
		}
		ctxDmaObj->base.refcnt++;
		;
		memToMemObj->ctxDmaBufferIn = ctxDmaObj;
	}
	else
	{
		(hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
					((((0 ? 15 : 0) / 32) << 2)))) / 4] =
			(NvV32) (((((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) +
									((engObj->instMemLoc) << 4)
									+
									((((0 ? 15 : 0) / 32) <<
											2)))) /
							4]) & ~((0xFFFFFFFF >> (31 - (1 ? 15 : 0) +
								(0 ? 15 : 0))) << ((0 ? 15 : 0) &
							31))) | (((0) & (0xFFFFFFFF >> (31 -
								(1 ? 15 : 0) +
								(0 ? 15 : 0)))) << ((0 ? 15 : 0) &
						31))));
		ctxDmaObj = memToMemObj->ctxDmaBufferIn;
		if (ctxDmaObj != (void *) 0)
		{
			ctxDmaObj->base.refcnt--;
			;
			memToMemObj->ctxDmaBufferIn = (void *) 0;
		}
	}
	grNotifyIfNeeded (engObj);
	return 0;
}

NvV32
mthdSetContextDmaBufferOut (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data,
	int cause)
{
	NvDeviceInfo       *dev =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	GrMemToMemObj      *memToMemObj = (GrMemToMemObj *) engObj;
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) dev;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GenericObj         *dataObj;
	NvContextDmaObj    *ctxDmaObj;
	NvU32               ctx1;

	;
	if (data != (NV_PMC_BOOT_0))
	{
		dataObj = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
		if (dataObj == (void *) 0)
		{
			;
			return (0x02000000);
		}
		if (dataObj->classInfo->num != (0x00000002))
		{
			;
			return (0x02000000);
		}
		ctxDmaObj = (NvContextDmaObj *) dataObj;
		if (((((ctxDmaObj->memoryObj->base.classInfo->num) != (0x00000040))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (((ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003D))
					|| !((((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 31 : 8) %
											32) +
										((0 ? 31 : 8) %
											32)))) ==
							(NV_PMC_BOOT_0))))
				&& (ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003E))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) ==
						(0x00000001))))
			|| (!((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& !((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 7 : 4) % 32) +
									((0 ? 7 : 4) % 32)))) ==
						(0x00000002)))))
		{
			;
			;
			return (0x01000000);
		}
		(hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
					((((0 ? 15 : 0) / 32) << 2)))) / 4] =
			(NvV32) (((((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) +
									((engObj->instMemLoc) << 4)
									+
									((((0 ? 15 : 0) / 32) <<
											2)))) /
							4]) & ~((0xFFFFFFFF >> (31 - (1 ? 15 : 0) +
								(0 ? 15 : 0))) << ((0 ? 15 : 0) &
							31))) | (((ctxDmaObj->
							instOffset) & (0xFFFFFFFF >> (31 -
								(1 ? 15 : 0) +
								(0 ? 15 : 0)))) << ((0 ? 15 : 0) &
						31))));
		if (memToMemObj->ctxDmaBufferOut != (void *) 0)
		{
			memToMemObj->ctxDmaBufferOut->base.refcnt--;
			;
		}
		ctxDmaObj->base.refcnt++;
		;
		memToMemObj->ctxDmaBufferOut = ctxDmaObj;
	}
	else
	{
		(hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
					((((0 ? 15 : 0) / 32) << 2)))) / 4] =
			(NvV32) (((((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) +
									((engObj->instMemLoc) << 4)
									+
									((((0 ? 15 : 0) / 32) <<
											2)))) /
							4]) & ~((0xFFFFFFFF >> (31 - (1 ? 15 : 0) +
								(0 ? 15 : 0))) << ((0 ? 15 : 0) &
							31))) | (((0) & (0xFFFFFFFF >> (31 -
								(1 ? 15 : 0) +
								(0 ? 15 : 0)))) << ((0 ? 15 : 0) &
						31))));
		ctxDmaObj = memToMemObj->ctxDmaBufferOut;
		if (ctxDmaObj != (void *) 0)
		{
			ctxDmaObj->base.refcnt--;
			;
			memToMemObj->ctxDmaBufferOut = (void *) 0;
		}
	}
	ctx1 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
					((((0 ? (0 * 32 + 31) : (0 * 32 + 0)) / 32) << 2)))) / 4]);
	if ((((EngineObjInfo *) ((engObj)->base.classInfo->objectInfo))->
			validateForHardware (engObj)))
	{
		if (!(ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32))))
		{
			ctx1 |= ((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	else
	{
		if (ctx1 & ((0x00000001) << ((0 ? 24 : 24) % 32)))
		{
			ctx1 &= ~((0x00000001) << ((0 ? 24 : 24) % 32));
			grUpdateContextSwitch1 (engObj, ctx1);
		}
	}
	grNotifyIfNeeded (engObj);
	return 0;
}

NvV32
grNv5HandleDataError (EngineObj *engObj, NvU32 subch, NvU32 offset, NvU32 data)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	int                 colorkey = 0;
	NvU32               ctx1;
	NvV32               status = (0x02000000);

	;
	switch (((engObj)->base.classInfo->num))
	{
		case (0x0000001F):
			if (offset == (0x00000184))
				colorkey = 1;
			if (offset == 0x198)
				status = (0x08000000);
			break;
		case (0x00000021):
			if (offset == (0x00000184))
				colorkey = 1;
			break;
		case (0x00000036):
			if (offset == (0x00000184))
				colorkey = 1;
			break;
		default:
			return status;
	}
	if (colorkey)
	{
		ctx1 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) +
						((engObj->instMemLoc) << 4) + ((((0 ? (0 * 32 +
											31) : (0 *
											32 +
											0)) /
									32) << 2)))) / 4]);
		if ((((((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((data) << 4) +
										((((0 ? (0 * 32 + 31) : (0 * 32 + 0)) / 32) << 2)))) / 4])) >> ((0 ? 7 : 0) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 7 : 0) % 32) + ((0 ? 7 : 0) % 32)))) == (0x00000017))
		{
			;
			ctx1 |= ((0x00000001) << ((0 ? 12 : 12) % 32));
			if ((((EngineObjInfo *) ((engObj)->base.classInfo->objectInfo))->
					validateForHardware (engObj)))
				ctx1 |= ((0x00000001) << ((0 ? 24 : 24) % 32));
			else
				ctx1 &= ~((0x00000001) << ((0 ? 24 : 24) % 32));
			(hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) +
						((engObj->instMemLoc) << 4) + ((((0 ? (0 * 32 +
											31) : (0 *
											32 +
											0)) /
									32) << 2)))) / 4] =
				(NvV32) ((ctx1));
			;
			;
			(hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH1) / 4] = (NvV32) (ctx1);
			;
			;
			;
			(hwreg)->Reg32[((0x00400180 + (subch) * 4)) / 4] = (NvV32) (ctx1);
			grNotifyIfNeeded (engObj);
			return 0;
		}
	}
	return status;
}

NvV32
grNv5HandleStateInvalid (EngineObj *engObj, NvU32 subch, NvU32 offset, NvU32 data)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->device->
			deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               ctx1,
	                    src,
	                    dest;
	int                 update = 0,
		resend = 0;
	NvV32               status = (0x01000000);

	;
	ctx1 = ((hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
					((((0 ? (0 * 32 + 31) : (0 * 32 + 0)) / 32) << 2)))) / 4]);
	dest = (((ctx1) >> ((0 ? 25 : 25) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 25 : 25) % 32) +
				((0 ? 25 : 25) % 32))));
	switch (((engObj)->base.classInfo->num))
	{
		case (0x0000001F):
			src = (((ctx1) >> ((0 ? 26 : 26) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 26 : 26) % 32) + ((0 ? 26 : 26) % 32))));
			if (src != dest && offset == (0x00000308))
			{
				if (dest == 0x00000001)
					ctx1 |= ((0x00000001) << ((0 ? 26 : 26) % 32));
				else
					ctx1 &= ~((0x00000001) << ((0 ? 26 : 26) % 32));
				update = 1;
				resend = 1;
				status = 0;
			}
			break;
		case (0x0000001C):
		case (0x0000001E):
			if ((offset >= 0x400) && (dest == NV_PMC_BOOT_0))
			{
				ctx1 &= ~((0x00000001) << ((0 ? 24 : 24) % 32));
				update = 1;
			}
			break;
		case (0x0000001D):
			if ((offset >= 0x308) && (dest == NV_PMC_BOOT_0))
			{
				ctx1 &= ~((0x00000001) << ((0 ? 24 : 24) % 32));
				update = 1;
			}
			break;
		default:
			return status;
	}
	if (update)
	{
		(hwreg)->Reg32[(((0 ? 0x007FFFFF : 0x00700000) + ((engObj->instMemLoc) << 4) +
					((((0 ? (0 * 32 + 31) : (0 * 32 + 0)) / 32) << 2)))) / 4] =
			(NvV32) ((ctx1));
		;
		;
		(hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH1) / 4] = (NvV32) (ctx1);
		;
		;
		;
		(hwreg)->Reg32[((0x00400180 + (subch) * 4)) / 4] = (NvV32) (ctx1);
		if (resend)
		{
			(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
			(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] =
				(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
			engObj->subChannel = subch;
			fifoResend (device, engObj, offset, data);
			(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
				(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
			(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] =
				(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
		}
		return status;
	}
	return status;
}
