 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


NvV32
grInit (NvDeviceInfo *device)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);

	;
	hwdev->info.Graphics.CurrentChID = (-1);
	switch (hwdev->info.Chip.Revision)
	{
		case 0x00:
		case 0x10:
		case 0x20:
			hwdev->info.Graphics.Debug0 =
				((0x00000001) << ((0 ? 4 : 4) %
					32)) | ((0x00000001) << ((0 ? 20 : 20) %
					32)) | ((0x00000001) << ((0 ? 21 : 21) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 24 : 24) %
					32)) | ((0x00000001) << ((0 ? 25 : 25) %
					32)) | ((0x00000001) << ((0 ? 28 : 28) % 32));
			hwdev->info.Graphics.Debug1 =
				((0x00000001) << ((0 ? 12 : 12) %
					32)) | ((0x00000001) << ((0 ? 13 : 13) %
					32)) | ((0x00000001) << ((0 ? 16 : 16) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 4 : 4) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 24 : 24) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 0 : 0) %
					32)) | ((0x00000001) << ((0 ? 16 : 16) %
					32)) | ((0x00000001) << ((0 ? 20 : 20) %
					32)) | ((0x00000001) << ((0 ? 28 : 28) % 32));
			hwdev->info.Graphics.Debug2 =
				((0x00000001) << ((0 ? 28 : 28) %
					32)) | ((0x00000001) << ((0 ? 8 : 8) %
					32)) | ((0x00000001) << ((0 ? 0 : 0) %
					32)) | ((0x00000001) << ((0 ? 20 : 20) %
					32)) | ((0x00000001) << ((0 ? 21 : 21) %
					32)) | ((0x00000001) << ((0 ? 24 : 24) %
					32)) | ((0x00000001) << ((0 ? 16 : 16) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 17 : 17) %
					32)) | ((0x00000001) << ((0 ? 12 : 12) %
					32)) | ((0x00000001) << ((0 ? 13 : 13) %
					32)) | ((0x00000001) << ((0 ? 14 : 14) %
					32)) | ((0x00000001) << ((0 ? 15 : 15) % 32));
			hwdev->info.Graphics.Debug3 =
				((0x00000001) << ((0 ? 0 : 0) %
					32)) | ((0x00000001) << ((0 ? 4 : 4) %
					32)) | ((0x00000001) << ((0 ? 5 : 5) %
					32)) | ((0x00000001) << ((0 ? 8 : 8) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 9 : 9) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 7 : 7) %
					32)) | ((0x00000001) << ((0 ? 13 : 13) %
					32)) | ((0x00000001) << ((0 ? 14 : 14) %
					32)) | ((0x00000001) << ((0 ? 15 : 15) %
					32)) | ((0x00000001) << ((0 ? 10 : 10) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 11 : 11) %
					32)) | ((0x00000001) << ((0 ? 12 : 12) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 16 : 16) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 17 : 17) %
					32)) | ((0x00000001) << ((0 ? 24 : 24) %
					32)) | ((0x00000001) << ((0 ? 22 : 22) %
					32)) | ((0x00000001) << ((0 ? 20 : 20) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 21 : 21) % 32));
			break;
	}
	hwdev->info.Graphics.Enabled = 0;
	(hwreg)->Reg32[(0x00401400) / 4] = (NvV32) (0xFFFFFFFF);
	return 0;
}
