 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


void
grInitChannelContext (NvDeviceInfo *device, NvU32 chid)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwChannelInfo      *hwchan;
	GrState            *grState;
	NvU32              *data;
	int                 i;

	;
	;
	hwchan = &hwdev->channel[chid];
	grState = &hwchan->gr;
	data = (NvU32 *) grState;
	for (i = 0; i < sizeof (hwchan->gr) / sizeof (NvU32); i++)
	{
		data[i] = 0;
	}
	hwchan->gr.ctx_user =
		(((chid) & (0xFFFFFFFF >> (31 - ((1 ? 27 : 24) % 32) +
					((0 ? 27 : 24) % 32)))) << ((0 ? 27 : 24) %
			32)) | (((0) & (0xFFFFFFFF >> (31 - ((1 ? 15 : 13) % 32) +
					((0 ? 15 : 13) % 32)))) << ((0 ? 15 : 13) % 32));
}

void
grUnloadCurrentChannelContext (NvDeviceInfo *device)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	HwChannelInfo      *hwchan;
	NvU32               chid;
	int                 i;

	chid = hwdev->info.Graphics.CurrentChID;
	if (chid == (-1))
	{
		;
		return;
	}
	;
	hwchan = &hwdev->channel[hwdev->info.Graphics.CurrentChID];
	hwchan->gr.ctx_switch1 = ((hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH1) / 4]);
	hwchan->gr.ctx_switch2 = ((hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH2) / 4]);
	hwchan->gr.ctx_switch3 = ((hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH3) / 4]);
	hwchan->gr.ctx_switch4 = ((hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH4) / 4]);
	hwchan->gr.ctx_user = ((hwreg)->Reg32[(NV_PGRAPH_CTX_USER) / 4]);
	;
	for (i = 0; i < 8; i++)
		hwchan->gr.ctx_cache1[i] = ((hwreg)->Reg32[((0x00400180 + (i) * 4)) / 4]);
	for (i = 0; i < 8; i++)
		hwchan->gr.ctx_cache2[i] = ((hwreg)->Reg32[((0x004001a0 + (i) * 4)) / 4]);
	for (i = 0; i < 8; i++)
		hwchan->gr.ctx_cache3[i] = ((hwreg)->Reg32[((0x004001c0 + (i) * 4)) / 4]);
	for (i = 0; i < 8; i++)
		hwchan->gr.ctx_cache4[i] = ((hwreg)->Reg32[((0x004001e0 + (i) * 4)) / 4]);
	for (i = 0; i < 32; i++)
		hwchan->gr.abs_x_ram[i] = ((hwreg)->Reg32[((0x00400400 + (i) * 4)) / 4]);
	for (i = 0; i < 32; i++)
		hwchan->gr.abs_y_ram[i] = ((hwreg)->Reg32[((0x00400480 + (i) * 4)) / 4]);
	hwchan->gr.x_misc = ((hwreg)->Reg32[(NV_PGRAPH_X_MISC) / 4]);
	hwchan->gr.y_misc = ((hwreg)->Reg32[(NV_PGRAPH_Y_MISC) / 4]);
	hwchan->gr.valid1 = ((hwreg)->Reg32[(NV_PGRAPH_VALID1) / 4]);
	hwchan->gr.source_color = ((hwreg)->Reg32[(NV_PGRAPH_SOURCE_COLOR) / 4]);
	hwchan->gr.misc24_0 = ((hwreg)->Reg32[(NV_PGRAPH_MISC24_0) / 4]);
	hwchan->gr.xy_logic_misc0 = ((hwreg)->Reg32[(NV_PGRAPH_XY_LOGIC_MISC0) / 4]);
	hwchan->gr.xy_logic_misc1 = ((hwreg)->Reg32[(NV_PGRAPH_XY_LOGIC_MISC1) / 4]);
	hwchan->gr.xy_logic_misc2 = ((hwreg)->Reg32[(NV_PGRAPH_XY_LOGIC_MISC2) / 4]);
	hwchan->gr.xy_logic_misc3 = ((hwreg)->Reg32[(NV_PGRAPH_XY_LOGIC_MISC3) / 4]);
	hwchan->gr.clipx_0 = ((hwreg)->Reg32[(NV_PGRAPH_CLIPX_0) / 4]);
	hwchan->gr.clipx_1 = ((hwreg)->Reg32[(NV_PGRAPH_CLIPX_1) / 4]);
	hwchan->gr.clipy_0 = ((hwreg)->Reg32[(NV_PGRAPH_CLIPY_0) / 4]);
	hwchan->gr.clipy_1 = ((hwreg)->Reg32[(NV_PGRAPH_CLIPY_1) / 4]);
	hwchan->gr.abs_iclip_xmax = ((hwreg)->Reg32[(NV_PGRAPH_ABS_ICLIP_XMAX) / 4]);
	hwchan->gr.abs_iclip_ymax = ((hwreg)->Reg32[(NV_PGRAPH_ABS_ICLIP_YMAX) / 4]);
	hwchan->gr.abs_uclip_xmin = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_XMIN) / 4]);
	hwchan->gr.abs_uclip_ymin = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_YMIN) / 4]);
	hwchan->gr.abs_uclip_xmax = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_XMAX) / 4]);
	hwchan->gr.abs_uclip_ymax = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_YMAX) / 4]);
	hwchan->gr.abs_uclipa_xmin = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIPA_XMIN) / 4]);
	hwchan->gr.abs_uclipa_ymin = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIPA_YMIN) / 4]);
	hwchan->gr.abs_uclipa_xmax = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIPA_XMAX) / 4]);
	hwchan->gr.abs_uclipa_ymax = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIPA_YMAX) / 4]);
	hwchan->gr.misc24_1 = ((hwreg)->Reg32[(NV_PGRAPH_MISC24_1) / 4]);
	hwchan->gr.misc24_2 = ((hwreg)->Reg32[(NV_PGRAPH_MISC24_2) / 4]);
	hwchan->gr.valid2 = ((hwreg)->Reg32[(NV_PGRAPH_VALID2) / 4]);
	hwchan->gr.passthru_0 = ((hwreg)->Reg32[(NV_PGRAPH_PASSTHRU_0) / 4]);
	hwchan->gr.passthru_1 = ((hwreg)->Reg32[(NV_PGRAPH_PASSTHRU_1) / 4]);
	hwchan->gr.passthru_2 = ((hwreg)->Reg32[(NV_PGRAPH_PASSTHRU_2) / 4]);
	hwchan->gr.combine0alpha = ((hwreg)->Reg32[(0x00400590) / 4]);
	hwchan->gr.combine0color = ((hwreg)->Reg32[(0x00400594) / 4]);
	hwchan->gr.combine1alpha = ((hwreg)->Reg32[(0x00400598) / 4]);
	hwchan->gr.combine1color = ((hwreg)->Reg32[(0x0040059C) / 4]);
	hwchan->gr.format0 = ((hwreg)->Reg32[(0x004005A8) / 4]);
	hwchan->gr.format1 = ((hwreg)->Reg32[(0x004005AC) / 4]);
	hwchan->gr.filter0 = ((hwreg)->Reg32[(0x004005B0) / 4]);
	hwchan->gr.filter1 = ((hwreg)->Reg32[(0x004005B4) / 4]);
	hwchan->gr.d3d_xy = ((hwreg)->Reg32[(0x004005c0) / 4]);
	hwchan->gr.d3d_u0 = ((hwreg)->Reg32[(0x004005c4) / 4]);
	hwchan->gr.d3d_v0 = ((hwreg)->Reg32[(0x004005c8) / 4]);
	hwchan->gr.d3d_u1 = ((hwreg)->Reg32[(0x004005cc) / 4]);
	hwchan->gr.d3d_v1 = ((hwreg)->Reg32[(0x004005d0) / 4]);
	hwchan->gr.d3d_zeta = ((hwreg)->Reg32[(0x004005d4) / 4]);
	hwchan->gr.d3d_rgb = ((hwreg)->Reg32[(0x004005d8) / 4]);
	hwchan->gr.d3d_s = ((hwreg)->Reg32[(0x004005dc) / 4]);
	hwchan->gr.d3d_m = ((hwreg)->Reg32[(0x004005e0) / 4]);
	hwchan->gr.mono_color0 = ((hwreg)->Reg32[(NV_PGRAPH_MONO_COLOR0) / 4]);
	hwchan->gr.rop3 = ((hwreg)->Reg32[(NV_PGRAPH_ROP3) / 4]);
	hwchan->gr.beta_and = ((hwreg)->Reg32[(NV_PGRAPH_BETA_AND) / 4]);
	hwchan->gr.beta_premult = ((hwreg)->Reg32[(NV_PGRAPH_BETA_PREMULT) / 4]);
	hwchan->gr.formats = ((hwreg)->Reg32[(NV_PGRAPH_FORMATS) / 4]);
	for (i = 0; i < 6; i++)
		hwchan->gr.boffset[i] = ((hwreg)->Reg32[((NV_PGRAPH_BOFFSET0 + (i) * 4)) / 4]);
	for (i = 0; i < 6; i++)
		hwchan->gr.bbase[i] = ((hwreg)->Reg32[((NV_PGRAPH_BBASE0 + (i) * 4)) / 4]);
	for (i = 0; i < 5; i++)
		hwchan->gr.bpitch[i] = ((hwreg)->Reg32[((NV_PGRAPH_BPITCH0 + (i) * 4)) / 4]);
	for (i = 0; i < 6; i++)
		hwchan->gr.blimit[i] = ((hwreg)->Reg32[((NV_PGRAPH_BLIMIT0 + (i) * 4)) / 4]);
	hwchan->gr.bswizzle2 = ((hwreg)->Reg32[(NV_PGRAPH_BSWIZZLE2) / 4]);
	hwchan->gr.bswizzle5 = ((hwreg)->Reg32[(NV_PGRAPH_BSWIZZLE5) / 4]);
	hwchan->gr.surface = ((hwreg)->Reg32[(NV_PGRAPH_SURFACE) / 4]);
	hwchan->gr.state = ((hwreg)->Reg32[(NV_PGRAPH_STATE) / 4]);
	hwchan->gr.notify = ((hwreg)->Reg32[(NV_PGRAPH_NOTIFY) / 4]);
	hwchan->gr.bpixel = ((hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4]);
	hwchan->gr.dma_pitch = ((hwreg)->Reg32[(NV_PGRAPH_DMA_PITCH) / 4]);
	hwchan->gr.dvd_colorfmt = ((hwreg)->Reg32[(NV_PGRAPH_DVD_COLORFMT) / 4]);
	hwchan->gr.scaled_format = ((hwreg)->Reg32[(NV_PGRAPH_SCALED_FORMAT) / 4]);
	hwchan->gr.patt_color0 = ((hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR0) / 4]);
	hwchan->gr.patt_color1 = ((hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR1) / 4]);
	for (i = 0; i < 2; i++)
		hwchan->gr.pattern[i] = ((hwreg)->Reg32[((0x00400808 + (i) * 4)) / 4]);
	hwchan->gr.pattern_shape = ((hwreg)->Reg32[(NV_PGRAPH_PATTERN_SHAPE) / 4]);
	hwchan->gr.chroma = ((hwreg)->Reg32[(NV_PGRAPH_CHROMA) / 4]);
	hwchan->gr.control0 = ((hwreg)->Reg32[(NV_PGRAPH_CONTROL0) / 4]);
	hwchan->gr.control1 = ((hwreg)->Reg32[(NV_PGRAPH_CONTROL1) / 4]);
	hwchan->gr.control2 = ((hwreg)->Reg32[(NV_PGRAPH_CONTROL2) / 4]);
	hwchan->gr.blend = ((hwreg)->Reg32[(NV_PGRAPH_BLEND) / 4]);
	hwchan->gr.stored_fmt = ((hwreg)->Reg32[(NV_PGRAPH_STORED_FMT) / 4]);
	for (i = 0; i < 64; i++)
		hwchan->gr.patt_colorram[i] = ((hwreg)->Reg32[((0x00400900 + (i) * 4)) / 4]);
	for (i = 0; i < 16; i++)
		hwchan->gr.u_ram[i] = ((hwreg)->Reg32[((0x00400d00 + (i) * 4)) / 4]);
	for (i = 0; i < 16; i++)
		hwchan->gr.v_ram[i] = ((hwreg)->Reg32[((0x00400d40 + (i) * 4)) / 4]);
	for (i = 0; i < 16; i++)
		hwchan->gr.m_ram[i] = ((hwreg)->Reg32[((0x00400d80 + (i) * 4)) / 4]);
	hwchan->gr.dma_start_0 = ((hwreg)->Reg32[(NV_PGRAPH_DMA_START_0) / 4]);
	hwchan->gr.dma_start_1 = ((hwreg)->Reg32[(NV_PGRAPH_DMA_START_1) / 4]);
	hwchan->gr.dma_length = ((hwreg)->Reg32[(NV_PGRAPH_DMA_LENGTH) / 4]);
	hwchan->gr.dma_misc = ((hwreg)->Reg32[(NV_PGRAPH_DMA_MISC) / 4]);
	hwchan->gr.dma_data_0 = ((hwreg)->Reg32[(NV_PGRAPH_DMA_DATA_0) / 4]);
	hwchan->gr.dma_data_1 = ((hwreg)->Reg32[(NV_PGRAPH_DMA_DATA_1) / 4]);
	hwchan->gr.dma_rm = ((hwreg)->Reg32[(NV_PGRAPH_DMA_RM) / 4]);
	hwchan->gr.dma_a_xlate_inst = ((hwreg)->Reg32[(NV_PGRAPH_DMA_A_XLATE_INST) / 4]);
	hwchan->gr.dma_a_control = ((hwreg)->Reg32[(NV_PGRAPH_DMA_A_CONTROL) / 4]);
	hwchan->gr.dma_a_limit = ((hwreg)->Reg32[(NV_PGRAPH_DMA_A_LIMIT) / 4]);
	hwchan->gr.dma_a_tlb_pte = ((hwreg)->Reg32[(NV_PGRAPH_DMA_A_TLB_PTE) / 4]);
	hwchan->gr.dma_a_tlb_tag = ((hwreg)->Reg32[(NV_PGRAPH_DMA_A_TLB_TAG) / 4]);
	hwchan->gr.dma_a_adj_offset = ((hwreg)->Reg32[(NV_PGRAPH_DMA_A_ADJ_OFFSET) / 4]);
	hwchan->gr.dma_a_offset = ((hwreg)->Reg32[(NV_PGRAPH_DMA_A_OFFSET) / 4]);
	hwchan->gr.dma_a_size = ((hwreg)->Reg32[(NV_PGRAPH_DMA_A_SIZE) / 4]);
	hwchan->gr.dma_a_y_size = ((hwreg)->Reg32[(NV_PGRAPH_DMA_A_Y_SIZE) / 4]);
	hwchan->gr.dma_b_xlate_inst = ((hwreg)->Reg32[(NV_PGRAPH_DMA_B_XLATE_INST) / 4]);
	hwchan->gr.dma_b_control = ((hwreg)->Reg32[(NV_PGRAPH_DMA_B_CONTROL) / 4]);
	hwchan->gr.dma_b_limit = ((hwreg)->Reg32[(NV_PGRAPH_DMA_B_LIMIT) / 4]);
	hwchan->gr.dma_b_tlb_pte = ((hwreg)->Reg32[(NV_PGRAPH_DMA_B_TLB_PTE) / 4]);
	hwchan->gr.dma_b_tlb_tag = ((hwreg)->Reg32[(NV_PGRAPH_DMA_B_TLB_TAG) / 4]);
	hwchan->gr.dma_b_adj_offset = ((hwreg)->Reg32[(NV_PGRAPH_DMA_B_ADJ_OFFSET) / 4]);
	hwchan->gr.dma_b_offset = ((hwreg)->Reg32[(NV_PGRAPH_DMA_B_OFFSET) / 4]);
	hwchan->gr.dma_b_size = ((hwreg)->Reg32[(NV_PGRAPH_DMA_B_SIZE) / 4]);
	hwchan->gr.dma_b_y_size = ((hwreg)->Reg32[(NV_PGRAPH_DMA_B_Y_SIZE) / 4]);
	(hwreg)->Reg32[(NV_PGRAPH_CTX_CONTROL) / 4] =
		(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 1 : 0) %
				32)) | ((NV_PMC_BOOT_0) << ((0 ? 8 : 8) %
				32)) | ((NV_PMC_BOOT_0) << ((0 ? 16 : 16) %
				32)) | ((NV_PMC_BOOT_0) << ((0 ? 24 : 24) %
				32)) | ((0x00000001) << ((0 ? 28 : 28) % 32)));
	hwdev->info.Graphics.CurrentChID = (-1);
}

NvV32
grLoadChannelContext (NvDeviceInfo *device, NvU32 chid)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	HwChannelInfo      *hwchan;
	NvU32               caches,
	                    fifo0,
	                    fifo1;
	NvU32               misc;
	int                 i;

	;
	caches = ((hwreg)->Reg32[(NV_PFIFO_CACHES) / 4]);
	fifo0 = ((hwreg)->Reg32[(NV_PFIFO_CACHE0_PULL0) / 4]);
	fifo1 = ((hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4]);
	(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] = (NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	(hwreg)->Reg32[(NV_PFIFO_CACHE0_PULL0) / 4] =
		(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
		(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	while (((hwreg)->Reg32[(NV_PGRAPH_INTR) / 4]))
		grService (device);
	{
		misc = ((hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4]);
		(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	};
	while ((volatile) ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]))
	{
		NvU32               pmc;

		pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);
		if (pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
		{
			grService (device);
		}
	};
	if (hwdev->info.Graphics.CurrentChID != chid)
	{
		grUnloadCurrentChannelContext (device);
	}
	hwdev->info.Graphics.CurrentChID = chid;
	if (chid == (-1))
	{
		(hwreg)->Reg32[(NV_PGRAPH_CTX_USER) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_CTX_USER) /
						4]) & ~((0xFFFFFFFF >> (31 - ((1 ? 27 : 24) % 32) +
							((0 ? 27 : 24) % 32))) << ((0 ? 27 : 24) %
						32))) | (((0x0F) & (0xFFFFFFFF >> (31 -
							((1 ? 27 : 24) % 32) +
							((0 ? 27 : 24) % 32)))) << ((0 ? 27 : 24) %
					32)));
		(hwreg)->Reg32[(NV_PGRAPH_CTX_CONTROL) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 1 : 0) %
					32)) | ((0x00000001) << ((0 ? 8 : 8) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 16 : 16) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 24 : 24) %
					32)) | ((0x00000001) << ((0 ? 28 : 28) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_FFINTFC_ST2) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 19 : 19) % 32)));
		misc |= ((0x00000001) << ((0 ? 0 : 0) % 32));
		{
			(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] = (NvV32) (misc);
		};
		return 0;
	}
	;
	hwchan = &hwdev->channel[hwdev->info.Graphics.CurrentChID];
	(hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH1) / 4] = (NvV32) (hwchan->gr.ctx_switch1);
	(hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH2) / 4] = (NvV32) (hwchan->gr.ctx_switch2);
	(hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH3) / 4] = (NvV32) (hwchan->gr.ctx_switch3);
	(hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH4) / 4] = (NvV32) (hwchan->gr.ctx_switch4);
	(hwreg)->Reg32[(NV_PGRAPH_CTX_USER) / 4] = (NvV32) (hwchan->gr.ctx_user);
	;
	for (i = 0; i < 8; i++)
		(hwreg)->Reg32[((0x00400180 + (i) * 4)) / 4] = (NvV32) (hwchan->gr.ctx_cache1[i]);
	for (i = 0; i < 8; i++)
		(hwreg)->Reg32[((0x004001a0 + (i) * 4)) / 4] = (NvV32) (hwchan->gr.ctx_cache2[i]);
	for (i = 0; i < 8; i++)
		(hwreg)->Reg32[((0x004001c0 + (i) * 4)) / 4] = (NvV32) (hwchan->gr.ctx_cache3[i]);
	for (i = 0; i < 8; i++)
		(hwreg)->Reg32[((0x004001e0 + (i) * 4)) / 4] = (NvV32) (hwchan->gr.ctx_cache4[i]);
	for (i = 0; i < 32; i++)
		(hwreg)->Reg32[((0x00400400 + (i) * 4)) / 4] = (NvV32) (hwchan->gr.abs_x_ram[i]);
	for (i = 0; i < 32; i++)
		(hwreg)->Reg32[((0x00400480 + (i) * 4)) / 4] = (NvV32) (hwchan->gr.abs_y_ram[i]);
	(hwreg)->Reg32[(NV_PGRAPH_X_MISC) / 4] = (NvV32) (hwchan->gr.x_misc);
	(hwreg)->Reg32[(NV_PGRAPH_Y_MISC) / 4] = (NvV32) (hwchan->gr.y_misc);
	(hwreg)->Reg32[(NV_PGRAPH_VALID1) / 4] = (NvV32) (hwchan->gr.valid1);
	(hwreg)->Reg32[(NV_PGRAPH_SOURCE_COLOR) / 4] = (NvV32) (hwchan->gr.source_color);
	(hwreg)->Reg32[(NV_PGRAPH_MISC24_0) / 4] = (NvV32) (hwchan->gr.misc24_0);
	(hwreg)->Reg32[(NV_PGRAPH_XY_LOGIC_MISC0) / 4] = (NvV32) (hwchan->gr.xy_logic_misc0);
	(hwreg)->Reg32[(NV_PGRAPH_XY_LOGIC_MISC1) / 4] = (NvV32) (hwchan->gr.xy_logic_misc1);
	(hwreg)->Reg32[(NV_PGRAPH_XY_LOGIC_MISC2) / 4] = (NvV32) (hwchan->gr.xy_logic_misc2);
	(hwreg)->Reg32[(NV_PGRAPH_XY_LOGIC_MISC3) / 4] = (NvV32) (hwchan->gr.xy_logic_misc3);
	(hwreg)->Reg32[(NV_PGRAPH_CLIPX_0) / 4] = (NvV32) (hwchan->gr.clipx_0);
	(hwreg)->Reg32[(NV_PGRAPH_CLIPX_1) / 4] = (NvV32) (hwchan->gr.clipx_1);
	(hwreg)->Reg32[(NV_PGRAPH_CLIPY_0) / 4] = (NvV32) (hwchan->gr.clipy_0);
	(hwreg)->Reg32[(NV_PGRAPH_CLIPY_1) / 4] = (NvV32) (hwchan->gr.clipy_1);
	(hwreg)->Reg32[(NV_PGRAPH_ABS_ICLIP_XMAX) / 4] = (NvV32) (hwchan->gr.abs_iclip_xmax);
	(hwreg)->Reg32[(NV_PGRAPH_ABS_ICLIP_YMAX) / 4] = (NvV32) (hwchan->gr.abs_iclip_ymax);
	(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_XMIN) / 4] = (NvV32) (hwchan->gr.abs_uclip_xmin);
	(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_YMIN) / 4] = (NvV32) (hwchan->gr.abs_uclip_ymin);
	(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_XMAX) / 4] = (NvV32) (hwchan->gr.abs_uclip_xmax);
	(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_YMAX) / 4] = (NvV32) (hwchan->gr.abs_uclip_ymax);
	(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIPA_XMIN) / 4] = (NvV32) (hwchan->gr.abs_uclipa_xmin);
	(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIPA_YMIN) / 4] = (NvV32) (hwchan->gr.abs_uclipa_ymin);
	(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIPA_XMAX) / 4] = (NvV32) (hwchan->gr.abs_uclipa_xmax);
	(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIPA_YMAX) / 4] = (NvV32) (hwchan->gr.abs_uclipa_ymax);
	(hwreg)->Reg32[(NV_PGRAPH_MISC24_1) / 4] = (NvV32) (hwchan->gr.misc24_1);
	(hwreg)->Reg32[(NV_PGRAPH_MISC24_2) / 4] = (NvV32) (hwchan->gr.misc24_2);
	(hwreg)->Reg32[(NV_PGRAPH_VALID2) / 4] = (NvV32) (hwchan->gr.valid2);
	(hwreg)->Reg32[(NV_PGRAPH_PASSTHRU_0) / 4] = (NvV32) (hwchan->gr.passthru_0);
	(hwreg)->Reg32[(NV_PGRAPH_PASSTHRU_1) / 4] = (NvV32) (hwchan->gr.passthru_1);
	(hwreg)->Reg32[(NV_PGRAPH_PASSTHRU_2) / 4] = (NvV32) (hwchan->gr.passthru_2);
	(hwreg)->Reg32[(0x00400590) / 4] = (NvV32) (hwchan->gr.combine0alpha);
	(hwreg)->Reg32[(0x00400594) / 4] = (NvV32) (hwchan->gr.combine0color);
	(hwreg)->Reg32[(0x00400598) / 4] = (NvV32) (hwchan->gr.combine1alpha);
	(hwreg)->Reg32[(0x0040059C) / 4] = (NvV32) (hwchan->gr.combine1color);
	(hwreg)->Reg32[(0x004005A8) / 4] = (NvV32) (hwchan->gr.format0);
	(hwreg)->Reg32[(0x004005AC) / 4] = (NvV32) (hwchan->gr.format1);
	(hwreg)->Reg32[(0x004005B0) / 4] = (NvV32) (hwchan->gr.filter0);
	(hwreg)->Reg32[(0x004005B4) / 4] = (NvV32) (hwchan->gr.filter1);
	(hwreg)->Reg32[(0x004005c0) / 4] = (NvV32) (hwchan->gr.d3d_xy);
	(hwreg)->Reg32[(0x004005c4) / 4] = (NvV32) (hwchan->gr.d3d_u0);
	(hwreg)->Reg32[(0x004005c8) / 4] = (NvV32) (hwchan->gr.d3d_v0);
	(hwreg)->Reg32[(0x004005cc) / 4] = (NvV32) (hwchan->gr.d3d_u1);
	(hwreg)->Reg32[(0x004005d0) / 4] = (NvV32) (hwchan->gr.d3d_v1);
	(hwreg)->Reg32[(0x004005d4) / 4] = (NvV32) (hwchan->gr.d3d_zeta);
	(hwreg)->Reg32[(0x004005d8) / 4] = (NvV32) (hwchan->gr.d3d_rgb);
	(hwreg)->Reg32[(0x004005dc) / 4] = (NvV32) (hwchan->gr.d3d_s);
	(hwreg)->Reg32[(0x004005e0) / 4] = (NvV32) (hwchan->gr.d3d_m);
	(hwreg)->Reg32[(NV_PGRAPH_MONO_COLOR0) / 4] = (NvV32) (hwchan->gr.mono_color0);
	(hwreg)->Reg32[(NV_PGRAPH_ROP3) / 4] = (NvV32) (hwchan->gr.rop3);
	(hwreg)->Reg32[(NV_PGRAPH_BETA_AND) / 4] = (NvV32) (hwchan->gr.beta_and);
	(hwreg)->Reg32[(NV_PGRAPH_BETA_PREMULT) / 4] = (NvV32) (hwchan->gr.beta_premult);
	(hwreg)->Reg32[(NV_PGRAPH_FORMATS) / 4] = (NvV32) (hwchan->gr.formats);
	for (i = 0; i < 6; i++)
		(hwreg)->Reg32[((NV_PGRAPH_BOFFSET0 + (i) * 4)) / 4] =
			(NvV32) (hwchan->gr.boffset[i]);
	for (i = 0; i < 6; i++)
		(hwreg)->Reg32[((NV_PGRAPH_BBASE0 + (i) * 4)) / 4] = (NvV32) (hwchan->gr.bbase[i]);
	for (i = 0; i < 5; i++)
		(hwreg)->Reg32[((NV_PGRAPH_BPITCH0 + (i) * 4)) / 4] =
			(NvV32) (hwchan->gr.bpitch[i]);
	for (i = 0; i < 6; i++)
		(hwreg)->Reg32[((NV_PGRAPH_BLIMIT0 + (i) * 4)) / 4] =
			(NvV32) (hwchan->gr.blimit[i]);
	(hwreg)->Reg32[(NV_PGRAPH_BSWIZZLE2) / 4] = (NvV32) (hwchan->gr.bswizzle2);
	(hwreg)->Reg32[(NV_PGRAPH_BSWIZZLE5) / 4] = (NvV32) (hwchan->gr.bswizzle5);
	(hwreg)->Reg32[(NV_PGRAPH_SURFACE) / 4] = (NvV32) (hwchan->gr.surface);
	(hwreg)->Reg32[(NV_PGRAPH_STATE) / 4] = (NvV32) (hwchan->gr.state);
	(hwreg)->Reg32[(NV_PGRAPH_NOTIFY) / 4] = (NvV32) (hwchan->gr.notify);
	(hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4] = (NvV32) (hwchan->gr.bpixel);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_PITCH) / 4] = (NvV32) (hwchan->gr.dma_pitch);
	(hwreg)->Reg32[(NV_PGRAPH_DVD_COLORFMT) / 4] = (NvV32) (hwchan->gr.dvd_colorfmt);
	(hwreg)->Reg32[(NV_PGRAPH_SCALED_FORMAT) / 4] = (NvV32) (hwchan->gr.scaled_format);
	(hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR0) / 4] = (NvV32) (hwchan->gr.patt_color0);
	(hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR1) / 4] = (NvV32) (hwchan->gr.patt_color1);
	for (i = 0; i < 2; i++)
		(hwreg)->Reg32[((0x00400808 + (i) * 4)) / 4] = (NvV32) (hwchan->gr.pattern[i]);
	(hwreg)->Reg32[(NV_PGRAPH_PATTERN_SHAPE) / 4] = (NvV32) (hwchan->gr.pattern_shape);
	(hwreg)->Reg32[(NV_PGRAPH_CHROMA) / 4] = (NvV32) (hwchan->gr.chroma);
	(hwreg)->Reg32[(NV_PGRAPH_CONTROL0) / 4] = (NvV32) (hwchan->gr.control0);
	(hwreg)->Reg32[(NV_PGRAPH_CONTROL1) / 4] = (NvV32) (hwchan->gr.control1);
	(hwreg)->Reg32[(NV_PGRAPH_CONTROL2) / 4] = (NvV32) (hwchan->gr.control2);
	(hwreg)->Reg32[(NV_PGRAPH_BLEND) / 4] = (NvV32) (hwchan->gr.blend);
	(hwreg)->Reg32[(NV_PGRAPH_STORED_FMT) / 4] = (NvV32) (hwchan->gr.stored_fmt);
	for (i = 0; i < 64; i++)
		(hwreg)->Reg32[((0x00400900 + (i) * 4)) / 4] =
			(NvV32) (hwchan->gr.patt_colorram[i]);
	for (i = 0; i < 16; i++)
		(hwreg)->Reg32[((0x00400d00 + (i) * 4)) / 4] = (NvV32) (hwchan->gr.u_ram[i]);
	for (i = 0; i < 16; i++)
		(hwreg)->Reg32[((0x00400d40 + (i) * 4)) / 4] = (NvV32) (hwchan->gr.v_ram[i]);
	for (i = 0; i < 16; i++)
		(hwreg)->Reg32[((0x00400d80 + (i) * 4)) / 4] = (NvV32) (hwchan->gr.m_ram[i]);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_START_0) / 4] = (NvV32) (hwchan->gr.dma_start_0);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_START_1) / 4] = (NvV32) (hwchan->gr.dma_start_1);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_LENGTH) / 4] = (NvV32) (hwchan->gr.dma_length);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_MISC) / 4] = (NvV32) (hwchan->gr.dma_misc);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_DATA_0) / 4] = (NvV32) (hwchan->gr.dma_data_0);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_DATA_1) / 4] = (NvV32) (hwchan->gr.dma_data_1);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_RM) / 4] = (NvV32) (hwchan->gr.dma_rm);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_A_XLATE_INST) / 4] = (NvV32) (hwchan->gr.dma_a_xlate_inst);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_A_CONTROL) / 4] = (NvV32) (hwchan->gr.dma_a_control);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_A_LIMIT) / 4] = (NvV32) (hwchan->gr.dma_a_limit);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_A_TLB_PTE) / 4] = (NvV32) (hwchan->gr.dma_a_tlb_pte);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_A_TLB_TAG) / 4] = (NvV32) (hwchan->gr.dma_a_tlb_tag);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_A_ADJ_OFFSET) / 4] = (NvV32) (hwchan->gr.dma_a_adj_offset);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_A_OFFSET) / 4] = (NvV32) (hwchan->gr.dma_a_offset);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_A_SIZE) / 4] = (NvV32) (hwchan->gr.dma_a_size);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_A_Y_SIZE) / 4] = (NvV32) (hwchan->gr.dma_a_y_size);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_B_XLATE_INST) / 4] = (NvV32) (hwchan->gr.dma_b_xlate_inst);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_B_CONTROL) / 4] = (NvV32) (hwchan->gr.dma_b_control);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_B_LIMIT) / 4] = (NvV32) (hwchan->gr.dma_b_limit);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_B_TLB_PTE) / 4] = (NvV32) (hwchan->gr.dma_b_tlb_pte);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_B_TLB_TAG) / 4] = (NvV32) (hwchan->gr.dma_b_tlb_tag);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_B_ADJ_OFFSET) / 4] = (NvV32) (hwchan->gr.dma_b_adj_offset);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_B_OFFSET) / 4] = (NvV32) (hwchan->gr.dma_b_offset);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_B_SIZE) / 4] = (NvV32) (hwchan->gr.dma_b_size);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_B_Y_SIZE) / 4] = (NvV32) (hwchan->gr.dma_b_y_size);
	(hwreg)->Reg32[(NV_PGRAPH_CTX_CONTROL) / 4] =
		(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 1 : 0) % 32)) | ((0x00000001) << ((0 ? 8 : 8) %
				32)) | ((0x00000001) << ((0 ? 16 : 16) %
				32)) | ((NV_PMC_BOOT_0) << ((0 ? 24 : 24) %
				32)) | ((0x00000001) << ((0 ? 28 : 28) % 32)));
	(hwreg)->Reg32[(NV_PGRAPH_FFINTFC_ST2) / 4] =
		(NvV32) (((hwreg)->Reg32[(NV_PGRAPH_FFINTFC_ST2) / 4]) & 0xffcfffff);
	{
		(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] = (NvV32) (misc);
	};
	(hwreg)->Reg32[(NV_PFIFO_CACHE0_PULL0) / 4] = (NvV32) (fifo0);
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] = (NvV32) (fifo1);
	(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] = (NvV32) (caches);
	return 0;
}
