 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


void
grInitChannelContext (NvDeviceInfo *device, NvU32 chid)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwChannelInfo      *hwchan;
	GrState            *grState;
	NvU32              *data;
	int                 i;

	;
	;
	hwchan = &hwdev->channel[chid];
	grState = &hwchan->gr;
	data = (NvU32 *) grState;
	for (i = 0; i < sizeof (hwchan->gr) / sizeof (NvU32); i++)
	{
		data[i] = 0;
	}
	hwchan->gr.ctx_user =
		(((chid) & (0xFFFFFFFF >> (31 - ((1 ? 30 : 24) % 32) +
					((0 ? 30 : 24) % 32)))) << ((0 ? 30 : 24) %
			32)) | (((0) & (0xFFFFFFFF >> (31 - ((1 ? 15 : 13) % 32) +
					((0 ? 15 : 13) % 32)))) << ((0 ? 15 : 13) % 32));
}

void
grUnloadCurrentChannelContext (NvDeviceInfo *device)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	HwChannelInfo      *hwchan;
	NvU32               chid;
	int                 i;

	chid = hwdev->info.Graphics.CurrentChID;
	if (chid == (-1))
	{
		;
		return;
	}
	;
	hwchan = &hwdev->channel[hwdev->info.Graphics.CurrentChID];
	hwchan->gr.ctx_switch = ((hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH) / 4]);
	hwchan->gr.ctx_user = ((hwreg)->Reg32[(NV_PGRAPH_CTX_USER) / 4]);
	;
	for (i = 0; i < (sizeof (hwchan->gr.ctx_cache) / sizeof (hwchan->gr.ctx_cache[0])); i++)
		hwchan->gr.ctx_cache[i] = ((hwreg)->Reg32[((0x004001a0 + (i) * 4)) / 4]);
	for (i = 0; i < (sizeof (hwchan->gr.abs_x_ram) / sizeof (hwchan->gr.abs_x_ram[0])); i++)
		hwchan->gr.abs_x_ram[i] = ((hwreg)->Reg32[((0x00400400 + (i) * 4)) / 4]);
	for (i = 0; i < (sizeof (hwchan->gr.abs_y_ram) / sizeof (hwchan->gr.abs_y_ram[0])); i++)
		hwchan->gr.abs_y_ram[i] = ((hwreg)->Reg32[((0x00400480 + (i) * 4)) / 4]);
	hwchan->gr.x_misc = ((hwreg)->Reg32[(NV_PGRAPH_X_MISC) / 4]);
	hwchan->gr.y_misc = ((hwreg)->Reg32[(NV_PGRAPH_Y_MISC) / 4]);
	hwchan->gr.exceptions = ((hwreg)->Reg32[(NV_PGRAPH_EXCEPTIONS) / 4]);
	hwchan->gr.source_color = ((hwreg)->Reg32[(NV_PGRAPH_SOURCE_COLOR) / 4]);
	hwchan->gr.misc24_0 = ((hwreg)->Reg32[(0x00400510) / 4]);
	hwchan->gr.xy_logic_misc0 = ((hwreg)->Reg32[(NV_PGRAPH_XY_LOGIC_MISC0) / 4]);
	hwchan->gr.xy_logic_misc1 = ((hwreg)->Reg32[(NV_PGRAPH_XY_LOGIC_MISC1) / 4]);
	hwchan->gr.xy_logic_misc2 = ((hwreg)->Reg32[(NV_PGRAPH_XY_LOGIC_MISC2) / 4]);
	hwchan->gr.xy_logic_misc3 = ((hwreg)->Reg32[(NV_PGRAPH_XY_LOGIC_MISC3) / 4]);
	hwchan->gr.clipx_0 = ((hwreg)->Reg32[(NV_PGRAPH_CLIPX_0) / 4]);
	hwchan->gr.clipx_1 = ((hwreg)->Reg32[(NV_PGRAPH_CLIPX_1) / 4]);
	hwchan->gr.clipy_0 = ((hwreg)->Reg32[(NV_PGRAPH_CLIPY_0) / 4]);
	hwchan->gr.clipy_1 = ((hwreg)->Reg32[(NV_PGRAPH_CLIPY_1) / 4]);
	hwchan->gr.abs_iclip_xmax = ((hwreg)->Reg32[(NV_PGRAPH_ABS_ICLIP_XMAX) / 4]);
	hwchan->gr.abs_iclip_ymax = ((hwreg)->Reg32[(NV_PGRAPH_ABS_ICLIP_YMAX) / 4]);
	hwchan->gr.abs_uclip_xmin = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_XMIN) / 4]);
	hwchan->gr.abs_uclip_xmax = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_XMAX) / 4]);
	hwchan->gr.abs_uclip_ymin = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_YMIN) / 4]);
	hwchan->gr.abs_uclip_ymax = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_YMAX) / 4]);
	hwchan->gr.passthru = ((hwreg)->Reg32[(0x0040054c) / 4]);
	hwchan->gr.src_canvas_min = ((hwreg)->Reg32[(NV_PGRAPH_SRC_CANVAS_MIN) / 4]);
	hwchan->gr.src_canvas_max = ((hwreg)->Reg32[(NV_PGRAPH_SRC_CANVAS_MAX) / 4]);
	hwchan->gr.dst_canvas_min = ((hwreg)->Reg32[(NV_PGRAPH_DST_CANVAS_MIN) / 4]);
	hwchan->gr.dst_canvas_max = ((hwreg)->Reg32[(NV_PGRAPH_DST_CANVAS_MAX) / 4]);
	hwchan->gr.abs_uclipa_xmin = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIPA_XMIN) / 4]);
	hwchan->gr.abs_uclipa_ymin = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIPA_YMIN) / 4]);
	hwchan->gr.abs_uclipa_xmax = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIPA_XMAX) / 4]);
	hwchan->gr.abs_uclipa_ymax = ((hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIPA_YMAX) / 4]);
	hwchan->gr.misc24_1 = ((hwreg)->Reg32[(0x00400570) / 4]);
	for (i = 0; i < 16; i++)
		hwchan->gr.zfog_ram[i] = ((hwreg)->Reg32[((0x00400580 + (i) * 4)) / 4]);
	hwchan->gr.d3d_xy = ((hwreg)->Reg32[(0x004005c0) / 4]);
	hwchan->gr.d3d_uv = ((hwreg)->Reg32[(0x004005c4) / 4]);
	hwchan->gr.d3d_zeta = ((hwreg)->Reg32[(0x004005c8) / 4]);
	hwchan->gr.d3d_rgb = ((hwreg)->Reg32[(0x004005cc) / 4]);
	hwchan->gr.d3d_fog = ((hwreg)->Reg32[(0x004005d0) / 4]);
	hwchan->gr.d3d_m = ((hwreg)->Reg32[(0x004005d4) / 4]);
	hwchan->gr.patt_color0_0 = ((hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR0_0) / 4]);
	hwchan->gr.patt_color0_1 = ((hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR0_1) / 4]);
	hwchan->gr.patt_color1_0 = ((hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR1_0) / 4]);
	hwchan->gr.patt_color1_1 = ((hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR1_1) / 4]);
	for (i = 0; i < 2; i++)
		hwchan->gr.pattern[i] = ((hwreg)->Reg32[((0x00400610 + (i) * 4)) / 4]);
	hwchan->gr.pattern_shape = ((hwreg)->Reg32[(NV_PGRAPH_PATTERN_SHAPE) / 4]);
	hwchan->gr.mono_color0 = ((hwreg)->Reg32[(NV_PGRAPH_MONO_COLOR0) / 4]);
	hwchan->gr.rop3 = ((hwreg)->Reg32[(NV_PGRAPH_ROP3) / 4]);
	hwchan->gr.plane_mask = ((hwreg)->Reg32[(NV_PGRAPH_PLANE_MASK) / 4]);
	hwchan->gr.chroma = ((hwreg)->Reg32[(NV_PGRAPH_CHROMA) / 4]);
	hwchan->gr.boffset0 = ((hwreg)->Reg32[(NV_PGRAPH_BOFFSET0) / 4]);
	hwchan->gr.boffset1 = ((hwreg)->Reg32[(NV_PGRAPH_BOFFSET1) / 4]);
	hwchan->gr.boffset2 = ((hwreg)->Reg32[(NV_PGRAPH_BOFFSET2) / 4]);
	hwchan->gr.boffset3 = ((hwreg)->Reg32[(NV_PGRAPH_BOFFSET3) / 4]);
	hwchan->gr.beta = ((hwreg)->Reg32[(NV_PGRAPH_BETA) / 4]);
	hwchan->gr.control_out = ((hwreg)->Reg32[(NV_PGRAPH_CONTROL_OUT) / 4]);
	hwchan->gr.bpitch0 = ((hwreg)->Reg32[(NV_PGRAPH_BPITCH0) / 4]);
	hwchan->gr.bpitch1 = ((hwreg)->Reg32[(NV_PGRAPH_BPITCH1) / 4]);
	hwchan->gr.bpitch2 = ((hwreg)->Reg32[(NV_PGRAPH_BPITCH2) / 4]);
	hwchan->gr.bpitch3 = ((hwreg)->Reg32[(NV_PGRAPH_BPITCH3) / 4]);
	hwchan->gr.dma = ((hwreg)->Reg32[(NV_PGRAPH_DMA) / 4]);
	hwchan->gr.notify = ((hwreg)->Reg32[(NV_PGRAPH_NOTIFY) / 4]);
	hwchan->gr.instance = ((hwreg)->Reg32[(NV_PGRAPH_INSTANCE) / 4]);
	hwchan->gr.memfmt = ((hwreg)->Reg32[(NV_PGRAPH_MEMFMT) / 4]);
	hwchan->gr.clip0_min = ((hwreg)->Reg32[(NV_PGRAPH_CLIP0_MIN) / 4]);
	hwchan->gr.clip0_max = ((hwreg)->Reg32[(NV_PGRAPH_CLIP0_MAX) / 4]);
	hwchan->gr.clip1_min = ((hwreg)->Reg32[(NV_PGRAPH_CLIP1_MIN) / 4]);
	hwchan->gr.clip1_max = ((hwreg)->Reg32[(NV_PGRAPH_CLIP1_MAX) / 4]);
	hwchan->gr.clip_misc = ((hwreg)->Reg32[(NV_PGRAPH_CLIP_MISC) / 4]);
	hwchan->gr.bpixel = ((hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4]);
	hwchan->gr.alphacntrl = ((hwreg)->Reg32[(0x004006c8) / 4]);
	hwchan->gr.dma_control = ((hwreg)->Reg32[(NV_PGRAPH_DMA_CONTROL) / 4]);
	hwchan->gr.dma_limit = ((hwreg)->Reg32[(0x00401220) / 4]);
	hwchan->gr.dma_tlb_pte = ((hwreg)->Reg32[(0x00401230) / 4]);
	hwchan->gr.dma_tlb_tag = ((hwreg)->Reg32[(0x00401240) / 4]);
	hwchan->gr.dma_adj_offset = ((hwreg)->Reg32[(0x00401250) / 4]);
	hwchan->gr.dma_offset = ((hwreg)->Reg32[(0x00401260) / 4]);
	hwchan->gr.dma_size = ((hwreg)->Reg32[(0x00401270) / 4]);
	hwchan->gr.dma_xlate_inst = ((hwreg)->Reg32[(0x00401280) / 4]);
	hwchan->gr.dma_y_size = ((hwreg)->Reg32[(0x00401290) / 4]);
	hwchan->gr.dma_linear_limit = ((hwreg)->Reg32[(0x00401400) / 4]);
	for (i = 0; i < 3; i++)
		hwchan->gr.dma_start[i] = ((hwreg)->Reg32[((0x00401800 + (i) * 16)) / 4]);
	hwchan->gr.dma_mtmf_notify = ((hwreg)->Reg32[(0x00401820) / 4]);
	hwchan->gr.dma_pitch = ((hwreg)->Reg32[(0x00401830) / 4]);
	hwchan->gr.dma_format = ((hwreg)->Reg32[(0x00401840) / 4]);
	(hwreg)->Reg32[(NV_PGRAPH_CTX_CONTROL) / 4] =
		(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 1 : 0) %
				32)) | ((NV_PMC_BOOT_0) << ((0 ? 8 : 8) %
				32)) | ((NV_PMC_BOOT_0) << ((0 ? 16 : 16) %
				32)) | ((NV_PMC_BOOT_0) << ((0 ? 24 : 24) %
				32)) | ((0x00000001) << ((0 ? 28 : 28) % 32)));
	hwdev->info.Graphics.CurrentChID = (-1);
}

NvV32
grLoadChannelContext (NvDeviceInfo *device, NvU32 chid)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	HwChannelInfo      *hwchan;
	NvU32               caches,
	                    fifo0,
	                    fifo1;
	int                 i;

	;
	caches = ((hwreg)->Reg32[(NV_PFIFO_CACHES) / 4]);
	fifo0 = ((hwreg)->Reg32[(NV_PFIFO_CACHE0_PULL0) / 4]);
	fifo1 = ((hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4]);
	(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] = (NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	(hwreg)->Reg32[(NV_PFIFO_CACHE0_PULL0) / 4] =
		(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
		(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	while (((hwreg)->Reg32[(NV_PGRAPH_INTR_0) / 4]) & 0x11111011)
	{
		grService (device);
	}
	(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] = (NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	{
		NvV32               _status;

		_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
		while (_status)
		{
			NvV32               _pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);

			if (_pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
			{
				grService (device);
			}
			_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
		}
	};
	if (((hwreg)->Reg32[(NV_PGRAPH_DEBUG_1) / 4]) & 0x01)
	{
		(hwreg)->Reg32[(NV_PGRAPH_DEBUG_0) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_DEBUG_0) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 0 : 0) % 32) +
							((0 ? 0 : 0) % 32))) << ((0 ? 0 : 0) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	}
	(hwreg)->Reg32[(NV_PGRAPH_DEBUG_0) / 4] =
		(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_DEBUG_0) / 4]) & ~((0xFFFFFFFF >> (31 -
						((1 ? 3 : 3) % 32) +
						((0 ? 3 : 3) % 32))) << ((0 ? 3 : 3) %
					32))) | ((0x00000001) << ((0 ? 3 : 3) % 32)));
	(hwreg)->Reg32[(NV_PGRAPH_DEBUG_0) / 4] =
		(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_DEBUG_0) / 4]) & ~((0xFFFFFFFF >> (31 -
						((1 ? 2 : 2) % 32) +
						((0 ? 2 : 2) % 32))) << ((0 ? 2 : 2) %
					32))) | ((0x00000001) << ((0 ? 2 : 2) % 32)));
	if (hwdev->info.Graphics.CurrentChID != chid)
	{
		grUnloadCurrentChannelContext (device);
	}
	hwdev->info.Graphics.CurrentChID = chid;
	if (chid == (-1))
	{
		(hwreg)->Reg32[(NV_PGRAPH_CTX_USER) / 4] = (NvV32) (0x7F000000);
		(hwreg)->Reg32[(NV_PGRAPH_CTX_CONTROL) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 1 : 0) %
					32)) | ((0x00000001) << ((0 ? 8 : 8) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 16 : 16) %
					32)) | ((NV_PMC_BOOT_0) << ((0 ? 24 : 24) %
					32)) | ((0x00000001) << ((0 ? 28 : 28) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE0_PULL0) / 4] = (NvV32) (fifo0);
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] = (NvV32) (fifo1);
		(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] = (NvV32) (caches);
		return 0;
	}
	;
	hwchan = &hwdev->channel[hwdev->info.Graphics.CurrentChID];
	(hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH) / 4] = (NvV32) (hwchan->gr.ctx_switch);
	(hwreg)->Reg32[(NV_PGRAPH_CTX_USER) / 4] = (NvV32) (hwchan->gr.ctx_user);
	for (i = 0; i < 8; i++)
		(hwreg)->Reg32[((0x004001a0 + (i) * 4)) / 4] = (NvV32) (hwchan->gr.ctx_cache[i]);
	for (i = 0; i < 32; i++)
		(hwreg)->Reg32[((0x00400400 + (i) * 4)) / 4] = (NvV32) (hwchan->gr.abs_x_ram[i]);
	for (i = 0; i < 32; i++)
		(hwreg)->Reg32[((0x00400480 + (i) * 4)) / 4] = (NvV32) (hwchan->gr.abs_y_ram[i]);
	(hwreg)->Reg32[(NV_PGRAPH_X_MISC) / 4] = (NvV32) (hwchan->gr.x_misc);
	(hwreg)->Reg32[(NV_PGRAPH_Y_MISC) / 4] = (NvV32) (hwchan->gr.y_misc);
	(hwreg)->Reg32[(NV_PGRAPH_EXCEPTIONS) / 4] = (NvV32) (hwchan->gr.exceptions);
	(hwreg)->Reg32[(NV_PGRAPH_SOURCE_COLOR) / 4] = (NvV32) (hwchan->gr.source_color);
	(hwreg)->Reg32[(0x00400510) / 4] = (NvV32) (hwchan->gr.misc24_0);
	(hwreg)->Reg32[(NV_PGRAPH_XY_LOGIC_MISC0) / 4] = (NvV32) (hwchan->gr.xy_logic_misc0);
	(hwreg)->Reg32[(NV_PGRAPH_XY_LOGIC_MISC1) / 4] = (NvV32) (hwchan->gr.xy_logic_misc1);
	(hwreg)->Reg32[(NV_PGRAPH_XY_LOGIC_MISC2) / 4] = (NvV32) (hwchan->gr.xy_logic_misc2);
	(hwreg)->Reg32[(NV_PGRAPH_XY_LOGIC_MISC3) / 4] = (NvV32) (hwchan->gr.xy_logic_misc3);
	(hwreg)->Reg32[(NV_PGRAPH_CLIPX_0) / 4] = (NvV32) (hwchan->gr.clipx_0);
	(hwreg)->Reg32[(NV_PGRAPH_CLIPX_1) / 4] = (NvV32) (hwchan->gr.clipx_1);
	(hwreg)->Reg32[(NV_PGRAPH_CLIPY_0) / 4] = (NvV32) (hwchan->gr.clipy_0);
	(hwreg)->Reg32[(NV_PGRAPH_CLIPY_1) / 4] = (NvV32) (hwchan->gr.clipy_1);
	(hwreg)->Reg32[(NV_PGRAPH_ABS_ICLIP_XMAX) / 4] = (NvV32) (hwchan->gr.abs_iclip_xmax);
	(hwreg)->Reg32[(NV_PGRAPH_ABS_ICLIP_YMAX) / 4] = (NvV32) (hwchan->gr.abs_iclip_ymax);
	(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_XMIN) / 4] = (NvV32) (hwchan->gr.abs_uclip_xmin);
	(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_YMIN) / 4] = (NvV32) (hwchan->gr.abs_uclip_ymin);
	(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_XMAX) / 4] = (NvV32) (hwchan->gr.abs_uclip_xmax);
	(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIP_YMAX) / 4] = (NvV32) (hwchan->gr.abs_uclip_ymax);
	(hwreg)->Reg32[(0x0040054c) / 4] = (NvV32) (hwchan->gr.passthru);
	(hwreg)->Reg32[(NV_PGRAPH_SRC_CANVAS_MIN) / 4] = (NvV32) (hwchan->gr.src_canvas_min);
	(hwreg)->Reg32[(NV_PGRAPH_SRC_CANVAS_MAX) / 4] = (NvV32) (hwchan->gr.src_canvas_max);
	(hwreg)->Reg32[(NV_PGRAPH_DST_CANVAS_MIN) / 4] = (NvV32) (hwchan->gr.dst_canvas_min);
	(hwreg)->Reg32[(NV_PGRAPH_DST_CANVAS_MAX) / 4] = (NvV32) (hwchan->gr.dst_canvas_max);
	(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIPA_XMIN) / 4] = (NvV32) (hwchan->gr.abs_uclipa_xmin);
	(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIPA_XMAX) / 4] = (NvV32) (hwchan->gr.abs_uclipa_xmax);
	(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIPA_YMIN) / 4] = (NvV32) (hwchan->gr.abs_uclipa_ymin);
	(hwreg)->Reg32[(NV_PGRAPH_ABS_UCLIPA_YMAX) / 4] = (NvV32) (hwchan->gr.abs_uclipa_ymax);
	(hwreg)->Reg32[(0x00400570) / 4] = (NvV32) (hwchan->gr.misc24_1);
	for (i = 0; i < 16; i++)
		(hwreg)->Reg32[((0x00400580 + (i) * 4)) / 4] = (NvV32) (hwchan->gr.zfog_ram[i]);
	(hwreg)->Reg32[(0x004005c0) / 4] = (NvV32) (hwchan->gr.d3d_xy);
	(hwreg)->Reg32[(0x004005c4) / 4] = (NvV32) (hwchan->gr.d3d_uv);
	(hwreg)->Reg32[(0x004005c8) / 4] = (NvV32) (hwchan->gr.d3d_zeta);
	(hwreg)->Reg32[(0x004005cc) / 4] = (NvV32) (hwchan->gr.d3d_rgb);
	(hwreg)->Reg32[(0x004005d0) / 4] = (NvV32) (hwchan->gr.d3d_fog);
	(hwreg)->Reg32[(0x004005d4) / 4] = (NvV32) (hwchan->gr.d3d_m);
	(hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR0_0) / 4] = (NvV32) (hwchan->gr.patt_color0_0);
	(hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR0_1) / 4] = (NvV32) (hwchan->gr.patt_color0_1);
	(hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR1_0) / 4] = (NvV32) (hwchan->gr.patt_color1_0);
	(hwreg)->Reg32[(NV_PGRAPH_PATT_COLOR1_1) / 4] = (NvV32) (hwchan->gr.patt_color1_1);
	for (i = 0; i < 2; i++)
		(hwreg)->Reg32[((0x00400610 + (i) * 4)) / 4] = (NvV32) (hwchan->gr.pattern[i]);
	(hwreg)->Reg32[(NV_PGRAPH_PATTERN_SHAPE) / 4] = (NvV32) (hwchan->gr.pattern_shape);
	(hwreg)->Reg32[(NV_PGRAPH_MONO_COLOR0) / 4] = (NvV32) (hwchan->gr.mono_color0);
	(hwreg)->Reg32[(NV_PGRAPH_ROP3) / 4] = (NvV32) (hwchan->gr.rop3);
	(hwreg)->Reg32[(NV_PGRAPH_PLANE_MASK) / 4] = (NvV32) (hwchan->gr.plane_mask);
	(hwreg)->Reg32[(NV_PGRAPH_CHROMA) / 4] = (NvV32) (hwchan->gr.chroma);
	(hwreg)->Reg32[(NV_PGRAPH_BOFFSET0) / 4] = (NvV32) (hwchan->gr.boffset0);
	(hwreg)->Reg32[(NV_PGRAPH_BOFFSET1) / 4] = (NvV32) (hwchan->gr.boffset1);
	(hwreg)->Reg32[(NV_PGRAPH_BOFFSET2) / 4] = (NvV32) (hwchan->gr.boffset2);
	(hwreg)->Reg32[(NV_PGRAPH_BOFFSET3) / 4] = (NvV32) (hwchan->gr.boffset3);
	(hwreg)->Reg32[(NV_PGRAPH_BETA) / 4] = (NvV32) (hwchan->gr.beta);
	(hwreg)->Reg32[(NV_PGRAPH_CONTROL_OUT) / 4] = (NvV32) (hwchan->gr.control_out);
	(hwreg)->Reg32[(NV_PGRAPH_BPITCH0) / 4] = (NvV32) (hwchan->gr.bpitch0);
	(hwreg)->Reg32[(NV_PGRAPH_BPITCH1) / 4] = (NvV32) (hwchan->gr.bpitch1);
	(hwreg)->Reg32[(NV_PGRAPH_BPITCH2) / 4] = (NvV32) (hwchan->gr.bpitch2);
	(hwreg)->Reg32[(NV_PGRAPH_BPITCH3) / 4] = (NvV32) (hwchan->gr.bpitch3);
	(hwreg)->Reg32[(NV_PGRAPH_DMA) / 4] = (NvV32) (hwchan->gr.dma);
	(hwreg)->Reg32[(NV_PGRAPH_NOTIFY) / 4] = (NvV32) (hwchan->gr.notify);
	(hwreg)->Reg32[(NV_PGRAPH_INSTANCE) / 4] = (NvV32) (hwchan->gr.instance);
	(hwreg)->Reg32[(NV_PGRAPH_MEMFMT) / 4] = (NvV32) (hwchan->gr.memfmt);
	(hwreg)->Reg32[(NV_PGRAPH_CLIP0_MIN) / 4] = (NvV32) (hwchan->gr.clip0_min);
	(hwreg)->Reg32[(NV_PGRAPH_CLIP0_MAX) / 4] = (NvV32) (hwchan->gr.clip0_max);
	(hwreg)->Reg32[(NV_PGRAPH_CLIP1_MIN) / 4] = (NvV32) (hwchan->gr.clip1_min);
	(hwreg)->Reg32[(NV_PGRAPH_CLIP1_MAX) / 4] = (NvV32) (hwchan->gr.clip1_max);
	(hwreg)->Reg32[(NV_PGRAPH_CLIP_MISC) / 4] = (NvV32) (hwchan->gr.clip_misc);
	(hwreg)->Reg32[(NV_PGRAPH_BPIXEL) / 4] = (NvV32) (hwchan->gr.bpixel);
	(hwreg)->Reg32[(0x004006c8) / 4] = (NvV32) (hwchan->gr.alphacntrl);
	(hwreg)->Reg32[(NV_PGRAPH_DMA_CONTROL) / 4] = (NvV32) (hwchan->gr.dma_control);
	(hwreg)->Reg32[(0x00401220) / 4] = (NvV32) (hwchan->gr.dma_limit);
	(hwreg)->Reg32[(0x00401230) / 4] = (NvV32) (hwchan->gr.dma_tlb_pte);
	(hwreg)->Reg32[(0x00401240) / 4] = (NvV32) (hwchan->gr.dma_tlb_tag);
	(hwreg)->Reg32[(0x00401250) / 4] = (NvV32) (hwchan->gr.dma_adj_offset);
	(hwreg)->Reg32[(0x00401260) / 4] = (NvV32) (hwchan->gr.dma_offset);
	(hwreg)->Reg32[(0x00401270) / 4] = (NvV32) (hwchan->gr.dma_size);
	(hwreg)->Reg32[(0x00401280) / 4] = (NvV32) (hwchan->gr.dma_xlate_inst);
	(hwreg)->Reg32[(0x00401290) / 4] = (NvV32) (hwchan->gr.dma_y_size);
	(hwreg)->Reg32[(0x00401400) / 4] = (NvV32) (hwchan->gr.dma_linear_limit);
	for (i = 0; i < 3; i++)
		(hwreg)->Reg32[((0x00401800 + (i) * 16)) / 4] = (NvV32) (hwchan->gr.dma_start[i]);
	(hwreg)->Reg32[(0x00401820) / 4] = (NvV32) (hwchan->gr.dma_mtmf_notify);
	(hwreg)->Reg32[(0x00401830) / 4] = (NvV32) (hwchan->gr.dma_pitch);
	(hwreg)->Reg32[(0x00401840) / 4] = (NvV32) (hwchan->gr.dma_format);
	(hwreg)->Reg32[(NV_PGRAPH_CTX_CONTROL) / 4] =
		(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 1 : 0) % 32)) | ((0x00000001) << ((0 ? 8 : 8) %
				32)) | ((0x00000001) << ((0 ? 16 : 16) %
				32)) | ((NV_PMC_BOOT_0) << ((0 ? 24 : 24) %
				32)) | ((0x00000001) << ((0 ? 28 : 28) % 32)));
	(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] = (NvV32) (0x00000001);
	(hwreg)->Reg32[(NV_PFIFO_CACHE0_PULL0) / 4] = (NvV32) (fifo0);
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] = (NvV32) (fifo1);
	(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] = (NvV32) (caches);
	return 0;
}
