 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


typedef struct _NvGrClassNotification
{
	NvU64               timeStamp;
	NvV8                zero[0x7];
	NvV8                status;
} NvGrClassNotification;;
void
grNotify (EngineObj *engineObj, int awaken, int ndx, NvV32 status)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engineObj))->base.parent->parent))->device->
			deviceInfo));
	NvContextDmaObj    *ctxDmaObj = engineObj->notifyCtxDma;
	NvU32               timeHi,
	                    timeLo;
	NvGrClassNotification *notify;
	int                 i;

	;
	;
	if (ctxDmaObj == (void *) 0)
	{
		;
		return;
	}
	notify = (NvGrClassNotification *) ((&ctxDmaObj->memoryObj->kernAddr)->low +
		(unsigned long) (&ctxDmaObj->offset)->low);
	tmrGetCurrentTime (device, &timeHi, &timeLo);
	notify[ndx].timeStamp.high = timeHi;
	notify[ndx].timeStamp.low = timeLo;
	for (i = 0; i < 7; i++)
		notify[ndx].zero[i] = (NvV8) 0;
	notify[ndx].status = (NvV8) status;
}

NvV32
grService (NvDeviceInfo *device)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	HwChannelInfo      *channelList = hwdev->channel;
	EngineObj          *object;
	NvContextDmaObj    *contextDmaObj;
	NvV32               intr;
	NvU32               ctx1,
	                    ctx2,
	                    ctx3;
	NvU32               nSource,
	                    nInstance;
	NvU32               instMemLoc;
	NvU32               chid,
	                    subch;
	NvU32               class;
	NvU32               offset;
	NvU32               user;
	NvU32               addr,
	                    data;
	NvV32               status = 0;

	(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] = (NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	intr = ((hwreg)->Reg32[(NV_PGRAPH_INTR) / 4]);
	;
	ctx1 = ((hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH1) / 4]);
	ctx2 = ((hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH2) / 4]);
	ctx3 = ((hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH3) / 4]);
	addr = ((hwreg)->Reg32[(NV_PGRAPH_TRAPPED_ADDR) / 4]);
	data = ((hwreg)->Reg32[(NV_PGRAPH_TRAPPED_DATA) / 4]);
	instMemLoc = ((hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH4) / 4]);
	user = ((hwreg)->Reg32[(NV_PGRAPH_CTX_USER) / 4]);
	class = (((((hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH1) / 4])) >> ((0 ? 7 : 0) %
				32)) & (0xFFFFFFFF >> (31 - ((1 ? 7 : 0) % 32) +
				((0 ? 7 : 0) % 32))));
	chid = (((addr) >> ((0 ? 27 : 24) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 27 : 24) % 32) +
				((0 ? 27 : 24) % 32))));
	subch = (((addr) >> ((0 ? 15 : 13) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 15 : 13) % 32) +
				((0 ? 15 : 13) % 32))));
	offset = addr & ((0xFFFFFFFF >> (31 - ((1 ? 12 : 2) % 32) +
				((0 ? 12 : 2) % 32))) << ((0 ? 12 : 2) % 32));
	nSource = ((hwreg)->Reg32[(NV_PGRAPH_NSOURCE) / 4]);
	nInstance =
		(((ctx2) >> ((0 ? 31 : 16) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 31 : 16) % 32) +
				((0 ? 31 : 16) % 32))));
	(hwreg)->Reg32[(NV_PGRAPH_INTR) / 4] = (NvV32) (intr);
	if (intr == 0)
		;
	if (intr & ((0x00000001) << ((0 ? 12 : 12) % 32)))
	{
		NvU32               currChid,
		                    i,
		                    get,
		                    put,
		                    pushPending;
		NvU32               isDma;

		currChid =
			(((((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4])) >> ((0 ? 3 : 0) %
					32)) & (0xFFFFFFFF >> (31 - ((1 ? 3 : 0) % 32) +
					((0 ? 3 : 0) % 32))));
		for (i = 0; i < 16; i++)
		{
			isDma = ((hwreg)->Reg32[(NV_PFIFO_MODE) / 4]) & (1 << i);
			if (channelList[i].base.inUse && isDma && (i != currChid))
			{
				put = ((hwreg)->Reg32[(0x714000 + i * 32) / 4]);
				get = ((hwreg)->Reg32[(0x714000 + i * 32 + 4) / 4]);
				pushPending = ((hwreg)->Reg32[(NV_PFIFO_DMA) / 4]);
				if (put != get && !(pushPending & (1 << i)))
				{
					pushPending |= (1 << i);
					(hwreg)->Reg32[(NV_PFIFO_DMA) / 4] = (NvV32) (pushPending);
				}
			}
		}
		while ((volatile) ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4])) ;;
		;
		;
		;
		status = grLoadChannelContext (device, chid);
		if (status)
		{
			;
			;
		}
	}
	if (intr == ((0x00000001) << ((0 ? 12 : 12) % 32)))
	{
		(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
		return (((hwreg)->Reg32[(NV_PGRAPH_INTR) / 4]));
	}
	object = fifoInstMemLocToObject (device, chid, subch, instMemLoc);
	if (!object)
	{
		;
		;
	}
	if ((intr & ((0x00000001) << ((0 ? 4 : 4) % 32))) && object)
	{
		;
		while ((volatile) ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4])) ;;
		status = classSoftwareMethod (object, offset, data, 1);
		if (status)
		{
			;
			;
			if (object)
				;
			;
			;
			;
			;
			errorWrite (&object->base, status, offset, data, 0, 0);
		}
	}
	if ((intr & ((0x00000001) << ((0 ? 0 : 0) % 32))) && object)
	{
		;
		;
		;
		if (nSource & ((0x00000001) << ((0 ? 6 : 6) % 32)))
		{
			EngineObj          *object2;

			while ((volatile) ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4])) ;;
			if (offset < 0x200)
			{
				if (!data)
					;
				object2 = fifoInstMemLocToObject (device, chid, subch, data);
				if (!object2)
				{
					;
				}
				else
				{
					data = object2->base.name;
				}
			}
			status = classSoftwareMethod (object, offset, data, 1);
			if (status)
			{
				;
				if (object)
					;
				;
				;
				;
				;
				errorWrite (&object->base, status, offset, data, 0, 0);
			}
		}
		else
		{
			;
			status = 0;
			if (nSource & ((0x00000001) << ((0 ? 1 : 1) % 32)))
			{
				;
				if ((offset == 0x104) && (data > 1 && data < 0x10))
				{
					;
					(hwreg)->Reg32[(NV_PGRAPH_NOTIFY) / 4] =
						(NvV32) (((0x00000001) << ((0 ? 16 : 16) %
								32)) | ((0x00000001) << ((0 ? 20 :
									20) % 32)));
					nSource &= ~((0x00000001) << ((0 ? 1 : 1) % 32));
				}
				else if (((hwdev->info.Chip.Architecture > 0x00000004)
						|| (hwdev->info.Chip.Architecture == 0x00000004
							&& hwdev->info.Chip.MaskRevision >=
							0x00000001)))
				{
					status |=
						grNv5HandleDataError (object, subch, offset, data);
				}
				else
				{
					status |= (0x02000000);
				}
			}
			if (nSource & ((0x00000001) << ((0 ? 2 : 2) % 32)))
			{
				;
				status |= (0x01000000);
			}
			if (nSource & ((0x00000001) << ((0 ? 3 : 3) % 32)))
			{
				;
				status |= (0x01000000);
			}
			if (nSource & ((0x00000001) << ((0 ? 4 : 4) % 32)))
			{
				;
				status |= (0x01000000);
			}
			if (nSource & ((0x00000001) << ((0 ? 7 : 7) % 32)))
			{
				;
				status |= (0x01000000);
			}
			if (nSource & ((0x00000001) << ((0 ? 8 : 8) % 32)))
			{
				;
				status |= (0x01000000);
			}
			if (nSource & ((0x00000001) << ((0 ? 9 : 9) % 32)))
			{
				;
				status |= (0x01000000);
			}
			if (nSource & ((0x00000001) << ((0 ? 10 : 10) % 32)))
			{
				;
				status |= (0x01000000);
			}
			if (nSource & ((0x00000001) << ((0 ? 11 : 11) % 32)))
			{
				;
				if (((hwdev->info.Chip.Architecture > 0x00000004)
						|| (hwdev->info.Chip.Architecture == 0x00000004
							&& hwdev->info.Chip.MaskRevision >=
							0x00000001)))
				{
					status |=
						grNv5HandleStateInvalid (object, subch, offset,
						data);
				}
				else
				{
					status |= (0x01000000);
				}
			}
			if (nSource & ((0x00000001) << ((0 ? 12 : 12) % 32)))
			{
				;
				status |= (0x00800000);
			}
			if (nSource & ((0x00000001) << ((0 ? 13 : 13) % 32)))
			{
				;
				status |= (0x00800000);
			}
			if (nSource & ((0x00000001) << ((0 ? 14 : 14) % 32)))
			{
				;
				status |= (0x01000000);
			}
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			if (nSource & (((0x00000001) << ((0 ? 0 : 0) %
							32)) | ((0x00000001) << ((0 ? 15 : 15) %
							32))))
			{
				while ((volatile) ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4])) ;;
				;
				contextDmaObj =
					fifoInstMemLocToContextDma (device, chid, nInstance);
				if (contextDmaObj)
				{
					grNotify (object, 1, 0, 0);
				}
				else
				{
					;
				}
			}
			else
			{
				;
				if (offset != 0x104
					&& ((hwreg)->Reg32[(NV_PGRAPH_NOTIFY) /
							4]) & ((0x00000001) << ((0 ? 16 : 16) %
							32)))
					(hwreg)->Reg32[(NV_PGRAPH_NOTIFY) / 4] =
						(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_NOTIFY) /
									4]) & ~((0xFFFFFFFF >> (31 -
										((1 ? 16 : 16) %
											32) +
										((0 ? 16 : 16) %
											32))) << ((0
										? 16 : 16) %
									32))) | ((NV_PMC_BOOT_0) <<
							((0 ? 16 : 16) % 32)));
				if (status)
					errorWrite (&object->base, status, offset, data, 0, 0);
			}
		}
	}
	if ((intr & ((0x00000001) << ((0 ? 16 : 16) % 32))) && object)
	{
		while ((volatile) ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4])) ;;
		;
		contextDmaObj = fifoInstMemLocToContextDma (device, chid, nInstance);
		if (contextDmaObj)
		{
			grNotify (object, 1, 0, 0);
		}
		else
		{
			;
		}
	}
	if (intr & ((0x00000001) << ((0 ? 8 : 8) % 32)))
	{
		;
		;
		;
		;
		;
		;
		;
		;
		;
		;
		;
		(hwreg)->Reg32[(NV_PGRAPH_DEBUG_1) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_DEBUG_1) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 4 : 4) % 32) +
							((0 ? 4 : 4) % 32))) << ((0 ? 4 : 4) %
						32))) | ((0x00000001) << ((0 ? 4 : 4) % 32)));
		;
	}
	if (intr & ((0x00000001) << ((0 ? 9 : 9) % 32)))
	{
		;
		;
		;
		;
		;
		;
		;
		;
		;
		;
		;
		(hwreg)->Reg32[(NV_PGRAPH_DEBUG_1) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_DEBUG_1) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 4 : 4) % 32) +
							((0 ? 4 : 4) % 32))) << ((0 ? 4 : 4) %
						32))) | ((0x00000001) << ((0 ? 4 : 4) % 32)));
		;
	}
	(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] = (NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
	return ((hwreg)->Reg32[(NV_PGRAPH_INTR) / 4]);
}
