 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


typedef struct _NvGrClassNotification
{
	NvU64               timeStamp;
	NvV8                zero[0x7];
	NvV8                status;
} NvGrClassNotification;;
void
grNotify (EngineObj *engineObj, int awaken, int ndx, NvV32 status)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((engineObj))->base.parent->parent))->device->
			deviceInfo));
	NvContextDmaObj    *ctxDmaObj = engineObj->notifyCtxDma;
	NvU32               timeHi,
	                    timeLo;
	NvGrClassNotification *notify;
	int                 i;

	;
	;
	if (ctxDmaObj == (void *) 0)
	{
		;
		return;
	}
	notify = (NvGrClassNotification *) ((&ctxDmaObj->memoryObj->kernAddr)->low +
		(unsigned long) (&ctxDmaObj->offset)->low);
	tmrGetCurrentTime (device, &timeHi, &timeLo);
	notify[ndx].timeStamp.high = timeHi;
	notify[ndx].timeStamp.low = timeLo;
	for (i = 0; i < 7; i++)
		notify[ndx].zero[i] = (NvV8) 0;
	notify[ndx].status = (NvV8) status;
}

NvV32
grService (NvDeviceInfo *device)
{
	HwReg              *hwreg = device->nvAddr;
	NvV32               status = 0;
	EngineObj          *object;
	NvV32               intr0,
	                    intr1,
	                    ctxsw;
	NvU32               instMemLoc;
	NvU32               chid,
	                    subch;
	NvU32               class;
	NvU32               offset;
	NvU32               method;
	NvU32               addr,
	                    data;

	(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] = (NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	{
		NvV32               _status;

		do
		{
			_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
		}
		while (_status);
	};
	intr0 = ((hwreg)->Reg32[(NV_PGRAPH_INTR_0) / 4]) & 0x11111011;
	intr1 = ((hwreg)->Reg32[(NV_PGRAPH_INTR_1) / 4]);
	ctxsw = ((hwreg)->Reg32[(NV_PGRAPH_CTX_SWITCH) / 4]);
	addr = ((hwreg)->Reg32[(0x004006B4) / 4]);
	data = ((hwreg)->Reg32[(0x004006B8) / 4]);
	instMemLoc = ((hwreg)->Reg32[(0x004006BC) / 4]);
	chid = (((addr) >> ((0 ? 30 : 24) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 30 : 24) % 32) +
				((0 ? 30 : 24) % 32))));
	subch = (((addr) >> ((0 ? 15 : 13) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 15 : 13) % 32) +
				((0 ? 15 : 13) % 32))));
	class = (((addr) >> ((0 ? 20 : 16) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 20 : 16) % 32) +
				((0 ? 20 : 16) % 32))));
	offset = addr & ((0xFFFFFFFF >> (31 - ((1 ? 12 : 2) % 32) +
				((0 ? 12 : 2) % 32))) << ((0 ? 12 : 2) % 32));
	(hwreg)->Reg32[(NV_PGRAPH_INTR_0) / 4] = (NvV32) (intr0);
	(hwreg)->Reg32[(NV_PGRAPH_INTR_1) / 4] = (NvV32) (intr1);
	;
	;
	if (intr0 & ((0x00000001) << ((0 ? 4 : 4) % 32)))
	{
		;
		grLoadChannelContext (device, chid);
	}
	object = fifoInstMemLocToObject (device, chid, subch, instMemLoc);
	if (!object)
	{
		;
		;
		addr = ((hwreg)->Reg32[(0x004006B4) / 4]);
		data = ((hwreg)->Reg32[(0x004006B8) / 4]);
		instMemLoc = ((hwreg)->Reg32[(0x004006BC) / 4]);
		chid = (((addr) >> ((0 ? 30 : 24) % 32)) & (0xFFFFFFFF >> (31 -
					((1 ? 30 : 24) % 32) + ((0 ? 30 : 24) % 32))));
		subch = (((addr) >> ((0 ? 15 : 13) % 32)) & (0xFFFFFFFF >> (31 -
					((1 ? 15 : 13) % 32) + ((0 ? 15 : 13) % 32))));
		class = (((addr) >> ((0 ? 20 : 16) % 32)) & (0xFFFFFFFF >> (31 -
					((1 ? 20 : 16) % 32) + ((0 ? 20 : 16) % 32))));
		offset = addr & ((0xFFFFFFFF >> (31 - ((1 ? 12 : 2) % 32) +
					((0 ? 12 : 2) % 32))) << ((0 ? 12 : 2) % 32));
		;
		;
		;
		;
		;
		;
		;
		(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
		return ((hwreg)->Reg32[(NV_PGRAPH_INTR_0) / 4]);
	}
	if (intr0 & ((0x00000001) << ((0 ? 0 : 0) % 32)))
	{
		if (intr1 & ((0x00000001) << ((0 ? 0 : 0) % 32)))
		{
			method = offset & 0x1FFF;
			;
			status = classSoftwareMethod (object, method, data, 1);
		}
		if (intr1 & ((0x00000001) << ((0 ? 4 : 4) % 32)))
		{
			;
			;
			status = (0x02000000);
		}
		if (intr1 & ((0x00000001) << ((0 ? 12 : 12) % 32)))
		{
			;
			status = (0x00800000);
		}
		if (status)
			errorWrite (&object->base, status, offset, data, 0, 0);
	}
	if (intr0 & ((0x00000001) << ((0 ? 16 : 16) % 32)))
	{
		;
		;
		;
		;
		;
		errorWrite (&object->base, (0x01000000), offset, data, 0, 0);
		(hwreg)->Reg32[(NV_PGRAPH_EXCEPTIONS) / 4] = (NvV32) (0x00000033);
	}
	if (intr0 & ((0x00000001) << ((0 ? 28 : 28) % 32)))
	{
		NvContextDmaObj    *contextDmaObj;
		NvV32               notify;
		NvU32               instMemLoc;

		(hwreg)->Reg32[(NV_PGRAPH_NOTIFY) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PGRAPH_NOTIFY) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 16 : 16) % 32) +
							((0 ? 16 : 16) % 32))) << ((0 ? 16 : 16) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 16 : 16) % 32)));
		(hwreg)->Reg32[(NV_PGRAPH_INTR_0) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 28 : 28) % 32)));
		notify = ((hwreg)->Reg32[(NV_PGRAPH_NOTIFY) / 4]);
		instMemLoc =
			(((notify) >> ((0 ? 15 : 0) % 32)) & (0xFFFFFFFF >> (31 -
					((1 ? 15 : 0) % 32) + ((0 ? 15 : 0) % 32))));
		;
		contextDmaObj = fifoInstMemLocToContextDma (device, chid, instMemLoc);
		if (contextDmaObj)
		{
			grNotify (object, 1, 0, 0);
		}
		else
		{
			;
		}
	}
	if (intr0 & ((0x00000001) << ((0 ? 12 : 12) % 32)))
	{
		;
		;
		;
		;
		;
		errorWrite (&object->base, (0x01000000), offset, data, 0, 0);
	}
	if (intr0 & ((0x00000001) << ((0 ? 24 : 24) % 32)))
	{
		;
		errorWrite (&object->base, (0x01000000), offset, data, 0, 0);
	}
	if (intr0 & ((0x00000001) << ((0 ? 20 : 20) % 32)))
	{
		;
		;
		;
		errorWrite (&object->base, (0x01000000), offset, data, 0, 0);
	}
	(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] = (NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
	return ((hwreg)->Reg32[(NV_PGRAPH_INTR_0) / 4]);
}
