 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


NvV32
fifoChangeState (NvDeviceInfo *device, int state)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvP64               base;
	NvU64               limit;
	NvV32               id;
	unsigned int        i;
	NvU32               intrEn0;
	NvV32               status = 0;

	;
	switch (state)
	{
		case 3:
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_FETCH) / 4] =
				(NvV32) ((((hwdev->info.Fifo.DmaFetchTrigger) & (0xFFFFFFFF >> (31 -
								((1 ? 7 : 3) % 32) +
								((0 ? 7 : 3) %
									32)))) << ((0 ? 7 : 3) %
						32)) | (((hwdev->info.Fifo.
							DmaFetchSize) & (0xFFFFFFFF >> (31 -
								((1 ? 15 : 13) % 32) +
								((0 ? 15 : 13) %
									32)))) << ((0 ? 15 : 13) %
						32)) | (((hwdev->info.Fifo.
							DmaFetchMaxReqs) & (0xFFFFFFFF >> (31 -
								((1 ? 20 : 16) % 32) +
								((0 ? 20 : 16) %
									32)))) << ((0 ? 20 : 16) %
						32)));
			break;
			break;
		case 1:
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_FETCH) / 4] =
				(NvV32) ((((hwdev->info.Fifo.DmaFetchTrigger) & (0xFFFFFFFF >> (31 -
								((1 ? 7 : 3) % 32) +
								((0 ? 7 : 3) %
									32)))) << ((0 ? 7 : 3) %
						32)) | (((hwdev->info.Fifo.
							DmaFetchSize) & (0xFFFFFFFF >> (31 -
								((1 ? 15 : 13) % 32) +
								((0 ? 15 : 13) %
									32)))) << ((0 ? 15 : 13) %
						32)) | (((hwdev->info.Fifo.
							DmaFetchMaxReqs) & (0xFFFFFFFF >> (31 -
								((1 ? 20 : 16) % 32) +
								((0 ? 20 : 16) %
									32)))) << ((0 ? 20 : 16) %
						32)));
			(hwreg)->Reg32[(NV_PFIFO_DMA_TIMESLICE) / 4] =
				(NvV32) (((0x00000001) << ((0 ? 24 : 24) %
						32)) | ((0x0001ffff) << ((0 ? 16 : 0) % 32)));
			(hwreg)->Reg32[(NV_PFIFO_DELAY_0) / 4] =
				(NvV32) ((((hwdev->info.Fifo.RetryCount) & (0xFFFFFFFF >> (31 -
								((1 ? 9 : 0) % 32) +
								((0 ? 9 : 0) %
									32)))) << ((0 ? 9 : 0) %
						32)));
			(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
			(hwreg)->Reg32[(NV_PFIFO_CACHE0_PUSH0) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
			(hwreg)->Reg32[(NV_PFIFO_CACHE0_PULL0) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH0) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_PUSH) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
			fifoFlushContext (device, 0xF);
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUT) / 4] = (NvV32) (0);
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_GET) / 4] = (NvV32) (0);
			(hwreg)->Reg32[(NV_PFIFO_RUNOUT_PUT) / 4] =
				(NvV32) ((((0) & (0xFFFFFFFF >> (31 - ((1 ? 12 : 3) % 32) +
								((0 ? 12 : 3) %
									32)))) << ((0 ? 12 : 3) %
						32)));
			(hwreg)->Reg32[(NV_PFIFO_RUNOUT_GET) / 4] =
				(NvV32) ((((0) & (0xFFFFFFFF >> (31 - ((1 ? 13 : 3) % 32) +
								((0 ? 13 : 3) %
									32)))) << ((0 ? 13 : 3) %
						32)));
			(&limit)->high = 0, (&limit)->low =
				(NvU32) ((hwdev->info.Pram.HashDepth) * sizeof (EngineObj *) - 1);
			status = nvArchMemoryAllocKernel (&base, limit, &id);
			if (status != (NV_PMC_BOOT_0))
			{
				;
				return 2;
			}
			hwdev->hashTable = (EngineObj **) (&base)->low;
			hwdev->hashTableId = id;
			for (i = 0; i < (hwdev->info.Pram.HashDepth); i++)
			{
				hwdev->hashTable[i] = (void *) 0;
			}
			(hwreg)->Reg32[(NV_PFIFO_CACHE0_HASH) / 4] = (NvV32) (0);
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_HASH) / 4] = (NvV32) (0);
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
				(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH0) / 4] =
				(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
			(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] =
				(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
			(hwreg)->Reg32[(NV_PFIFO_INTR_0) / 4] = (NvV32) (0xFFFFFFFF);
			intrEn0 =
				((0x00000001) << ((0 ? 0 : 0) %
					32)) | ((0x00000001) << ((0 ? 4 : 4) %
					32)) | ((0x00000001) << ((0 ? 12 : 12) %
					32)) | ((0x00000001) << ((0 ? 16 : 16) %
					32)) | ((0x00000001) << ((0 ? 8 : 8) % 32));
			(hwreg)->Reg32[(NV_PFIFO_INTR_EN_0) / 4] = (NvV32) (intrEn0);
			break;
		case 2:
			(hwreg)->Reg32[(NV_PFIFO_DMA_TIMESLICE) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 24 : 24) % 32)));
			while (((((((hwreg)->Reg32[(NV_PFIFO_CACHE1_STATUS) / 4])) >> ((0 ? 4 : 4) %
								32)) & (0xFFFFFFFF >> (31 -
								((1 ? 4 : 4) % 32) +
								((0 ? 4 : 4) % 32)))) != 0x00000001)
				|| ((((((hwreg)->Reg32[(NV_PFIFO_RUNOUT_STATUS) /
										4])) >> ((0 ? 4 : 4)
								% 32)) & (0xFFFFFFFF >> (31 -
								((1 ? 4 : 4) % 32) +
								((0 ? 4 : 4) % 32)))) != 0x00000001)
				|| ((((((hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_PUSH) /
										4])) >> ((0 ? 4 : 4)
								% 32)) & (0xFFFFFFFF >> (31 -
								((1 ? 4 : 4) % 32) +
								((0 ? 4 : 4) % 32)))) ==
					0x00000001))
			{
				fifoService (device);
				if (((hwreg)->Reg32[(NV_PGRAPH_INTR) / 4]))
					grService (device);
			}
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_PUSH) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
			while ((((((hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_PUSH) /
									4])) >> ((0 ? 4 : 4) %
							32)) & (0xFFFFFFFF >> (31 -
							((1 ? 4 : 4) % 32) +
							((0 ? 4 : 4) % 32)))) == 0x00000001) ;
			(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
			(hwreg)->Reg32[(NV_PFIFO_CACHE0_PUSH0) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
			(hwreg)->Reg32[(NV_PFIFO_CACHE0_PULL0) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH0) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
			fifoFlushContext (device, 0xF);
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUT) / 4] = (NvV32) (0);
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_GET) / 4] = (NvV32) (0);
			if (hwdev->hashTable)
			{
				;
				nvArchMemoryFree (hwdev->hashTableId);
			}
			hwdev->hashTable = (void *) 0;
			(hwreg)->Reg32[(NV_PFIFO_DMA) / 4] = (NvV32) (0);
			(hwreg)->Reg32[(NV_PFIFO_INTR_EN_0) / 4] = (NvV32) (0);
			break;
		case 0:
			fifoInit (device);
			break;
		case 4:;
			break;
	}
	return status;
}
