 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


NvV32
fifoHashSearch (NvDeviceInfo *dev, NvU32 name, NvU32 chid)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) dev;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               entry;
	NvV32               context;
	HashTableEntry     *hwHashTable = (HashTableEntry *) hwdev->info.Pram.HashTableAddr;

	for (entry = 0; entry < (hwdev->info.Pram.HashDepth); entry++)
	{
		if (((hwreg)->Reg32[((NvU32) &hwHashTable[entry].name) / 4]) == name)
		{
			context =
				((hwreg)->Reg32[((NvU32) &hwHashTable[entry].context) /
					4]) & 0x00FFFFFF;
			;
			return context;
		}
	}
	;
	return 0;
}

void
fifoRemoveHashEntry (NvDeviceInfo *dev, EngineObj *obj)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) dev;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	int                 entry;
	HashTableEntry     *hwHashTable = (HashTableEntry *) hwdev->info.Pram.HashTableAddr;

	;
	entry = obj->hashEntry;
	if (entry == (~0))
	{
		;
		return;
	}
	;
	hwdev->hashTable[entry] = (void *) 0;
	obj->hashEntry = (~0);
	(hwreg)->Reg32[((NvU32) &hwHashTable[entry].context) / 4] =
		(NvV32) (((NV_PMC_BOOT_0) << ((0 ? (1 * 32 + 31) : (1 * 32 + 31)) & 31)));
	(hwreg)->Reg32[((NvU32) &hwHashTable[entry].name) / 4] = (NvV32) (0x0);
}

void
fifoAddHashEntry (NvDeviceInfo *dev, EngineObj *obj)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) dev;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	int                 chID = objectToChID (obj);
	NvU32               hash,
	                    entry;
	HashTableEntry     *hwHashTable = (HashTableEntry *) hwdev->info.Pram.HashTableAddr;
	static NvU32        randomEntry;

	;
	;
	hash = (((obj->base.name >> 0) & 0x1FF) ^ ((obj->base.name >> 9) & 0x1FF) ^ ((obj->base.
				name >> 18) & 0x1FF) ^ ((obj->base.
				name >> 27) & 0x1FF) ^ ((chID << 5) & 0x1FF));
	for (entry = hash; entry < (hwdev->info.Pram.HashDepth); entry++)
	{
		if (hwdev->hashTable[entry] == (void *) 0)
		{
			break;
		}
	}
	if (entry == (hwdev->info.Pram.HashDepth))
	{
		for (entry = 0; entry < (hash - 1); entry++)
		{
			if (hwdev->hashTable[entry] == (void *) 0)
				break;
		}
	}
	if (entry == (hash - 1))
	{
		;
		entry = (hash + randomEntry) % (hwdev->info.Pram.HashDepth);
		hwdev->hashTable[entry]->hashEntry = (~0);
	}
	hwdev->hashTable[entry] = obj;
	obj->hashEntry = entry;
	;
	(hwreg)->Reg32[((NvU32) &hwHashTable[entry].name) / 4] = (NvV32) (obj->base.name);
	(hwreg)->Reg32[((NvU32) &hwHashTable[entry].context) / 4] =
		(NvV32) (obj->context | (0x00000001 << ((0 ? (1 * 32 + 31) : (1 * 32 + 31)) & 31)));
	if (++randomEntry >= (hwdev->info.Pram.HashDepth))
	{
		randomEntry = 0;
	}
}
void
fifoSetupNv03ChannelPio (NvDeviceInfo *device, unsigned int channelId, NvV32 size)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32              *ctxtPtr,
	                   *initCtxtPtr;
	NvU32               cacheData;

	;
	cacheData = ((hwreg)->Reg32[(NV_PFIFO_CACHES) / 4]);
	(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] = (NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	initCtxtPtr = (NvU32 *) (hwdev->info.Pram.FifoContextAddr + (channelId * 32));
	for (ctxtPtr = initCtxtPtr; ctxtPtr < (initCtxtPtr + 8); ctxtPtr++)
	{
		(hwreg)->Reg32[((NvU32) ctxtPtr) / 4] = (NvV32) (0);
	}
	;
	hwdev->info.Fifo.Mode &= ~(1 << channelId);
	(hwreg)->Reg32[(NV_PFIFO_MODE) / 4] = (NvV32) (hwdev->info.Fifo.Mode);
	if (size == 0x200)
	{
		hwdev->info.Fifo.Size |= (1 << channelId);
		(hwreg)->Reg32[(NV_PFIFO_SIZE) / 4] = (NvV32) (hwdev->info.Fifo.Size);
	}
	else
	{
		hwdev->info.Fifo.Size &= ~(1 << channelId);
		(hwreg)->Reg32[(NV_PFIFO_SIZE) / 4] = (NvV32) (hwdev->info.Fifo.Size);
	}
	if ((hwdev->info.Fifo.AllocateCount++ == 0)
		|| ((((((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4])) >> ((0 ? 3 : 0) %
						32)) & (0xFFFFFFFF >> (31 - ((1 ? 3 : 0) % 32) +
						((0 ? 3 : 0) % 32)))) == channelId))
	{
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH0) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4] =
			(NvV32) ((((channelId) & (0xFFFFFFFF >> (31 - ((1 ? 3 : 0) % 32) +
							((0 ? 3 : 0) % 32)))) << ((0 ? 3 : 0) %
					32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUT) / 4] =
			(NvV32) ((((0) & (0xFFFFFFFF >> (31 - ((1 ? 9 : 2) % 32) +
							((0 ? 9 : 2) % 32)))) << ((0 ? 9 : 2) %
					32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_GET) / 4] =
			(NvV32) ((((0) & (0xFFFFFFFF >> (31 - ((1 ? 9 : 2) % 32) +
							((0 ? 9 : 2) % 32)))) << ((0 ? 9 : 2) %
					32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_ENGINE) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH0) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
		cacheData = ((0x00000001) << ((0 ? 0 : 0) % 32));
	}
	(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] = (NvV32) (cacheData);
}

void
fifoSetupNv04ChannelDma (NvDeviceInfo *device, unsigned int channelId,
	Nv04ChannelDmaObj *channelObj)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32              *ctxtPtr,
	                   *initCtxtPtr;
	NvContextDmaObj    *ctxDmaObj;
	NvU32               defaultFetch;
	NvU32               cacheData;

	ctxDmaObj = (NvContextDmaObj *) channelObj->pushBuffer;
	cacheData = ((hwreg)->Reg32[(NV_PFIFO_CACHES) / 4]);
	(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] = (NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	initCtxtPtr = (NvU32 *) (hwdev->info.Pram.FifoContextAddr + (channelId * 32));
	for (ctxtPtr = initCtxtPtr; ctxtPtr < (initCtxtPtr + 8); ctxtPtr++)
	{
		(hwreg)->Reg32[((NvU32) ctxtPtr) / 4] = (NvV32) (0);
	}
	(hwreg)->Reg32[((NvU32) (initCtxtPtr + (((0 ? (2 * 32 + 15) : (2 * 32 +
								0)) / 32) << 2))) / 4] =
		(NvV32) (ctxDmaObj->instOffset);
	;
	defaultFetch =
		(((hwdev->info.Fifo.DmaFetchTrigger) & (0xFFFFFFFF >> (31 - ((1 ? 7 : 3) % 32) +
					((0 ? 7 : 3) % 32)))) << ((0 ? 7 : 3) %
			32)) | (((hwdev->info.Fifo.DmaFetchSize) & (0xFFFFFFFF >> (31 -
					((1 ? 15 : 13) % 32) +
					((0 ? 15 : 13) % 32)))) << ((0 ? 15 : 13) %
			32)) | (((hwdev->info.Fifo.DmaFetchMaxReqs) & (0xFFFFFFFF >> (31 -
					((1 ? 20 : 16) % 32) +
					((0 ? 20 : 16) % 32)))) << ((0 ? 20 : 16) % 32));
	(hwreg)->Reg32[((NvU32) (initCtxtPtr + (((0 ? (4 * 32 + 7) : (4 * 32 +
								3)) / 32) << 2))) / 4] =
		(NvV32) (defaultFetch);
	hwdev->info.Fifo.Mode |= (1 << channelId);
	(hwreg)->Reg32[(NV_PFIFO_MODE) / 4] = (NvV32) (hwdev->info.Fifo.Mode);
	if ((hwdev->info.Fifo.AllocateCount++ == 0)
		|| ((((((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4])) >> ((0 ? 3 : 0) %
						32)) & (0xFFFFFFFF >> (31 - ((1 ? 3 : 0) % 32) +
						((0 ? 3 : 0) % 32)))) == channelId))
	{
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH0) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4] =
			(NvV32) ((((channelId) & (0xFFFFFFFF >> (31 - ((1 ? 3 : 0) % 32) +
							((0 ? 3 : 0) % 32)))) << ((0 ? 3 : 0) %
					32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) /
						4]) & ~((0xFFFFFFFF >> (31 - ((1 ? 8 : 8) % 32) +
							((0 ? 8 : 8) % 32))) << ((0 ? 8 : 8) %
						32))) | ((0x00000001) << ((0 ? 8 : 8) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_PUT) / 4] =
			(NvV32) ((((channelObj->put) & (0xFFFFFFFF >> (31 - ((1 ? 28 : 2) % 32) +
							((0 ? 28 : 2) % 32)))) << ((0 ? 28 : 2) %
					32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_GET) / 4] =
			(NvV32) ((((channelObj->get) & (0xFFFFFFFF >> (31 - ((1 ? 28 : 2) % 32) +
							((0 ? 28 : 2) % 32)))) << ((0 ? 28 : 2) %
					32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_INSTANCE) / 4] =
			(NvV32) (ctxDmaObj->instOffset);
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_CTL) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_STATE) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_ENGINE) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_FETCH) / 4] = (NvV32) (defaultFetch);
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_PUSH) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH0) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
		cacheData = ((0x00000001) << ((0 ? 0 : 0) % 32));
	}
	(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] = (NvV32) (cacheData);
}

void
fifoCloseDownNv03Channel (NvChannelInfo *channel)
{
	NvDeviceInfo       *device = channel->device;
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               fifoReassign,
	                    fifoPush,
	                    fifoPull;
	NvU32              *ctxtPtr,
	                   *initCtxtPtr;
	unsigned int        chid = channel->id;

	;
	fifoReassign = ((hwreg)->Reg32[(NV_PFIFO_CACHES) / 4]);
	fifoPush = ((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH0) / 4]);
	fifoPull = ((hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4]);
	(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] = (NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH0) / 4] =
		(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
		(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	if ((((((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4])) >> ((0 ? 3 : 0) %
					32)) & (0xFFFFFFFF >> (31 - ((1 ? 3 : 0) % 32) +
					((0 ? 3 : 0) % 32)))) == chid)
	{
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_ENGINE) / 4] = (NvV32) (0);
		if (hwdev->info.Fifo.Mode & (1 << chid))
		{
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_PUSH) / 4] = (NvV32) (0);
			while ((((((hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_PUSH) /
									4])) >> ((0 ? 4 : 4) %
							32)) & (0xFFFFFFFF >> (31 -
							((1 ? 4 : 4) % 32) +
							((0 ? 4 : 4) % 32)))) == 0x00000001) ;
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_PUT) / 4] = (NvV32) (0);
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_GET) / 4] = (NvV32) (0);
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_STATE) / 4] = (NvV32) (0);
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_FETCH) / 4] = (NvV32) (0);
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_TLB_PTE) / 4] = (NvV32) (0);
			hwdev->info.Fifo.Mode &= ~(1 << chid);
			(hwreg)->Reg32[(NV_PFIFO_MODE) / 4] = (NvV32) (hwdev->info.Fifo.Mode);
		}
	}
	else
	{
		initCtxtPtr = (NvU32 *) (hwdev->info.Pram.FifoContextAddr + (chid * 32));
		for (ctxtPtr = initCtxtPtr; ctxtPtr < (initCtxtPtr + 8); ctxtPtr++)
		{
			(hwreg)->Reg32[((NvU32) ctxtPtr) / 4] = (NvV32) (0);
		}
		if (hwdev->info.Fifo.Mode & (1 << chid))
		{
			(hwreg)->Reg32[(NV_PFIFO_DMA) / 4] =
				(NvV32) (((hwreg)->Reg32[(NV_PFIFO_DMA) / 4]) & (~(1 << chid)));
			hwdev->info.Fifo.Mode &= ~(1 << chid);
			(hwreg)->Reg32[(NV_PFIFO_MODE) / 4] = (NvV32) (hwdev->info.Fifo.Mode);
		}
	}
	hwdev->info.Fifo.Size &= ~(1 << chid);
	(hwreg)->Reg32[(NV_PFIFO_SIZE) / 4] = (NvV32) (hwdev->info.Fifo.Size);
	if (hwdev->info.Graphics.CurrentChID == chid)
	{
		hwdev->info.Graphics.CurrentChID = (-1);
		grLoadChannelContext (device, (-1));
	}
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] = (NvV32) (fifoPull);
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH0) / 4] = (NvV32) (fifoPush);
	(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] = (NvV32) (fifoReassign);
}

void
fifoInitSubChannelCache (NvChannelInfo *channelInfo)
{
	int                 i;

	for (i = 0; i < 8; i++)
	{
		channelInfo->subChannel[i] = (void *) 0;
	}
}
void
fifoRemoveObjectFromSubChannelCache (EngineObj *object)
{
	NvChannelObj       *channelObj = (NvChannelObj *) object->base.parent;
	NvChannelInfo      *channelInfo = channelObj->channel;
	int                 i;

	;
	for (i = 0; i < 8; i++)
	{
		if (channelInfo->subChannel[i] == object)
		{
			channelInfo->subChannel[i] = (void *) 0;
		}
	}
}
NvContextDmaObj    *
fifoInstMemLocToContextDma (NvDeviceInfo *device, NvU32 chid, NvU32 instMemLoc)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	GenericObj         *list[2];
	GenericObj         *obj;
	int                 i;

	;
	list[0] = hwchan->base.object->base.parent;
	;
	list[1] = list[0]->parent;
	;
	for (i = 0; i < (sizeof (list) / sizeof (list[0])); i++)
	{
		for (obj = list[i]->childList; obj; obj = obj->next)
		{
			if (obj->mask & 0x10)
			{
				NvContextDmaObj    *contextDmaObj = (NvContextDmaObj *) obj;

				if (instMemLoc == contextDmaObj->instOffset)
				{
					;
					return contextDmaObj;
				}
			}
		}
	}
	return (void *) 0;
}

EngineObj          *
fifoInstMemLocToObject (NvDeviceInfo *device, NvU32 chid, NvU32 subChannel, NvU32 instMemLoc)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvChannelObj       *channelObj = hwchan->base.object;
	GenericObj         *obj;
	EngineObj          *engineObj;
	NvU32               instMemLoc2;

	;
	;
	;
	;
	engineObj = hwchan->base.subChannel[subChannel];
	if (engineObj)
	{
		;
		instMemLoc2 =
			(((engineObj->context) >> ((0 ? (1 * 32 + 15) : (1 * 32 +
							0)) & 31)) & (0xFFFFFFFF >> (31 -
					(1 ? (1 * 32 + 15) : (1 * 32 + 0)) + (0 ? (1 * 32 +
							15) : (1 * 32 + 0)))));
		if (instMemLoc == instMemLoc2)
		{
			;
			engineObj->subChannel = subChannel;
			return engineObj;
		}
	}
	for (obj = channelObj->base.childList; obj; obj = obj->next)
	{
		if (obj->mask & 0x1)
		{
			engineObj = (EngineObj *) obj;
			instMemLoc2 =
				(((engineObj->context) >> ((0 ? (1 * 32 + 15) : (1 * 32 +
								0)) & 31)) & (0xFFFFFFFF >> (31 -
						(1 ? (1 * 32 + 15) : (1 * 32 + 0)) + (0 ? (1 * 32 +
								15) : (1 * 32 + 0)))));
			if (instMemLoc == instMemLoc2)
			{
				;
				return engineObj;
			}
		}
	}
	engineObj = channelObj->nullObj;
	;
	if (engineObj != (void *) 0)
	{
		instMemLoc2 =
			(((engineObj->context) >> ((0 ? (1 * 32 + 15) : (1 * 32 +
							0)) & 31)) & (0xFFFFFFFF >> (31 -
					(1 ? (1 * 32 + 15) : (1 * 32 + 0)) + (0 ? (1 * 32 +
							15) : (1 * 32 + 0)))));
		if (instMemLoc == instMemLoc2)
		{
			;
			return engineObj;
		}
	}
	;
	return (void *) 0;
}

NvV32
fifoFlushContext (NvDeviceInfo *device, NvU32 newChid)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               ctxtPtr = (NvU32) hwdev->info.Pram.FifoContextAddr;
	NvU32               currChid;
	NvU32               pushPending;

	currChid = ((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4]);
	;
	(hwreg)->Reg32[((NvU32) (ctxtPtr + (currChid * 32) + (((0 ? (0 * 32 + 28) : (0 * 32 +
								2)) / 32) << 2))) / 4] =
		(NvV32) (((hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_PUT) / 4]));
	(hwreg)->Reg32[((NvU32) (ctxtPtr + (currChid * 32) + (((0 ? (1 * 32 + 28) : (1 * 32 +
								2)) / 32) << 2))) / 4] =
		(NvV32) (((hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_GET) / 4]));
	(hwreg)->Reg32[((NvU32) (ctxtPtr + (currChid * 32) + (((0 ? (2 * 32 + 15) : (2 * 32 +
								0)) / 32) << 2))) / 4] =
		(NvV32) (((hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_INSTANCE) / 4]));
	(hwreg)->Reg32[((NvU32) (ctxtPtr + (currChid * 32) + (((0 ? (3 * 32 + 12) : (3 * 32 +
								2)) / 32) << 2))) / 4] =
		(NvV32) (((hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_STATE) / 4]));
	(hwreg)->Reg32[((NvU32) (ctxtPtr + (currChid * 32) + (((0 ? (4 * 32 + 7) : (4 * 32 +
								3)) / 32) << 2))) / 4] =
		(NvV32) (((hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_FETCH) / 4]));
	(hwreg)->Reg32[((NvU32) (ctxtPtr + (currChid * 32) + (((0 ? (5 * 32 + 1) : (5 * 32 +
								0)) / 32) << 2))) / 4] =
		(NvV32) (((hwreg)->Reg32[(NV_PFIFO_CACHE1_ENGINE) / 4]));
	(hwreg)->Reg32[((NvU32) (ctxtPtr + (currChid * 32) + (((0 ? (6 * 32 + 1) : (6 * 32 +
								0)) / 32) << 2))) / 4] =
		(NvV32) (((hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL1) / 4]));
	if (((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4]) & ((0x00000001) << ((0 ? 8 : 8) % 32)))
	{
		pushPending = ((hwreg)->Reg32[(NV_PFIFO_DMA) / 4]) & ~(1 << currChid);
		if (((hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_PUT) / 4]) !=
			((hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_GET) / 4]))
			pushPending |= (1 << currChid);
		(hwreg)->Reg32[(NV_PFIFO_DMA) / 4] = (NvV32) (pushPending);
	}
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_PUT) / 4] =
		(NvV32) (((hwreg)->Reg32[((NvU32) (ctxtPtr + (newChid * 32) + (((0 ? (0 * 32 +
										28) : (0 * 32 +
										2)) / 32) << 2))) /
				4]));
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_GET) / 4] =
		(NvV32) (((hwreg)->Reg32[((NvU32) (ctxtPtr + (newChid * 32) + (((0 ? (1 * 32 +
										28) : (1 * 32 +
										2)) / 32) << 2))) /
				4]));
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_INSTANCE) / 4] =
		(NvV32) (((hwreg)->Reg32[((NvU32) (ctxtPtr + (newChid * 32) + (((0 ? (2 * 32 +
										15) : (2 * 32 +
										0)) / 32) << 2))) /
				4]));
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_STATE) / 4] =
		(NvV32) (((hwreg)->Reg32[((NvU32) (ctxtPtr + (newChid * 32) + (((0 ? (3 * 32 +
										12) : (3 * 32 +
										2)) / 32) << 2))) /
				4]));
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_FETCH) / 4] =
		(NvV32) (((hwreg)->Reg32[((NvU32) (ctxtPtr + (newChid * 32) + (((0 ? (4 * 32 +
										7) : (4 * 32 +
										3)) / 32) << 2))) /
				4]));
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_ENGINE) / 4] =
		(NvV32) (((hwreg)->Reg32[((NvU32) (ctxtPtr + (newChid * 32) + (((0 ? (5 * 32 +
										1) : (5 * 32 +
										0)) / 32) << 2))) /
				4]));
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL1) / 4] =
		(NvV32) (((hwreg)->Reg32[((NvU32) (ctxtPtr + (newChid * 32) + (((0 ? (6 * 32 +
										1) : (6 * 32 +
										0)) / 32) << 2))) /
				4]));
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4] =
		(NvV32) ((((newChid) & (0xFFFFFFFF >> (31 - ((1 ? 3 : 0) % 32) +
						((0 ? 3 : 0) % 32)))) << ((0 ? 3 : 0) % 32)));
	if ((hwdev->info.Fifo.Mode & (1 << newChid)) && (newChid != 0xF))
	{
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) /
						4]) & ~((0xFFFFFFFF >> (31 - ((1 ? 8 : 8) % 32) +
							((0 ? 8 : 8) % 32))) << ((0 ? 8 : 8) %
						32))) | ((0x00000001) << ((0 ? 8 : 8) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_PUSH) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
	}
	(hwreg)->Reg32[(NV_PFIFO_TIMESLICE) / 4] = (NvV32) (0x1fffff);
	return 0;
}

NvV32
fifoService (NvDeviceInfo *device)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               intr;
	NvV32               status;
	NvU32               getPtr,
	                    fifoGetPtr;
	NvU32               chid;
	NvU32               type;
	NvU32               reason,
	                    swDevice;
	NvU32               subChannel,
	                    method,
	                    data,
	                    byteEnables;
	int                 i;

	status = 0;
	intr = ((hwreg)->Reg32[(NV_PFIFO_INTR_0) / 4]);
	if (intr & ((0x00000001) << ((0 ? 0 : 0) % 32)))
	{
		;
		(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_INTR_0) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
		reason = ((hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4]);
		swDevice =
			(((reason) >> ((0 ? 8 : 8) % 32)) & (0xFFFFFFFF >> (31 -
					((1 ? 8 : 8) % 32) + ((0 ? 8 : 8) % 32))));
		chid = ((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4]);
		getPtr = ((hwreg)->Reg32[(NV_PFIFO_CACHE1_GET) / 4]) >> 2;
		subChannel =
			(((((hwreg)->Reg32[((0x00003800 + (getPtr) * 8)) / 4])) >> ((0 ? 15 : 13) %
					32)) & (0xFFFFFFFF >> (31 - ((1 ? 15 : 13) % 32) +
					((0 ? 15 : 13) % 32))));
		method = ((hwreg)->Reg32[((0x00003800 + (getPtr) * 8)) / 4]) & 0x1FFF;
		data = ((hwreg)->Reg32[((0x00003804 + (getPtr) * 8)) / 4]);
		;
		;
		;
		;
		;
		;
		;
		;
		i = 0xFFFF;
		while (i-- && (reason & ((0x00000001) << ((0 ? 12 : 12) % 32))))
		{
			reason = ((hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4]);
		}
		if ((reason & ((0x00000001) << ((0 ? 8 : 8) % 32)))
			|| (reason & ((0x00000001) << ((0 ? 4 : 4) % 32))))
		{
			;
			if ((chid < 16) && hwdev->channel[chid].base.inUse)
			{
				if (method >= 0x0100)
				{
					EngineObj          *object;
					int                 engineType;

					engineType =
						(((hwreg)->Reg32[(NV_PFIFO_CACHE1_ENGINE) /
								4]) >> (subChannel * 4)) & 0x03;
					if (engineType == 0)
					{
						object = hwdev->channel[chid].base.
							subChannel[subChannel];
					}
					else if (engineType == 1)
					{
						NvU32               inst;

						(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] =
							(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) %
									32)));
						if (chid == hwdev->info.Graphics.CurrentChID)
						{
							while ((volatile) ((hwreg)->
									Reg32[(NV_PGRAPH_STATUS) /
										4])) ;;
							inst = ((hwreg)->Reg32[((0x004001e0 +
											(subChannel)
											* 4)) / 4]);
						}
						else
						{
							HwChannelInfo      *hwchan =
								&hwdev->channel[chid];
							inst = hwchan->gr.ctx_cache4[subChannel];
						}
						(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] =
							(NvV32) (((0x00000001) << ((0 ? 0 : 0) %
									32)));
						object = fifoInstMemLocToObject (device, chid,
							subChannel, inst);
					}
					else
					{
						object = (void *) 0;
					}
					if (object)
					{
						;
						status = classSoftwareMethod (object, method, data,
							swDevice ? 5 : 3);
						if (status)
						{
							;
							errorWrite (&object->base, status, method,
								data, 0, 0);
						}
					}
					else
					{
						NvChannelObj       *channelObj;

						;
						channelObj = hwdev->channel[chid].base.object;
						errorWrite (&channelObj->base, (0x02000000), method,
							data, 0, 0);
					}
				}
				else
				{
					status = ctrlSoftwareMethod (device, chid, subChannel,
						method, data);
					if (status)
					{
						NvChannelObj       *channelObj;

						channelObj = hwdev->channel[chid].base.object;
						;
						errorWrite (&channelObj->base, status, method, data,
							0, 0);
					}
				}
			}
			else
			{
				;
				;
				;
				;
			}
		}
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_HASH) / 4] = (NvV32) (0);
		getPtr++;
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_GET) / 4] =
			(NvV32) ((((getPtr) & (0xFFFFFFFF >> (31 - ((1 ? 9 : 2) % 32) +
							((0 ? 9 : 2) % 32)))) << ((0 ? 9 : 2) %
					32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
	}
	if (intr & ((0x00000001) << ((0 ? 4 : 4) % 32)))
	{
		;
		;
		(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		if (((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4]) & ((0x00000001) << ((0 ? 8 : 8) %
					32)))
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_PUSH) / 4] =
				(NvV32) ((((hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_PUSH) /
							4]) & ~((0xFFFFFFFF >> (31 -
								((1 ? 0 : 0) % 32) +
								((0 ? 0 : 0) %
									32))) << ((0 ? 0 : 0) %
							32))) | ((NV_PMC_BOOT_0) << ((0 ? 0 : 0) %
						32)));
		if (((((((hwreg)->Reg32[(NV_PFIFO_CACHE1_STATUS) / 4])) >> ((0 ? 4 : 4) %
							32)) & (0xFFFFFFFF >> (31 -
							((1 ? 4 : 4) % 32) +
							((0 ? 4 : 4) % 32)))) == 0x00000001)
			&& ((((((hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_PUSH) / 4])) >> ((0 ? 4 : 4) %
							32)) & (0xFFFFFFFF >> (31 -
							((1 ? 4 : 4) % 32) +
							((0 ? 4 : 4) % 32)))) == NV_PMC_BOOT_0))
		{
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
			getPtr = ((hwreg)->Reg32[(NV_PFIFO_RUNOUT_GET) / 4]);
			data = ((hwreg)->Reg32[(hwdev->info.Pram.FifoRunoutAddr + getPtr) / 4]);
			chid = (((data) >> ((0 ? (0 * 32 + 22) : (0 * 32 +
								16)) & 31)) & (0xFFFFFFFF >> (31 -
						(1 ? (0 * 32 + 22) : (0 * 32 + 16)) + (0 ? (0 * 32 +
								22) : (0 * 32 + 16)))));
			type = (((data) >> ((0 ? (0 * 32 + 23) : (0 * 32 +
								23)) & 31)) & (0xFFFFFFFF >> (31 -
						(1 ? (0 * 32 + 23) : (0 * 32 + 23)) + (0 ? (0 * 32 +
								23) : (0 * 32 + 23)))));
			reason = (((data) >> ((0 ? (0 * 32 + 31) : (0 * 32 +
								28)) & 31)) & (0xFFFFFFFF >> (31 -
						(1 ? (0 * 32 + 31) : (0 * 32 + 28)) + (0 ? (0 * 32 +
								31) : (0 * 32 + 28)))));
			method = (((data) >> ((0 ? (0 * 32 + 12) : (0 * 32 +
								0)) & 31)) & (0xFFFFFFFF >> (31 -
						(1 ? (0 * 32 + 12) : (0 * 32 + 0)) + (0 ? (0 * 32 +
								12) : (0 * 32 + 0)))));
			subChannel =
				(((data) >> ((0 ? (0 * 32 + 15) : (0 * 32 +
								13)) & 31)) & (0xFFFFFFFF >> (31 -
						(1 ? (0 * 32 + 15) : (0 * 32 + 13)) + (0 ? (0 * 32 +
								15) : (0 * 32 + 13)))));
			byteEnables =
				(((data) >> ((0 ? (0 * 32 + 27) : (0 * 32 +
								24)) & 31)) & (0xFFFFFFFF >> (31 -
						(1 ? (0 * 32 + 27) : (0 * 32 + 24)) + (0 ? (0 * 32 +
								27) : (0 * 32 + 24)))));
			method = method & 0x1FFF;
			data = ((hwreg)->Reg32[(hwdev->info.Pram.FifoRunoutAddr + getPtr + 4) / 4]);
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			if (reason == NV_PMC_BOOT_0)
			{
				if (method >= 0x100)
				{
					if (type == 0x00000001)
						status |= (0x00000004);
					if (byteEnables != 0)
						status |= (0x00000008);
					if (byteEnables & 0x1)
						status |= (0x00000010);
				}
				else
				{
					if (method == 0)
					{
						if (type == 0x00000001)
							status |= (0x00000004);
						if (byteEnables != 0)
							status |= (0x00000008);
						if (byteEnables & 0x1)
							status |= (0x00000010);
					}
					else if (method < 0x10 || method > 0x1f)
					{
						status |= (0x08000000);
						if (type == NV_PMC_BOOT_0)
							status |= (0x00000002);
						else
							status |= (0x00000004);
						if (byteEnables != 0)
							status |= (0x00000008);
						if (byteEnables & 0x1)
							status |= (0x00000010);
					}
					else if (method >= 0x10 && method <= 0x1f)
					{
						if (type == NV_PMC_BOOT_0)
							status = (0x00000002);
						if (byteEnables != 0xc && byteEnables != 0x3)
							status |= (0x00000008);
						if ((byteEnables & 0x1 && !(byteEnables & 0x2))
							|| (byteEnables & 0x4
								&& !(byteEnables & 0x8)))
							status |= (0x00000010);
					}
				}
			}
			else if (reason == 0x00000005)
			{
				status = (0x08000000);
				if (type == NV_PMC_BOOT_0)
					status |= (0x00000002);
				else if (type == 0x00000001)
					status |= (0x00000004);
			}
			else if ((reason == 0x00000001) || (reason == 0x00000002))
			{
				if ((chid < 16) && hwdev->channel[chid].base.inUse)
				{
					if ((((((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4])) >> ((0
										? 3 : 0) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 3 : 0) % 32) +
									((0 ? 3 : 0) % 32)))) !=
						chid)
						fifoFlushContext (device, chid);
					;
					fifoGetPtr =
						(((((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUT) /
										4])) >> ((0 ? 9 : 2)
								% 32)) & (0xFFFFFFFF >> (31 -
								((1 ? 9 : 2) % 32) +
								((0 ? 9 : 2) % 32))));
					(hwreg)->Reg32[((0x00003800 + (fifoGetPtr) * 8)) / 4] =
						(NvV32) (method | (((subChannel) & (0xFFFFFFFF >>
									(31 - ((1 ? 15 : 13) % 32) +
										((0 ? 15 : 13) %
											32)))) <<
							((0 ? 15 : 13) % 32)));
					(hwreg)->Reg32[((0x00003804 + (fifoGetPtr) * 8)) / 4] =
						(NvV32) (data);
					fifoGetPtr++;
					(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUT) / 4] =
						(NvV32) ((((fifoGetPtr) & (0xFFFFFFFF >> (31 -
										((1 ? 9 : 2) % 32) +
										((0 ? 9 : 2) %
											32)))) <<
							((0 ? 9 : 2) % 32)));
				}
			}
			else if (reason == 0x00000003)
			{
				status = (0x00000001);
				if (type == NV_PMC_BOOT_0)
					status |= (0x00000002);
				else if (type == 0x00000001)
					status |= (0x00000004);
			}
			else
			{
				;
			}
			if (status)
			{
				NvChannelObj       *channelObj;

				channelObj = hwdev->channel[chid].base.object;
				;
				errorWrite (&channelObj->base, status, method, data, 0, 0);
			}
			getPtr = (getPtr + 8) & hwdev->info.Pram.RunOutMask;
			(hwreg)->Reg32[(NV_PFIFO_RUNOUT_GET) / 4] = (NvV32) (getPtr);
			getPtr = ((hwreg)->Reg32[(NV_PFIFO_RUNOUT_GET) / 4]);
			if (((hwreg)->Reg32[(NV_PFIFO_RUNOUT_STATUS) /
						4]) & ((0x00000001) << ((0 ? 4 : 4) % 32)))
			{
				(hwreg)->Reg32[(NV_PFIFO_INTR_0) / 4] =
					(NvV32) (((0x00000001) << ((0 ? 4 : 4) % 32)));
			}
		}
		else
		{
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
				(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
		}
	}
	if (intr & ((0x00000001) << ((0 ? 8 : 8) % 32)))
	{
		NvChannelObj       *channelObj;

		status = (0x00000001);
		;
		(hwreg)->Reg32[(NV_PFIFO_INTR_0) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 8 : 8) % 32)));
		;
		;
		(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		getPtr = ((hwreg)->Reg32[(NV_PFIFO_RUNOUT_GET) / 4]);
		data = ((hwreg)->Reg32[(hwdev->info.Pram.FifoRunoutAddr + getPtr) / 4]);
		chid = (((data) >> ((0 ? (0 * 32 + 22) : (0 * 32 +
							16)) & 31)) & (0xFFFFFFFF >> (31 -
					(1 ? (0 * 32 + 22) : (0 * 32 + 16)) + (0 ? (0 * 32 +
							22) : (0 * 32 + 16)))));
		method = (((data) >> ((0 ? (0 * 32 + 12) : (0 * 32 +
							0)) & 31)) & (0xFFFFFFFF >> (31 -
					(1 ? (0 * 32 + 12) : (0 * 32 + 0)) + (0 ? (0 * 32 +
							12) : (0 * 32 + 0)))));
		method = method & 0x1FFF;
		data = ((hwreg)->Reg32[(hwdev->info.Pram.FifoRunoutAddr + getPtr + 4) / 4]);
		channelObj = hwdev->channel[chid].base.object;
		;
		errorWrite (&channelObj->base, status, method, data, 0, 0);
	}
	if (intr & ((0x00000001) << ((0 ? 12 : 12) % 32)))
	{
		;
		;
		;
		;
		;
		(hwreg)->Reg32[(NV_PFIFO_INTR_0) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 12 : 12) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_STATE) / 4] = (NvV32) (0);
		if (((hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_PUT) / 4]) !=
			((hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_GET) / 4]))
		{
			getPtr = ((hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_GET) / 4]);
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_GET) / 4] = (NvV32) (getPtr + 4);
		}
	}
	if (intr & ((0x00000001) << ((0 ? 16 : 16) % 32)))
	{
		;
		(hwreg)->Reg32[(NV_PFIFO_INTR_0) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 16 : 16) % 32)));
		;
	}
	if (((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4]) & ((0x00000001) << ((0 ? 8 : 8) % 32)))
	{
		while ((((((hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_PUSH) / 4])) >> ((0 ? 4 : 4) %
						32)) & (0xFFFFFFFF >> (31 - ((1 ? 4 : 4) % 32) +
						((0 ? 4 : 4) % 32)))) == 0x00000001) ;
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA_PUSH) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
	}
	if (((hwreg)->Reg32[(NV_PFIFO_INTR_0) / 4]) == NV_PMC_BOOT_0)
	{
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
	}
	intr = ((hwreg)->Reg32[(NV_PFIFO_INTR_0) / 4]);
	intr |= (((((hwreg)->Reg32[(NV_PFIFO_DEBUG_0) / 4])) >> ((0 ? 0 : 0) %
				32)) & (0xFFFFFFFF >> (31 - ((1 ? 0 : 0) % 32) +
				((0 ? 0 : 0) % 32))));
	return (intr);
}

NvV32
fifoResend (NvDeviceInfo *device, EngineObj *object, NvU32 method, NvV32 data)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               context = object->context;

	;
	;
	;
	;
	;
	;
	;
	if (context)
	{
		while ((volatile) ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]))
		{
			NvU32               pmc;

			pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);
			if (pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
			{
				grService (device);
			}
		};
		(hwreg)->Reg32[(NV_PFIFO_CACHE0_GET) / 4] = (NvV32) (NV_PMC_BOOT_0);
		(hwreg)->Reg32[(NV_PFIFO_CACHE0_PUT) / 4] = (NvV32) (0x00000004);
		(hwreg)->Reg32[(NV_PFIFO_CACHE0_PUSH1) / 4] = (NvV32) (objectToChID (object));
		(hwreg)->Reg32[(NV_PFIFO_CACHE0_HASH) / 4] =
			(NvV32) (((context >> ((0 ? (1 * 32 + 15) : (1 * 32 +
								0)) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? (1 * 32 + 15) : (1 * 32 + 0)) % 32) +
						((0 ? (1 * 32 + 15) : (1 * 32 +
									0)) %
							32)))) | (((1) & (0xFFFFFFFF >> (31 -
							((1 ? 16 : 16) % 32) +
							((0 ? 16 : 16) % 32)))) << ((0 ? 16 : 16) %
					32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE0_ENGINE) / 4] =
			(NvV32) (((context >> ((0 ? (1 * 32 + 17) : (1 * 32 +
								16)) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? (1 * 32 + 17) : (1 * 32 + 16)) % 32) +
						((0 ? (1 * 32 + 17) : (1 * 32 +
									16)) % 32)))) << (4 *
				object->subChannel));
		(hwreg)->Reg32[((0x00003104 + (0) * 8)) / 4] = (NvV32) (data);
		(hwreg)->Reg32[((0x00003100 + (0) * 8)) / 4] =
			(NvV32) (method | (object->subChannel << ((0 ? 15 : 13) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE0_PULL0) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
		while ((((((hwreg)->Reg32[(NV_PFIFO_CACHE0_STATUS) / 4])) >> ((0 ? 4 : 4) %
						32)) & (0xFFFFFFFF >> (31 - ((1 ? 4 : 4) % 32) +
						((0 ? 4 : 4) % 32)))) == NV_PMC_BOOT_0)
		{
			if (((hwreg)->Reg32[(NV_PGRAPH_INTR) / 4]))
			{
				grService (device);
			}
		}
		(hwreg)->Reg32[(NV_PFIFO_CACHE0_PULL0) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	}
	return 0;
}
