 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


NvV32
fifoHashSearch (NvDeviceInfo *dev, NvU32 name, NvU32 chid)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) dev;
	HwReg              *hwram = ((hwdev)->base.imAddr);
	NvU32               hash;
	NvU32               entry;
	NvU32               i;
	NvV32               context;
	HashTableEntry     *hwHashTable = (HashTableEntry *) hwdev->info.Pram.HashTableAddr;

	hash = ((((name) ^ ((name) >> 8) ^ ((name) >> 16) ^ ((name) >> 24)) & 0xFF) ^ ((chid) &
			0x7F));
	for (i = 0; i < (hwdev->info.Pram.HashDepth); i++)
	{
		entry = ((hash) * (hwdev->info.Pram.HashDepth) + (i));
		if (((hwram)->Reg32[((NvU32) &hwHashTable[entry].name -
						(0 ? 0x01FFFFFF : 0x01C00000)) / 4]) == name)
		{
			context =
				((hwram)->Reg32[((NvU32) &hwHashTable[entry].context -
						(0 ? 0x01FFFFFF : 0x01C00000)) / 4]) & 0x00FFFFFF;
			;
			return context;
		}
	}
	;
	return 0;
}

void
fifoRemoveHashEntry (NvDeviceInfo *dev, EngineObj *obj)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) dev;
	HwReg              *hwram = ((hwdev)->base.imAddr);
	int                 entry;
	HashTableEntry     *hwHashTable = (HashTableEntry *) hwdev->info.Pram.HashTableAddr;

	;
	entry = obj->hashEntry;
	if (entry == (~0))
	{
		;
		return;
	}
	;
	hwdev->hashTable[entry] = (void *) 0;
	obj->hashEntry = (~0);
	(hwram)->Reg32[((NvU32) &hwHashTable[entry].context - (0 ? 0x01FFFFFF : 0x01C00000)) / 4] =
		(NvV32) (0x0);
	(hwram)->Reg32[((NvU32) &hwHashTable[entry].name - (0 ? 0x01FFFFFF : 0x01C00000)) / 4] =
		(NvV32) (0x0);
}

void
fifoAddHashEntry (NvDeviceInfo *dev, EngineObj *obj)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) dev;
	HwReg              *hwram = ((hwdev)->base.imAddr);
	int                 chID = objectToChID (obj);
	NvU32               hash;
	int                 entry;
	unsigned int        i;
	HashTableEntry     *hwHashTable = (HashTableEntry *) hwdev->info.Pram.HashTableAddr;
	static NvU32        randomEntry;

	;
	;
	hash = ((((obj->base.name) ^ ((obj->base.name) >> 8) ^ ((obj->base.name) >> 16) ^ ((obj->
						base.name) >> 24)) & 0xFF) ^ ((chID) & 0x7F));
	for (i = 0; i < (hwdev->info.Pram.HashDepth); i++)
	{
		entry = ((hash) * (hwdev->info.Pram.HashDepth) + (i));
		if (hwdev->hashTable[entry] == (void *) 0)
		{
			break;
		}
	}
	if (i == (hwdev->info.Pram.HashDepth))
	{
		;
		entry = ((hash) * (hwdev->info.Pram.HashDepth) + (randomEntry));
		hwdev->hashTable[entry]->hashEntry = (~0);
	}
	hwdev->hashTable[entry] = obj;
	obj->hashEntry = entry;
	;
	(hwram)->Reg32[((NvU32) &hwHashTable[entry].name - (0 ? 0x01FFFFFF : 0x01C00000)) / 4] =
		(NvV32) (obj->base.name);
	(hwram)->Reg32[((NvU32) &hwHashTable[entry].context - (0 ? 0x01FFFFFF : 0x01C00000)) / 4] =
		(NvV32) (obj->context);
	if (++randomEntry >= (hwdev->info.Pram.HashDepth))
	{
		randomEntry = 0;
	}
}
NvU32               fifoGrayIncTable[] = {
	0x01, 0x03, 0x06, 0x02, 0x0C, 0x04, 0x07, 0x05, 0x18, 0x08, 0x0B, 0x09, 0x0D, 0x0F, 0x0A,
		0x0E, 0x00, 0x10, 0x13, 0x11, 0x15, 0x17, 0x12, 0x16, 0x19, 0x1B, 0x1E, 0x1A, 0x14,
		0x1C, 0x1F, 0x1D
};
NvU32
grayToBinary (NvU32 gray)
{
	NvU32               bin;

	bin = gray;
	while (gray != 0)
	{
		gray = gray >> 1;
		bin = bin ^ gray;
	}
	return bin;
}

NvU32
fifoGrayInc (NvU32 gray)
{
	NvU32               bin;

	bin = grayToBinary (gray);
	bin = (bin + 1) % (64 << 1);
	return bin ^ (bin >> 1);
}

void
fifoSetupNv03Channel (NvDeviceInfo *device, unsigned int channelId)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwChannelInfo      *hwchan = &hwdev->channel[channelId];
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	HwReg              *hwram = ((hwdev)->base.imAddr);
	NvU32               cacheData;
	NvU32              *initCtxPtr,
	                   *ctxPtr;

	cacheData = ((hwreg)->Reg32[(NV_PFIFO_CACHES) / 4]);
	(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] = (NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	initCtxPtr = (NvU32 *) (hwdev->info.Pram.FifoContextAddr + (channelId * 32));
	for (ctxPtr = initCtxPtr; ctxPtr < (initCtxPtr + 8); ctxPtr++)
	{
		(hwram)->Reg32[((NvU32) ctxPtr - (0 ? 0x01FFFFFF : 0x01C00000)) / 4] = (NvV32) (0);
	}
	hwchan->fifo.dma_status = 0;
	hwchan->allocMask = 0;
	hwchan->nv03Surfaces2d = (void *) 0;
	hwchan->nv03Surfaces3d = (void *) 0;
	hwchan->dstCanvasOwner = 0;
	;
	if ((hwdev->info.Fifo.AllocateCount++ == 0)
		|| ((((((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4])) >> ((0 ? 6 : 0) %
						32)) & (0xFFFFFFFF >> (31 - ((1 ? 6 : 0) % 32) +
						((0 ? 6 : 0) % 32)))) == channelId))
	{
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH0) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4] =
			(NvV32) ((((channelId) & (0xFFFFFFFF >> (31 - ((1 ? 6 : 0) % 32) +
							((0 ? 6 : 0) % 32)))) << ((0 ? 6 : 0) %
					32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUT) / 4] =
			(NvV32) ((((0) & (0xFFFFFFFF >> (31 - ((1 ? 8 : 2) % 32) +
							((0 ? 8 : 2) % 32)))) << ((0 ? 8 : 2) %
					32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_GET) / 4] =
			(NvV32) ((((0) & (0xFFFFFFFF >> (31 - ((1 ? 8 : 2) % 32) +
							((0 ? 8 : 2) % 32)))) << ((0 ? 8 : 2) %
					32)));
		(hwreg)->Reg32[((0x00003280 + (0) * 16)) / 4] = (NvV32) (0);
		(hwreg)->Reg32[((0x00003280 + (1) * 16)) / 4] = (NvV32) (0);
		(hwreg)->Reg32[((0x00003280 + (2) * 16)) / 4] = (NvV32) (0);
		(hwreg)->Reg32[((0x00003280 + (3) * 16)) / 4] = (NvV32) (0);
		(hwreg)->Reg32[((0x00003280 + (4) * 16)) / 4] = (NvV32) (0);
		(hwreg)->Reg32[((0x00003280 + (5) * 16)) / 4] = (NvV32) (0);
		(hwreg)->Reg32[((0x00003280 + (6) * 16)) / 4] = (NvV32) (0);
		(hwreg)->Reg32[((0x00003280 + (7) * 16)) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH0) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
		cacheData = ((0x00000001) << ((0 ? 0 : 0) % 32));
	}
	(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] = (NvV32) (cacheData);
}

void
fifoCloseDownNv03Channel (NvChannelInfo *channel)
{
	NvDeviceInfo       *device = channel->device;
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	HwReg              *hwram = ((hwdev)->base.imAddr);
	NvU32               fifoReassign,
	                    fifoPush,
	                    fifoPull;
	NvU32               subChannel;
	NvU32              *ctxtPtr,
	                   *initCtxtPtr;
	unsigned int        chid = channel->id;

	;
	fifoReassign = ((hwreg)->Reg32[(NV_PFIFO_CACHES) / 4]);
	fifoPush = ((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH0) / 4]);
	fifoPull = ((hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4]);
	(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] = (NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH0) / 4] =
		(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
		(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	if ((((((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4])) >> ((0 ? 6 : 0) %
					32)) & (0xFFFFFFFF >> (31 - ((1 ? 6 : 0) % 32) +
					((0 ? 6 : 0) % 32)))) == chid)
	{
		;
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUT) / 4] = (NvV32) (0);
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_GET) / 4] = (NvV32) (0);
		for (subChannel = 0; subChannel < 8; subChannel++)
		{
			(hwreg)->Reg32[((0x00003280 + (subChannel) * 16)) / 4] = (NvV32) (0);
		}
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL1) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL1) /
						4]) & ~((0xFFFFFFFF >> (31 - ((1 ? 4 : 4) % 32) +
							((0 ? 4 : 4) % 32))) << ((0 ? 4 : 4) %
						32))) | ((0x00000001) << ((0 ? 4 : 4) % 32)));
	}
	else
	{
		initCtxtPtr = (NvU32 *) (hwdev->info.Pram.FifoContextAddr + (chid * 32));
		for (ctxtPtr = initCtxtPtr; ctxtPtr < (initCtxtPtr + 8); ctxtPtr++)
		{
			(hwram)->Reg32[((NvU32) ctxtPtr - (0 ? 0x01FFFFFF : 0x01C00000)) / 4] =
				(NvV32) (0);
		}
	}
	if (hwdev->info.Graphics.CurrentChID == chid)
	{
		hwdev->info.Graphics.CurrentChID = (-1);
		grLoadChannelContext (device, (-1));
	}
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] = (NvV32) (fifoPull);
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH0) / 4] = (NvV32) (fifoPush);
	(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] = (NvV32) (fifoReassign);
}

void
fifoInitSubChannelCache (NvChannelInfo *channelInfo)
{
	int                 i;

	for (i = 0; i < 8; i++)
	{
		channelInfo->subChannel[i] = (void *) 0;
	}
}
void
fifoRemoveObjectFromSubChannelCache (EngineObj *object)
{
	NvChannelObj       *channelObj = (NvChannelObj *) object->base.parent;
	NvChannelInfo      *channelInfo = channelObj->channel;
	int                 i;

	;
	for (i = 0; i < 8; i++)
	{
		if (channelInfo->subChannel[i] == object)
		{
			channelInfo->subChannel[i] = (void *) 0;
		}
	}
}
NvContextDmaObj    *
fifoInstMemLocToContextDma (NvDeviceInfo *device, NvU32 chid, NvU32 instMemLoc)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	GenericObj         *list[2];
	GenericObj         *obj;
	int                 i;

	;
	list[0] = hwchan->base.object->base.parent;
	;
	list[1] = list[0]->parent;
	;
	for (i = 0; i < (sizeof (list) / sizeof (list[0])); i++)
	{
		for (obj = list[i]->childList; obj; obj = obj->next)
		{
			if (obj->mask & 0x10)
			{
				NvContextDmaObj    *contextDmaObj = (NvContextDmaObj *) obj;

				if (instMemLoc == contextDmaObj->instOffset)
				{
					;
					return contextDmaObj;
				}
			}
		}
	}
	return (void *) 0;
}

EngineObj          *
fifoInstMemLocToObject (NvDeviceInfo *device, NvU32 chid, NvU32 subChannel, NvU32 instMemLoc)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwChannelInfo      *hwchan = &hwdev->channel[chid];
	NvChannelObj       *channelObj = hwchan->base.object;
	GenericObj         *obj;
	EngineObj          *engineObj;
	NvU32               instMemLoc2;

	;
	;
	;
	;
	engineObj = hwchan->base.subChannel[subChannel];
	if (engineObj)
	{
		;
		instMemLoc2 =
			(((engineObj->context) >> ((0 ? (1 * 32 + 15) : (1 * 32 +
							0)) & 31)) & (0xFFFFFFFF >> (31 -
					(1 ? (1 * 32 + 15) : (1 * 32 + 0)) + (0 ? (1 * 32 +
							15) : (1 * 32 + 0)))));
		if (instMemLoc == instMemLoc2)
		{
			;
			engineObj->subChannel = subChannel;
			return engineObj;
		}
	}
	for (obj = channelObj->base.childList; obj; obj = obj->next)
	{
		if (obj->mask & 0x1)
		{
			engineObj = (EngineObj *) obj;
			instMemLoc2 =
				(((engineObj->context) >> ((0 ? (1 * 32 + 15) : (1 * 32 +
								0)) & 31)) & (0xFFFFFFFF >> (31 -
						(1 ? (1 * 32 + 15) : (1 * 32 + 0)) + (0 ? (1 * 32 +
								15) : (1 * 32 + 0)))));
			if (instMemLoc == instMemLoc2)
			{
				;
				hwchan->base.subChannel[subChannel] = engineObj;
				engineObj->subChannel = subChannel;
				return engineObj;
			}
		}
	}
	engineObj = channelObj->nullObj;
	;
	if (engineObj != (void *) 0)
	{
		instMemLoc2 =
			(((engineObj->context) >> ((0 ? (1 * 32 + 15) : (1 * 32 +
							0)) & 31)) & (0xFFFFFFFF >> (31 -
					(1 ? (1 * 32 + 15) : (1 * 32 + 0)) + (0 ? (1 * 32 +
							15) : (1 * 32 + 0)))));
		if (instMemLoc == instMemLoc2)
		{
			;
			return engineObj;
		}
	}
	;
	return (void *) 0;
}
static EngineObj   *
fifoSubChannelToObject (NvDeviceInfo *device, NvU32 chid, NvU32 subChannel)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	HwReg              *hwram = ((hwdev)->base.imAddr);
	EngineObj          *object;
	NvU32               fifoContextBase = hwdev->info.Pram.FifoContextAddr;
	NvV32               context;

	;
	if ((((((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4])) >> ((0 ? 6 : 0) %
					32)) & (0xFFFFFFFF >> (31 - ((1 ? 6 : 0) % 32) +
					((0 ? 6 : 0) % 32)))) == chid)
	{
		context = ((hwreg)->Reg32[((0x00003280 + (subChannel) * 16)) / 4]);
		;
	}
	else
	{
		context =
			((hwram)->Reg32[(fifoContextBase + 4 * ((chid * 8) + subChannel) -
					(0 ? 0x01FFFFFF : 0x01C00000)) / 4]);
		;
	}
	object = fifoInstMemLocToObject (device, chid, subChannel,
		(((context) >> ((0 ? (1 * 32 + 15) : (1 * 32 + 0)) & 31)) & (0xFFFFFFFF >> (31 -
					(1 ? (1 * 32 + 15) : (1 * 32 + 0)) + (0 ? (1 * 32 +
							15) : (1 * 32 + 0))))));
	return object;
}

NvV32
fifoFlushContext (NvDeviceInfo *device, NvU32 newChid)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	HwReg              *hwram = ((hwdev)->base.imAddr);
	NvU32              *fifoCtxBase = (NvU32 *) hwdev->info.Pram.FifoContextAddr;
	NvU32               currChid;
	NvU32               subChan;
	NvV32               context;

	currChid = ((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4]);
	;
	for (subChan = 0; subChan < 8; subChan++)
	{
		context = ((hwreg)->Reg32[((0x00003280 + (subChan) * 16)) / 4]);
		(hwram)->Reg32[((NvU32) (fifoCtxBase + (currChid * 8) + subChan) -
				(0 ? 0x01FFFFFF : 0x01C00000)) / 4] = (NvV32) (context);
	}
	hwdev->channel[currChid].fifo.dma_status = ((hwreg)->Reg32[(0x00003218) / 4]);
	grLoadChannelContext (device, newChid);
	for (subChan = 0; subChan < 8; subChan++)
	{
		context =
			((hwram)->Reg32[((NvU32) (fifoCtxBase + (newChid * 8) + subChan) -
					(0 ? 0x01FFFFFF : 0x01C00000)) / 4]);
		(hwreg)->Reg32[((0x00003280 + (subChan) * 16)) / 4] = (NvV32) (context);
	}
	(hwreg)->Reg32[(0x00003218) / 4] = (NvV32) (hwdev->channel[newChid].fifo.dma_status);
	(hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4] = (NvV32) (newChid);
	return 0;
}

NvV32
fifoService (NvDeviceInfo *device)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	HwReg              *hwram = ((hwdev)->base.imAddr);
	NvV32               intr;
	NvV32               status;
	NvU32               getPtr;
	NvU32               cache1Addr;
	NvU32               chid;
	NvU32               type;
	NvU32               reason,
	                    swDevice;
	NvU32               subChannel,
	                    method,
	                    data,
	                    byteEnables;
	int                 moreFifoEntries;
	NvU32               context;

	intr = ((hwreg)->Reg32[(NV_PFIFO_INTR_0) / 4]);
	;
	status = 0;
	if (intr & ((0x00000001) << ((0 ? 0 : 0) % 32)))
	{
		;
		(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		moreFifoEntries = 1;
		while (moreFifoEntries)
		{
			(hwreg)->Reg32[(NV_PFIFO_INTR_0) / 4] =
				(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
			reason = ((hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4]);
			swDevice =
				(((reason) >> ((0 ? 8 : 8) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 8 : 8) % 32) + ((0 ? 8 : 8) % 32))));
			chid = ((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4]);
			getPtr = ((hwreg)->Reg32[(NV_PFIFO_CACHE1_GET) / 4]) >> 2;
			if ((hwdev->info.Chip.Revision == 0x20))
			{
				cache1Addr = ((getPtr ^ (getPtr >> 1)) & 0x20) | (getPtr & 0x1f);
				subChannel =
					(((((hwreg)->Reg32[((0x00003400 + (cache1Addr) * 8)) /
									4])) >> ((0 ? 15 : 13) %
							32)) & (0xFFFFFFFF >> (31 -
							((1 ? 15 : 13) % 32) +
							((0 ? 15 : 13) % 32))));
				method = ((hwreg)->Reg32[((0x00003400 +
								(cache1Addr) * 8)) / 4]) & 0x1FFF;
				data = ((hwreg)->Reg32[((0x00003404 + (cache1Addr) * 8)) / 4]);
			}
			else
			{
				subChannel =
					(((((hwreg)->Reg32[((0x00003300 + (getPtr) * 8)) /
									4])) >> ((0 ? 15 : 13) %
							32)) & (0xFFFFFFFF >> (31 -
							((1 ? 15 : 13) % 32) +
							((0 ? 15 : 13) % 32))));
				method = ((hwreg)->Reg32[((0x00003300 +
								(getPtr) * 8)) / 4]) & 0x1FFF;
				data = ((hwreg)->Reg32[((0x00003304 + (getPtr) * 8)) / 4]);
			}
			if ((chid < 16) && hwdev->channel[chid].base.inUse)
			{
				if (method >= 0x0100)
				{
					EngineObj          *object;

					context =
						((hwreg)->Reg32[((0x00003280 +
									(subChannel) * 16)) / 4]);
					object = fifoInstMemLocToObject (device, chid, subChannel,
						(((context) >> ((0 ? 15 : 0) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 15 : 0) % 32) +
									((0 ? 15 : 0) % 32)))));
					if (object)
					{
						;
						;
						status = classSoftwareMethod (object, method, data,
							swDevice ? 5 : 3);
						if (status)
						{
							;
							errorWrite (&object->base, status, method,
								data, 0, 0);
						}
					}
					else
					{
						NvChannelObj       *channelObj;

						;
						channelObj = hwdev->channel[chid].base.object;
						errorWrite (&channelObj->base, (0x02000000), method,
							data, 0, 0);
					}
				}
				else
				{
					status = ctrlSoftwareMethod (device, chid, subChannel,
						method, data);
					if (status)
					{
						NvChannelObj       *channelObj;

						channelObj = hwdev->channel[chid].base.object;
						;
						errorWrite (&channelObj->base, status, method, data,
							0, 0);
					}
				}
			}
			else
			{
				;
				;
				;
				;
			}
			if ((hwdev->info.Chip.Revision == 0x20))
			{
				(hwreg)->Reg32[(NV_PFIFO_CACHE1_GET) / 4] =
					(NvV32) (fifoGrayInc (getPtr) << 2);
				getPtr = ((hwreg)->Reg32[(NV_PFIFO_CACHE1_GET) / 4]) >> 2;
				cache1Addr = ((getPtr ^ (getPtr >> 1)) & 0x20) | (getPtr & 0x1f);
			}
			else
			{
				(hwreg)->Reg32[(NV_PFIFO_CACHE1_GET) / 4] =
					(NvV32) (fifoGrayIncTable[getPtr] << 2);
				getPtr = ((hwreg)->Reg32[(NV_PFIFO_CACHE1_GET) / 4]) >> 2;
			}
			moreFifoEntries = 0;
			if ((((((hwreg)->Reg32[(0x00003214) / 4])) >> ((0 ? 4 : 4) %
							32)) & (0xFFFFFFFF >> (31 -
							((1 ? 4 : 4) % 32) +
							((0 ? 4 : 4) % 32)))) == NV_PMC_BOOT_0)
			{
				if ((hwdev->info.Chip.Revision == 0x20))
				{
					method = ((hwreg)->Reg32[((0x00003400 +
									(cache1Addr) * 8)) /
							4]) & 0x1FFF;
					data = ((hwreg)->Reg32[((0x00003404 +
									(cache1Addr) * 8)) / 4]);
					subChannel =
						(((((hwreg)->Reg32[((0x00003400 + (cache1Addr) * 8))
										/
										4])) >> ((0 ? 15 :
									13) %
								32)) & (0xFFFFFFFF >> (31 -
								((1 ? 15 : 13) % 32) +
								((0 ? 15 : 13) % 32))));
				}
				else
				{
					method = ((hwreg)->Reg32[((0x00003300 +
									(getPtr) * 8)) /
							4]) & 0x1FFF;
					data = ((hwreg)->Reg32[((0x00003304 + (getPtr) * 8)) / 4]);
					subChannel =
						(((((hwreg)->Reg32[((0x00003300 + (getPtr) * 8)) /
										4])) >> ((0 ? 15 :
									13) %
								32)) & (0xFFFFFFFF >> (31 -
								((1 ? 15 : 13) % 32) +
								((0 ? 15 : 13) % 32))));
				}
				;
				if (method == 0)
				{
					context = fifoHashSearch (device, data, chid);
				}
				else
				{
					EngineObj          *object;

					context =
						((hwreg)->Reg32[((0x00003280 +
									(subChannel) * 16)) / 4]);
					object = fifoInstMemLocToObject (device, chid, subChannel,
						(((context) >> ((0 ? 15 : 0) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 15 : 0) % 32) +
									((0 ? 15 : 0) % 32)))));
					if (object)
					{
						;
					}
				}
				if (!context)
				{
					moreFifoEntries = 1;
				}
			}
		}
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
	}
	if (intr & ((0x00000001) << ((0 ? 12 : 12) % 32)))
	{
		NvV32               reasonReg;

		;
		(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_DMA0) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_INTR_0) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 12 : 12) % 32)));
		reasonReg = ((hwreg)->Reg32[(0x00003218) / 4]);
		reason = (((reasonReg) >> ((0 ? 30 : 30) % 32)) & (0xFFFFFFFF >> (31 -
					((1 ? 30 : 30) % 32) + ((0 ? 30 : 30) % 32))));
		;
		switch (reason)
		{
			default:;
				;
				break;
		}
	}
	if (intr & ((0x00000001) << ((0 ? 4 : 4) % 32)))
	{
		;
		;
		if ((((((hwreg)->Reg32[(0x00003214) / 4])) >> ((0 ? 4 : 4) %
						32)) & (0xFFFFFFFF >> (31 - ((1 ? 4 : 4) % 32) +
						((0 ? 4 : 4) % 32)))) == 0x00000001)
		{
			(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
			getPtr = ((hwreg)->Reg32[(NV_PFIFO_RUNOUT_GET) / 4]);
			data = ((hwram)->Reg32[(hwdev->info.Pram.FifoRunoutAddr + getPtr -
						(0 ? 0x01FFFFFF : 0x01C00000)) / 4]);
			chid = (((data) >> ((0 ? (0 * 32 + 22) : (0 * 32 +
								16)) & 31)) & (0xFFFFFFFF >> (31 -
						(1 ? (0 * 32 + 22) : (0 * 32 + 16)) + (0 ? (0 * 32 +
								22) : (0 * 32 + 16)))));
			type = (((data) >> ((0 ? (0 * 32 + 23) : (0 * 32 +
								23)) & 31)) & (0xFFFFFFFF >> (31 -
						(1 ? (0 * 32 + 23) : (0 * 32 + 23)) + (0 ? (0 * 32 +
								23) : (0 * 32 + 23)))));
			reason = (((data) >> ((0 ? (0 * 32 + 31) : (0 * 32 +
								28)) & 31)) & (0xFFFFFFFF >> (31 -
						(1 ? (0 * 32 + 31) : (0 * 32 + 28)) + (0 ? (0 * 32 +
								31) : (0 * 32 + 28)))));
			method = (((data) >> ((0 ? (0 * 32 + 15) : (0 * 32 +
								0)) & 31)) & (0xFFFFFFFF >> (31 -
						(1 ? (0 * 32 + 15) : (0 * 32 + 0)) + (0 ? (0 * 32 +
								15) : (0 * 32 + 0)))));
			byteEnables =
				(((data) >> ((0 ? (0 * 32 + 27) : (0 * 32 +
								24)) & 31)) & (0xFFFFFFFF >> (31 -
						(1 ? (0 * 32 + 27) : (0 * 32 + 24)) + (0 ? (0 * 32 +
								27) : (0 * 32 + 24)))));
			subChannel = method >> 13;
			method = method & 0x1FFF;
			data = ((hwram)->Reg32[(hwdev->info.Pram.FifoRunoutAddr + getPtr + 4 -
						(0 ? 0x01FFFFFF : 0x01C00000)) / 4]);
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			if (reason == NV_PMC_BOOT_0)
			{
				if (method >= 0x100)
				{
					if (type == 0x00000001)
						status = (0x00000004);
					if (byteEnables != 0)
						status |= (0x00000008);
					if (byteEnables & 0x1)
						status |= (0x00000010);
				}
				else
				{
					if (method == 0)
					{
						if (type == 0x00000001)
							status = (0x00000004);
						if (byteEnables != 0)
							status |= (0x00000008);
						if (byteEnables & 0x1)
							status |= (0x00000010);
					}
					else if (method < 0x10 || method > 0x1f)
					{
						status |= (0x08000000);
						if (type == NV_PMC_BOOT_0)
							status |= (0x00000002);
						else
							status |= (0x00000004);
						if (byteEnables != 0)
							status |= (0x00000008);
						if (byteEnables & 0x1)
							status |= (0x00000010);
					}
					else if (method >= 0x10 && method <= 0x1f)
					{
						if (type == NV_PMC_BOOT_0)
							status = (0x00000002);
						if (byteEnables != 0xc && byteEnables != 0x3)
							status |= (0x00000008);
						if ((byteEnables & 0x1) && (byteEnables & 0x4))
							status |= (0x00000010);
					}
				}
			}
			else if (reason == 0x00000005)
			{
				status = (0x08000000);
				if (type == NV_PMC_BOOT_0)
					status |= (0x00000002);
				else if (type == 0x00000001)
					status |= (0x00000004);
			}
			else if ((reason == 0x00000001) || (reason == 0x00000002))
			{
				if ((chid < 16) && hwdev->channel[chid].base.inUse)
				{
					if (method >= 0x0100)
					{
						EngineObj          *object;

						object = fifoSubChannelToObject (device, chid,
							subChannel);
						hwdev->channel[chid].base.subChannel[subChannel] =
							object;
						if (object)
						{
							{
								NvV32               _status;

								_status =
									((hwreg)->
									Reg32[(NV_PGRAPH_STATUS) /
										4]);
								while (_status)
								{
									NvV32               _pmc =
										((hwreg)->
										Reg32[(NV_PMC_INTR_0) / 4]);
									if (_pmc & ((0x00000001) <<
											((0 ? 12 : 12) % 32)))
									{
										grService (device);
									}
									_status =
										((hwreg)->
										Reg32[(NV_PGRAPH_STATUS) / 4]);
								}
							};
							object->subChannel = subChannel;
							status = classSoftwareMethod (object,
								method, data, 4);
							if (status)
								errorWrite (&object->base, status,
									method, data, 0, 0);
							status = 0;
						}
						else
						{
							status = (0x02000000);
						}
					}
					else
					{
						;
						status = ctrlSoftwareMethod (device, chid,
							subChannel, method, data);
						if (status == (0x08000000))
						{
							if (type == NV_PMC_BOOT_0)
								status |= (0x00000002);
							else
								status |= (0x00000004);
							if (byteEnables != 0)
								status |= (0x00000008);
							if (byteEnables & 0x1)
								status |= (0x00000010);
						}
					}
				}
				else
				{
					;
					;
					;
					;
				}
			}
			else if (reason == 0x00000003)
			{
				status = (0x00000001);
				if (type == NV_PMC_BOOT_0)
					status |= (0x00000002);
				else if (type == 0x00000001)
					status |= (0x00000004);
			}
			else
			{
				;
			}
			if (status)
			{
				NvChannelObj       *channelObj;

				channelObj = hwdev->channel[chid].base.object;
				;
				errorWrite (&channelObj->base, status, method, data, 0, 0);
			}
			getPtr = (getPtr + 8) & hwdev->info.Pram.RunOutMask;
			(hwreg)->Reg32[(NV_PFIFO_RUNOUT_GET) / 4] = (NvV32) (getPtr);
			getPtr = ((hwreg)->Reg32[(NV_PFIFO_RUNOUT_GET) / 4]);
			if (((hwreg)->Reg32[(NV_PFIFO_RUNOUT_STATUS) /
						4]) & ((0x00000001) << ((0 ? 4 : 4) % 32)))
			{
				(hwreg)->Reg32[(NV_PFIFO_INTR_0) / 4] =
					(NvV32) (((0x00000001) << ((0 ? 4 : 4) % 32)));
			}
		}
		else
		{
			(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
				(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
		}
	}
	if (intr & ((0x00000001) << ((0 ? 8 : 8) % 32)))
	{
		NvChannelObj       *channelObj;

		status = (0x00000001);
		;
		(hwreg)->Reg32[(NV_PFIFO_INTR_0) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 8 : 8) % 32)));
		;
		(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
		getPtr = ((hwreg)->Reg32[(NV_PFIFO_RUNOUT_GET) / 4]);
		data = ((hwram)->Reg32[(hwdev->info.Pram.FifoRunoutAddr + getPtr -
					(0 ? 0x01FFFFFF : 0x01C00000)) / 4]);
		chid = (((data) >> ((0 ? (0 * 32 + 22) : (0 * 32 +
							16)) & 31)) & (0xFFFFFFFF >> (31 -
					(1 ? (0 * 32 + 22) : (0 * 32 + 16)) + (0 ? (0 * 32 +
							22) : (0 * 32 + 16)))));
		method = (((data) >> ((0 ? (0 * 32 + 15) : (0 * 32 +
							0)) & 31)) & (0xFFFFFFFF >> (31 -
					(1 ? (0 * 32 + 15) : (0 * 32 + 0)) + (0 ? (0 * 32 +
							15) : (0 * 32 + 0)))));
		method = method & 0x1FFF;
		data = ((hwram)->Reg32[(hwdev->info.Pram.FifoRunoutAddr + getPtr + 4 -
					(0 ? 0x01FFFFFF : 0x01C00000)) / 4]);
		channelObj = hwdev->channel[chid].base.object;
		;
		errorWrite (&channelObj->base, status, method, data, 0, 0);
	}
	if (((hwreg)->Reg32[(NV_PFIFO_INTR_0) / 4]) == NV_PMC_BOOT_0)
	{
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL0) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHES) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 0 : 0) % 32)));
	}
	intr = ((hwreg)->Reg32[(NV_PFIFO_INTR_0) / 4]);
	intr |= (((((hwreg)->Reg32[(0x00002080) / 4])) >> ((0 ? 0 : 0) % 32)) & (0xFFFFFFFF >> (31 -
				((1 ? 0 : 0) % 32) + ((0 ? 0 : 0) % 32))));
	return intr;
}

NvV32
fifoResend (NvDeviceInfo *device, EngineObj *object, NvU32 method, NvV32 data)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               context = object->context;

	;
	;
	;
	;
	;
	;
	;
	if (context)
	{
		{
			NvV32               _status;

			_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
			while (_status)
			{
				NvV32               _pmc = ((hwreg)->Reg32[(NV_PMC_INTR_0) / 4]);

				if (_pmc & ((0x00000001) << ((0 ? 12 : 12) % 32)))
				{
					grService (device);
				}
				_status = ((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]);
			}
		};
		(hwreg)->Reg32[(0x00003070) / 4] = (NvV32) (NV_PMC_BOOT_0);
		(hwreg)->Reg32[(0x00003010) / 4] = (NvV32) (0x00000004);
		(hwreg)->Reg32[(NV_PFIFO_CACHE0_PUSH1) / 4] = (NvV32) (objectToChID (object));
		(hwreg)->Reg32[((0x00003080 + (0) * 16)) / 4] = (NvV32) (context);
		(hwreg)->Reg32[((0x00003104 + (0) * 8)) / 4] = (NvV32) (data);
		(hwreg)->Reg32[((0x00003100 + (0) * 8)) / 4] =
			(NvV32) (method | (object->subChannel << ((0 ? 15 : 13) % 32)));
		(hwreg)->Reg32[(NV_PFIFO_CACHE0_PULL0) / 4] = (NvV32) (0x00000001);
		while ((((((hwreg)->Reg32[(0x00003014) / 4])) >> ((0 ? 4 : 4) %
						32)) & (0xFFFFFFFF >> (31 - ((1 ? 4 : 4) % 32) +
						((0 ? 4 : 4) % 32)))) == NV_PMC_BOOT_0)
		{
			if (((hwreg)->Reg32[(NV_PGRAPH_INTR_0) / 4]) & 0x11111011)
			{
				grService (device);
			}
		}
		(hwreg)->Reg32[(NV_PFIFO_CACHE0_PULL0) / 4] =
			(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	}
	return 0;
}
