 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


NvS32
fbCalcScreenMemSize (NvDeviceInfo *device)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	NvS32               size;

	switch (hwdev->info.Framebuffer.RamSizeMb)
	{
		case 1:
			size = 0x2000;
			break;
		case 2:
			size = 0x5000;
			break;
		case 8:
			size = 0x17000;
			break;
		case 16:
			size = 0x2e000;
			break;
		case 32:
			size = 0x5c000;
			break;
		case 64:
			size = 0xb8000;
			break;
		case 4:
		default:
			size = 0xb000;
			break;
	}
	return size;
}

void
fbLoadConfig0Register (NvDeviceInfo *device)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);

	;
	hwdev->info.Framebuffer.ConfigReg = 0x00001114;
	(hwreg)->Reg32[(NV_PFB_CONFIG_0) / 4] = (NvV32) (hwdev->info.Framebuffer.ConfigReg);
}

NvV32
fbChangeState (NvDeviceInfo *device, int state)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvV32               id,
	                    status = 0;
	NvU32               size,
	                    offset;
	NvU8               *pbyte;
	NvU64               limit;
	NvP64               base;

	;
	switch (state)
	{
		case 3:;
			break;
		case 1:;
			size = fbCalcScreenMemSize (device);
			dacCalcPClkVClkRatio (device);
			fbLoadConfig0Register (device);
			status = fbMemPoolCreate (device);
			if (status)
				return status;
			hwdev->info.Pram.CurrentSize = 0x1400;
			(hwreg)->Reg32[(NV_PFIFO_RAMHT) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 17 : 16) %
						32)) | (((0) & (0xFFFFFFFF >> (31 -
								((1 ? 8 : 4) % 32) +
								((0 ? 8 : 4) %
									32)))) << ((0 ? 8 : 4) %
						32)) | ((0x00000003) << ((0 ? 25 : 24) % 32)));
			hwdev->info.Pram.HashTableAddr = (0 ? 0x007FFFFF : 0x00700000) + 0;
			hwdev->info.Pram.HashDepth = 512;
			(hwreg)->Reg32[(NV_PFIFO_RAMRO) / 4] =
				(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 16 : 16) %
						32)) | (((0x8) & (0xFFFFFFFF >> (31 -
								((1 ? 8 : 1) % 32) +
								((0 ? 8 : 1) %
									32)))) << ((0 ? 8 : 1) %
						32)));
			hwdev->info.Pram.FifoRunoutAddr = (0 ? 0x007FFFFF : 0x00700000) + 0x1000;
			hwdev->info.Pram.RunOutMask = 0x01FF;
			(hwreg)->Reg32[(NV_PFIFO_RAMFC) / 4] =
				(NvV32) (((((0x1200 >> 9)) & (0xFFFFFFFF >> (31 -
								((1 ? 8 : 1) % 32) +
								((0 ? 8 : 1) %
									32)))) << ((0 ? 8 : 1) %
						32)));
			hwdev->info.Pram.FifoContextAddr = (0 ? 0x007FFFFF : 0x00700000) + 0x1200;
			hwdev->info.Pram.FreeInstSize = size - 0x1400;
			hwdev->info.Pram.FreeInstBase = hwdev->info.Pram.CurrentSize >> 4;
			;
			status = fbMemAlloc (device, 0, hwdev->info.Framebuffer.BankCount - 1,
				&size, &offset, 0x01);
			if (status)
			{
				;
				return status;
			}
			;
			hwdev->info.Pram.FreeInstMax = (hwdev->info.Pram.FreeInstSize / 16) & ~0x07;
			;
			;
			;
			;
			size = hwdev->info.Pram.FreeInstMax / 8 + 4;
			(&limit)->high = 0, (&limit)->low = (NvU32) (size - 1);
			status = nvArchMemoryAllocKernel (&base, limit, &id);
			if (status != (NV_PMC_BOOT_0))
			{
				;
				return 2;
			}
			;
			hwdev->info.Pram.FbInstBitMap = (NvU8 *) (&base)->low;
			hwdev->info.Pram.FbInstBitMapId = id;
			pbyte = hwdev->info.Pram.FbInstBitMap;
			*pbyte++ = 0xFE;
			while (--size)
			{
				*pbyte++ = 0xFF;
			}
			break;
		case 2:;
			if (hwdev->info.Pram.FbInstBitMap)
			{
				;
				nvArchMemoryFree (hwdev->info.Pram.FbInstBitMapId);
			}
			hwdev->info.Pram.FbInstBitMap = (void *) 0;
			fbMemPoolDestroy (device);
			break;
		case 0:;
			fbInit (device);
			break;
		case 4:;
			break;
	}
	return status;
}
