 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


MemClassInfo        memClassInfoTbl[] = {
	{0, 0, 0, 0}, {(0x00000040), 0xfff, 0xfff, 0}, {(0x0000003D), 0xfff, 0xfff, 0},
};
NvV32
fbMemPoolCreate (NvDeviceInfo *device)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	NvU8               *fbAddr;
	MemPool            *memPool;
	MemBlock           *block;
	NvU32               sizeBank,
	                    ramSize,
	                    numBanks,
	                    i;
	NvP64               base;
	NvU64               limit;
	NvV32               status,
	                    id;

	;
	;
	ramSize = hwdev->info.Framebuffer.RamSize;
	numBanks = hwdev->info.Framebuffer.BankCount;
	fbAddr = (NvU8 *) (&device->fbPhysAddr)->low;
	;
	device->fbmemLockId = nvArchRequestId (0x01);
	if (device->fbmemLockId == 0)
	{
		;
		return (0x00000002);
	}
	status = nvArchLockAllocSleep (device->fbmemLockId);
	if (status != (NV_PMC_BOOT_0))
	{
		;
		return 2;;
	}
	(&limit)->high = 0, (&limit)->low =
		(NvU32) (sizeof (MemPool) + ((numBanks - 1) * sizeof (MemBank)) - 1);
	status = nvArchMemoryAllocKernel (&base, limit, &id);
	if (status != (NV_PMC_BOOT_0))
	{
		nvArchLockFree (device->fbmemLockId);
		;
		return 2;
	}
	memPool = (MemPool *) (&base)->low;
	memPool->base = fbAddr;
	memPool->total = ramSize;
	memPool->free = ramSize;
	hwdev->info.Framebuffer.FbMemPool = memPool;
	hwdev->info.Framebuffer.FbMemPoolId = id;
	(&limit)->high = 0, (&limit)->low = (NvU32) (sizeof (MemBlock) - 1);
	status = nvArchMemoryAllocKernel (&base, limit, &id);
	if (status != (NV_PMC_BOOT_0))
	{
		nvArchLockFree (device->fbmemLockId);
		;
		nvArchMemoryFree (hwdev->info.Framebuffer.FbMemPoolId);
		return 2;
	}
	block = (MemBlock *) (&base)->low;
	block->memoryId = id;
	block->owner = 0xffffffff;
	block->begin = 0;
	block->end = ramSize - 1;
	block->prevFree = (void *) 0;
	block->nextFree = (void *) 0;
	block->next = (void *) 0;
	block->prev = (void *) 0;
	memPool->blockListHead = block;
	memPool->blockListTail = block;
	memPool->freeBlockListHead = block;
	memPool->freeBlockListTail = block;
	memPool->numBanks = numBanks;
	sizeBank = ramSize / numBanks;
	for (i = 0; i < numBanks; i++)
	{
		memPool->bank[i].offset = i * sizeBank;
		memPool->bank[i].size = sizeBank;
	}
	;
	return 0;
}

NvV32
fbMemPoolDestroy (NvDeviceInfo *device)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	MemPool            *memPool = hwdev->info.Framebuffer.FbMemPool;
	MemBlock           *block,
	                   *blockFirst,
	                   *blockNext;

	;
	if (memPool == (void *) 0)
		return 0;
	block = blockFirst = memPool->blockListHead;
	while (block != (void *) 0)
	{
		blockNext = block->next;
		nvArchMemoryFree (block->memoryId);
		block = blockNext;
	}
	nvArchLockFree (device->fbmemLockId);
	nvArchMemoryFree (hwdev->info.Framebuffer.FbMemPoolId);
	hwdev->info.Framebuffer.FbMemPool = 0;
	return 0;
}
static NvV32
blockAlloc (MemPool *memPool, MemBlock *blockFree, NvU32 owner, NvU32 allocLo, NvU32 allocHi)
{
	MemBlock           *blockNew,
	                   *blockSplit;
	NvU64               limit;
	NvP64               base;
	NvV32               status,
	                    id;

	;
	if (allocLo == blockFree->begin && allocHi == blockFree->end)
	{
		if (blockFree->nextFree)
			blockFree->nextFree->prevFree = blockFree->prevFree;
		if (blockFree->prevFree)
			blockFree->prevFree->nextFree = blockFree->nextFree;
		if (memPool->freeBlockListHead == blockFree)
			memPool->freeBlockListHead = blockFree->nextFree;
		if (memPool->freeBlockListTail == blockFree)
			memPool->freeBlockListTail = blockFree->prevFree;
		blockFree->owner = owner;
		memPool->free -= (blockFree->end - blockFree->begin + 1);
		;
		return 0;
	}
	(&limit)->high = 0, (&limit)->low = (NvU32) (sizeof (MemBlock) - 1);
	status = nvArchMemoryAllocKernel (&base, limit, &id);
	if (status != (NV_PMC_BOOT_0))
	{
		;
		return 2;
	}
	blockNew = (MemBlock *) (&base)->low;
	blockNew->memoryId = id;
	blockNew->owner = owner;
	blockNew->begin = allocLo;
	blockNew->end = allocHi;
	if ((blockFree->begin < blockNew->begin) && (blockFree->end > blockNew->end))
	{
		status = nvArchMemoryAllocKernel (&base, limit, &id);
		if (status != (NV_PMC_BOOT_0))
		{
			;
			nvArchMemoryFree (blockNew->memoryId);
			return 2;
		}
		blockSplit = (MemBlock *) (&base)->low;
		blockSplit->memoryId = id;
		blockSplit->owner = 0xffffffff;
		blockSplit->begin = blockNew->end + 1;
		blockSplit->end = blockFree->end;
		blockFree->end = blockNew->begin - 1;
		blockSplit->nextFree = blockFree->nextFree;
		blockSplit->prevFree = blockFree;
		if (blockSplit->nextFree)
			blockSplit->nextFree->prevFree = blockSplit;
		blockFree->nextFree = blockSplit;
		blockNew->next = blockSplit;
		blockNew->prev = blockFree;
		blockSplit->next = blockFree->next;
		blockSplit->prev = blockNew;
		blockFree->next = blockNew;
		if (blockSplit->next)
			blockSplit->next->prev = blockSplit;
		if (memPool->freeBlockListTail == blockFree)
			memPool->freeBlockListTail = blockSplit;
		if (memPool->blockListTail == blockFree)
			memPool->blockListTail = blockSplit;
	}
	else if (blockFree->end == blockNew->end)
	{
		blockFree->end = blockNew->begin - 1;
		blockNew->next = blockFree->next;
		blockNew->prev = blockFree;
		if (blockFree->next)
			blockFree->next->prev = blockNew;
		blockFree->next = blockNew;
		if (memPool->blockListTail == blockFree)
			memPool->blockListTail = blockNew;
	}
	else if (blockFree->begin == blockNew->begin)
	{
		blockFree->begin = blockNew->end + 1;
		blockNew->next = blockFree;
		blockNew->prev = blockFree->prev;
		if (blockFree->prev)
			blockFree->prev->next = blockNew;
		blockFree->prev = blockNew;
		if (memPool->blockListHead == blockFree)
			memPool->blockListHead = blockNew;
	}
	else
	{
		;
		nvArchMemoryFree (blockNew->memoryId);
		;
		return 2;
	}
	memPool->free -= (blockNew->end - blockNew->begin + 1);
	;
	;
	return 0;
}

NvV32
fbMemAlloc (NvDeviceInfo *device, NvU32 owner, NvU32 bankNum, NvU32 *size, NvU32 *offset,
	NvU32 direction)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	MemPool            *memPool = hwdev->info.Framebuffer.FbMemPool;
	MemBank            *bank;
	NvU32               rangeLo,
	                    rangeHi,
	                    freeLo,
	                    freeHi;
	NvU32               allocLo,
	                    allocAl,
	                    allocHi;
	MemBlock           *blockFree,
	                   *blockBest = (void *) 0;
	MemClassInfo       *memClassInfo;
	NvU32               sizeBest = 0;
	int                 wrapped = 0;
	NvV32               status;

	;
	;
	if (!memPool)
	{
		*size = 0;
		return 2;
	}
	if (*size == 0)
	{
		;
		return 0;
	}
	if ((bankNum != 0xffffffff) && (bankNum > memPool->numBanks))
	{
		;
		*size = 0;
		return 2;
	}
	nvArchLockAcquire (device->fbmemLockId);
	if (memPool->freeBlockListHead == (void *) 0)
	{
		nvArchLockRelease (device->fbmemLockId);
		;
		*size = 0;
		return 2;
	}
	;
	for (memClassInfo = &memClassInfoTbl[0];
		memClassInfo < &memClassInfoTbl[(sizeof (memClassInfoTbl) / sizeof (MemClassInfo))];
		memClassInfo++)
	{
		if (memClassInfo->classNum == owner)
			break;
	}
	if (memClassInfo == &memClassInfoTbl[(sizeof (memClassInfoTbl) / sizeof (MemClassInfo))])
		memClassInfo = &memClassInfoTbl[0];
	;
	if (*size & memClassInfo->limitAlign)
	{
		;
		*size = ((*size + memClassInfo->limitAlign) & ~memClassInfo->limitAlign);
	}
	if (bankNum == 0xffffffff)
	{
		bank = &memPool->bank[memPool->numBanks - 1];
		rangeLo = memPool->bank[0].offset;
		rangeHi = bank->offset + bank->size - 1;
	}
	else
	{
		bank = &memPool->bank[bankNum];
		rangeLo = bank->offset;
		rangeHi = bank->offset + bank->size - 1;
	}
	;
	if (direction == 0x01)
	{
		blockFree = memPool->freeBlockListTail;
		while (blockFree && blockFree->begin > rangeHi)
			blockFree = blockFree->prevFree;
	}
	else
	{
		blockFree = memPool->freeBlockListHead;
		while (blockFree && blockFree->end < rangeLo)
			blockFree = blockFree->nextFree;
	}
	while (blockFree != (void *) 0)
	{
		if ((blockFree->begin > rangeHi) || (blockFree->end < rangeLo))
		{
			;
			break;
		}
		freeLo = (rangeLo < blockFree->begin) ? blockFree->begin : rangeLo;
		freeHi = (rangeHi > blockFree->end) ? blockFree->end : rangeHi;
		;
		if (direction == 0x01)
		{
			allocLo = ((freeHi - *size + 1) & ~memClassInfo->baseAlign);
			allocAl = allocLo;
			allocHi = allocAl + *size - 1;
			if ((allocLo > freeHi) || (allocLo < freeLo))
			{
				allocLo = freeLo;
				allocAl =
					((freeLo +
						memClassInfo->baseAlign) & ~memClassInfo->
					baseAlign);
				if ((allocAl + memClassInfo->limitAlign + 1) > freeHi)
				{
					blockFree = blockFree->prevFree;
					continue;
				}
				allocHi = allocAl + *size - 1;
				if ((allocHi < allocLo) || (allocHi > freeHi))
				{
					allocHi =
						allocAl + ((freeHi - allocAl +
							1) & ~memClassInfo->limitAlign) - 1;
				}
				wrapped = 1;
			}
		}
		else
		{
			allocLo = freeLo;
			allocAl = ((freeLo + memClassInfo->baseAlign) & ~memClassInfo->baseAlign);
			allocHi = allocAl + *size - 1;
			if ((allocHi < allocLo) || (allocHi > freeHi))
			{
				if ((allocAl + memClassInfo->limitAlign + 1) > freeHi)
				{
					blockFree = blockFree->nextFree;
					continue;
				}
				allocHi =
					allocAl + ((freeHi - allocAl +
						1) & ~memClassInfo->limitAlign) - 1;
				wrapped = 1;
			}
		}
		if (wrapped)
		{
			if ((((sizeBest < *size) && ((allocHi - allocAl + 1) > sizeBest))
					|| ((sizeBest > *size)
						&& ((allocHi - allocAl + 1) < sizeBest))))
			{
				blockBest = blockFree;
				sizeBest = allocHi - allocAl + 1;
			}
			wrapped = 0;
		}
		else if ((allocLo == freeLo) && (allocHi == freeHi))
		{
			sizeBest = allocHi - allocLo + 1;
			;
			blockBest = blockFree;
			break;
		}
		else if ((allocLo >= freeLo) && (allocHi <= freeHi))
		{
			if ((((sizeBest < *size) && ((allocHi - allocAl + 1) > sizeBest))
					|| ((sizeBest > *size)
						&& ((allocHi - allocAl + 1) < sizeBest))))
			{
				sizeBest = allocHi - allocAl + 1;
				blockBest = blockFree;
			}
		}
		else
		{
			;
		}
		blockFree = (direction == 0x01) ? blockFree->prevFree : blockFree->nextFree;
	}
	if (blockBest && (memClassInfo->flags & 0x0001) && (sizeBest != *size))
		blockBest = (void *) 0;
	if (blockBest == (void *) 0)
	{
		nvArchLockRelease (device->fbmemLockId);
		;
		*size = 0;
		return 2;
	}
	status = blockAlloc (memPool, blockBest, owner, allocLo, allocHi);
	nvArchLockRelease (device->fbmemLockId);
	if (status == 0)
	{
		*offset = allocLo;
		*size = sizeBest;
	}
	else
	{
		*size = 0;
	}
	return status;
}
static NvV32
blockFree (MemPool *memPool, MemBlock *block)
{
	MemBlock           *blockTmp;

	;
	if (block->owner == 0xffffffff)
	{
		;
		return -2;
	}
	memPool->free += (block->end - block->begin + 1);
	if (block->prev && block->prev->owner == 0xffffffff)
	{
		;
		block->prev->next = block->next;
		block->prev->end = block->end;
		if (block->next)
			block->next->prev = block->prev;
		if (memPool->blockListTail == block)
			memPool->blockListTail = block->prev;
		blockTmp = block;
		block = block->prev;
		nvArchMemoryFree (blockTmp->memoryId);
	}
	if (block->next && block->next->owner == 0xffffffff)
	{
		;
		block->next->prev = block->prev;
		block->next->begin = block->begin;
		if (block->prev)
			block->prev->next = block->next;
		if (memPool->blockListHead == block)
			memPool->blockListHead = block->next;
		if (block->owner == 0xffffffff)
		{
			if (memPool->freeBlockListHead == block)
				memPool->freeBlockListHead = block->nextFree;
			block->nextFree->prevFree = block->prevFree;
			if (block->prevFree)
				block->prevFree->nextFree = block->nextFree;
		}
		blockTmp = block;
		block = block->next;
		nvArchMemoryFree (blockTmp->memoryId);
	}
	if (block->owner != 0xffffffff)
	{
		;
		if (!(blockTmp = memPool->freeBlockListHead))
		{
			;
			memPool->freeBlockListHead = block;
			memPool->freeBlockListTail = block;
			block->nextFree = (void *) 0;
			block->prevFree = (void *) 0;
		}
		else
		{
			while (blockTmp && blockTmp->begin < block->begin)
				blockTmp = blockTmp->nextFree;
			if (blockTmp)
			{
				block->nextFree = blockTmp;
				block->prevFree = blockTmp->prevFree;
				blockTmp->prevFree = block;
				if (block->prevFree)
				{
					block->prevFree->nextFree = block;
				}
				else
				{
					;
					memPool->freeBlockListHead = block;
				}
			}
			else
			{
				blockTmp = memPool->freeBlockListTail;
				block->nextFree = (void *) 0;
				block->prevFree = blockTmp;
				block->prevFree->nextFree = block;
				memPool->freeBlockListTail = block;
			}
		}
	}
	block->owner = 0xffffffff;
	;
	return 0;
}

NvV32
fbMemFree (NvDeviceInfo *device, NvU32 offset)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	MemPool            *memPool = hwdev->info.Framebuffer.FbMemPool;
	MemBlock           *block;
	NvV32               status;

	;
	if (!memPool)
	{
		;
		return -2;
	}
	nvArchLockAcquire (device->fbmemLockId);
	if (offset > memPool->total / 2)
	{
		for (block = memPool->blockListTail; block; block = block->prev)
		{
			if (block->begin == offset)
			{
				status = blockFree (memPool, block);
				nvArchLockRelease (device->fbmemLockId);
				return status;
			}
			if (block->begin < offset)
				break;
		}
	}
	else
	{
		for (block = memPool->blockListHead; block; block = block->next)
		{
			if (block->begin == offset)
			{
				status = blockFree (memPool, block);
				nvArchLockRelease (device->fbmemLockId);
				return status;
			}
			if (block->begin > offset)
				break;
		}
	}
	;
	nvArchLockRelease (device->fbmemLockId);
	return -2;
}
