 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


NvV32
fbInit (NvDeviceInfo *device)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);

	;
	hwdev->info.Framebuffer.RamType = 1;
	;
	hwdev->info.Framebuffer.RamType = 1;
	switch ((((((hwreg)->Reg32[(NV_PFB_BOOT_0) / 4])) >> ((0 ? 1 : 0) %
					32)) & (0xFFFFFFFF >> (31 - ((1 ? 1 : 0) % 32) +
					((0 ? 1 : 0) % 32)))))
	{
		case 0x00000003:
			hwdev->info.Framebuffer.RamSizeMb = 16;
			hwdev->info.Framebuffer.RamSize = 0x01000000;
			break;
		case 0x00000002:
			hwdev->info.Framebuffer.RamSizeMb = 8;
			hwdev->info.Framebuffer.RamSize = 0x00800000;
			break;
		case 0x00000001:
			hwdev->info.Framebuffer.RamSizeMb = 4;
			hwdev->info.Framebuffer.RamSize = 0x00400000;
			break;
		case NV_PMC_BOOT_0:
			hwdev->info.Framebuffer.RamSizeMb = 32;
			hwdev->info.Framebuffer.RamSize = 0x02000000;
			break;
		default:;
			;
	}
	if ((hwdev->info.Framebuffer.RamSizeMb == 16) || (hwdev->info.Framebuffer.RamSizeMb == 8))
		hwdev->info.Framebuffer.BankCount = 4;
	else
		hwdev->info.Framebuffer.BankCount = 2;
	;
	if ((((((hwreg)->Reg32[(NV_PFB_BOOT_0) / 4])) >> ((0 ? 2 : 2) % 32)) & (0xFFFFFFFF >> (31 -
					((1 ? 2 : 2) % 32) + ((0 ? 2 : 2) % 32)))) == 0x00000001)
		hwdev->info.Framebuffer.BusWidth = 128;
	else
		hwdev->info.Framebuffer.BusWidth = 64;
	hwdev->info.Framebuffer.RawBandwidth =
		((hwdev->info.Dac.MClk >> 5) * (hwdev->info.Framebuffer.BusWidth ==
			64 ? 8 : 16) * 31);
	hwdev->info.Framebuffer.Pipeline = 250;
	hwdev->info.Framebuffer.LimitOverlayDsDx = 1;
	hwdev->info.Framebuffer.LimitOverlayDtDy = 1;
	hwdev->info.Framebuffer.ImageBurst = 16;
	hwdev->info.Framebuffer.CursorBurst = 4;
	hwdev->info.Framebuffer.OverlayBurst = 8;
	;
	;
	fbCalcScreenMemSize (device);
	return 0;
}
