 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


void
fbService (NvDeviceInfo *device)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);

	devVblank (device);
	{
		static volatile int check = 0;
		static volatile int gfx = 0;

		if (check & 1)
		{
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
		}
		if (check & 2)
		{
			;
			;
			;
			;
			;
			;
			;
			;
		}
		if (check & 4)
		{
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
			;
		}
		switch (gfx)
		{
			case 1:
				(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] = (NvV32) (1);
				break;
			case 2:
				(hwreg)->Reg32[(NV_PGRAPH_FIFO) / 4] = (NvV32) (0);
				break;
		}
	}
}
NvV32
fbAllocInstMemAlign (NvDeviceInfo *device, NvV32 *inst, NvV32 *size, NvV32 align, int wantBest)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	NvV32               i,
	                    j;
	NvV32               mask;
	NvV32               bestSize = 0,
		bestOffset = 0;

	;
	if (*size == 0)
	{
		;
		;
	}
	*inst = 0;
	i = hwdev->info.Pram.FreeInstBase;
	mask = align - 1;
	while (mask & i)
	{
		i += 0x1;
	}
	i -= hwdev->info.Pram.FreeInstBase;
	for (; i < hwdev->info.Pram.FreeInstMax; i += align)
	{
		NvV32               k = i;

		if (hwdev->info.Pram.FbInstBitMap[k >> 3] & (1 << (k & 7)))
		{
			j = 0;
			do
			{
				if ((++k >= hwdev->info.Pram.FreeInstMax) || (++j >= *size))
					break;
			}
			while (hwdev->info.Pram.FbInstBitMap[k >> 3] & (1 << (k & 7)));
			if (j == *size)
			{
				bestSize = j;
				bestOffset = k - j;
				break;
			}
			if (wantBest)
			{
				if ((j & ~mask) > bestSize)
				{
					bestOffset = k - j - 1;
					bestSize = (j & ~mask);
				}
			}
		}
	}
	if (bestSize)
	{
		*inst = bestOffset + hwdev->info.Pram.FreeInstBase;
		*size = bestSize;
		while (bestSize--)
		{
			hwdev->info.Pram.FbInstBitMap[bestOffset >> 3] &= ~(1 << (bestOffset & 7));
			bestOffset++;
		}
		;
		return 0;
	}
	;
	return 2;
}

NvV32
fbAllocInstMem (NvDeviceInfo *device, NvV32 *inst, NvV32 *size, int wantBest)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	NvV32               i,
	                    j;
	NvV32               bestSize = 0,
		bestOffset = 0;

	;
	if (size == 0)
	{
		;
		;
	}
	*inst = 0;
	for (i = 0; i < hwdev->info.Pram.FreeInstMax; i++)
	{
		if (!hwdev->info.Pram.FbInstBitMap[i >> 3])
		{
			i += 7;
		}
		else if (hwdev->info.Pram.FbInstBitMap[i >> 3] & (1 << (i & 7)))
		{
			j = 0;
			do
			{
				if ((++i >= hwdev->info.Pram.FreeInstMax) || (++j >= *size))
					break;
			}
			while (hwdev->info.Pram.FbInstBitMap[i >> 3] & (1 << (i & 7)));
			if (j == *size)
			{
				bestOffset = i - j;
				bestSize = j;
				break;
			}
			if (wantBest)
			{
				if (j > bestSize)
				{
					bestOffset = i - j - 1;
					bestSize = j;
				}
			}
		}
	}
	if (bestSize)
	{
		*inst = bestOffset + hwdev->info.Pram.FreeInstBase;
		*size = bestSize;
		while (bestSize--)
		{
			hwdev->info.Pram.FbInstBitMap[bestOffset >> 3] &= ~(1 << (bestOffset & 7));
			bestOffset++;
		}
		;
		return 0;
	}
	;
	return 2;
}

NvV32
fbFreeInstMem (NvDeviceInfo *device, NvV32 inst, NvV32 size)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;

	if (!inst)
		return 0;
	;
	inst -= hwdev->info.Pram.FreeInstBase;
	while (size--)
	{
		hwdev->info.Pram.FbInstBitMap[inst >> 3] |= (1 << (inst & 7));
		inst++;
	}
	return 0;
}
