 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


NvV32               devDmaAllocate (NvDeviceInfo *, NvContextDmaObj *);
void                devDmaFree (NvDeviceInfo *, NvContextDmaObj *);
NvV32               nvFunc365 (NvDeviceInfo *, NvContextDmaObj *, void *);
NvV32               dmaAllocInstance (NvDeviceInfo *, NvContextDmaObj *);
NvV32               dmaFreeInstance (NvDeviceInfo *, NvContextDmaObj *);
NvV32
devDmaAllocate (NvDeviceInfo *deviceInfo, NvContextDmaObj *ctxDmaObj)
{
	NvU32               pte;
	NvV32               status;

	;
	;
	switch ((ctxDmaObj->memoryObj->base.classInfo->num))
	{
		case (0x00000040):
		case (0x0000003D):
		case (0x0000003F):
			pte = ((NvU32) (&ctxDmaObj->memoryObj->physAddr)->low +
				(NvU32) (unsigned long) (&ctxDmaObj->offset)->low) & ~(0xfff);
			pte -= (NvU32) ((&deviceInfo->fbPhysAddr)->low);
			break;
		case (0x0000003E):;
			if (ctxDmaObj->info)
				pte = (NvU32) (&ctxDmaObj->info[0].base)->low;
			break;
		default:
			pte = 0;
	}
	(&ctxDmaObj->pteBase)->low = (unsigned long) (pte);
	;
	status = dmaAllocInstance (deviceInfo, ctxDmaObj);
	if (status != (NV_PMC_BOOT_0))
	{
		return status;
	}
	return (NV_PMC_BOOT_0);
}

void
devDmaFree (NvDeviceInfo *deviceInfo, NvContextDmaObj *ctxDmaObj)
{
	;
	if (ctxDmaObj->pteCount)
	{
		dmaFreeInstance (deviceInfo, ctxDmaObj);
	}
}
NvV32
dmaAllocInstance (NvDeviceInfo *deviceInfo, NvContextDmaObj *ctxDmaObj)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) deviceInfo;
	HwReg              *hwram = ((hwdev)->base.imAddr);
	NvU32               pte;
	NvV32               status;
	NvV32               adjust,
	                    numParas;
	NvV32               access;
	NvV32               i;

	if ((ctxDmaObj->pteCount + 1) < 3)
	{
		numParas = 1;
	}
	else
	{
		numParas = 2 + (ctxDmaObj->pteCount - 1) / 4;
	}
	status = fbAllocInstMem (deviceInfo, &ctxDmaObj->instOffset, &numParas, 0);
	if (status)
	{
		;
		return (0x00000002);
	}
	;
	adjust = (((ctxDmaObj->pteAdjust) & (0xFFFFFFFF >> (31 - (1 ? (0 * 32 + 11) : (0 * 32 +
							0)) + (0 ? (0 * 32 + 11) : (0 * 32 +
							0))))) << ((0 ? (0 * 32 + 11) : (0 * 32 +
					0)) & 31));
	adjust |= ((0x00000001) << ((0 ? (0 * 32 + 16) : (0 * 32 + 16)) & 31));
	switch ((ctxDmaObj->memoryObj->base.classInfo->num))
	{
		case (0x0000003E):
			adjust |= ((0x00000002) << ((0 ? (0 * 32 + 25) : (0 * 32 + 24)) & 31));
			break;
		case (0x00000040):
		case (0x0000003D):
		case (0x0000003F):
			adjust |= ((NV_PMC_BOOT_0) << ((0 ? (0 * 32 + 25) : (0 * 32 + 24)) & 31));
			break;
	}
	if (((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
							((1 ? 7 : 4) % 32) +
							((0 ? 7 : 4) % 32)))) == (0x00000001))))
		access = ((NV_PMC_BOOT_0) << ((0 ? (2 * 32 + 1) : (2 * 32 + 1)) & 31));
	else
		access = ((0x00000001) << ((0 ? (2 * 32 + 1) : (2 * 32 + 1)) & 31));
	if (ctxDmaObj->info != (void *) 0)
	{
		for (i = 0; i < ctxDmaObj->pteCount; i++)
		{
			pte = (NvU32) (&ctxDmaObj->info[i].base)->low;
			(hwram)->Reg32[((0 ? 0x01FFFFFF : 0x01C00000) +
					((ctxDmaObj->instOffset) << 4) + (8 + i * 4) -
					(0 ? 0x01FFFFFF : 0x01C00000)) / 4] =
				(NvV32) (((pte | ((0x00000001) << ((0 ? (2 * 32 + 0) : (2 * 32 +
										0)) & 31)) |
						access)));
		}
	}
	else
	{
		pte = (NvU32) (&ctxDmaObj->pteBase)->low;
		for (i = 0; i < ctxDmaObj->pteCount; i++)
		{
			pte += ((1 << (32 - ((1 ? (2 * 32 + 31) : (2 * 32 + 12)) - (0 ? (2 * 32 +
									31) : (2 * 32 + 12)) +
							1))) * i);
			(hwram)->Reg32[((0 ? 0x01FFFFFF : 0x01C00000) +
					((ctxDmaObj->instOffset) << 4) + (8 + i * 4) -
					(0 ? 0x01FFFFFF : 0x01C00000)) / 4] =
				(NvV32) (((pte | ((0x00000001) << ((0 ? (2 * 32 + 0) : (2 * 32 +
										0)) & 31)) |
						access)));
		}
	}
	(hwram)->Reg32[((0 ? 0x01FFFFFF : 0x01C00000) + ((ctxDmaObj->instOffset) << 4) + (8 +
				i * 4) - (0 ? 0x01FFFFFF : 0x01C00000)) / 4] =
		(NvV32) ((0xffffffff));
	(hwram)->Reg32[((0 ? 0x01FFFFFF : 0x01C00000) + ((ctxDmaObj->instOffset) << 4) +
			((((0 ? (0 * 32 + 11) : (0 * 32 + 0)) / 32) << 2)) -
			(0 ? 0x01FFFFFF : 0x01C00000)) / 4] = (NvV32) ((adjust));
	(hwram)->Reg32[((0 ? 0x01FFFFFF : 0x01C00000) + ((ctxDmaObj->instOffset) << 4) +
			((((0 ? (1 * 32 + 31) : (1 * 32 + 0)) / 32) << 2)) -
			(0 ? 0x01FFFFFF : 0x01C00000)) / 4] = (NvV32) ((ctxDmaObj->pteLimit));
	return (NV_PMC_BOOT_0);
}

NvV32
dmaFreeInstance (NvDeviceInfo *deviceInfo, NvContextDmaObj *ctxDmaObj)
{
	NvV32               numParas;

	if (ctxDmaObj == (void *) 0)
	{
		;
		return (NV_PMC_BOOT_0);
	}
	if ((ctxDmaObj->pteCount + 1) < 3)
		numParas = 1;
	else
		numParas = 2 + (ctxDmaObj->pteCount - 1) / 4;
	fbFreeInstMem (deviceInfo, ctxDmaObj->instOffset, numParas);
	ctxDmaObj->instOffset = 0;
	return (NV_PMC_BOOT_0);
}
