 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


static NvV32        devSupported (NvP64 *);
static NvV32        devInit (NvDeviceInfo **, NvP64 *, NvP64 *);
static NvV32        devCleanup (NvDeviceInfo *);
static NvV32        devIntrsAlloc (NvDeviceInfo *);
static NvV32        devIntrsFree (NvDeviceInfo *);
static NvV32        devHwInit (NvDeviceInfo *);
extern ClassInfo   *devDeviceClassInfo (void);
static NvDeviceFuncTable nvDeviceFuncTable = {
	devSupported, devInit, devCleanup, devIntrsAlloc, devIntrsFree, devIntrsPending,
		devServiceIntrs, devChangeState, 0xdeadbeef
};
NvArchInfo         *archInfo = &nvArchInfo;
static unsigned long chipIds[] = {
	0x20034001, 0x20044001, 0x20134000, 0x20114000, 0
};
NvDeviceType        nvDeviceType = {
	10001, "nv04", &archInfo, &nvArchDevFuncTable, &nvDeviceFuncTable, chipIds,
};
static NvV32
devSupported (NvP64 *nvPhys)
{
	NvV32               id,
	                    status;
	NvP64               base;
	NvU64               limit;
	NvV32              *chipId;

	;
	base = *nvPhys;
	(&limit)->high = 0, (&limit)->low = (NvU32) (3);
	status = nvArchMappingAllocPhysToKern (&base, limit, (NV_PMC_BOOT_0), &id);
	if (status != (NV_PMC_BOOT_0))
	{
		;
		return 1;
	}
	;
	for (chipId = chipIds; *chipId; chipId++)
	{
		if (*chipId == *((NvV32 *) (&base)->low))
			break;
	}
	nvArchMappingFree (id);
	if (*chipId == 0)
	{
		;
		return 2;
	}
	;
	return 0;
}
static NvV32
devInit (NvDeviceInfo **deviceInfop, NvP64 *nvPhys, NvP64 *fbPhys)
{
	NvV32               id,
	                    status;
	NvDeviceInfo       *deviceInfo;
	NvP64               base;
	NvU64               limit;

	;
	(&limit)->high = 0, (&limit)->low = (NvU32) (sizeof (HwDeviceInfo) - 1);
	status = nvArchMemoryAllocKernel (&base, limit, &id);
	if (status != (NV_PMC_BOOT_0))
	{
		;
		return 2;
	}
	deviceInfo = (NvDeviceInfo *) (&base)->low;
	zeroMemory ((NvU32 *) deviceInfo, (NvV32) (sizeof (HwDeviceInfo) / 4));
	deviceInfo->memoryId = id;
	;
	deviceInfo->nvPhysAddr = *nvPhys;
	deviceInfo->fbPhysAddr = *fbPhys;
	deviceInfo->nvSize = 0x740000;
	deviceInfo->imSize = 0x40000;
	deviceInfo->vhandlers = (void *) 0;
	(&deviceInfo->imPhysAddr)->low =
		(unsigned long) ((nvPhys)->low + (0 ? 0x007FFFFF : 0x00700000));
	base = deviceInfo->nvPhysAddr;
	(&limit)->high = 0, (&limit)->low = (NvU32) (deviceInfo->nvSize - 1);
	status = nvArchMappingAllocPhysToKern (&base, limit, (NV_PMC_BOOT_0), &id);
	if (status != (NV_PMC_BOOT_0))
	{
		;
		nvArchMemoryFree (deviceInfo->memoryId);
		return 1;
	}
	deviceInfo->nvAddr = (void *) (&base)->low;
	deviceInfo->nvAddrId = id;
	deviceInfo->imAddr =
		(void *) ((unsigned long) deviceInfo->nvAddr + (0 ? 0x007FFFFF : 0x00700000));
	deviceInfo->imAddrId = 0;
	;
	;
	status = devHwInit (deviceInfo);
	if (status != 0)
	{
		;
		nvArchMappingFree (deviceInfo->imAddrId);
		nvArchMappingFree (deviceInfo->nvAddrId);
		nvArchMemoryFree (deviceInfo->memoryId);
		return 1;
	}
	*deviceInfop = deviceInfo;
	return 0;
}
static NvV32
devCleanup (NvDeviceInfo *deviceInfo)
{
	;
	nvArchMappingFree (deviceInfo->nvAddrId);
	;
	nvArchMemoryFree (deviceInfo->memoryId);
	return 0;
}
static NvV32
devIntrsAlloc (NvDeviceInfo *deviceInfo)
{
	NvDeviceInterrupt  *intrs;
	NvP64               base;
	NvV32               numIntrs = 1;
	NvV32               memoryId;
	NvV32               status;
	NvU64               limit;
	int                 i;

	;
	(&limit)->high = 0, (&limit)->low = (NvU32) (numIntrs * sizeof (NvDeviceInterrupt) - 1);
	status = nvArchMemoryAllocKernel (&base, limit, &memoryId);
	if (status != (NV_PMC_BOOT_0))
	{
		;
		return 2;
	}
	intrs = (NvDeviceInterrupt *) (&base)->low;
	intrs[0].number = 0;
	intrs[0].latency = 0xffffffff;
	for (i = 0; i < (long) numIntrs; i++)
	{
		status = nvArchInterruptAlloc (deviceInfo, 0x0);
		if (status != (NV_PMC_BOOT_0))
		{
			;
			while (i--)
				nvArchInterruptFree (deviceInfo, intrs[i].interruptId);
			nvArchMemoryFree (memoryId);
			return 2;
		}
		intrs[i].interruptId = 0x0;
	}
	deviceInfo->interrupts = intrs;
	deviceInfo->interruptCount = numIntrs;
	deviceInfo->interruptsMemoryId = memoryId;
	return 0;
}
static NvV32
devIntrsFree (NvDeviceInfo *deviceInfo)
{
	NvDeviceInterrupt  *intrs;
	int                 i;

	;
	;
	intrs = deviceInfo->interrupts;
	for (i = 0; i < (long) deviceInfo->interruptCount; i++)
	{
		;
		(void) nvArchInterruptFree (deviceInfo, intrs[i].interruptId);
	}
	(void) nvArchMemoryFree (deviceInfo->interruptsMemoryId);
	return 0;
}
static void         nv04FbCalcSgramSize (NvDeviceInfo *, NvU8 *);
static void         nv05FbCalcRamSize (NvDeviceInfo *, NvU8 *);
static NvV32        devNv04HwInit (NvDeviceInfo *);
static NvV32        devNv05HwInit (NvDeviceInfo *);
static NvV32
devHwInit (NvDeviceInfo *deviceInfo)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) deviceInfo;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               value;
	NvV32               status;

	;
	;
	(hwreg)->Reg32[(0x00001854) / 4] =
		(NvV32) ((((hwreg)->Reg32[(0x00001854) / 4]) & ~((0xFFFFFFFF >> (31 -
						((1 ? 0 : 0) % 32) +
						((0 ? 0 : 0) % 32))) << ((0 ? 0 : 0) %
					32))) | ((0x00000001) << ((0 ? 0 : 0) % 32)));
	value = ((hwreg)->Reg32[(0x0000184C) / 4]);
	(hwreg)->Reg32[(0x0000184C) / 4] = (NvV32) (0x0);
	(hwreg)->Reg32[(NV_PMC_ENABLE) / 4] =
		(NvV32) (((0x00000001) << ((0 ? 24 : 24) % 32)) | ((0x00000001) << ((0 ? 16 : 16) %
				32)) | ((0x00000001) << ((0 ? 8 : 8) % 32)));
	(hwreg)->Reg32[(NV_PMC_ENABLE) / 4] =
		(NvV32) (((0x00000001) << ((0 ? 20 : 20) % 32)) | ((0x00000001) << ((0 ? 24 : 24) %
				32)) | ((0x00000001) << ((0 ? 16 : 16) %
				32)) | ((0x00000001) << ((0 ? 8 : 8) % 32)));
	(hwreg)->Reg32[(0x0000184C) / 4] = (NvV32) (value);
	(hwreg)->Reg32[(0x00001850) / 4] =
		(NvV32) ((((hwreg)->Reg32[(0x00001850) / 4]) & ~((0xFFFFFFFF >> (31 -
						((1 ? 0 : 0) % 32) +
						((0 ? 0 : 0) % 32))) << ((0 ? 0 : 0) %
					32))) | ((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	if ((((((((hwreg)->Reg32[(NV_PMC_BOOT_0) / 4])) >> ((0 ? 15 : 12) %
							32)) & (0xFFFFFFFF >> (31 -
							((1 ? 15 : 12) % 32) +
							((0 ? 15 : 12) % 32)))) > 0x00000004)
			|| ((((((hwreg)->Reg32[(NV_PMC_BOOT_0) / 4])) >> ((0 ? 15 : 12) %
							32)) & (0xFFFFFFFF >> (31 -
							((1 ? 15 : 12) % 32) +
							((0 ? 15 : 12) % 32)))) == 0x00000004
				&& (((((hwreg)->Reg32[(NV_PMC_BOOT_0) / 4])) >> ((0 ? 23 : 20) %
							32)) & (0xFFFFFFFF >> (31 -
							((1 ? 23 : 20) % 32) +
							((0 ? 23 : 20) % 32)))) >= 0x00000001)))
		status = devNv05HwInit (deviceInfo);
	else
		status = devNv04HwInit (deviceInfo);
	(hwreg)->Reg32[(0x00001850) / 4] =
		(NvV32) ((((hwreg)->Reg32[(0x00001850) / 4]) & ~((0xFFFFFFFF >> (31 -
						((1 ? 0 : 0) % 32) +
						((0 ? 0 : 0) % 32))) << ((0 ? 0 : 0) %
					32))) | ((0x00000001) << ((0 ? 0 : 0) % 32)));
	return status;
}
static NvV32
devNv04HwInit (NvDeviceInfo *deviceInfo)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) deviceInfo;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU16               clock;
	NvV32               value,
	                    mappingId,
	                    status;
	NvU8               *fbAddr;
	NvP64               base;
	NvU64               limit;

	;
	(hwreg)->Reg32[(NV_PEXTDEV_BOOT_0) / 4] =
		(NvV32) ((((hwreg)->Reg32[(NV_PEXTDEV_BOOT_0) / 4]) & ~((0xFFFFFFFF >> (31 -
						((1 ? 10 : 10) % 32) +
						((0 ? 10 : 10) % 32))) << ((0 ? 10 : 10) %
					32))) | ((0x00000001) << ((0 ? 10 : 10) % 32)));
	(hwreg)->Reg32[(0x00001080) / 4] = (NvV32) (0x020f0000);
	clock = 9000;
	value = dacCalcMNP (deviceInfo, &clock);
	;
	(hwreg)->Reg32[(NV_PRAMDAC_NVPLL_COEFF) / 4] = (NvV32) (value);
	clock = 11000;
	value = dacCalcMNP (deviceInfo, &clock);
	;
	(hwreg)->Reg32[(NV_PRAMDAC_MPLL_COEFF) / 4] = (NvV32) (value);
	(hwreg)->Reg32[(NV_PFB_CONFIG_0) / 4] =
		(NvV32) (((0x00000014) << ((0 ? 5 : 0) % 32)) | ((0x00000001) << ((0 ? 9 : 8) %
				32)) | ((0x00000001) << ((0 ? 12 : 12) %
				32)) | ((NV_PMC_BOOT_0) << ((0 ? 23 : 13) % 32)));
	clock = 3600;
	value = dacCalcMNP (deviceInfo, &clock);
	;
	(hwreg)->Reg32[(NV_PRAMDAC_VPLL_COEFF) / 4] = (NvV32) (value);
	(hwreg)->Reg32[(0x00100080) / 4] = (NvV32) (0x20001d00);
	(hwreg)->Reg32[(NV_PFB_CONFIG_1) / 4] =
		(NvV32) (((0x00000003) << ((0 ? 2 : 0) % 32)) | ((0x00000009) << ((0 ? 7 : 4) %
				32)) | ((0x00000002) << ((0 ? 10 : 8) %
				32)) | ((0x00000006) << ((0 ? 14 : 12) %
				32)) | ((0x00000001) << ((0 ? 18 : 16) %
				32)) | ((NV_PMC_BOOT_0) << ((0 ? 22 : 20) %
				32)) | ((0x00000001) << ((0 ? 26 : 24) %
				32)) | ((0x00000004) << ((0 ? 30 : 28) %
				32)) | ((0x00000001) << ((0 ? 31 : 31) % 32)));
	(hwreg)->Reg32[(NV_PFB_RTL) / 4] = (NvV32) (0x0);
	(hwreg)->Reg32[(0x00001084) / 4] =
		(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) %
				32)) | ((NV_PMC_BOOT_0) << ((0 ? 1 : 1) %
				32)) | ((0x00000001) << ((0 ? 4 : 3) %
				32)) | ((NV_PMC_BOOT_0) << ((0 ? 5 : 5) %
				32)) | ((0x00000001) << ((0 ? 6 : 6) %
				32)) | ((0x00000001) << ((0 ? 7 : 7) %
				32)) | ((0x00000001) << ((0 ? 8 : 8) %
				32)) | ((0x00000001) << ((0 ? 9 : 9) %
				32)) | ((0x00000001) << ((0 ? 10 : 10) %
				32)) | ((0x00000001) << ((0 ? 12 : 12) %
				32)) | ((0x00000001) << ((0 ? 14 : 14) %
				32)) | ((NV_PMC_BOOT_0) << ((0 ? 15 : 15) % 32)));
	base = deviceInfo->fbPhysAddr;
	(&limit)->high = 0, (&limit)->low = (NvU32) (0x1000000 - 1);
	status = nvArchMappingAllocPhysToKern (&base, limit, (NV_PMC_BOOT_0), &mappingId);
	if (status != (NV_PMC_BOOT_0))
	{
		;
		return 2;
	}
	fbAddr = (NvU8 *) (&base)->low;
	;
	nv04FbCalcSgramSize (deviceInfo, fbAddr);
	;
	nvArchMappingFree (mappingId);
	value = ((hwreg)->Reg32[(NV_PFB_BOOT_0) / 4]);
	if (((value & ((0x00000003) << ((0 ? 5 : 3) % 32))) == ((0x00000003) << ((0 ? 5 : 3) % 32)))
		|| ((value & ((0x00000002) << ((0 ? 5 : 3) % 32))) ==
			((0x00000002) << ((0 ? 5 : 3) % 32))))
		(hwreg)->Reg32[(NV_PFB_CONFIG_1) / 4] = (NvV32) (0x31012132);
	(hwreg)->Reg32[(NV_PRAMDAC_PLL_COEFF_SELECT) / 4] = (NvV32) (0x500);
	(hwreg)->Reg32[(0x00001088) / 4] = (NvV32) (0x11f0);
	(hwreg)->Reg32[(0x0000108C) / 4] = (NvV32) (((0x00000001) << ((0 ? 1 : 0) % 32)));
	return 0;
}
static NvV32
devNv05HwInit (NvDeviceInfo *deviceInfo)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) deviceInfo;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU16               clock;
	NvV32               value,
	                    mappingId,
	                    status;
	NvU8               *fbAddr;
	NvP64               base;
	NvU64               limit;

	;
	value = ((hwreg)->Reg32[(NV_PEXTDEV_BOOT_0) / 4]);
	;
	value |= (((0x00000001) << ((0 ? 31 : 31) % 32)) | 0x800);
	;
	(hwreg)->Reg32[(NV_PEXTDEV_BOOT_0) / 4] = (NvV32) (value);
	(hwreg)->Reg32[(0x000010E0) / 4] = (NvV32) (NV_PMC_BOOT_0);
	(hwreg)->Reg32[(0x00001080) / 4] = (NvV32) (0x01020101);
	(hwreg)->Reg32[(0x000010B0) / 4] = (NvV32) (0x0800bba7);
	(hwreg)->Reg32[(0x000010B4) / 4] = (NvV32) (0xefe00000);
	(hwreg)->Reg32[(0x000010B8) / 4] = (NvV32) (0x88c98200);
	(hwreg)->Reg32[(0x000010BC) / 4] = (NvV32) (0xff988aa9);
	clock = 12500;
	value = dacCalcMNP (deviceInfo, &clock);
	;
	(hwreg)->Reg32[(NV_PRAMDAC_NVPLL_COEFF) / 4] = (NvV32) (value);
	clock = 15000;
	value = dacCalcMNP (deviceInfo, &clock);
	;
	(hwreg)->Reg32[(NV_PRAMDAC_MPLL_COEFF) / 4] = (NvV32) (value);
	(hwreg)->Reg32[(NV_PFB_CONFIG_0) / 4] =
		(NvV32) (((0x00000014) << ((0 ? 5 : 0) % 32)) | ((0x00000001) << ((0 ? 9 : 8) %
				32)) | ((0x00000001) << ((0 ? 12 : 12) %
				32)) | ((NV_PMC_BOOT_0) << ((0 ? 23 : 13) % 32)));
	clock = 3600;
	value = dacCalcMNP (deviceInfo, &clock);
	;
	(hwreg)->Reg32[(NV_PRAMDAC_VPLL_COEFF) / 4] = (NvV32) (value);
	(hwreg)->Reg32[(0x00100080) / 4] = (NvV32) (0x20002500);
	(hwreg)->Reg32[(NV_PFB_CONFIG_1) / 4] =
		(NvV32) (((0x00000003) << ((0 ? 2 : 0) % 32)) | ((0x00000009) << ((0 ? 7 : 4) %
				32)) | ((0x00000002) << ((0 ? 10 : 8) %
				32)) | ((0x00000006) << ((0 ? 14 : 12) %
				32)) | ((0x00000001) << ((0 ? 18 : 16) %
				32)) | ((NV_PMC_BOOT_0) << ((0 ? 22 : 20) %
				32)) | ((0x00000001) << ((0 ? 26 : 24) %
				32)) | ((0x00000004) << ((0 ? 30 : 28) % 32)));
	(hwreg)->Reg32[(NV_PFB_RTL) / 4] = (NvV32) (0x0);
	(hwreg)->Reg32[(0x00001084) / 4] =
		(NvV32) (((NV_PMC_BOOT_0) << ((0 ? 0 : 0) %
				32)) | ((NV_PMC_BOOT_0) << ((0 ? 1 : 1) %
				32)) | ((0x00000001) << ((0 ? 4 : 3) %
				32)) | ((NV_PMC_BOOT_0) << ((0 ? 5 : 5) %
				32)) | ((0x00000001) << ((0 ? 6 : 6) %
				32)) | ((0x00000001) << ((0 ? 8 : 8) %
				32)) | ((0x00000001) << ((0 ? 9 : 9) %
				32)) | ((0x00000001) << ((0 ? 10 : 10) %
				32)) | ((0x00000001) << ((0 ? 12 : 12) %
				32)) | ((0x00000001) << ((0 ? 14 : 14) %
				32)) | ((NV_PMC_BOOT_0) << ((0 ? 15 : 15) % 32)));
	base = deviceInfo->fbPhysAddr;
	(&limit)->high = 0, (&limit)->low = (NvU32) (0x2000000 - 1);
	status = nvArchMappingAllocPhysToKern (&base, limit, (NV_PMC_BOOT_0), &mappingId);
	if (status != (NV_PMC_BOOT_0))
	{
		;
		return 2;
	}
	fbAddr = (NvU8 *) (&base)->low;
	;
	nv05FbCalcRamSize (deviceInfo, fbAddr);
	;
	nvArchMappingFree (mappingId);
	value = ((hwreg)->Reg32[(NV_PFB_BOOT_0) / 4]);
	(hwreg)->Reg32[(NV_PFB_BOOT_0) / 4] = (NvV32) (value);
	(hwreg)->Reg32[(NV_PFB_CONFIG_1) / 4] =
		(NvV32) (((0x00000003) << ((0 ? 2 : 0) % 32)) | ((0x00000009) << ((0 ? 7 : 4) %
				32)) | ((0x00000002) << ((0 ? 10 : 8) %
				32)) | ((0x00000006) << ((0 ? 14 : 12) %
				32)) | ((0x00000001) << ((0 ? 18 : 16) %
				32)) | ((NV_PMC_BOOT_0) << ((0 ? 22 : 20) %
				32)) | ((0x00000001) << ((0 ? 26 : 24) %
				32)) | ((0x00000004) << ((0 ? 30 : 28) % 32)));
	(hwreg)->Reg32[(NV_PRAMDAC_PLL_COEFF_SELECT) / 4] = (NvV32) (0x00000500);
	(hwreg)->Reg32[(0x00001088) / 4] = (NvV32) (0x000001f0);
	(hwreg)->Reg32[(0x0000108C) / 4] =
		(NvV32) (((0x00000001) << ((0 ? 1 : 0) % 32)) | ((0x0000000D) << ((0 ? 7 : 4) %
				32)));
	return 0;
}
static void
fbLatchMemConfig (NvDeviceInfo *device)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               latency;

	latency =
		(((((hwreg)->Reg32[(NV_PFB_CONFIG_1) / 4])) >> ((0 ? 2 : 0) %
				32)) & (0xFFFFFFFF >> (31 - ((1 ? 2 : 0) % 32) +
				((0 ? 2 : 0) % 32))));
	(hwreg)->Reg32[(NV_PFB_CONFIG_1) / 4] =
		(NvV32) ((((hwreg)->Reg32[(NV_PFB_CONFIG_1) / 4]) & ~((0xFFFFFFFF >> (31 -
						((1 ? 2 : 0) % 32) +
						((0 ? 2 : 0) % 32))) << ((0 ? 2 : 0) %
					32))) | ((0x00000003) << ((0 ? 2 : 0) % 32)));
	(hwreg)->Reg32[(NV_PFB_CONFIG_1) / 4] =
		(NvV32) ((((hwreg)->Reg32[(NV_PFB_CONFIG_1) / 4]) & ~((0xFFFFFFFF >> (31 -
						((1 ? 2 : 0) % 32) +
						((0 ? 2 : 0) % 32))) << ((0 ? 2 : 0) %
					32))) | ((0x00000002) << ((0 ? 2 : 0) % 32)));
	(hwreg)->Reg32[(NV_PFB_CONFIG_1) / 4] =
		(NvV32) ((((hwreg)->Reg32[(NV_PFB_CONFIG_1) / 4]) & ~((0xFFFFFFFF >> (31 -
						((1 ? 2 : 0) % 32) +
						((0 ? 2 : 0) % 32))) << ((0 ? 2 : 0) %
					32))) | ((0x00000003) << ((0 ? 2 : 0) % 32)));
	(hwreg)->Reg32[(NV_PFB_CONFIG_1) / 4] =
		(NvV32) ((((hwreg)->Reg32[(NV_PFB_CONFIG_1) / 4]) & ~((0xFFFFFFFF >> (31 -
						((1 ? 2 : 0) % 32) +
						((0 ? 2 : 0) % 32))) << ((0 ? 2 : 0) %
					32))) | (((latency) & (0xFFFFFFFF >> (31 -
						((1 ? 2 : 0) % 32) +
						((0 ? 2 : 0) % 32)))) << ((0 ? 2 : 0) % 32)));
}
static void
nv04FbCalcSgramSize (NvDeviceInfo *device, NvU8 *fbAddr)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	int                 i,
	                    memsize;

	(hwreg)->Reg32[(0x00100080) / 4] =
		(NvV32) ((((hwreg)->Reg32[(0x00100080) / 4]) & ~((0xFFFFFFFF >> (31 -
						((1 ? 4 : 4) % 32) +
						((0 ? 4 : 4) % 32))) << ((0 ? 4 : 4) %
					32))) | ((0x00000001) << ((0 ? 4 : 4) % 32)));
	(hwreg)->Reg32[(NV_PFB_BOOT_0) / 4] =
		(NvV32) (((0x00000003) << ((0 ? 1 : 0) % 32)) | ((0x00000001) << ((0 ? 2 : 2) %
				32)) | ((0x00000003) << ((0 ? 5 : 3) % 32)));
	fbLatchMemConfig (device);
	for (i = 0; i < 4; i++)
		(*((NvU32 *) &fbAddr[i * 4]) =
			(NvU32) (NvU32) (("NV4A")[0] | ("NV4A")[1] << 8 | ("NV4A")[2] << 16 |
				("NV4A")[3] << 24));
	memsize =
		(((NvU32) *((NvU32 *) &fbAddr[0x0])) ==
		(NvU32) (("NV4A")[0] | ("NV4A")[1] << 8 | ("NV4A")[2] << 16 | ("NV4A")[3] << 24)) ?
		16 : 8;
	if (((NvU16) *((NvU16 *) &fbAddr[0x0000000c])) == (NvU16) (("NV")[0] | ("NV")[1] << 8))
	{
		if (memsize == 16)
		{
			(*((NvU32 *) &fbAddr[0x00800000]) =
				(NvU32) (NvU32) (("A4VN")[0] | ("A4VN")[1] << 8 | ("A4VN")[2] << 16
					| ("A4VN")[3] << 24));
			if (((NvU32) *((NvU32 *) &fbAddr[0x00800000])) !=
				(NvU32) (("A4VN")[0] | ("A4VN")[1] << 8 | ("A4VN")[2] << 16 |
					("A4VN")[3] << 24))
			{
				(hwreg)->Reg32[(NV_PFB_BOOT_0) / 4] =
					(NvV32) ((((hwreg)->Reg32[(NV_PFB_BOOT_0) /
								4]) & ~((0xFFFFFFFF >> (31 -
									((1 ? 1 : 0) % 32) +
									((0 ? 1 : 0) %
										32))) << ((0 ? 1 :
									0) %
								32))) | ((0x00000002) << ((0 ? 1 :
								0) % 32)));
			}
		}
		else
		{
			(*((NvU32 *) &fbAddr[0x00800000]) =
				(NvU32) (NvU32) (("A4VN")[0] | ("A4VN")[1] << 8 | ("A4VN")[2] << 16
					| ("A4VN")[3] << 24));
			if (((NvU32) *((NvU32 *) &fbAddr[0x00800000])) !=
				(NvU32) (("A4VN")[0] | ("A4VN")[1] << 8 | ("A4VN")[2] << 16 |
					("A4VN")[3] << 24))
			{
				(hwreg)->Reg32[(NV_PFB_BOOT_0) / 4] =
					(NvV32) ((((hwreg)->Reg32[(NV_PFB_BOOT_0) /
								4]) & ~((0xFFFFFFFF >> (31 -
									((1 ? 1 : 0) % 32) +
									((0 ? 1 : 0) %
										32))) << ((0 ? 1 :
									0) %
								32))) | ((0x00000002) << ((0 ? 1 :
								0) % 32)));
			}
			else
			{
				(hwreg)->Reg32[(NV_PFB_BOOT_0) / 4] =
					(NvV32) ((((hwreg)->Reg32[(NV_PFB_BOOT_0) /
								4]) & ~((0xFFFFFFFF >> (31 -
									((1 ? 1 : 0) % 32) +
									((0 ? 1 : 0) %
										32))) << ((0 ? 1 :
									0) %
								32))) | ((0x00000001) << ((0 ? 1 :
								0) % 32)));
			}
		}
	}
	else
	{
		(hwreg)->Reg32[(NV_PFB_BOOT_0) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PFB_BOOT_0) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 1 : 0) % 32) +
							((0 ? 1 : 0) % 32))) << ((0 ? 1 : 0) %
						32))) | ((0x00000001) << ((0 ? 1 : 0) % 32)));
		(hwreg)->Reg32[(NV_PFB_BOOT_0) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PFB_BOOT_0) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 2 : 2) % 32) +
							((0 ? 2 : 2) % 32))) << ((0 ? 2 : 2) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 2 : 2) % 32)));
	}
	fbLatchMemConfig (device);
	(hwreg)->Reg32[(0x00100080) / 4] =
		(NvV32) ((((hwreg)->Reg32[(0x00100080) / 4]) & ~((0xFFFFFFFF >> (31 -
						((1 ? 4 : 4) % 32) +
						((0 ? 4 : 4) % 32))) << ((0 ? 4 : 4) %
					32))) | ((NV_PMC_BOOT_0) << ((0 ? 4 : 4) % 32)));
}
typedef struct _nv5MemInit
{
	NvU32               pfbBoot0;
	NvU32               pfbConfig1;
} nv5MemInit;
nv5MemInit          nv5MemInitTbl[] = {
	{0x24, 0x00}, {0x28, 0x00}, {0x24, 0x01}, {0x1f, 0x00}, {0x0f, 0x00}, {0x17, 0x00}, {0x06,
			0x00}, {0x00, 0x00},
};
static void
nv05FbCalcRamSize (NvDeviceInfo *device, NvU8 *fbAddr)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               i,
	                    value;

	(hwreg)->Reg32[(0x00100080) / 4] =
		(NvV32) ((((hwreg)->Reg32[(0x00100080) / 4]) & ~((0xFFFFFFFF >> (31 -
						((1 ? 4 : 4) % 32) +
						((0 ? 4 : 4) % 32))) << ((0 ? 4 : 4) %
					32))) | ((NV_PMC_BOOT_0) << ((0 ? 4 : 4) % 32)));
	i = (((((hwreg)->Reg32[(NV_PEXTDEV_BOOT_0) / 4])) >> ((0 ? 5 : 2) %
				32)) & (0xFFFFFFFF >> (31 - ((1 ? 5 : 2) % 32) +
				((0 ? 5 : 2) % 32))));
	value = ((((hwreg)->Reg32[(NV_PFB_BOOT_0) / 4]) & 0xffffffc0) | nv5MemInitTbl[i].pfbBoot0);
	(hwreg)->Reg32[(NV_PFB_BOOT_0) / 4] = (NvV32) (value);
	value = ((((hwreg)->Reg32[(NV_PFB_CONFIG_1) /
					4]) & 0xff8ffffe) | (nv5MemInitTbl[i].pfbConfig1 << 20));
	(hwreg)->Reg32[(NV_PFB_CONFIG_1) / 4] = (NvV32) (value);
	fbLatchMemConfig (device);
	for (i = 0; i < 4; i++)
		(*((NvU32 *) &fbAddr[i * 4]) =
			(NvU32) (NvU32) (("NV5A")[0] | ("NV5A")[1] << 8 | ("NV5A")[2] << 16 |
				("NV5A")[3] << 24));
	if (((NvU16) *((NvU16 *) &fbAddr[0x0000000c])) != (NvU16) (("NV")[0] | ("NV")[1] << 8))
	{
		(hwreg)->Reg32[(NV_PFB_BOOT_0) / 4] =
			(NvV32) ((((hwreg)->Reg32[(NV_PFB_BOOT_0) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 2 : 2) % 32) +
							((0 ? 2 : 2) % 32))) << ((0 ? 2 : 2) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 2 : 2) % 32)));
		fbLatchMemConfig (device);
	}
	if ((((((hwreg)->Reg32[(NV_PFB_BOOT_0) / 4])) >> ((0 ? 1 : 0) % 32)) & (0xFFFFFFFF >> (31 -
					((1 ? 1 : 0) % 32) + ((0 ? 1 : 0) % 32)))) == NV_PMC_BOOT_0)
	{
		(*((NvU32 *) &fbAddr[0x01000000]) =
			(NvU32) (NvU32) (("NV5B")[0] | ("NV5B")[1] << 8 | ("NV5B")[2] << 16 |
				("NV5B")[3] << 24));
		if (((NvU32) *((NvU32 *) &fbAddr[0x01000000])) ==
			(NvU32) (("NV5B")[0] | ("NV5B")[1] << 8 | ("NV5B")[2] << 16 | ("NV5B")[3] <<
				24))
		{
			(*((NvU32 *) &fbAddr[NV_PMC_BOOT_0]) =
				(NvU32) (NvU32) (("A5VN")[0] | ("A5VN")[1] << 8 | ("A5VN")[2] << 16
					| ("A5VN")[3] << 24));
			if (((NvU32) *((NvU32 *) &fbAddr[NV_PMC_BOOT_0])) !=
				(NvU32) (("A5VN")[0] | ("A5VN")[1] << 8 | ("A5VN")[2] << 16 |
					("A5VN")[3] << 24))
				(hwreg)->Reg32[(NV_PFB_BOOT_0) / 4] =
					(NvV32) ((((hwreg)->Reg32[(NV_PFB_BOOT_0) /
								4]) & ~((0xFFFFFFFF >> (31 -
									((1 ? 1 : 0) % 32) +
									((0 ? 1 : 0) %
										32))) << ((0 ? 1 :
									0) %
								32))) | ((0x00000003) << ((0 ? 1 :
								0) % 32)));
		}
		else
		{
			(hwreg)->Reg32[(NV_PFB_BOOT_0) / 4] =
				(NvV32) ((((hwreg)->Reg32[(NV_PFB_BOOT_0) /
							4]) & ~((0xFFFFFFFF >> (31 -
								((1 ? 1 : 0) % 32) +
								((0 ? 1 : 0) %
									32))) << ((0 ? 1 : 0) %
							32))) | ((0x00000003) << ((0 ? 1 : 0) %
						32)));
		}
	}
	else
	{
		if ((((((hwreg)->Reg32[(NV_PFB_BOOT_0) / 4])) >> ((0 ? 1 : 0) %
						32)) & (0xFFFFFFFF >> (31 - ((1 ? 1 : 0) % 32) +
						((0 ? 1 : 0) % 32)))) == 0x00000003)
		{
			(*((NvU32 *) &fbAddr[0x00800000]) =
				(NvU32) (NvU32) (("NV5C")[0] | ("NV5C")[1] << 8 | ("NV5C")[2] << 16
					| ("NV5C")[3] << 24));
			if (((NvU32) *((NvU32 *) &fbAddr[0x00800000])) !=
				(NvU32) (("NV5C")[0] | ("NV5C")[1] << 8 | ("NV5C")[2] << 16 |
					("NV5C")[3] << 24))
			{
				(*((NvU32 *) &fbAddr[0x00400000]) =
					(NvU32) (NvU32) (("NV5D")[0] | ("NV5D")[1] << 8 |
						("NV5D")[2] << 16 | ("NV5D")[3] << 24));
				if (((NvU32) *((NvU32 *) &fbAddr[0x00400000])) ==
					(NvU32) (("NV5D")[0] | ("NV5D")[1] << 8 | ("NV5D")[2] << 16
						| ("NV5D")[3] << 24))
					(hwreg)->Reg32[(NV_PFB_BOOT_0) / 4] =
						(NvV32) ((((hwreg)->Reg32[(NV_PFB_BOOT_0) /
									4]) & ~((0xFFFFFFFF >> (31 -
										((1 ? 1 : 0) % 32) +
										((0 ? 1 : 0) %
											32))) << ((0
										? 1 : 0) %
									32))) | ((0x00000002) << ((0
									? 1 : 0) % 32)));
				else
					(hwreg)->Reg32[(NV_PFB_BOOT_0) / 4] =
						(NvV32) ((((hwreg)->Reg32[(NV_PFB_BOOT_0) /
									4]) & ~((0xFFFFFFFF >> (31 -
										((1 ? 1 : 0) % 32) +
										((0 ? 1 : 0) %
											32))) << ((0
										? 1 : 0) %
									32))) | ((0x00000001) << ((0
									? 1 : 0) % 32)));
			}
		}
		else
		{
			(*((NvU32 *) &fbAddr[0x00400000]) =
				(NvU32) (NvU32) (("NV5D")[0] | ("NV5D")[1] << 8 | ("NV5D")[2] << 16
					| ("NV5D")[3] << 24));
			if (((NvU32) *((NvU32 *) &fbAddr[0x00400000])) !=
				(NvU32) (("NV5D")[0] | ("NV5D")[1] << 8 | ("NV5D")[2] << 16 |
					("NV5D")[3] << 24))
				(hwreg)->Reg32[(NV_PFB_BOOT_0) / 4] =
					(NvV32) ((((hwreg)->Reg32[(NV_PFB_BOOT_0) /
								4]) & ~((0xFFFFFFFF >> (31 -
									((1 ? 1 : 0) % 32) +
									((0 ? 1 : 0) %
										32))) << ((0 ? 1 :
									0) %
								32))) | ((0x00000002) << ((0 ? 1 :
								0) % 32)));
			else
				(hwreg)->Reg32[(NV_PFB_BOOT_0) / 4] =
					(NvV32) ((((hwreg)->Reg32[(NV_PFB_BOOT_0) /
								4]) & ~((0xFFFFFFFF >> (31 -
									((1 ? 1 : 0) % 32) +
									((0 ? 1 : 0) %
										32))) << ((0 ? 1 :
									0) %
								32))) | ((0x00000001) << ((0 ? 1 :
								0) % 32)));
		}
	}
	fbLatchMemConfig (device);
}
