 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvos32.h>
#include <nvhw32.h>
#include "common1.h"
#include "common2.h"


ClassInfo           Nv01DeviceClassInfo;
ClassInfo          *devDeviceChildClassTable[] =
	{ &Nv01ContextDmaClassInfo, &Nv01MemoryLocalBankedClassInfo,
		&Nv01MemoryLocalLinearClassInfo, &Nv03MemoryLocalCursorClassInfo,
		&Nv03ChannelDmaClassInfo, &Nv03ChannelPioClassInfo, };
NvV32
devAllocDevice (GenericObj *obj, NvClassAllocParameters *alloc)
{
	NvSession          *session = nvArchGetSessionFromObject (obj);
	NvDeviceObj        *deviceObj = (NvDeviceObj *) obj;
	Nv0003AllocParameters *params = (Nv0003AllocParameters *) alloc;
	NvArchInfo         *arch = session->arch;
	NvDevice           *device;
	NvDeviceInfo       *deviceInfo;
	NvDeviceType       *deviceType;
	NvV32               status;
	int                 i;

	;
	for (i = 0; i < nvArchInfo.numDevices; i++)
		if (arch->deviceTable[i].deviceId == params->portId)
			break;
	if (i == nvArchInfo.numDevices)
	{
		;
		return (0x00000002);
	}
	device = &arch->deviceTable[i];
	if (device->deviceInfo != (void *) 0)
	{
		;
		return (0x00000002);
	}
	deviceType = device->deviceType;
	status = (deviceType->func->devInit (&deviceInfo, &device->deviceBase[0x0],
			&device->deviceBase[0x1]));
	if (status != 0)
	{
		;
		return (0x00000002);
	}
	deviceInfo->classInfo = &Nv01DeviceClassInfo;
	device->deviceInfo = deviceInfo;
	status = (deviceType->func->devIntrsAlloc (deviceInfo));
	if (status != 0)
	{
		;
		(deviceType->func->devCleanup (deviceInfo));
		return (0x00000002);
	}
	status = (deviceType->func->devChangeState (deviceInfo, 0));
	if (status != 0)
	{
		;
		(deviceType->func->devChangeState (deviceInfo, 4));
		(deviceType->func->devCleanup (deviceInfo));
		return (0x00000002);
	}
	status = (deviceType->func->devChangeState (deviceInfo, 1));
	if (status != 0)
	{
		;
		(deviceType->func->devChangeState (deviceInfo, 2));
		(deviceType->func->devChangeState (deviceInfo, 4));
		(deviceType->func->devCleanup (deviceInfo));
		return (0x00000002);
	}
	deviceObj->device = device;
	return 0;
}

NvV32
devFreeDevice (GenericObj *obj)
{
	NvDeviceObj        *deviceObj = (NvDeviceObj *) obj;
	NvDevice           *device = deviceObj->device;
	NvDeviceInfo       *deviceInfo = device->deviceInfo;
	NvDeviceType       *deviceType = device->deviceType;

	;
	;
	(nvArchDevFuncTable->nvArchFreeObjectChildren) (obj);
	(deviceType->func->devChangeState (deviceInfo, 2));
	(deviceType->func->devChangeState (deviceInfo, 4));
	(deviceType->func->devIntrsFree (deviceInfo));
	(deviceType->func->devCleanup (deviceInfo));
	device->deviceInfo = (void *) 0;
	return 0;
}

ClassInfo           Nv01DeviceClassInfo = {
	(0x00000003), "nv01 device", sizeof (NvDeviceObj), 0x8, 1, (void *) 0, (void *) 0,
		devAllocDevice, (void *) 0, (void *) 0, devFreeDevice, (void *) 0, (void *) 0,
		(sizeof (devDeviceChildClassTable) / sizeof (devDeviceChildClassTable[0])),
		devDeviceChildClassTable, 0, (void *) 0
};
