 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


extern NvV32        mthdUnimplemented (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSwSetContextDmaNotifies (EngineObj *, MethodInfo *, NvV32, NvV32, int);
void                dacSetCursorXY (DacObj *, int);
void                dacSetCursorImage (DacObj *, int);
void                dacStartDac (DacObj *, int);
NvU16               ReadIndexed (NvDeviceInfo *, NvU32, NvU8);
void                WriteIndexed (NvDeviceInfo *, NvU32, NvU16);
void                LoadIndexRange (NvDeviceInfo *, NvU32, NvU8, NvU8, NvU8 *);
void                setDacRegs (DacObj *, int);
void                setDacOffset (DacObj *, int, NvU16);
void                nvFunc342 (DacObj *, int);
void                LoadDefaultATCAndSavePtr (NvDeviceInfo *, NvU8 *);
void                dacLoadPalette (DacObj *, int);
void                FixLowWaterMark (NvDeviceInfo *, NvU16);
void                nvFunc289 (NvDeviceInfo *, NvU32, NvU8);
void                dacBlank (DacObj *);
void                nvFunc347 (DacObj *);
void                dacInitDac (DacObj *);
void                nvFunc340 (DacObj *, int);
void                dacStartImage (DacObj *, int);
int                 dacEnableImageScan (DacObj *);
typedef struct
{
	NvU8                index;
	NvU8                data;
} dacreg_t;
typedef struct
{
	NvU8                ClockMode;
	NvU8                MapMask;
	NvU8                FontAddr;
	NvU8                MemMode;
} seq_t;
typedef struct
{
	dacreg_t            presetRowScan;
	dacreg_t            cursorS;
	dacreg_t            cursorE;
	dacreg_t            regenSHigh;
	dacreg_t            regenSLow;
	dacreg_t            cursorPosHigh;
	dacreg_t            cursorPosLow;
	dacreg_t            uLineRow;
	dacreg_t            mode;
	dacreg_t            lineCompare;
} crtc_t;
typedef struct
{
	NvU8                SetReset;
	NvU8                EnableSetReset;
	NvU8                ColorCmp;
	NvU8                ROP;
	NvU8                ReadMap;
	NvU8                Mode;
	NvU8                Misc;
	NvU8                CDC;
	NvU8                BitMask;
} gr_t;
typedef struct
{
	seq_t               seq_regs;
	crtc_t              crtc_regs;
	gr_t                gr_regs;
} dacinit_tbl_t;
dacinit_tbl_t       dacinit_tbl = {
	{0x01, 0x0f, 0x00, 0x0e}, {{0x08, 0x00}, {0x0a, 0x00}, {0x0b, 0x00}, {0x0c, 0x00}, {0x0d,
				0x00}, {0x0e, 0x00}, {0x0f, 0x00}, {0x14, 0x00}, {0x17, 0xe3},
		{0x18, 0xff}}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x05, 0x0f, 0xff}
};
NvU8                atc_tbl[20] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0D, 0x0e,
		0x0f, 0x41, 0x00, 0x0f, 0x00,
};
typedef struct
{
	NvU16               Freq;
	NvU8                LowWaterMark64;
	NvU8                BurstSize64;
	NvU8                LowWaterMark128;
	NvU8                BurstSize128;
} fifo_t;
fifo_t              DACFifoTable[] = {
	{24000, 0x10, 0x03, 0x10, 0x03}, {27000, 0x11, 0x03, 0x11, 0x03}, {28000, 0x12, 0x03, 0x12,
			0x03}, {29000, 0x13, 0x03, 0x13, 0x03}, {32000, 0x14, 0x03, 0x14, 0x03},
		{33000, 0x15, 0x03, 0x15, 0x03}, {36000, 0x16, 0x03, 0x16, 0x03}, {38000, 0x17,
			0x03, 0x17, 0x03}, {39000, 0x18, 0x03, 0x18, 0x03}, {42000, 0x1A, 0x03,
			0x1A, 0x03}, {50000, 0x22, 0x02, 0x22, 0x02}, {65535, 0x25, 0x01, 0x25,
			0x01}
};
void
WriteIndexed (NvDeviceInfo *device, NvU32 addr, NvU16 datum)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);

	(hwreg)->Reg8[addr] = (NvV8) (datum & 0xff);
	(hwreg)->Reg8[addr + 1] = (NvV8) ((datum >> 8) & 0xff);
}

NvU16
ReadIndexed (NvDeviceInfo *device, NvU32 addr, NvU8 reg)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU16               datum;

	(hwreg)->Reg8[addr] = (NvV8) (reg);
	datum = (((hwreg)->Reg8[addr + 1]) << 8) & 0xff00;
	datum |= reg;
	return datum;
}

void
LoadIndexRange (NvDeviceInfo *device, NvU32 addr, NvU8 index, NvU8 count, NvU8 *regs)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	int                 i;

	for (i = 0; i < count; i++)
	{
		{
			(hwreg)->Reg8[addr] = (NvV8) ((index) & 0xff);
			(hwreg)->Reg8[addr + 1] = (NvV8) ((*regs) & 0xff);
		};
		index++;
		regs++;
	}
}
void
dacInitDac (DacObj *dacObj)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((&dacObj->base))->base.parent->parent))->
			device->deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	dacreg_t           *regs;
	int                 i;

	;
	{
		NvU16               wv;

		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x57) & 0xff);
		};
		wv = ((hwreg)->Reg8[0x006013d4] =
			(NvV8) ((0x21) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
		wv |= 0xc800;
		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((wv & 0xff) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((wv >> 8) & 0xff);
		};
	};
	{
		(hwreg)->Reg8[0x000C03c4] = (NvV8) ((0x00) & 0xff);
		(hwreg)->Reg8[0x000C03c4 + 1] = (NvV8) ((0x01) & 0xff);
	};
	LoadIndexRange (device, 0x000C03c4, 1, sizeof (seq_t), (NvU8 *) &(dacinit_tbl.seq_regs));
	{
		(hwreg)->Reg8[0x000C03c4] = (NvV8) ((0x00) & 0xff);
		(hwreg)->Reg8[0x000C03c4 + 1] = (NvV8) ((0x03) & 0xff);
	};
	regs = (dacreg_t *) & dacinit_tbl.crtc_regs;
	for (i = 0; i < sizeof (crtc_t) / sizeof (dacreg_t); i++)
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((regs[i].index) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((regs[i].data) & 0xff);
	};
	LoadIndexRange (device, 0x000C03ce, 0, sizeof (gr_t), (NvU8 *) &(dacinit_tbl.gr_regs));
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x99) & 0xff);
	};;
}

void
dacImageInVblank (DacObj *dacObj)
{
	int                 i,
	                    flags;
	int                 curr = -1,
		next = -1;

	if (dacObj->flags & 0x00000010)
	{
		dacImageOnOff (((NvDeviceInfo *) (((NvDeviceObj *) (((&dacObj->base))->base.parent->
							parent))->device->deviceInfo)), 0);
		for (i = 0; i < 2; i++)
		{
			if (((dacObj->setImage[i].notifyType) != (NvV32) -1))
			{
				;
				dacNotify (dacObj, 1, (1 + (i)), 0, (0x00));
				(*(&dacObj->setImage[i].notifyType) = -1);
			}
			(dacObj->flags =
				((dacObj->flags & ~((0xFFFFFFFF >> (31 - ((1 ? (11 + (i * 4)) : (8 +
												(i * 4))) % 32) + ((0 ? (11 + (i * 4)) : (8 + (i * 4))) % 32))) << ((0 ? (11 + (i * 4)) : (8 + (i * 4))) % 32))) | (0x00000001) << ((0 ? (11 + (i * 4)) : (8 + (i * 4))) % 32)));
		}
		dacObj->flags &= ~0x00000010;
		return;
	}
	for (i = 0; i < 2; i++)
	{
		flags = ((dacObj->flags >> ((0 ? (11 + (i * 4)) : (8 +
							(i * 4))) % 32)) & (0xFFFFFFFF >> (31 -
					((1 ? (11 + (i * 4)) : (8 + (i * 4))) % 32) + ((0 ? (11 +
								(i * 4)) : (8 + (i * 4))) % 32))));
		if (flags & 0x00000004)
		{
			;
			;
			;
			curr = i;
		}
		if ((flags & 0x00000002) && next == -1)
		{
			;
			next = i;
		}
	}
	if (next != -1)
	{
		NvU32               imageSize;

		;
		if (curr != -1)
		{
			;
			;
			dacNotify (dacObj, 1, (1 + (curr)), 0, (0x00));
			(*(&dacObj->setImage[curr].notifyType) = -1);
			(dacObj->flags =
				((dacObj->flags & ~((0xFFFFFFFF >> (31 - ((1 ? (11 + (curr * 4))
											: (8 + (curr * 4))) % 32) + ((0 ? (11 + (curr * 4)) : (8 + (curr * 4))) % 32))) << ((0 ? (11 + (curr * 4)) : (8 + (curr * 4))) % 32))) | (0x00000001) << ((0 ? (11 + (curr * 4)) : (8 + (curr * 4))) % 32)));
		}
		imageSize =
			(((((dacObj->setDac[0].imageHeight ? dacObj->setDac[0].imageHeight -
							1 : 0) * dacObj->setImage[next].pitch) +
					(dacObj->setDac[0].imageWidth *
						((dacObj->setImage[next].color ==
								(NV_PMC_BOOT_0)) ? 1 : ((dacObj->
									setImage[next].color ==
									(0x00000003)) ? 4 : 2)))) >
				(((dacObj->setDac[1].imageHeight ? dacObj->setDac[1].imageHeight -
							1 : 0) * dacObj->setImage[next].pitch) +
					(dacObj->setDac[0].imageWidth *
						((dacObj->setImage[next].color ==
								(NV_PMC_BOOT_0)) ? 1 : ((dacObj->
									setImage[next].color ==
									(0x00000003)) ? 4 : 2)))))
			? (((dacObj->setDac[0].imageHeight ? dacObj->setDac[0].imageHeight -
						1 : 0) * dacObj->setImage[next].pitch) +
				(dacObj->setDac[0].imageWidth * ((dacObj->setImage[next].color ==
							(NV_PMC_BOOT_0)) ? 1 : ((dacObj->
								setImage[next].color ==
								(0x00000003)) ? 4 : 2))))
			: (((dacObj->setDac[1].imageHeight ? dacObj->setDac[1].imageHeight -
						1 : 0) * dacObj->setImage[next].pitch) +
				(dacObj->setDac[0].imageWidth * ((dacObj->setImage[next].color ==
							(NV_PMC_BOOT_0)) ? 1 : ((dacObj->
								setImage[next].color ==
								(0x00000003)) ? 4 : 2)))));
		if ((dacObj->setImage[next].offset + imageSize) - 1 >
			((unsigned long) (&dacObj->setCtxDmaImage[next]->limit)->low))
		{
			;
			;
			dacImageOnOff (((NvDeviceInfo *) (((NvDeviceObj *) (((&dacObj->base))->base.
								parent->parent))->device->
						deviceInfo)), 0);
			(dacObj->flags =
				((dacObj->flags & ~((0xFFFFFFFF >> (31 - ((1 ? (11 + (next * 4))
											: (8 + (next * 4))) % 32) + ((0 ? (11 + (next * 4)) : (8 + (next * 4))) % 32))) << ((0 ? (11 + (next * 4)) : (8 + (next * 4))) % 32))) | (0x00000001) << ((0 ? (11 + (next * 4)) : (8 + (next * 4))) % 32)));
			errorWrite (&dacObj->base.base, (0x04000000),
				(0x00000304 + (next) * 0x0008),
				(dacObj->setImage[next].pitch | (dacObj->setImage[next].
						color << ((0 ? 27 : 16) %
							32)) | (dacObj->setImage[next].
						notifyType << ((0 ? 31 : 28) % 32))), 0, 0);
			return;
		}
		;
		if (dacObj->setCtxDmaLut[next])
			dacLoadPalette (dacObj, next);
		dacStartImage (dacObj, next);
		(dacObj->flags =
			((dacObj->flags & ~((0xFFFFFFFF >> (31 - ((1 ? (11 + (next * 4)) : (8 +
											(next * 4)))
									% 32) + ((0 ? (11 +
											(next * 4))
										: (8 + (next * 4)))
									% 32))) << ((0 ? (11 +
									(next * 4)) : (8 +
									(next * 4))) %
							32))) | (0x00000004) << ((0 ? (11 +
							(next * 4)) : (8 + (next * 4))) % 32)));
	}
}
void
dacCursorInVblank (DacObj *dacObj)
{
	int                 i,
	                    flags;
	int                 curr = -1,
		next = -1;

	if (dacObj->flags & 0x00000002)
	{
		dacSetCursorXY (dacObj, 0);
		dacObj->flags &= ~0x00000002;
	}
	if (dacObj->flags & 0x00000020)
	{
		dacCursorOnOff (((NvDeviceInfo *) (((NvDeviceObj *) (((&dacObj->base))->base.
							parent->parent))->device->deviceInfo)), 0);
		for (i = 0; i < 2; i++)
		{
			if (((dacObj->setCursor[i].notifyType) != (NvV32) -1))
			{
				;
				dacNotify (dacObj, 1, (3 + (i)), 0, (0x00));
				(*(&dacObj->setCursor[i].notifyType) = -1);
			}
			(dacObj->flags =
				((dacObj->flags & ~((0xFFFFFFFF >> (31 - ((1 ? (19 + (i * 4)) : (16
												+
												(i * 4))) % 32) + ((0 ? (19 + (i * 4)) : (16 + (i * 4))) % 32))) << ((0 ? (19 + (i * 4)) : (16 + (i * 4))) % 32))) | (0x00000001) << ((0 ? (19 + (i * 4)) : (16 + (i * 4))) % 32)));
		}
		dacObj->flags &= ~0x00000020;
		return;
	}
	for (i = 0; i < 2; i++)
	{
		flags = ((dacObj->flags >> ((0 ? (19 + (i * 4)) : (16 +
							(i * 4))) % 32)) & (0xFFFFFFFF >> (31 -
					((1 ? (19 + (i * 4)) : (16 + (i * 4))) % 32) + ((0 ? (19 +
								(i * 4)) : (16 + (i * 4))) % 32))));
		if (flags & 0x00000004)
		{
			;
			;
			;
			curr = i;
		}
		if ((flags & 0x00000002) && next == -1)
		{
			;
			next = i;
		}
	}
	if (next != -1)
	{
		if (curr != -1)
		{
			;
			dacNotify (dacObj, 1, (3 + (curr)), 0, (0x00));
			(*(&dacObj->setCursor[curr].notifyType) = -1);
			(dacObj->flags =
				((dacObj->flags & ~((0xFFFFFFFF >> (31 - ((1 ? (19 + (curr * 4))
											: (16 + (curr * 4))) % 32) + ((0 ? (19 + (curr * 4)) : (16 + (curr * 4))) % 32))) << ((0 ? (19 + (curr * 4)) : (16 + (curr * 4))) % 32))) | (0x00000001) << ((0 ? (19 + (curr * 4)) : (16 + (curr * 4))) % 32)));
		}
		if ((dacObj->setCursor[next].offset + 32 * 32 * 2 - 1) >
			((unsigned long) (&dacObj->setCtxDmaCursor[next]->limit)->low))
		{
			;
			errorWrite (&dacObj->base.base, (0x04000000),
				(0x00000348 + (next) * 0x000C), dacObj->setCursor[next].notifyType,
				0, 0);
			return;
		}
		dacSetCursorImage (dacObj, next);
		(dacObj->flags =
			((dacObj->flags & ~((0xFFFFFFFF >> (31 - ((1 ? (19 + (next * 4)) : (16 +
											(next * 4)))
									% 32) + ((0 ? (19 +
											(next * 4))
										: (16 + (next * 4)))
									% 32))) << ((0 ? (19 +
									(next * 4)) : (16 +
									(next * 4))) %
							32))) | (0x00000004) << ((0 ? (19 +
							(next * 4)) : (16 + (next * 4))) % 32)));
	}
}
void
dacDacInVblank (DacObj *dacObj)
{
	int                 i,
	                    flags;
	int                 curr = -1,
		next = -1;

	if (dacObj->flags & 0x00000040)
	{
		dacOnOff (((NvDeviceInfo *) (((NvDeviceObj *) (((&dacObj->base))->base.parent->
							parent))->device->deviceInfo)), 0);
		for (i = 0; i < 2; i++)
		{
			if (((dacObj->setDac[i].notifyType) != (NvV32) -1))
			{
				;;
				dacNotify (dacObj, 1, (5 + (i)), 0, (0x00));
				(*(&dacObj->setDac[i].notifyType) = -1);
			}
			(dacObj->flags =
				((dacObj->flags & ~((0xFFFFFFFF >> (31 - ((1 ? (27 + (i * 4)) : (24
												+
												(i * 4))) % 32) + ((0 ? (27 + (i * 4)) : (24 + (i * 4))) % 32))) << ((0 ? (27 + (i * 4)) : (24 + (i * 4))) % 32))) | (0x00000001) << ((0 ? (27 + (i * 4)) : (24 + (i * 4))) % 32)));
		}
		dacObj->flags &= ~0x00000040;
		return;
	}
	for (i = 0; i < 2; i++)
	{
		flags = ((dacObj->flags >> ((0 ? (27 + (i * 4)) : (24 +
							(i * 4))) % 32)) & (0xFFFFFFFF >> (31 -
					((1 ? (27 + (i * 4)) : (24 + (i * 4))) % 32) + ((0 ? (27 +
								(i * 4)) : (24 + (i * 4))) % 32))));
		if (flags & 0x00000004)
		{
			;
			;
			;
			curr = i;
		}
		if ((flags & 0x00000002) && next == -1)
		{
			;
			next = i;
		}
	}
	if (next != -1)
	{
		if (curr != -1)
		{
			;
			dacNotify (dacObj, 1, (5 + (curr)), 0, (0x00));
			(*(&dacObj->setDac[curr].notifyType) = -1);
			(dacObj->flags =
				((dacObj->flags & ~((0xFFFFFFFF >> (31 - ((1 ? (27 + (curr * 4))
											: (24 + (curr * 4))) % 32) + ((0 ? (27 + (curr * 4)) : (24 + (curr * 4))) % 32))) << ((0 ? (27 + (curr * 4)) : (24 + (curr * 4))) % 32))) | (0x00000001) << ((0 ? (27 + (curr * 4)) : (24 + (curr * 4))) % 32)));
		}
		dacStartDac (dacObj, next);
		(dacObj->flags =
			((dacObj->flags & ~((0xFFFFFFFF >> (31 - ((1 ? (27 + (next * 4)) : (24 +
											(next * 4)))
									% 32) + ((0 ? (27 +
											(next * 4))
										: (24 + (next * 4)))
									% 32))) << ((0 ? (27 +
									(next * 4)) : (24 +
									(next * 4))) %
							32))) | (0x00000004) << ((0 ? (27 +
							(next * 4)) : (24 + (next * 4))) % 32)));
	}
}
void
dacVblankHandler (GenericObj *genericObj)
{
	DacObj             *dacObj = (DacObj *) genericObj;

	if ((dacObj->flags & 0x00000001) == 0)
	{
		dacInitDac (dacObj);
		dacObj->flags |= 0x00000001;
	}
	dacDacInVblank (dacObj);
	dacImageInVblank (dacObj);
	dacCursorInVblank (dacObj);
}

void
dacCalcPClkVClkRatio (NvDeviceInfo *device)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;

	if (hwdev->info.Dac.VClk < 50000000)
		hwdev->info.Dac.PClkVClkRatio = 1;
	else if (hwdev->info.Dac.VClk < 100000000)
		hwdev->info.Dac.PClkVClkRatio = 2;
	else if (hwdev->info.Dac.VClk < 200000000)
		hwdev->info.Dac.PClkVClkRatio = 4;
	else if (hwdev->info.Dac.VClk < 400000000)
		hwdev->info.Dac.PClkVClkRatio = 8;
	else
		hwdev->info.Dac.PClkVClkRatio = 16;
}

void
dacStartImage (DacObj *dacObj, int buffer)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((&dacObj->base))->base.parent->parent))->
			device->deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               lrv,
	                    i;

	{
		NvU16               wv;

		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x57) & 0xff);
		};
		wv = ((hwreg)->Reg8[0x006013d4] =
			(NvV8) ((0x21) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
		wv |= 0xc800;
		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((wv & 0xff) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((wv >> 8) & 0xff);
		};
	};
	setDacOffset (dacObj, buffer, dacObj->setImage[buffer].pitch);
	lrv = ((hwreg)->Reg32[(NV_PRAMDAC_GENERAL_CONTROL) / 4]);
	lrv &= ~(NvU32) ((3 << ((0 ? 5 : 4) % 32)) | (1 << ((0 ? 12 : 12) % 32)));
	lrv |= (NvU32) (1 << ((0 ? 8 : 8) % 32));
	lrv |= (NvU32) (1 << ((0 ? 20 : 20) % 32));
	switch (dacObj->setImage[buffer].color)
	{
		case (NV_PMC_BOOT_0):
			lrv |= ((0x00000003) << ((0 ? 5 : 4) % 32));
			{
				(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x28) & 0xff);
				(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x01) & 0xff);
			};
			break;
		case (0x00000001):
			lrv |= (((0x00000003) << ((0 ? 5 : 4) %
						32)) | ((0x00000001) << ((0 ? 12 : 12) % 32)));
			{
				(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x28) & 0xff);
				(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x02) & 0xff);
			};
			break;
		case (0x00000002):
			lrv |= (((NV_PMC_BOOT_0) << ((0 ? 5 : 4) %
						32)) | ((NV_PMC_BOOT_0) << ((0 ? 12 : 12) % 32)));
			{
				(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x28) & 0xff);
				(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x02) & 0xff);
			};
			break;
		case (0x00000003):
			lrv |= (((NV_PMC_BOOT_0) << ((0 ? 5 : 4) %
						32)) | ((NV_PMC_BOOT_0) << ((0 ? 12 : 12) % 32)));
			{
				(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x28) & 0xff);
				(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x03) & 0xff);
			};
			break;
		default:;
	}
	(hwreg)->Reg32[(NV_PRAMDAC_GENERAL_CONTROL) / 4] = (NvV32) (lrv);
	lrv = (dacObj->setImage[buffer].offset +
		(NvV32) ((&dacObj->setCtxDmaImage[buffer]->pteBase)->low)) / 4;
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x0c) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((lrv >> 8) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x0d) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((lrv) & 0xff);
	};
	i = ((hwreg)->Reg8[0x006013d4] = (NvV8) ((0x19) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x19) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) (((i & 0xe0) | ((lrv >> 16) & 0x1f)) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x99) & 0xff);
	};;
}

void
dacSetCursorXY (DacObj *dacObj, int buf)
{
	HwDeviceInfo       *hwdev =
		(HwDeviceInfo *) ((NvDeviceInfo *) (((NvDeviceObj *) (((&dacObj->base))->base.
					parent->parent))->device->deviceInfo));
	HwReg              *hwreg = ((hwdev)->base.nvAddr);

	;
	{
		NvU16               wv;

		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x57) & 0xff);
		};
		wv = ((hwreg)->Reg8[0x006013d4] =
			(NvV8) ((0x21) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
		wv |= 0xc800;
		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((wv & 0xff) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((wv >> 8) & 0xff);
		};
	};
	(hwreg)->Reg32[(NV_PRAMDAC_GRCURSOR_START_POS) / 4] =
		(NvV32) ((dacObj->setCursor[buf].y << 16) | dacObj->setCursor[buf].x);
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x99) & 0xff);
	};;
}

void
dacSetCursorImage (DacObj *dacObj, int buf)
{
	HwDeviceInfo       *hwdev =
		(HwDeviceInfo *) ((NvDeviceInfo *) (((NvDeviceObj *) (((&dacObj->base))->base.
					parent->parent))->device->deviceInfo));
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	unsigned long       offset;
	NvU8                reg;

	offset = dacObj->setCursor[buf].offset +
		(NvV32) ((&dacObj->setCtxDmaCursor[buf]->pteBase)->low);
	;
	;
	{
		NvU16               wv;

		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x57) & 0xff);
		};
		wv = ((hwreg)->Reg8[0x006013d4] =
			(NvV8) ((0x21) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
		wv |= 0xc800;
		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((wv & 0xff) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((wv >> 8) & 0xff);
		};
	};
	reg = ((hwreg)->Reg8[0x006013d4] = (NvV8) ((0x30) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
	reg &= ~0x7f;
	reg |= ((offset >> 16) & 0x7f);
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x30) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((reg) & 0xff);
	};
	reg = ((hwreg)->Reg8[0x006013d4] = (NvV8) ((0x31) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
	reg &= ~0xf8;
	reg |= ((offset >> 11) & 0x1f) << 0x3;
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x31) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((reg | 0x1) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x99) & 0xff);
	};;
	dacSetCursorXY (dacObj, buf);
}

void
dacBlank (DacObj *dacObj)
{
	HwDeviceInfo       *hwdev =
		(HwDeviceInfo *) ((NvDeviceInfo *) (((NvDeviceObj *) (((&dacObj->base))->base.
					parent->parent))->device->deviceInfo));
	HwReg              *hwreg = ((hwdev)->base.nvAddr);

	;
	{
		NvU16               wv;

		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x57) & 0xff);
		};
		wv = ((hwreg)->Reg8[0x006013d4] =
			(NvV8) ((0x21) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
		wv |= 0xc800;
		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((wv & 0xff) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((wv >> 8) & 0xff);
		};
	};
	((hwreg)->Reg32[(0x006013da) / 4]);
	(hwreg)->Reg8[0x006013c0] = (NvV8) (0x00);
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x99) & 0xff);
	};;
}

void
dacUnblank (DacObj *dacObj)
{
	HwDeviceInfo       *hwdev =
		(HwDeviceInfo *) ((NvDeviceInfo *) (((NvDeviceObj *) (((&dacObj->base))->base.
					parent->parent))->device->deviceInfo));
	HwReg              *hwreg = ((hwdev)->base.nvAddr);

	;
	{
		NvU16               wv;

		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x57) & 0xff);
		};
		wv = ((hwreg)->Reg8[0x006013d4] =
			(NvV8) ((0x21) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
		wv |= 0xc800;
		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((wv & 0xff) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((wv >> 8) & 0xff);
		};
	};
	((hwreg)->Reg32[(0x006013da) / 4]);
	(hwreg)->Reg8[0x006013c0] = (NvV8) (0x20);
	((hwreg)->Reg32[(0x006013da) / 4]);
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x99) & 0xff);
	};;
}

NvU32
dacGetScanline (NvDeviceInfo *device)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU16               scanline;

	{
		NvU16               wv;

		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x57) & 0xff);
		};
		wv = ((hwreg)->Reg8[0x006013d4] =
			(NvV8) ((0x21) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
		wv |= 0xc800;
		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((wv & 0xff) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((wv >> 8) & 0xff);
		};
	};
	scanline = ((hwreg)->Reg8[0x006013d4] =
		(NvV8) ((0x35) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1])) & 0x3;
	scanline <<= 8;
	scanline |= ((hwreg)->Reg8[0x006013d4] =
		(NvV8) ((0x34) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x99) & 0xff);
	};;
	return scanline;
}

void
dacStartDac (DacObj *dacObj, int buffer)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((&dacObj->base))->base.parent->parent))->
			device->deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU16               wv;

	{
		NvU16               wv;

		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x57) & 0xff);
		};
		wv = ((hwreg)->Reg8[0x006013d4] =
			(NvV8) ((0x21) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
		wv |= 0xc800;
		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((wv & 0xff) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((wv >> 8) & 0xff);
		};
	};
	wv = ((hwreg)->Reg8[0x000C03c4] = (NvV8) ((0x01) & 0xff), ((hwreg)->Reg8[0x000C03c4 + 1]));
	{
		(hwreg)->Reg8[0x000C03c4] = (NvV8) ((0x01) & 0xff);
		(hwreg)->Reg8[0x000C03c4 + 1] = (NvV8) ((wv | 0x20) & 0xff);
	};
	setDacRegs (dacObj, buffer);
	wv = ((hwreg)->Reg8[0x000C03c4] = (NvV8) ((0x01) & 0xff), ((hwreg)->Reg8[0x000C03c4 + 1]));
	wv &= ~0x20;
	if (dacEnableImageScan (dacObj) == 0)
		wv |= 0x20;
	else
		wv &= ~0x20;
	{
		(hwreg)->Reg8[0x000C03c4] = (NvV8) ((0x01) & 0xff);
		(hwreg)->Reg8[0x000C03c4 + 1] = (NvV8) ((wv) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x99) & 0xff);
	};;
}

void
setDacOffset (DacObj *dacObj, int buffer, NvU16 pitch)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((&dacObj->base))->base.parent->parent))->
			device->deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU16               wv;
	NvU16               offset = pitch / 8;

	dacObj->setDac[buffer].cachedPitch = pitch;
	wv = ((hwreg)->Reg8[0x006013d4] = (NvV8) ((0x19) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
	wv &= 0x1f;
	wv |= (offset >> 8) << 5;
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x19) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((wv) & 0xff);
	};
	wv = ((hwreg)->Reg8[0x006013d4] = (NvV8) ((0x25) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
	wv &= 0x1f;
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x25) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] =
			(NvV8) ((((((offset) & (1 << (11))) >> (11)) << (5)) | wv) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x13) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((offset & 0xff) & 0xff);
	};
}

void
setDacRegs (DacObj *dacObj, int buffer)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((&dacObj->base))->base.parent->parent))->
			device->deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU16               wv;
	NvU32               lrv;
	NvU16               htotal,
	                    vtotal;
	NvU16               offset;
	NvU16               hbe;
	NvU16               hrs;
	NvU16               hre;
	NvU16               hde;
	NvU16               hbs;
	NvU16               vde;
	NvU16               vbs;
	NvU16               vbe;
	NvU16               vrs;
	NvU16               vre;
	NvU16               lc;
	NvU16               hfc;

	htotal = (NvU16) dacObj->setDac[buffer].totalWidth;
	hrs = dacObj->setDac[buffer].hSyncStart / 8;
	hbe = htotal / 8;
	hde = (dacObj->setDac[buffer].imageWidth == 0) ? 1 : dacObj->setDac[buffer].imageWidth / 8;
	hbs = hde;
	hre = (dacObj->setDac[buffer].hSyncStart + dacObj->setDac[buffer].hSyncWidth) / 8;
	vtotal = (NvU16) dacObj->setDac[buffer].totalHeight;
	vrs = dacObj->setDac[buffer].vSyncStart;
	vbe = vtotal;
	vde = (dacObj->setDac[buffer].imageHeight == 0) ? 1 : dacObj->setDac[buffer].imageHeight;
	vbs = vde;
	vre = dacObj->setDac[buffer].vSyncStart + dacObj->setDac[buffer].vSyncWidth;
	lc = (dacObj->setDac[buffer].imageHeight == 0) ? 0 : vde;
	hfc = 0x1ff;
	offset = dacObj->setDac[buffer].cachedPitch;
	(hwreg)->Reg8[0x000C03c2] =
		(NvV8) (((((dacObj->setDac[buffer].
						vSyncPolarity) & (1 << (0))) >> (0)) << (7)) |
		((((dacObj->setDac[buffer].hSyncPolarity) & (1 << (0))) >> (0)) << (6)) | 0x2b);
	{
		(hwreg)->Reg8[0x000C03c4] = (NvV8) ((0x01) & 0xff);
		(hwreg)->Reg8[0x000C03c4 + 1] = (NvV8) ((0x01) & 0xff);
	};
	wv = ((hwreg)->Reg8[0x006013d4] =
		(NvV8) ((0x11) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1])) & 0x7f;
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x11) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((wv) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x00) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) (((htotal / 8) - 5) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x01) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((hde - 1) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x02) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((hbs - 1) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x03) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x80 | ((hbe - 1) & 0x1f)) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x04) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((hrs + 2) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x05) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] =
			(NvV8) ((((((hbe - 1) & (1 << (5))) >> (5)) << (7)) | ((hre +
						2) & 0x1f)) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x06) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((vtotal - 2) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x07) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] =
			(NvV8) ((((((vrs) & (1 << (9))) >> (9)) << (7)) | ((((vde -
								1) & (1 << (9))) >> (9)) << (6)) |
				((((vtotal - 2) & (1 << (9))) >> (9)) << (5)) | ((((lc) & (1 <<
								(8))) >> (8)) << (4)) | ((((vbs -
								1) & (1 << (8))) >> (8)) << (3)) |
				((((vrs) & (1 << (8))) >> (8)) << (2)) | ((((vde -
								1) & (1 << (8))) >> (8)) << (1)) |
				((((vtotal - 2) & (1 << (8))) >> (8)) << (0))) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x09) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] =
			(NvV8) ((((((lc) & (1 << (9))) >> (9)) << (6)) | ((((vbs -
								1) & (1 << (9))) >> (9)) << (5))) &
			0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x10) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((vrs) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x11) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((vre & 0xf) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x12) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((vde - 1) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x15) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((vbs - 1) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x16) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((vbe - 1) & 0xff);
	};
	wv = ((hwreg)->Reg8[0x006013d4] = (NvV8) ((0x19) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
	wv &= 0x1f;
	wv |= (offset >> 8) << 5;
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x19) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((wv) & 0xff);
	};
	wv = 0;
	if (dacObj->setDac[buffer].hSyncWidth == 0)
		wv |= 0x80;
	if (dacObj->setDac[buffer].vSyncWidth == 0)
		wv |= 0x40;
	wv |= ((dacObj->setDac[buffer].imageWidth < 1280)
		&& (dacObj->setDac[buffer].imageHeight < 1024)) ? 0x04 : 0;
	wv |= 0x38;
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1a) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((wv) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1b) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x01) & 0xff);
	};
	wv = ((hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1c) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
	wv |= 0x1c;
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1c) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((wv) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1d) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x00) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1e) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x00) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x20) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x10) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x25) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] =
			(NvV8) ((((((offset) & (1 << (11))) >> (11)) << (5)) | ((((hbe -
								1) & (1 << (6))) >> (6)) << (4)) |
				((((vbs - 1) & (1 << (10))) >> (10)) << (3)) | ((((vrs) & (1 <<
								(10))) >> (10)) << (2)) | ((((vde -
								1) & (1 << (10))) >> (10)) << (1)) |
				((((vtotal - 2) & (1 << (10))) >> (10)) << (0))) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x2d) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] =
			(NvV8) ((((((hfc) & (1 << (8))) >> (8)) << (4)) | ((((hrs +
								2) & (1 << (8))) >> (8)) << (3)) |
				((((hbs - 1) & (1 << (8))) >> (8)) << (2)) | ((((hde -
								1) & (1 << (8))) >> (8)) << (1)) |
				(((((htotal / 8) - 5) & (1 << (8))) >> (8)) << (0))) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x29) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x00) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x2a) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x00) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x30) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x00) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x31) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x00) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x32) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x00) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x33) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x00) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x34) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x00) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x30) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((hfc & 0x1f) & 0xff);
	}
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x13) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((offset & 0xff) & 0xff);
	};
	lrv = ((hwreg)->Reg32[(NV_PRAMDAC_PLL_COEFF_SELECT) / 4]);
	(hwreg)->Reg32[(NV_PRAMDAC_PLL_COEFF_SELECT) / 4] = (NvV32) (0x10000700);
}

void
dacLoadPalette (DacObj *dacObj, int buffer)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((&dacObj->base))->base.parent->parent))->
			device->deviceInfo));
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32              *xrgbp =
		(NvU32 *) ((&dacObj->setCtxDmaLut[buffer]->memoryObj->kernAddr)->low +
		(unsigned long) (&dacObj->setCtxDmaLut[buffer]->offset)->low);
	NvU32               xrgb;
	int                 i;

	;
	{
		NvU16               wv;

		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x57) & 0xff);
		};
		wv = ((hwreg)->Reg8[0x006013d4] =
			(NvV8) ((0x21) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
		wv |= 0xc800;
		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((wv & 0xff) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((wv >> 8) & 0xff);
		};
	};
	LoadDefaultATCAndSavePtr (device, atc_tbl);
	((hwreg)->Reg32[(0x006013da) / 4]);
	(hwreg)->Reg8[0x006013c0] = (NvV8) (0x14);
	(hwreg)->Reg8[0x006013c0] = (NvV8) (0x00);
	(hwreg)->Reg8[0x006813C6] = (NvV8) (0xff);
	(hwreg)->Reg8[0x006813C8] = (NvV8) (0x00);
	for (i = 0; i < 256; i++)
	{
		xrgb = *xrgbp++;
		(hwreg)->Reg8[0x006813C9] = (NvV8) ((xrgb >> 16) & 0xff);
		(hwreg)->Reg8[0x006813C9] = (NvV8) ((xrgb >> 8) & 0xff);
		(hwreg)->Reg8[0x006813C9] = (NvV8) ((xrgb & 0xff));
	}
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1F) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x99) & 0xff);
	};
}

void
LoadDefaultATCAndSavePtr (NvDeviceInfo *device, NvU8 *pal)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU8                i;

	((hwreg)->Reg32[(0x006013da) / 4]);
	for (i = 0; i < 20; i++)
	{
		(hwreg)->Reg8[0x006013c0] = (NvV8) (i);
		(hwreg)->Reg8[0x006013c0] = (NvV8) (*pal++);
	}
	((hwreg)->Reg32[(0x006013da) / 4]);
}

void
dacSetPixelClock (NvDeviceInfo *device, NvU32 hz)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU32               mnp;
	NvU16               clock = (NvU16) (hz / 10000);

	if (hz == 0)
	{
		(hwreg)->Reg32[(0x00680510) / 4] =
			(NvV32) ((((hwreg)->Reg32[(0x00680510) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 14 : 12) % 32) +
							((0 ? 14 : 12) % 32))) << ((0 ? 14 : 12) %
						32))) | ((0x00000002) << ((0 ? 14 : 12) % 32)));
		return;
	}
	if ((((((hwreg)->Reg32[(0x00680510) / 4])) >> ((0 ? 14 : 12) % 32)) & (0xFFFFFFFF >> (31 -
					((1 ? 14 : 12) % 32) + ((0 ? 14 : 12) % 32)))) ==
		0x00000002)
		(hwreg)->Reg32[(0x00680510) / 4] =
			(NvV32) ((((hwreg)->Reg32[(0x00680510) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 14 : 12) % 32) +
							((0 ? 14 : 12) % 32))) << ((0 ? 14 : 12) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 14 : 12) % 32)));
	FixLowWaterMark (device, clock);
	mnp = dacCalcMNP (device, &clock);
	(hwreg)->Reg32[(NV_PRAMDAC_VPLL_COEFF) / 4] = (NvV32) (mnp);
}

void
FixLowWaterMark (NvDeviceInfo *device, NvU16 clock)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU16               wv;
	NvU32               lwv;
	NvU16               i;

	wv = ReadIndexed (device, 0x006013d4, 0x28);
	wv >>= 8;
	if (wv & 0x0003)
	{
		wv--;
		clock <<= (NvU8) wv;
		for (i = 0; clock > DACFifoTable[i].Freq; i++)
			;
		lwv = ((hwreg)->Reg32[(NV_PFB_BOOT_0) / 4]) & 0x00000004L;
		if (lwv)
		{
			wv = ((DACFifoTable[i].LowWaterMark128) << 8) | 0x20;
			i = ((DACFifoTable[i].BurstSize128) << 8) | 0x1b;
		}
		else
		{
			wv = ((DACFifoTable[i].LowWaterMark64) << 8) | 0x20;
			i = ((DACFifoTable[i].BurstSize64) << 8) | 0x1b;
		}
		WriteIndexed (device, 0x006013d4, i);
		WriteIndexed (device, 0x006013d4, wv);
	}
}
NvU32
dacCalcMNP (NvDeviceInfo *device, NvU16 *clock)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU16               crystalFreq;
	NvU32               vclk;
	NvU16               vclkClosest;
	NvU16               deltaOld;
	NvU16               bestM;
	NvU16               bestP;
	NvU16               bestN;
	NvU16               lowM;
	NvU16               highM;
	NvU32               hiVclk1,
	                    hiVclk2;
	NvU16               powerP;
	NvU16               m;
	NvU16               n;
	NvU16               i,
	                    j;
	NvU32               lwv;
	NvU32               lwv2;
	NvU16               lwvs,
	                    vclks;
	NvU16               t;
	NvU32               fMaxVco;

	;
	vclk = (NvU32) (*clock * 10);
	deltaOld = 0xffff;
	hiVclk1 = 250000;
	hiVclk2 = 340000;
	if (vclk < 256000)
		fMaxVco = 256000;
	else
		fMaxVco = vclk;
	lwv = ((hwreg)->Reg32[(NV_PEXTDEV_BOOT_0) / 4]) & 0x00000040;
	if (lwv)
	{
		crystalFreq = 14318;
		lowM = 1;
		if (vclk > hiVclk2)
			highM = 2;
		else if (vclk > hiVclk1)
			highM = 6;
		else
			highM = 14;
	}
	else
	{
		crystalFreq = 13500;
		lowM = 1;
		if (vclk > hiVclk2)
			highM = 2;
		else if (vclk > hiVclk1)
			highM = 6;
		else
			highM = 13;
	}
	for (powerP = 0; powerP <= 4; powerP++)
	{
		for (m = lowM; m <= highM; m++)
		{
			lwv = vclk << powerP;
			if ((lwv >= 128000) && (lwv <= fMaxVco))
			{
				lwv *= (NvU32) m;
				lwv += (crystalFreq >> 1);
				lwv /= crystalFreq;
				n = (NvU16) (lwv & 0xffff);
				if (n > 0xff)
					break;
				lwv *= crystalFreq;
				i = 1 << powerP;
				i >>= 1;
				lwv += i;
				lwv >>= powerP;
				i = m;
				j = m;
				j >>= 1;
				lwv += j;
				lwv /= m;
				lwv2 = lwv;
				lwvs = (NvU16) (lwv & 0xffff);
				vclks = (NvU16) (vclk & 0xffff);
				if (lwvs < vclks)
				{
					t = lwvs;
					lwvs = vclks;
					vclks = t;
				}
				lwvs -= vclks;
				if ((((((((hwreg)->Reg32[(NV_PMC_BOOT_0) / 4])) >> ((0 ? 15 : 12) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 15 : 12) %
											32) +
										((0 ? 15 : 12) %
											32)))) >
							0x00000004)
						|| ((((((hwreg)->Reg32[(NV_PMC_BOOT_0) / 4])) >> ((0
											? 15 : 12) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 15 : 12) %
											32) +
										((0 ? 15 : 12) %
											32)))) ==
							0x00000004
							&& (((((hwreg)->Reg32[(NV_PMC_BOOT_0) / 4]))
									>> ((0 ? 23 : 20) %
										32)) & (0xFFFFFFFF
									>> (31 - ((1 ? 23 : 20) %
											32) +
										((0 ? 23 : 20) %
											32)))) >=
							0x00000001)))
				{
					if (vclk > hiVclk1)
					{
						if (((vclk / lwvs) > 200) || (lwvs == 0))
						{
							lwv = powerP;
							lwv <<= 16;
							lwv |= ((n << 8) | m);
							lwv2 /= 10;
							*clock = ((NvU16) (lwv2 & 0xffff));
							return lwv;
						}
					}
					if (lwvs < deltaOld)
					{
						deltaOld = lwvs;
						bestP = powerP;
						bestM = m;
						bestN = n;
						lwv2 /= 10;
						vclkClosest = (NvU16) (lwv2 & 0xffff);
					}
				}
				else
				{
					if (lwvs < deltaOld)
					{
						deltaOld = lwvs;
						bestP = powerP;
						bestM = m;
						bestN = n;
						lwv2 /= 10;
						vclkClosest = (NvU16) (lwv2 & 0xffff);
					}
				}
			}
		}
	}
	lwv = bestP;
	lwv <<= 16;
	lwv |= ((bestN << 8) | (bestM));
	;
	;
	*clock = vclkClosest;
	return lwv;
}

void
dacImageOnOff (NvDeviceInfo *device, int state)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU16               wv;

	;
	{
		NvU16               wv;

		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x57) & 0xff);
		};
		wv = ((hwreg)->Reg8[0x006013d4] =
			(NvV8) ((0x21) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
		wv |= 0xc800;
		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((wv & 0xff) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((wv >> 8) & 0xff);
		};
	};
	wv = ((hwreg)->Reg8[0x000C03c4] = (NvV8) ((0x1) & 0xff), ((hwreg)->Reg8[0x000C03c4 + 1]));
	wv &= ~0x20;
	wv |= (state == 0 ? 0x20 : 0);
	{
		(hwreg)->Reg8[0x000C03c4] = (NvV8) ((0x1) & 0xff);
		(hwreg)->Reg8[0x000C03c4 + 1] = (NvV8) ((wv) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x99) & 0xff);
	};;
}

void
dacCursorOnOff (NvDeviceInfo *device, int state)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU16               wv;

	;
	{
		NvU16               wv;

		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x57) & 0xff);
		};
		wv = ((hwreg)->Reg8[0x006013d4] =
			(NvV8) ((0x21) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
		wv |= 0xc800;
		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((wv & 0xff) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((wv >> 8) & 0xff);
		};
	};
	wv = ((hwreg)->Reg8[0x006013d4] = (NvV8) ((0x31) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
	wv &= ~0x1;
	wv |= state ? 1 : 0;
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x31) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((wv) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x99) & 0xff);
	};;
}

void
dacOnOff (NvDeviceInfo *device, int state)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	NvU16               wv;

	;
	if (state == 1)
	{
		(hwreg)->Reg32[(0x00600140) / 4] =
			(NvV32) ((((hwreg)->Reg32[(0x00600140) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 0 : 0) % 32) +
							((0 ? 0 : 0) % 32))) << ((0 ? 0 : 0) %
						32))) | ((0x00000001) << ((0 ? 0 : 0) % 32)));
	}
	else
	{
		(hwreg)->Reg32[(0x00600140) / 4] =
			(NvV32) ((((hwreg)->Reg32[(0x00600140) / 4]) & ~((0xFFFFFFFF >> (31 -
							((1 ? 0 : 0) % 32) +
							((0 ? 0 : 0) % 32))) << ((0 ? 0 : 0) %
						32))) | ((NV_PMC_BOOT_0) << ((0 ? 0 : 0) % 32)));
	}
	{
		NvU16               wv;

		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x57) & 0xff);
		};
		wv = ((hwreg)->Reg8[0x006013d4] =
			(NvV8) ((0x21) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
		wv |= 0xc800;
		{
			(hwreg)->Reg8[0x006013d4] = (NvV8) ((wv & 0xff) & 0xff);
			(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((wv >> 8) & 0xff);
		};
	};
	wv = ((hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1a) & 0xff), ((hwreg)->Reg8[0x006013d4 + 1]));
	wv &= ~0xc0;
	wv |= state == 0 ? 0xc0 : 0;
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1a) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((wv) & 0xff);
	};
	{
		(hwreg)->Reg8[0x006013d4] = (NvV8) ((0x1f) & 0xff);
		(hwreg)->Reg8[0x006013d4 + 1] = (NvV8) ((0x99) & 0xff);
	};;
}

int
dacEnableImageScan (DacObj *dacObj)
{
	NvU32               flags;
	int                 i,
	                    rc = 0;

	for (i = 0; i < 2; i++)
	{
		flags = ((dacObj->flags >> ((0 ? (11 + (i * 4)) : (8 +
							(i * 4))) % 32)) & (0xFFFFFFFF >> (31 -
					((1 ? (11 + (i * 4)) : (8 + (i * 4))) % 32) + ((0 ? (11 +
								(i * 4)) : (8 + (i * 4))) % 32))));
		if (flags & (0x00000004 | 0x00000002))
		{
			rc = 1;
			break;
		}
	}
	if (rc == 1)
		for (i = 0; i < 2; i++)
		{
			flags = ((dacObj->flags >> ((0 ? (27 + (i * 4)) : (24 +
								(i * 4))) %
						32)) & (0xFFFFFFFF >> (31 - ((1 ? (27 +
									(i * 4)) : (24 +
									(i * 4))) % 32) +
						((0 ? (27 + (i * 4)) : (24 + (i * 4))) % 32))));
			if (flags & (0x00000004 | 0x00000002))
			{
				if (dacObj->setDac[i].imageHeight == 0
					|| dacObj->setDac[i].imageWidth == 0)
					rc = 0;
				break;
			}
		}
	;
	return rc;
}
