 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


extern NvV32        mthdUnimplemented (EngineObj *, MethodInfo *, NvV32, NvV32, int);
extern NvV32        mthdSwSetContextDmaNotifies (EngineObj *, MethodInfo *, NvV32, NvV32, int);
void                dacVblankHandler (GenericObj *);
void
dacNotify (DacObj *dacObj, int awaken, int ndx, NvU32 offset, NvV32 status)
{
	NvDeviceInfo       *device =
		((NvDeviceInfo *) (((NvDeviceObj *) (((&dacObj->base))->base.parent->parent))->
			device->deviceInfo));
	NvContextDmaObj    *ctxDmaObj = ((EngineObj *) dacObj)->notifyCtxDma;
	NvU32               timeHi,
	                    timeLo;
	Nv0046Notification *notify;

	;
	tmrGetCurrentTime (device, &timeHi, &timeLo);
	notify = (Nv0046Notification *) ((&ctxDmaObj->memoryObj->kernAddr)->low +
		(unsigned long) (&ctxDmaObj->offset)->low);
	notify[ndx].timeStamp.high = timeHi;
	notify[ndx].timeStamp.low = timeLo;
	notify[ndx].zero[0] = (NvV8) 0;
	notify[ndx].zero[1] = (NvV8) 0;
	notify[ndx].zero[2] = (NvV8) 0;
	notify[ndx].offset = offset;
	notify[ndx].status = (NvV8) status;
}
static NvV32
mthdSynchronize (EngineObj *object, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	NvV32               status = 0;

	;
	if (!object->notifyCtxDma)
		status |= (0x01000000);
	switch (data)
	{
		case (NV_PMC_BOOT_0):
		case (0x00000001):
			return status;
		case (0x00000002):
		case (0x00000003):
			break;
		default:;
			status |= (0x02000000);
			break;
	}
	if (status)
		return status;
	dacNotify ((DacObj *) object, (data == (0x00000003)), (0), 0, status);
	return 0;
}
static NvV32
mthdStopImage (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	DacObj             *dacObj = (DacObj *) engObj;
	int                 i;

	;
	switch (data)
	{
		case (NV_PMC_BOOT_0):
			dacObj->flags |= 0x00000010;
			dacImageOnOff (((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.
								parent->parent))->device->
						deviceInfo)), 0);
			for (i = 0; i < 2; i++)
			{
				if (((dacObj->setImage[i].notifyType) != (NvV32) -1))
				{
					;
					dacNotify (dacObj, 1, (1 + (i)), 0, (0x00));
					(*(&dacObj->setImage[i].notifyType) = -1);
				}
				(dacObj->flags =
					((dacObj->flags & ~((0xFFFFFFFF >> (31 - ((1 ? (11 + (i * 4)) : (8 + (i * 4))) % 32) + ((0 ? (11 + (i * 4)) : (8 + (i * 4))) % 32))) << ((0 ? (11 + (i * 4)) : (8 + (i * 4))) % 32))) | (0x00000001) << ((0 ? (11 + (i * 4)) : (8 + (i * 4))) % 32)));
			}
			break;
		case (0x00000001):
			dacObj->flags |= 0x00000010;
			break;
		default:;
			return (0x02000000);
	}
	return 0;
}
static NvV32
mthdStopCursor (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	DacObj             *dacObj = (DacObj *) engObj;
	int                 i;

	;
	switch (data)
	{
		case (NV_PMC_BOOT_0):
			dacObj->flags |= 0x00000020;
			dacCursorOnOff (((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.
								parent->parent))->device->
						deviceInfo)), 0);
			for (i = 0; i < 2; i++)
			{
				if (((dacObj->setCursor[i].notifyType) != (NvV32) -1))
				{
					;
					dacNotify (dacObj, 1, (3 + (i)), 0, (0x00));
					(*(&dacObj->setCursor[i].notifyType) = -1);
				}
				(dacObj->flags =
					((dacObj->flags & ~((0xFFFFFFFF >> (31 - ((1 ? (19 + (i * 4)) : (16 + (i * 4))) % 32) + ((0 ? (19 + (i * 4)) : (16 + (i * 4))) % 32))) << ((0 ? (19 + (i * 4)) : (16 + (i * 4))) % 32))) | (0x00000001) << ((0 ? (19 + (i * 4)) : (16 + (i * 4))) % 32)));
			}
			break;
		case (0x00000001):
			dacObj->flags |= 0x00000020;
			break;
		default:;
			return (0x02000000);
	}
	return 0;
}
static NvV32
mthdStopDac (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	DacObj             *dacObj = (DacObj *) engObj;
	int                 i;

	;
	switch (data)
	{
		case (NV_PMC_BOOT_0):
			dacObj->flags |= 0x00000040;
			dacOnOff (((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->
								parent))->device->deviceInfo)), 0);
			for (i = 0; i < 2; i++)
			{
				if (((dacObj->setDac[i].notifyType) != (NvV32) -1))
				{
					;
					dacNotify (dacObj, 1, (5 + (i)), 0, (0x00));
					(*(&dacObj->setDac[i].notifyType) = -1);
				}
				(dacObj->flags =
					((dacObj->flags & ~((0xFFFFFFFF >> (31 - ((1 ? (27 + (i * 4)) : (24 + (i * 4))) % 32) + ((0 ? (27 + (i * 4)) : (24 + (i * 4))) % 32))) << ((0 ? (27 + (i * 4)) : (24 + (i * 4))) % 32))) | (0x00000001) << ((0 ? (27 + (i * 4)) : (24 + (i * 4))) % 32)));
			}
			dacObj->flags &= ~0x00000040;
			break;
		case (0x00000001):
			dacObj->flags |= 0x00000040;
			break;
		default:;
			return (0x02000000);
	}
	return 0;
}
static NvV32
mthdSetContextDmaNotifies (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data,
	int cause)
{
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GenericObj         *dataObj;
	NvContextDmaObj    *ctxObj;
	DacObj             *dacObj = (DacObj *) engObj;
	int                 buf;

	;
	for (buf = 0; buf < 2; buf++)
	{
		if (((dacObj->setImage[buf].notifyType) != (NvV32) -1)
			|| ((dacObj->setCursor[buf].notifyType) != (NvV32) -1)
			|| ((dacObj->setDac[buf].notifyType) != (NvV32) -1))
		{
			;
			return (0x00800000);
		}
	}
	if (data != (NV_PMC_BOOT_0))
	{
		dataObj = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
		if (dataObj == (void *) 0 || dataObj->classInfo->num != (0x00000002))
		{
			;
			return (0x02000000);
		}
		if (engObj->base.parent->parent != dataObj->parent)
		{
			;
			return (0x02000000);
		}
		ctxObj = (NvContextDmaObj *) dataObj;
		if (((((unsigned long) (&ctxObj->offset)->low) & 0x7f) != 0x0)
			|| (((unsigned long) (&ctxObj->limit)->low) < 0x6f))
		{
			;
			return (0x01000000);
		}
	}
	return mthdSwSetContextDmaNotifies (engObj, method, offset, data, cause);
}
static NvV32
mthdSetContextDmaImage (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	DacObj             *dacObj = (DacObj *) engObj;
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GenericObj         *dataObj;
	NvContextDmaObj    *ctxObj;
	int                 buf = (offset == 0x0184) ? 0 : 1;

	;
	if (dacObj->flags & 0x00000010)
		return (0x00800000);
	if (((dacObj->setImage[buf].notifyType) != (NvV32) -1))
		return (0x00800000);
	if (data != (NV_PMC_BOOT_0))
	{
		dataObj = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
		if (dataObj == (void *) 0 || dataObj->classInfo->num != (0x00000002))
		{
			;
			return (0x02000000);
		}
		if (engObj->base.parent->parent != dataObj->parent)
		{
			;
			return (0x02000000);
		}
		ctxObj = (NvContextDmaObj *) dataObj;
		if (((((ctxObj->memoryObj->base.classInfo->num) != (0x00000040))
					|| !(((ctxObj->usrFlags >> ((0 ? 31 : 8) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 31 : 8) % 32) +
									((0 ? 31 : 8) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& (((ctxObj->memoryObj->base.classInfo->num) != (0x0000003D))
					|| !(((ctxObj->usrFlags >> ((0 ? 31 : 8) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 31 : 8) % 32) +
									((0 ? 31 : 8) % 32)))) ==
						(NV_PMC_BOOT_0))))
			|| !(((ctxObj->usrFlags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
							((1 ? 3 : 0) % 32) +
							((0 ? 3 : 0) % 32)))) == (NV_PMC_BOOT_0))
			|| (!(((ctxObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
								((1 ? 7 : 4) % 32) +
								((0 ? 7 : 4) % 32)))) ==
					(NV_PMC_BOOT_0))
				&& !(((ctxObj->usrFlags >> ((0 ? 7 : 4) %
								32)) & (0xFFFFFFFF >> (31 -
								((1 ? 7 : 4) % 32) +
								((0 ? 7 : 4) % 32)))) ==
					(0x00000001))))
		{
			;
			;
			return (0x01000000);
		}
		if (dacObj->setCtxDmaImage[buf])
		{
			dacObj->setCtxDmaImage[buf]->base.refcnt--;
			;
		}
		ctxObj->base.refcnt++;
		;
		dacObj->setCtxDmaImage[buf] = ctxObj;
	}
	else
	{
		if (dacObj->setCtxDmaImage[buf])
		{
			dacObj->setCtxDmaImage[buf]->base.refcnt--;
			;
		}
		dacObj->setCtxDmaImage[buf] = (void *) 0;
	}
	return 0;
}
static NvV32
mthdSetContextDmaLut (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	DacObj             *dacObj = (DacObj *) engObj;
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GenericObj         *dataObj;
	NvContextDmaObj    *ctxDmaObj;
	int                 buf = (offset == 0x018c) ? 0 : 1;

	;
	if (dacObj->flags & 0x00000010)
		return (0x00800000);
	if (((dacObj->setImage[buf].notifyType) != (NvV32) -1))
		return (0x00800000);
	if (data != (NV_PMC_BOOT_0))
	{
		dataObj = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
		if (dataObj == (void *) 0 || dataObj->classInfo->num != (0x00000002))
		{
			;
			return (0x02000000);
		}
		if (engObj->base.parent->parent != dataObj->parent)
		{
			;
			return (0x02000000);
		}
		ctxDmaObj = (NvContextDmaObj *) dataObj;
		if (((((ctxDmaObj->memoryObj->base.classInfo->num) != (0x00000040))
					|| !(((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 31 : 8) % 32) +
									((0 ? 31 : 8) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& (((ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003D))
					|| !(((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
									32)) & (0xFFFFFFFF >> (31 -
									((1 ? 31 : 8) % 32) +
									((0 ? 31 : 8) % 32)))) ==
						(NV_PMC_BOOT_0)))
				&& (ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003E))
			|| (!(((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
								((1 ? 3 : 0) % 32) +
								((0 ? 3 : 0) % 32)))) ==
					(NV_PMC_BOOT_0))
				&& !(((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) %
								32)) & (0xFFFFFFFF >> (31 -
								((1 ? 3 : 0) % 32) +
								((0 ? 3 : 0) % 32)))) ==
					(0x00000001)))
			|| (!(((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
								((1 ? 7 : 4) % 32) +
								((0 ? 7 : 4) % 32)))) ==
					(NV_PMC_BOOT_0))
				&& !(((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) %
								32)) & (0xFFFFFFFF >> (31 -
								((1 ? 7 : 4) % 32) +
								((0 ? 7 : 4) % 32)))) ==
					(0x00000001)))
			|| ((((unsigned long) (&ctxDmaObj->offset)->low) & 0x3ff) != 0x0)
			|| (((unsigned long) (&ctxDmaObj->limit)->low) < 0x3ff))
		{
			;
			;
			return (0x01000000);
		}
		if (dacObj->setCtxDmaLut[buf])
		{
			dacObj->setCtxDmaLut[buf]->base.refcnt--;
			;
		}
		ctxDmaObj->base.refcnt++;
		;
		dacObj->setCtxDmaLut[buf] = ctxDmaObj;
	}
	else
	{
		if (dacObj->setCtxDmaLut[buf])
		{
			dacObj->setCtxDmaLut[buf]->base.refcnt--;
			;
		}
		dacObj->setCtxDmaLut[buf] = (void *) 0;
	}
	return 0;
}
static NvV32
mthdSetContextDmaCursor (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	DacObj             *dacObj = (DacObj *) engObj;
	NvSession          *session = nvArchGetSessionFromObject (&engObj->base);
	GenericObj         *dataObj;
	NvContextDmaObj    *ctxDmaObj;
	int                 buf = (offset == 0x0194) ? 0 : 1;

	;
	if (dacObj->flags & 0x00000020)
		return (0x00800000);
	if (((dacObj->setCursor[buf].notifyType) != (NvV32) -1))
		return (0x00800000);
	if (data != (NV_PMC_BOOT_0))
	{
		dataObj = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
		if (dataObj == (void *) 0 || dataObj->classInfo->num != (0x00000002))
		{
			;
			return (0x02000000);
		}
		if (engObj->base.parent->parent != dataObj->parent)
		{
			;
			return (0x02000000);
		}
		ctxDmaObj = (NvContextDmaObj *) dataObj;
		;
		if ((((ctxDmaObj->memoryObj->base.classInfo->num) != (0x0000003F))
				|| !(((ctxDmaObj->usrFlags >> ((0 ? 31 : 8) %
								32)) & (0xFFFFFFFF >> (31 -
								((1 ? 31 : 8) % 32) +
								((0 ? 31 : 8) % 32)))) ==
					(NV_PMC_BOOT_0)))
			|| (!(((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
								((1 ? 3 : 0) % 32) +
								((0 ? 3 : 0) % 32)))) ==
					(NV_PMC_BOOT_0))
				&& !(((ctxDmaObj->usrFlags >> ((0 ? 3 : 0) %
								32)) & (0xFFFFFFFF >> (31 -
								((1 ? 3 : 0) % 32) +
								((0 ? 3 : 0) % 32)))) ==
					(0x00000001)))
			|| (!(((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
								((1 ? 7 : 4) % 32) +
								((0 ? 7 : 4) % 32)))) ==
					(NV_PMC_BOOT_0))
				&& !(((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) %
								32)) & (0xFFFFFFFF >> (31 -
								((1 ? 7 : 4) % 32) +
								((0 ? 7 : 4) % 32)))) ==
					(0x00000001)))
			|| ((((unsigned long) (&ctxDmaObj->offset)->low) & 0x7ff) != 0x0))
		{
			;
			;
			return (0x01000000);
		}
		if ((NvV32) ((&ctxDmaObj->memoryObj->usrAddr)->low +
				(unsigned long) (&ctxDmaObj->offset)->low) & 0x7ff)
		{
			;
			return (0x01000000);
		}
		if (dacObj->setCtxDmaCursor[buf])
		{
			dacObj->setCtxDmaCursor[buf]->base.refcnt--;
			;
		}
		ctxDmaObj->base.refcnt++;
		;
		dacObj->setCtxDmaCursor[buf] = ctxDmaObj;
	}
	else
	{
		if (dacObj->setCtxDmaCursor[buf])
		{
			dacObj->setCtxDmaCursor[buf]->base.refcnt--;
			;
		}
		dacObj->setCtxDmaCursor[buf] = (void *) 0;
	}
	return 0;
}
static NvV32
mthdGet (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	DacObj             *dacObj = (DacObj *) engObj;
	NvU32               scanline,
	                    getoffset = 0;
	int                 buf;
	NvV32               status = (0x01);

	;
	if (data == (NV_PMC_BOOT_0))
	{
		buf = 0;
	}
	else if (data == (0x00000001))
	{
		buf = 1;
	}
	else
	{
		;
		return (0x02000000);
	}
	if (((dacObj->setImage[buf].notifyType) != (NvV32) -1))
	{
		NvU32               height = (NvU32) -1;

		scanline =
			dacGetScanline (((NvDeviceInfo *) (((NvDeviceObj *) (((&dacObj->base))->
							base.parent->parent))->device->
					deviceInfo)));
		if (((dacObj->setImage[buf].notifyType) != (NvV32) -1))
		{
			if (((dacObj->setDac[0].notifyType) != (NvV32) -1))
				height = dacObj->setDac[0].imageHeight;
			else if (((dacObj->setDac[0].notifyType) != (NvV32) -1))
				height = dacObj->setDac[1].imageHeight;
			if ((height != (NvU32) -1) && (scanline <= height))
			{
				status = (0x02);
				getoffset =
					(scanline * dacObj->setImage[buf].pitch) +
					dacObj->setImage[buf].offset;
			}
		}
	}
	dacNotify (dacObj, 1, (0), getoffset, status);
	return 0;
}
static NvV32
mthdSetImage (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	DacObj             *dacObj = (DacObj *) engObj;
	int                 buf = ((offset - method->begin) > 7);
	NvU16               pitch,
	                    color,
	                    notifyType;

	;
	if (dacObj->flags & 0x00000010)
	{
		;
		return (0x00800000);
	}
	if (((dacObj->setImage[buf].notifyType) != (NvV32) -1))
	{
		;
		return (0x00800000);
	}
	if (dacObj->setPixelClock != 0)
	{
		if ((((dacObj->overheadImage * ((dacObj->setImage[buf].color ==
								(NV_PMC_BOOT_0)) ? 1 : ((dacObj->
									setImage[buf].color ==
									(0x00000003)) ? 4 : 2))) >>
					16) + (dacObj->overheadCursor * 2)) >
			(dacObj->limitBandwidth * 1000 / dacObj->setPixelClock))
		{
			;
			return (0x00400000);
		}
	}
	switch (offset - method->begin)
	{
		case 0x00:
		case 0x8:
			if (data & 0x3f)
			{
				;
				return (0x02000000);
			}
			;
			dacObj->setImage[buf].offset = data;
			break;
		case 0x04:
		case 0x0c:
			if ((dacObj->base.notifyCtxDma == (void *) 0)
				|| (dacObj->setCtxDmaImage[buf] == (void *) 0)
				|| (dacObj->setCtxDmaLut[buf] == (void *) 0))
			{
				;
				return (0x01000000);
			}
			pitch = (NvU16) ((data >> ((0 ? 15 : 0) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 15 : 0) % 32) + ((0 ? 15 : 0) % 32))));
			color = (NvU16) ((data >> ((0 ? 27 : 16) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 27 : 16) % 32) + ((0 ? 27 : 16) % 32))));
			notifyType =
				(NvU16) ((data >> ((0 ? 31 : 28) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 31 : 28) % 32) + ((0 ? 31 : 28) % 32))));
			;
			if (pitch & 0x3f || pitch > 16320)
			{
				;
				return (0x02000000);
			}
			if ((color != (NV_PMC_BOOT_0)) && (color != (0x00000001))
				&& (color != (0x00000002)) && (color != (0x00000003)))
			{
				;
				return (0x02000000);
			}
			if ((notifyType != (NV_PMC_BOOT_0)) && (notifyType != (0x00000001)))
			{
				;
				return (0x02000000);
			}
			dacObj->setImage[buf].pitch = pitch;
			dacObj->setImage[buf].color = color;
			dacObj->setImage[buf].notifyType = notifyType;
			(dacObj->flags =
				((dacObj->flags & ~((0xFFFFFFFF >> (31 - ((1 ? (11 + (buf * 4)) : (8
												+
												(buf * 4))) % 32) + ((0 ? (11 + (buf * 4)) : (8 + (buf * 4))) % 32))) << ((0 ? (11 + (buf * 4)) : (8 + (buf * 4))) % 32))) | (0x00000002) << ((0 ? (11 + (buf * 4)) : (8 + (buf * 4))) % 32)));
			if (dacEnableImageScan (dacObj))
				dacImageOnOff (((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->
									base.parent->parent))->
							device->deviceInfo)), 1);
			break;
	}
	return 0;
}
static NvV32
mthdSetCursor (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	DacObj             *dacObj = (DacObj *) engObj;
	int                 buf = ((offset - method->begin) > 0xb);
	NvS16               x,
	                    y;

	;
	if (dacObj->flags & 0x00000020)
	{
		;
		return (0x00800000);
	}
	if (((dacObj->setCursor[buf].notifyType) != (NvV32) -1))
	{
		;
		return (0x00800000);
	}
	switch (offset - method->begin)
	{
		case 0x0:
		case 0xc:
			if (data & 0x7ff)
			{
				;
				return (0x02000000);
			}
			dacObj->setCursor[buf].offset = data;
			break;
		case 0x4:
		case 0x10:
			x = (NvS16) ((data >> ((0 ? 15 : 0) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 15 : 0) % 32) + ((0 ? 15 : 0) % 32))));
			y = (NvS16) ((data >> ((0 ? 31 : 16) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 31 : 16) % 32) + ((0 ? 31 : 16) % 32))));
			if (x < -2048 || x > 2047 || y < -2048 || y > 2047)
			{
				;
				return (0x02000000);
			}
			dacObj->setCursor[buf].x = x;
			dacObj->setCursor[buf].y = y;
			break;
		case 0x8:
		case 0x14:
			if ((dacObj->base.notifyCtxDma == (void *) 0)
				|| (dacObj->setCtxDmaCursor[buf] == (void *) 0))
			{
				;
				return (0x01000000);
			}
			if ((data != (NV_PMC_BOOT_0)) && (data != (0x00000001)))
			{
				;
				return (0x02000000);
			}
			dacObj->setCursor[buf].notifyType = data;
			(dacObj->flags =
				((dacObj->flags & ~((0xFFFFFFFF >> (31 - ((1 ? (19 + (buf * 4))
											: (16 + (buf * 4))) % 32) + ((0 ? (19 + (buf * 4)) : (16 + (buf * 4))) % 32))) << ((0 ? (19 + (buf * 4)) : (16 + (buf * 4))) % 32))) | (0x00000002) << ((0 ? (19 + (buf * 4)) : (16 + (buf * 4))) % 32)));
			dacCursorOnOff (((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.
								parent->parent))->device->
						deviceInfo)), 1);
			break;
	}
	return 0;
}
static NvV32
mthdSetCursorPointOutA (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	DacObj             *dacObj = (DacObj *) engObj;
	int                 x,
	                    y;

	x = ((data >> ((0 ? 15 : 0) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 15 : 0) % 32) +
				((0 ? 15 : 0) % 32))));
	y = ((data >> ((0 ? 31 : 16) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 31 : 16) % 32) +
				((0 ? 31 : 16) % 32))));
	;
	if (x < -2048 || x > 2047 || y < -2048 || y > 2047)
	{
		;
		return (0x02000000);
	}
	dacObj->setCursor[0].x = x;
	dacObj->setCursor[1].x = x;
	dacObj->setCursor[0].y = y;
	dacObj->setCursor[1].y = y;
	dacObj->flags |= 0x00000002;
	return 0;
}
static NvV32
mthdSetDac (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	DacObj             *dacObj = (DacObj *) engObj;
	int                 arg1,
	                    arg2,
	                    arg3;
	int                 buf = ((offset - method->begin) > 0xf);

	;
	if (dacObj->flags & 0x00000040)
	{
		;
		return (0x00800000);
	}
	if (((dacObj->setDac[buf].notifyType) != (NvV32) -1))
	{
		;
		return (0x00800000);
	}
	switch (offset - method->begin)
	{
		case 0x00:
		case 0x10:
			arg1 = ((data >> ((0 ? 15 : 0) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 15 : 0) % 32) + ((0 ? 15 : 0) % 32))));
			arg2 = ((data >> ((0 ? 31 : 16) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 31 : 16) % 32) + ((0 ? 31 : 16) % 32))));
			;
			if (arg1 > 2048 || arg1 & 0x7 || arg2 > 2048)
			{
				;
				return (0x02000000);
			}
			dacObj->setDac[buf].imageWidth = arg1;
			dacObj->setDac[buf].imageHeight = arg2;
			break;
		case 0x04:
		case 0x14:
			arg1 = ((data >> ((0 ? 27 : 16) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 27 : 16) % 32) + ((0 ? 27 : 16) % 32))));
			arg2 = ((data >> ((0 ? 15 : 0) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 15 : 0) % 32) + ((0 ? 15 : 0) % 32))));
			arg3 = ((data >> ((0 ? 31 : 28) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 31 : 28) % 32) + ((0 ? 31 : 28) % 32))));
			;
			if (arg2 > 4088 || arg2 & 7 || arg1 > 256 || arg1 & 7)
			{
				;
				return (0x02000000);
			}
			if (arg3 > (0x00000001))
			{
				;
				return (0x02000000);
			}
			dacObj->setDac[buf].hSyncWidth = arg1;
			dacObj->setDac[buf].hSyncStart = arg2;
			dacObj->setDac[buf].hSyncPolarity = arg3;
			break;
		case 0x08:
		case 0x18:
			arg1 = ((data >> ((0 ? 27 : 16) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 27 : 16) % 32) + ((0 ? 27 : 16) % 32))));
			arg2 = ((data >> ((0 ? 15 : 0) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 15 : 0) % 32) + ((0 ? 15 : 0) % 32))));
			arg3 = ((data >> ((0 ? 31 : 28) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 31 : 28) % 32) + ((0 ? 31 : 28) % 32))));
			;
			if (arg1 > 16 || arg2 > 2047)
			{
				;
				return (0x02000000);
			}
			if (arg3 > (0x00000001))
			{
				;
				return (0x02000000);
			}
			dacObj->setDac[buf].vSyncWidth = arg1;
			dacObj->setDac[buf].vSyncStart = arg2;
			dacObj->setDac[buf].vSyncPolarity = arg3;
			break;
		case 0x0c:
		case 0x1c:
			if (dacObj->base.notifyCtxDma == (void *) 0)
			{
				;
				return (0x01000000);
			}
			arg1 = ((data >> ((0 ? 15 : 0) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 15 : 0) % 32) + ((0 ? 15 : 0) % 32))));
			arg2 = ((data >> ((0 ? 27 : 16) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 27 : 16) % 32) + ((0 ? 27 : 16) % 32))));
			arg3 = ((data >> ((0 ? 31 : 28) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 31 : 28) % 32) + ((0 ? 31 : 28) % 32))));
			;
			if (arg1 < 40 || arg1 > 4128 || arg1 & 7 || arg2 < 2 || arg2 > 2049)
			{
				;
				return (0x02000000);
			}
			if ((arg3 != (NV_PMC_BOOT_0)) && (arg3 != (0x00000001)))
			{
				;
				return (0x02000000);
			}
			dacObj->setDac[buf].totalWidth = arg1;
			dacObj->setDac[buf].totalHeight = arg2;
			dacObj->setDac[buf].notifyType = arg3;
			(dacObj->flags =
				((dacObj->flags & ~((0xFFFFFFFF >> (31 - ((1 ? (27 + (buf * 4))
											: (24 + (buf * 4))) % 32) + ((0 ? (27 + (buf * 4)) : (24 + (buf * 4))) % 32))) << ((0 ? (27 + (buf * 4)) : (24 + (buf * 4))) % 32))) | (0x00000002) << ((0 ? (27 + (buf * 4)) : (24 + (buf * 4))) % 32)));
			dacOnOff (((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->
								parent))->device->deviceInfo)), 1);
			if ((dacObj->flags & 0x00000001) == 0)
				dacVblankHandler (&engObj->base);
			break;
	}
	return 0;
}
static NvV32
mthdSetPixelClock (EngineObj *engObj, MethodInfo *method, NvV32 offset, NvV32 data, int cause)
{
	DacObj             *dacObj = (DacObj *) engObj;

	;
	if (data > dacObj->limitPixelClock)
	{
		;
		return (0x02000000);
	}
	if (data != 0)
	{
		if ((((dacObj->overheadImage * ((((dacObj->setImage[0].color == (NV_PMC_BOOT_0)) ? 1
									: ((dacObj->setImage[0].
											color ==
											(0x00000003))
										? 4 : 2)) >
								((dacObj->setImage[1].color ==
										(NV_PMC_BOOT_0)) ? 1
									: ((dacObj->setImage[1].
											color ==
											(0x00000003))
										? 4 : 2)))
							? ((dacObj->setImage[0].color ==
									(NV_PMC_BOOT_0)) ? 1
								: ((dacObj->setImage[0].color ==
										(0x00000003)) ? 4 :
									2)) : ((dacObj->setImage[1].
									color ==
									(NV_PMC_BOOT_0)) ? 1
								: ((dacObj->setImage[1].color ==
										(0x00000003)) ? 4 :
									2)))) >> 16) +
				(dacObj->overheadCursor * 2)) >
			(dacObj->limitBandwidth * 1000 / data))
		{
			;
			return (0x00400000);
		}
	}
	dacObj->setPixelClock = data;
	dacSetPixelClock (((NvDeviceInfo *) (((NvDeviceObj *) (((engObj))->base.parent->parent))->
				device->deviceInfo)), data);
	return 0;
}

NvV32
allocNv03VideoLutCursorDac (GenericObj *genericObj, NvClassAllocParameters *alloc)
{
	Nv0046AllocParameters *ap = (Nv0046AllocParameters *) alloc;
	DacObj             *dacObj = (DacObj *) genericObj;
	HwDeviceInfo       *hwdev =
		(HwDeviceInfo *) ((NvDeviceInfo *) (((NvDeviceObj *) (((&dacObj->base))->base.
					parent->parent))->device->deviceInfo));
	int                 i;

	;
	if (hwdev->info.Framebuffer.RawBandwidth == 0)
	{
		;
		return (0x00000002);
	}
	if (ap->portId != 0)
	{
		;
		return (0x00000002);
	}
	if (hwdev->info.Dac.PortIdAllocMask & (1 << ap->portId))
	{
		;
		return (0x00000002);
	}
	hwdev->info.Dac.PortIdAllocMask |= (1 << ap->portId);
	dacObj->flags = 0;
	dacObj->portId = ap->portId;
	dacObj->setPixelClock = 0;
	;
	dacObj->overheadImage =
		(1 << 16) +
		((((10 << 16) * hwdev->info.Framebuffer.BusWidth) >> 7) /
		hwdev->info.Framebuffer.ImageBurst);
	dacObj->overheadCursor = 0;
	dacObj->limitPixelClock =
		((ap->limitPixelClock <
			hwdev->info.Framebuffer.Pipeline *
			1000000) ? ap->limitPixelClock : hwdev->info.Framebuffer.Pipeline *
		1000000);
	dacObj->limitBandwidth =
		((ap->limitBandwidth <
			hwdev->info.Framebuffer.RawBandwidth >> 10) ? ap->limitBandwidth : hwdev->
		info.Framebuffer.RawBandwidth >> 10);
	;
	;
	dacObj->limitBandwidth =
		((dacObj->limitBandwidth <
			((dacObj->limitPixelClock / 1000) *
				((dacObj->overheadImage << 2) >> 16))) ? dacObj->
		limitBandwidth : ((dacObj->limitPixelClock / 1000) *
			((dacObj->overheadImage << 2) >> 16)));
	hwdev->info.Framebuffer.RawBandwidth -= (dacObj->limitBandwidth << 10);
	ap->limitPixelClock = dacObj->limitPixelClock;
	ap->limitBandwidth = dacObj->limitBandwidth;
	ap->overheadImage = dacObj->overheadImage;
	ap->overheadCursor = dacObj->overheadCursor;
	;
	;
	for (i = 0; i < 2; i++)
	{
		dacObj->setCtxDmaImage[i] = (void *) 0;
		dacObj->setCtxDmaLut[i] = (void *) 0;
		dacObj->setCtxDmaCursor[i] = (void *) 0;
		dacObj->setImage[i].offset = 0;
		dacObj->setImage[i].color = 0;
		dacObj->setImage[i].pitch = 0;
		(*(&dacObj->setImage[i].notifyType) = -1);
		dacObj->setDac[i].imageWidth = 0;
		dacObj->setDac[i].imageHeight = 0;
		dacObj->setDac[i].hSyncStart = 0;
		dacObj->setDac[i].hSyncWidth = 0;
		dacObj->setDac[i].hSyncPolarity = (NV_PMC_BOOT_0);
		dacObj->setDac[i].vSyncStart = 0;
		dacObj->setDac[i].vSyncWidth = 0;
		dacObj->setDac[i].vSyncPolarity = (NV_PMC_BOOT_0);
		dacObj->setDac[i].totalHeight = 0;
		dacObj->setDac[i].totalWidth = 0;
		dacObj->setDac[i].cachedPitch = 0;
		(*(&dacObj->setDac[i].notifyType) = -1);
		dacObj->setCursor[i].offset = 0;
		dacObj->setCursor[i].x = 0;
		dacObj->setCursor[i].y = 0;
		(*(&dacObj->setCursor[i].notifyType) = -1);
	}
	return 0;
}

NvV32
attachNv03VideoLutCursorDac (GenericObj *genericObj, NvClassAllocParameters *alloc)
{
	DacObj             *dacObj = (DacObj *) genericObj;
	NvDeviceInfo       *dev =
		((NvDeviceInfo *) (((NvDeviceObj *) (((&dacObj->base))->base.parent->parent))->
			device->deviceInfo));
	devAddVblankHandler (dev, genericObj, dacVblankHandler, &dacObj->vinfo);
	return swAttachEngineObject (genericObj, alloc);
}

NvV32
detachNv03VideoLutCursorDac (GenericObj *genericObj)
{
	DacObj             *dacObj = (DacObj *) genericObj;
	NvDeviceInfo       *dev =
		((NvDeviceInfo *) (((NvDeviceObj *) (((&dacObj->base))->base.parent->parent))->
			device->deviceInfo));
	devReleaseVblankHandler (dev, genericObj);
	dacImageOnOff (dev, 0);
	dacCursorOnOff (dev, 0);
	dacOnOff (dev, 0);
	dacSetPixelClock (dev, 0);
	return swDetachEngineObject (genericObj);
}

NvV32
freeNv03VideoLutCursorDac (GenericObj *genericObj)
{
	DacObj             *dacObj = (DacObj *) genericObj;
	HwDeviceInfo       *hwdev =
		(HwDeviceInfo *) ((NvDeviceInfo *) (((NvDeviceObj *) (((&dacObj->base))->base.
					parent->parent))->device->deviceInfo));
	int                 buf;

	for (buf = 0; buf < 2; buf++)
	{
		if (dacObj->setCtxDmaImage[buf])
			dacObj->setCtxDmaImage[buf]->base.refcnt--;
		if (dacObj->setCtxDmaLut[buf])
			dacObj->setCtxDmaLut[buf]->base.refcnt--;
		if (dacObj->setCtxDmaCursor[buf])
			dacObj->setCtxDmaCursor[buf]->base.refcnt--;
	}
	hwdev->info.Framebuffer.RawBandwidth += (dacObj->limitBandwidth << 10);
	hwdev->info.Dac.PortIdAllocMask &= ~(1 << dacObj->portId);
	return 0;
}

MethodInfo          Nv03VideoLutCursorDacMethods[] = {
	{mthdSynchronize, "Synchronize", 0x0100, 0x0103}, {mthdStopImage, "StopImage", 0x0104,
			0x0107}, {mthdStopCursor, "StopCursor", 0x0108, 0x010b}, {mthdStopDac,
			"StopDac", 0x010c, 0x010f}, {mthdSetContextDmaNotifies,
			"SetContextDmaNotifies", 0x0180, 0x0183}, {mthdSetContextDmaImage,
			"SetContextDmaImage", 0x0184, 0x018b}, {mthdSetContextDmaLut,
			"SetContextDmaLut", 0x018c, 0x0193}, {mthdSetContextDmaCursor,
			"SetContextDmaCursor", 0x0194, 0x019b}, {mthdGet, "Get", 0x02fc, 0x02ff},
		{mthdSetImage, "SetImage", 0x0300, 0x030f}, {mthdSetCursor, "SetCursor", 0x0340,
			0x0357}, {mthdSetCursorPointOutA, "SetCursorPointOutA", 0x0358, 0x035b},
		{mthdSetDac, "SetDac", 0x0380, 0x039f}, {mthdSetPixelClock, "SetPixelClock", 0x03a0,
			0x03a3}
};
static EngineObjInfo Nv03VideoLutCursorDacObjInfo = {
	((NV_PMC_BOOT_0) << ((0 ? (1 * 32 + 17) : (1 * 32 + 16)) & 31)), 0, {(0x00000046), 0x0,
			0x0}, (void *) 0
};
ClassInfo           Nv03VideoLutCursorDacClassInfo = {
	(0x00000046), "NV03 video LUT cursor DAC", sizeof (DacObj), 0x1, 16,
		&Nv03VideoLutCursorDacObjInfo, (void *) 0, allocNv03VideoLutCursorDac,
		attachNv03VideoLutCursorDac, (void *) 0, freeNv03VideoLutCursorDac,
		detachNv03VideoLutCursorDac, (void *) 0, 0, (void *) 0,
		(sizeof (Nv03VideoLutCursorDacMethods) / sizeof (Nv03VideoLutCursorDacMethods[0])),
		Nv03VideoLutCursorDacMethods
};
