 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"


NvV32               Nv01AllocContextDma (GenericObj *, NvClassAllocParameters *);
NvV32               Nv01AttachContextDma (GenericObj *, NvClassAllocParameters *);
NvV32               Nv01FreeContextDma (GenericObj *);
NvV32               Nv01DetachContextDma (GenericObj *);
static NvV32
nvContextDmaCheckFlags (NvV32 usrFlags, NvV32 memFlags, NvContextDmaObj *ctxdma)
{
	NvV32               memPages;
	NvV32               busAccRead,
	                    busAccWrite;
	NvV32               memAccRead,
	                    memAccWrite;
	NvV32               tmpAccRead0,
	                    tmpAccRead1,
	                    tmpAccRead2,
	                    tmpAccRead3;
	NvV32               tmpAccWrite0,
	                    tmpAccWrite1,
	                    tmpAccWrite2,
	                    tmpAccWrite3;
	NvOs8e0Info        *info = ctxdma->info;
	unsigned            i;

	;
	if (((memFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 7 : 4) % 32) +
					((0 ? 7 : 4) % 32)))) == (0x00000001))
		tmpAccRead0 = 0x02;
	else
		tmpAccRead0 = 0x01;
	if (((memFlags >> ((0 ? 11 : 8) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 11 : 8) % 32) +
					((0 ? 11 : 8) % 32)))) == (0x00000001))
		tmpAccWrite0 = 0x02;
	else
		tmpAccWrite0 = 0x01;
	tmpAccRead1 = 0x02;
	tmpAccRead2 = 0x02;
	tmpAccWrite1 = 0x02;
	tmpAccWrite2 = 0x02;
	memPages =
		((memFlags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 3 : 0) % 32) +
				((0 ? 3 : 0) % 32))));
	if ((memPages == (NV_PMC_BOOT_0) || memPages == (0x00000001)) && info)
	{
		for (i = 0; i < ctxdma->pteCount; i++)
		{
			memAccRead =
				((info[i].flags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 3 : 0) % 32) + ((0 ? 3 : 0) % 32))));
			memAccWrite =
				((info[i].flags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 7 : 4) % 32) + ((0 ? 7 : 4) % 32))));
			busAccRead =
				((info[i].flags >> ((0 ? 11 : 8) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 11 : 8) % 32) + ((0 ? 11 : 8) % 32))));
			busAccWrite =
				((info[i].flags >> ((0 ? 31 : 12) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 31 : 12) % 32) + ((0 ? 31 : 12) % 32))));
			if (memAccRead != (0x00000001))
				tmpAccRead1 = 0x01;
			if (memAccWrite != (0x00000001))
				tmpAccWrite1 = 0x01;
			if (busAccRead != (0x00000001))
				tmpAccRead2 = 0x01;
			if (busAccWrite != (0x00000001))
				tmpAccWrite2 = 0x01;
		}
		if ((tmpAccRead0 & tmpAccRead1 & tmpAccRead2) == 0x02)
			tmpAccRead3 = 0x02;
		else
			tmpAccRead3 = 0x01;
		if ((tmpAccWrite0 & tmpAccWrite1 & tmpAccWrite2) == 0x02)
			tmpAccWrite3 = 0x02;
		else
			tmpAccWrite3 = 0x01;
	}
	else
	{
		tmpAccRead3 = tmpAccRead0;
		tmpAccWrite3 = tmpAccWrite0;
	}
	if (((usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 7 : 4) % 32) +
					((0 ? 7 : 4) % 32)))) == (NV_PMC_BOOT_0))
	{
		if ((tmpAccRead3 & tmpAccWrite3) != 0x02)
			return (0x00000002);
	}
	else if (((usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 7 : 4) % 32) +
					((0 ? 7 : 4) % 32)))) == (0x00000001))
	{
		if (tmpAccRead3 != 0x02)
			return (0x00000002);
	}
	else if (((usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 7 : 4) % 32) +
					((0 ? 7 : 4) % 32)))) == (0x00000002))
	{
		if (tmpAccWrite3 != 0x02)
			return (0x00000002);
	}
	if ((((usrFlags >> ((0 ? 31 : 8) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 31 : 8) % 32) +
						((0 ? 31 : 8) % 32)))) == (NV_PMC_BOOT_0))
		&& (((memFlags >> ((0 ? 31 : 12) % 32)) & (0xFFFFFFFF >> (31 -
						((1 ? 31 : 12) % 32) + ((0 ? 31 : 12) % 32)))) !=
			(0x00000001)))
		return (0x00000002);
	return (NV_PMC_BOOT_0);
}

NvV32
Nv01AllocContextDma (GenericObj *obj, NvClassAllocParameters *alloc)
{
	Nv0002AllocParameters *allocDma = (Nv0002AllocParameters *) alloc;
	NvContextDmaObj    *ctxdma = (NvContextDmaObj *) obj;
	NvDevice           *device;
	NvMemoryObj        *memoryObj;
	NvSession          *session = nvArchGetSessionFromObject (obj);
	NvP64               base,
	                    alignedBase;
	NvU64               limit,
	                    alignedLimit;
	NvU32               dmaAddr;
	NvV32               memoryId,
	                    flags;
	NvV32               status;

	;
	;
	memoryObj =
		(NvMemoryObj *) (nvArchDevFuncTable->nvArchLookupObjectByName) (session,
		allocDma->objectMemory);
	if (memoryObj == (void *) 0)
	{
		;
		return (0x00000005);
	}
	if ((memoryObj->base.classInfo->num != (0x0000003E))
		&& (memoryObj->base.classInfo->num != (0x00000040))
		&& (memoryObj->base.classInfo->num != (0x0000003D))
		&& (memoryObj->base.classInfo->num != (0x0000003F)))
	{
		;
		return (0x00000005);
	}
	;
	flags = ((allocDma->flags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 3 : 0) % 32) +
				((0 ? 3 : 0) % 32))));
	if ((flags != (NV_PMC_BOOT_0)) && (flags != (0x00000001)) && (flags != (0x00000002))
		&& (flags != (0x00000003)))
	{
		;
		return (0x00000006);
	}
	flags = ((allocDma->flags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 - ((1 ? 7 : 4) % 32) +
				((0 ? 7 : 4) % 32))));
	if ((flags != (NV_PMC_BOOT_0)) && (flags != (0x00000001)) && (flags != (0x00000002)))
	{
		;
		return (0x00000007);
	}
	flags = ((allocDma->flags >> ((0 ? 31 : 8) % 32)) & (0xFFFFFFFF >> (31 -
				((1 ? 31 : 8) % 32) + ((0 ? 31 : 8) % 32))));
	if ((flags != (NV_PMC_BOOT_0)) && (flags != (0x00000001)))
	{
		;
		return (0x00000008);
	}
	if (((unsigned long) (&allocDma->offset)->low & 0x3f)
		|| ((unsigned long) (&allocDma->offset)->low >
			(unsigned long) (&memoryObj->limit)->low))
	{
		;
		return (0x00000009);
	}
	if ((((unsigned long) (&allocDma->limit)->low + 1) & 0x3f)
		|| (((unsigned long) (&allocDma->offset)->low +
				(unsigned long) (&allocDma->limit)->low >
				(unsigned long) (&memoryObj->limit)->low)))
	{
		;
		return (0x0000000A);
	}
	ctxdma->flags = 0;
	ctxdma->memoryObj = memoryObj;
	ctxdma->usrFlags = allocDma->flags;
	ctxdma->offset = allocDma->offset;
	ctxdma->limit = allocDma->limit;
	ctxdma->contextDmaId = 0;
	ctxdma->mappingId = 0;
	dmaAddr =
		(NvU32) ((&ctxdma->memoryObj->usrAddr)->low +
		(unsigned long) (&ctxdma->offset)->low);
	device = ((NvDeviceObj *) obj->parent)->device;
	ctxdma->instOffset = 0;
	ctxdma->pteAdjust =
		dmaAddr & ((1 << (32 - ((1 ? (2 * 32 + 31) : (2 * 32 + 12)) - (0 ? (2 * 32 +
							31) : (2 * 32 + 12)) + 1))) - 1);
	ctxdma->pteLimit = ctxdma->pteAdjust + (unsigned long) (&ctxdma->limit)->low;
	ctxdma->pteCount =
		(((NvV32) ctxdma->pteLimit >> (32 - ((1 ? (2 * 32 + 31) : (2 * 32 + 12)) -
					(0 ? (2 * 32 + 31) : (2 * 32 + 12)) + 1))) +
		(((NvV32) ctxdma->pteLimit & ((1 << (32 - ((1 ? (2 * 32 + 31) : (2 * 32 + 12)) -
								(0 ? (2 * 32 + 31) : (2 * 32 +
										12)) + 1))) - 1)) !=
			0));
	(&alignedBase)->low =
		(unsigned long) ((void *) (dmaAddr & ~((1 << (32 - ((1 ? (2 * 32 + 31) : (2 * 32 +
									12)) - (0 ? (2 * 32 +
									31) : (2 * 32 + 12)) +
							1))) - 1)));
	(&alignedLimit)->high = 0, (&alignedLimit)->low =
		(NvU32) ((ctxdma->pteCount * (1 << (32 - ((1 ? (2 * 32 + 31) : (2 * 32 + 12)) -
						(0 ? (2 * 32 + 31) : (2 * 32 + 12)) + 1)))) - 1);
	memoryObj->base.refcnt++;
	;
	if (memoryObj->base.parent != obj->parent)
	{
		NvV32               deviceId;

		flags = ((allocDma->flags >> ((0 ? 3 : 0) % 32)) & (0xFFFFFFFF >> (31 -
					((1 ? 3 : 0) % 32) + ((0 ? 3 : 0) % 32))));
		if ((flags == (NV_PMC_BOOT_0)) || (flags == (0x00000001)))
		{
			(&limit)->high = 0, (&limit)->low =
				(NvU32) (ctxdma->pteCount * sizeof (NvOs8e0Info) - 1);
			status = nvArchMemoryAllocKernel (&base, limit, &memoryId);
			if (status != (NV_PMC_BOOT_0))
			{
				;
				memoryObj->base.refcnt--;
				return (0x00000002);
			}
			deviceId = device->deviceId;
		}
		else
		{
			(&base)->low = (unsigned long) (0);
			deviceId = 0;
		}
		if (flags == (NV_PMC_BOOT_0))
			flags = ((NV_PMC_BOOT_0) << ((0 ? 3 : 0) % 32));
		else if (flags == (0x00000001))
			flags = ((0x00000001) << ((0 ? 3 : 0) % 32));
		else if (flags == (0x00000002))
			flags = ((0x00000002) << ((0 ? 3 : 0) % 32));
		else
			flags = ((0x00000003) << ((0 ? 3 : 0) % 32));
		status = nvArchContextDmaSystemAlloc (alignedBase, alignedLimit, &flags, base,
			deviceId, &ctxdma->contextDmaId);
		if (status != (NV_PMC_BOOT_0))
		{
			;
			memoryObj->base.refcnt--;
			nvArchMemoryFree (memoryId);
			if (status == (0x00000006))
				return (0x00000009);
			if (status == (0x00000007))
				return (0x0000000A);
			return (0x00000002);
		}
		ctxdma->info = (NvOs8e0Info *) (&base)->low;
		ctxdma->infoId = memoryId;
	}
	else
	{
		flags = (((NV_PMC_BOOT_0) << ((0 ? 3 : 0) % 32)) | ((0x00000001) << ((0 ? 7 : 4) %
					32)) | ((0x00000001) << ((0 ? 11 : 8) %
					32)) | ((0x00000001) << ((0 ? 31 : 12) % 32)));
		ctxdma->info = (void *) 0;
		ctxdma->infoId = 0;
	}
	status = nvContextDmaCheckFlags (allocDma->flags, flags, ctxdma);
	if (status != (NV_PMC_BOOT_0))
	{
		;
		ctxdma->memoryObj->base.refcnt--;
		if (ctxdma->infoId)
			nvArchMemoryFree (ctxdma->infoId);
		if (ctxdma->contextDmaId)
			(void) nvArchContextDmaSystemFree (ctxdma->contextDmaId);
		return status;
	}
	if (memoryObj->base.parent != obj->parent)
	{
		memoryObj->kernAddr = alignedBase;
		flags = (((0x00000003) << ((0 ? 3 : 0) % 32)) | ((NV_PMC_BOOT_0) << ((0 ? 7 : 4) %
					32)) | ((0x00000003) << ((0 ? 31 : 8) % 32)));
		status = nvArchMappingAllocUserToKern (&memoryObj->kernAddr, alignedLimit, flags,
			&ctxdma->mappingId);
		if (status != (NV_PMC_BOOT_0))
			return (0x00000002);
	}
	return (NV_PMC_BOOT_0);
}

NvV32
Nv01AttachContextDma (GenericObj *obj, NvClassAllocParameters *alloc)
{
	NvContextDmaObj    *ctxdma = (NvContextDmaObj *) obj;
	NvDeviceObj        *deviceObj = (NvDeviceObj *) obj->parent;
	NvDevice           *device = deviceObj->device;
	NvV32               status;

	status = devDmaAllocate (device->deviceInfo, ctxdma);
	if (status != 0)
		status = (0x00000002);
	else
		status = (NV_PMC_BOOT_0);
	if (ctxdma->infoId)
	{
		;
		nvArchLockRelease (0x01);
		nvArchMemoryFree (ctxdma->infoId);
		nvArchLockAcquire (0x01);
	}
	return status;
}

NvV32
Nv01FreeContextDma (GenericObj *obj)
{
	NvContextDmaObj    *ctxdma = (NvContextDmaObj *) obj;

	;
	;
	if (ctxdma->memoryObj)
		ctxdma->memoryObj->base.refcnt--;
	if (ctxdma->contextDmaId)
		(void) nvArchContextDmaSystemFree (ctxdma->contextDmaId);
	if (ctxdma->mappingId)
		(void) nvArchMappingFree (ctxdma->mappingId);
	return (NV_PMC_BOOT_0);
}

NvV32
Nv01DetachContextDma (GenericObj *obj)
{
	NvContextDmaObj    *ctxdma = (NvContextDmaObj *) obj;
	NvDeviceObj        *deviceObj = (NvDeviceObj *) obj->parent;
	NvDevice           *device = deviceObj->device;

	;
	devDmaFree (device->deviceInfo, ctxdma);
	return (NV_PMC_BOOT_0);
}

ClassInfo           Nv01ContextDmaClassInfo = {
	(0x00000002), "context dma", sizeof (NvContextDmaObj), 0x10, 1, (void *) 0, (void *) 0,
		Nv01AllocContextDma, Nv01AttachContextDma, (void *) 0, Nv01FreeContextDma,
		Nv01DetachContextDma, (void *) 0, 0, (void *) 0, 0, (void *) 0
};
