 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


NvV32
ctrlSetObject (NvDeviceInfo *device, NvU32 chid, NvU32 subChannel, NvU32 offset, NvV32 data)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwReg              *hwreg = ((hwdev)->base.nvAddr);
	HwReg              *hwram = ((hwdev)->base.imAddr);
	NvU32               fifoContextBase = hwdev->info.Pram.FifoContextAddr;
	NvU32               activeChid;
	NvChannelInfo      *channel = &hwdev->channel[chid].base;
	GenericObj         *object;
	EngineObj          *engineObj;
	NvV32               context;
	NvSession          *session;

	;
	session = nvArchGetSessionFromObject (&hwdev->channel[chid].base.object->base);
	object = (nvArchDevFuncTable->nvArchLookupObjectByName) (session, data);
	if (object)
	{
		if (object->parent == &channel->object->base)
		{
			;
		}
		else
		{
			;
			return (0x02000000);
		}
	}
	else
	{
		;
		return (0x02000000);
	}
	engineObj = (EngineObj *) object;
	engineObj->subChannel = subChannel;
	channel->subChannel[subChannel] = engineObj;
	fifoAddHashEntry (device, engineObj);
	context = engineObj->context;
	if (object->mask & 0x1000)
	{
		;
		context &= ~((0x00000001) << ((0 ? (1 * 32 + 23) : (1 * 32 + 23)) & 31));
	}
	activeChid =
		(((((hwreg)->Reg32[(NV_PFIFO_CACHE1_PUSH1) / 4])) >> ((0 ? 6 : 0) %
				32)) & (0xFFFFFFFF >> (31 - ((1 ? 6 : 0) % 32) +
				((0 ? 6 : 0) % 32))));
	if (activeChid == chid)
	{
		(hwreg)->Reg32[((0x00003280 + (subChannel) * 16)) / 4] = (NvV32) (context);
		(hwreg)->Reg32[(NV_PFIFO_CACHE1_PULL1) / 4] =
			(NvV32) (((0x00000001) << ((0 ? 4 : 4) % 32)));
	}
	else
	{
		(hwram)->Reg32[(fifoContextBase + 4 * ((chid * 8) + subChannel) -
				(0 ? 0x01FFFFFF : 0x01C00000)) / 4] = (NvV32) (context);
	}
	if (engineObj->context & ((0x00000001) << ((0 ? (1 * 32 + 23) : (1 * 32 + 23)) & 31)))
	{
		;
		fifoResend (device, engineObj, 0x0, object->name);
		if (object->mask & 0x1000)
		{
			fifoRemoveHashEntry (device, engineObj);
		}
	}
	return 0;
}

NvV32
ctrlSoftwareMethod (NvDeviceInfo *device, NvU32 chid, NvU32 subChannel, NvU32 offset, NvV32 data)
{
	switch (offset)
	{
		case 0x0:
			return ctrlSetObject (device, chid, subChannel, offset, data);
	}
	;
	;
	;
	;
	;
	return (0x08000000);
}
