typedef struct _MemBank MemBank;
typedef struct _MemBlock MemBlock;
typedef struct _MemPool MemPool;
typedef struct _MemClassInfo MemClassInfo;
struct _MemBank
{
	NvU32               offset;
	NvU32               size;
};
struct _MemBlock
{
	NvV32               memoryId;
	NvU32               owner;
	NvU32               begin;
	NvU32               end;
	MemBlock           *prevFree;
	MemBlock           *nextFree;
	MemBlock           *prev;
	MemBlock           *next;
};
struct _MemPool
{
	NvV32               memoryId;
	NvU8               *base;
	NvU32               total;
	NvU32               free;
	MemBlock           *blockListHead;
	MemBlock           *blockListTail;
	MemBlock           *freeBlockListHead;
	MemBlock           *freeBlockListTail;
	NvU32               numBanks;
	MemBank             bank[1];
};
struct _MemClassInfo
{
	NvU32               classNum;
	NvU32               baseAlign;
	NvU32               limitAlign;
	NvU32               flags;
};
extern NvV32        fbMemPoolCreate (NvDeviceInfo *);
extern NvV32        fbMemPoolDestroy (NvDeviceInfo *);
extern NvV32        fbMemAlloc (NvDeviceInfo *, NvU32, NvU32, NvU32 *, NvU32 *, NvU32);
extern NvV32        fbMemFree (NvDeviceInfo *, NvU32);
typedef struct _HashTableEntry
{
	NvV32               name;
	NvV32               context;
} HashTableEntry;
typedef struct _def_nv4_hw_info
{
	struct _def_chip_info
	{
		char                ID[32];
		NvU32               SavePmc;
		NvU32               SaveIntrEn0;
		NvU32               IntrEn0;
		NvU32               Implementation;
		NvU32               Revision;
		NvU32               Architecture;
		NvU32               Manufacturer;
		NvU32               Subrevision;
		NvU32               MaskRevision;
		NvU32               Bus;
		NvU32               NVAGPEnabled;
		NvU32               CrystalFreq;
		NvU32               ChipToken[2];
		NvU32               ServiceCount;
		NvU32               ServiceTimeLo;
		NvU32               ServiceTimeHi;
		NvU32               ExceptionTimeLo;
		NvU32               ExceptionTimeHi;
	} Chip;
	struct _def_pram_info
	{
		NvU32               ConfigReg;
		NvU32               HashDepth;
		NvU32               RunOutMask;
		NvU32               FreeInstSize;
		NvU32               FreeInstBase;
		NvU32               FreeInstMax;
		NvU32               CurrentSize;
		NvU32               PrivBase;
		NvU32               UpdateFlags;
		NvU32               FinishFlags;
		NvU32               HashTableAddr;
		NvU32               FifoRunoutAddr;
		NvU32               FifoContextAddr;
		NvU32               AudioScratchAddr;
		NvU32               AuthScratchAddr;
		NvU8               *FbInstBitMap;
		NvV32               FbInstBitMapId;
	} Pram;
	struct _def_fifo_info
	{
		NvU32               ServiceCount;
		NvU32               AllocateCount;
		NvU32               RetryCount;
		NvU32               Count;
		NvU32               UpdateFlags;
		NvU32               FinishFlags;
		NvU32               TimeSlice;
		NvU32               DmaFetchTrigger;
		NvU32               DmaFetchSize;
		NvU32               DmaFetchMaxReqs;
		NvU32               Mode;
		NvU32               Size;
		NvU32               CurrentChID;
	} Fifo;
	struct _def_framebuffer_info
	{
		NvU32               RamType;
		NvU32               RamSizeMb;
		NvU32               RamSize;
		NvU32               ConfigReg;
		NvU32               BusWidth;
		NvU32               RawBandwidth;
		NvU32               Pipeline;
		NvU32               LimitOverlayDsDx;
		NvU32               LimitOverlayDtDy;
		NvU32               ImageBurst;
		NvU32               CursorBurst;
		NvU32               OverlayBurst;
		NvU32               BankCount;
		MemPool            *FbMemPool;
		NvV32               FbMemPoolId;
	} Framebuffer;
	struct _def_graphics_info
	{
		NvU32               Debug0;
		NvU32               Debug1;
		NvU32               Debug2;
		NvU32               Debug3;
		NvU32               CurrentChID;
		NvU32               Count;
		NvU32               CanvasCount;
		NvU32               Enabled;
		NvU32               ServiceCount;
		NvU32               ComplexClipCount;
		NvU32               UpdateFlags;
		NvU32               FinishFlags;
	} Graphics;
	struct _def_mediaport_info
	{
		VideoVbiPortObj    *CurrVideoVbiPort;
		VideoInputPortObj  *CurrVideoInputPort;
		DataOutputPortObj  *CurrDataOutputPort;
		IntrPortObj        *CurrIntrPort;
		IoPortObj          *CurrIoPort;
		NvU32               Enabled;
		NvU32               MPCPresent;
		NvU32               MPCDeviceAddr;
		NvU32               ServiceCount;
	} MediaPort;
	struct _def_dac_info
	{
		NvU32               PortIdAllocMask;
		NvU32               InputWidth;
		NvU32               PClkVClkRatio;
		NvU32               VClk;
		NvU32               MClk;
		NvU32               PClk;
		NvU32               NVClk;
		NvU32               VPllM;
		NvU32               VPllN;
		NvU32               VPllO;
		NvU32               VPllP;
		NvU32               MPllM;
		NvU32               MPllN;
		NvU32               MPllO;
		NvU32               MPllP;
		NvU32               NVPllM;
		NvU32               NVPllN;
		NvU32               NVPllO;
		NvU32               NVPllP;
	} Dac;
	struct _def_dgp_chip_info
	{
		NvU32               Chip;
		NvU32               Enable3D;
		NvU32               Scale;
		NvU32               HorizDelay;
		NvU32               HorizOffset;
		NvU32               HorizScale;
		NvU32               VertOffset;
		NvU32               VertScale;
		NvU32               UpdateFlags;
		NvU32               FinishFlags;
	} Dgp;
	struct _def_timer_info
	{
		NvU32               tmrSave[2];
		NvU32               Denominator;
		NvU32               Numerator;
		NvU32               ServiceCount;
		NvU32               UpdateFlags;
		NvU32               FinishFlags;
		TimerCallback      *CallbackTable;
		NvV32               CallbackTableId;
		TimerCallback      *CallbackList;
		TimerCallback      *CallbackFreeList;
	} Timer;
	struct _def_stat_info
	{
		NvU32               AudioExceptionCount;
		NvU32               FifoExceptionCount;
		NvU32               FramebufferExceptionCount;
		NvU32               GraphicsExceptionCount;
		NvU32               TimerExceptionCount;
		NvU32               TotalExceptionCount;
		NvU32               IntTimeLo;
		NvU32               IntTimeHi;
		NvU32               ExecTimeLo;
		NvU32               ExecTimeHi;
		NvU32               MemAlloced;
		NvU32               MemLocked;
		NvU32               UpdateLo;
		NvU32               UpdateHi;
	} Statistics;
	struct _def_null_info
	{
		char                ID[32];
	} Null;
} Nv4Info;
typedef struct
{
	NvU32               ctx_switch1;
	NvU32               ctx_switch2;
	NvU32               ctx_switch3;
	NvU32               ctx_switch4;
	NvU32               ctx_user;
	NvU32               ctx_cache1[8];
	NvU32               ctx_cache2[8];
	NvU32               ctx_cache3[8];
	NvU32               ctx_cache4[8];
	NvU32               abs_x_ram[32];
	NvU32               abs_y_ram[32];
	NvU32               x_misc;
	NvU32               y_misc;
	NvU32               valid1;
	NvU32               source_color;
	NvU32               misc24_0;
	NvU32               xy_logic_misc0;
	NvU32               xy_logic_misc1;
	NvU32               xy_logic_misc2;
	NvU32               xy_logic_misc3;
	NvU32               clipx_0;
	NvU32               clipx_1;
	NvU32               clipy_0;
	NvU32               clipy_1;
	NvU32               abs_iclip_xmax;
	NvU32               abs_iclip_ymax;
	NvU32               abs_uclip_xmin;
	NvU32               abs_uclip_ymin;
	NvU32               abs_uclip_xmax;
	NvU32               abs_uclip_ymax;
	NvU32               abs_uclipa_xmin;
	NvU32               abs_uclipa_ymin;
	NvU32               abs_uclipa_xmax;
	NvU32               abs_uclipa_ymax;
	NvU32               misc24_1;
	NvU32               misc24_2;
	NvU32               valid2;
	NvU32               passthru_0;
	NvU32               passthru_1;
	NvU32               passthru_2;
	NvU32               combine0alpha;
	NvU32               combine0color;
	NvU32               combine1alpha;
	NvU32               combine1color;
	NvU32               format0;
	NvU32               format1;
	NvU32               filter0;
	NvU32               filter1;
	NvU32               d3d_xy;
	NvU32               d3d_u0;
	NvU32               d3d_v0;
	NvU32               d3d_u1;
	NvU32               d3d_v1;
	NvU32               d3d_zeta;
	NvU32               d3d_rgb;
	NvU32               d3d_s;
	NvU32               d3d_m;
	NvU32               mono_color0;
	NvU32               rop3;
	NvU32               beta_and;
	NvU32               beta_premult;
	NvU32               formats;
	NvU32               boffset[6];
	NvU32               bbase[6];
	NvU32               bpitch[5];
	NvU32               blimit[6];
	NvU32               bswizzle2;
	NvU32               bswizzle5;
	NvU32               surface;
	NvU32               state;
	NvU32               notify;
	NvU32               bpixel;
	NvU32               dma_pitch;
	NvU32               dvd_colorfmt;
	NvU32               scaled_format;
	NvU32               patt_color0;
	NvU32               patt_color1;
	NvU32               pattern[2];
	NvU32               pattern_shape;
	NvU32               chroma;
	NvU32               control0;
	NvU32               control1;
	NvU32               control2;
	NvU32               blend;
	NvU32               stored_fmt;
	NvU32               patt_colorram[64];
	NvU32               u_ram[16];
	NvU32               v_ram[16];
	NvU32               m_ram[16];
	NvU32               dma_start_0;
	NvU32               dma_start_1;
	NvU32               dma_length;
	NvU32               dma_misc;
	NvU32               dma_data_0;
	NvU32               dma_data_1;
	NvU32               dma_rm;
	NvU32               dma_a_xlate_inst;
	NvU32               dma_a_control;
	NvU32               dma_a_limit;
	NvU32               dma_a_tlb_pte;
	NvU32               dma_a_tlb_tag;
	NvU32               dma_a_adj_offset;
	NvU32               dma_a_offset;
	NvU32               dma_a_size;
	NvU32               dma_a_y_size;
	NvU32               dma_b_xlate_inst;
	NvU32               dma_b_control;
	NvU32               dma_b_limit;
	NvU32               dma_b_tlb_pte;
	NvU32               dma_b_tlb_tag;
	NvU32               dma_b_adj_offset;
	NvU32               dma_b_offset;
	NvU32               dma_b_size;
	NvU32               dma_b_y_size;
} GrState;
typedef struct
{
	NvU32               dma_status;
} FifoState;
typedef struct
{
	NvChannelInfo       base;
	GrState             gr;
	FifoState           fifo;
	unsigned int        allocMask;
	GrNv03Surfaces2dObj *nv03Surfaces2d;
	GrNv03Surfaces3dObj *nv03Surfaces3d;
} HwChannelInfo;
typedef struct
{
	NvDeviceInfo        base;
	HwChannelInfo       channel[16];
	Nv4Info             info;
	EngineObj         **hashTable;
	NvV32               hashTableId;
} HwDeviceInfo;
extern ClassInfo    Nv01DeviceClassInfo;
extern ClassInfo    Nv01ContextDmaClassInfo;
extern ClassInfo    Nv03ChannelDmaClassInfo;
extern ClassInfo    Nv03ChannelPioClassInfo;
extern ClassInfo    Nv01MemoryLocalBankedClassInfo;
extern ClassInfo    Nv01MemoryLocalLinearClassInfo;
extern ClassInfo    Nv03MemoryLocalCursorClassInfo;
extern ClassInfo    Nv01MappingLocalClassInfo;
extern ClassInfo    Nv01ContextColorKeyClassInfo;
extern ClassInfo    Nv01ContextBeta1ClassInfo;
extern ClassInfo    Nv01ContextPatternClassInfo;
extern ClassInfo    Nv01ContextClipRectClassInfo;
extern ClassInfo    Nv01RenderSolidLinClassInfo;
extern ClassInfo    Nv01RenderSolidTriClassInfo;
extern ClassInfo    Nv01RenderSolidRectClassInfo;
extern ClassInfo    Nv01ImageFromCpuClassInfo;
extern ClassInfo    Nv01ContextRopClassInfo;
extern ClassInfo    Nv03Surfaces2dClassInfo;
extern ClassInfo    Nv03Surfaces3dClassInfo;
extern ClassInfo    Nv01ImageBlitClassInfo;
extern ClassInfo    Nv03StretchedImageFromCpuClassInfo;
extern ClassInfo    Nv03ScaledImageFromMemoryClassInfo;
extern ClassInfo    Nv03MemoryToMemoryFormatClassInfo;
extern ClassInfo    Nv03Dx3TexturedTriangleClassInfo;
extern ClassInfo    Nv03GdiRectangleTextClassInfo;
extern ClassInfo    Nv03VideoLutCursorPALClassInfo;
extern ClassInfo    Nv03VideoLutCursorNTSCClassInfo;
extern ClassInfo    Nv03VideoLutCursorDacClassInfo;
extern ClassInfo    Nv03VideoLutOverlayCursorDacClassInfo;
extern ClassInfo    Nv01TimerClassInfo;
extern ClassInfo    Nv03VideoVbiPortClassInfo;
extern ClassInfo    Nv03VideoInputPortClassInfo;
extern ClassInfo    Nv03DataOutputPortClassInfo;
extern ClassInfo    Nv03InterruptPortClassInfo;
extern ClassInfo    Nv03SerialPortClassInfo;
extern ClassInfo    Nv01ParallelPortClassInfo;
