typedef struct _def_node
{
	NvU32               Value;
	void               *Data;
	int                 LeftCount;
	int                 RightCount;
	struct _def_node   *LeftBranch;
	struct _def_node   *RightBranch;
} NODE             ,
                   *PNODE;
typedef unsigned RM_STATUS;
RM_STATUS           btreeInsertBranch (PNODE, PNODE);
RM_STATUS           btreeInsert (PNODE, PNODE *);
RM_STATUS           btreeDelete (NvU32, PNODE *);
RM_STATUS           btreeSearch (NvU32, PNODE *, PNODE);
RM_STATUS           btreeEnumStart (NvU32, PNODE *, PNODE);
RM_STATUS           btreeEnumNext (PNODE *, PNODE);
RM_STATUS           btreeBalanceBranch (PNODE *);
RM_STATUS           btreeBalance (PNODE *);
typedef union _HwReg
{
	volatile NvV8       Reg8[1];
	volatile NvV16      Reg16[1];
	volatile NvV32      Reg32[1];
} HwReg;
typedef void       *ObjectInfo;
typedef struct _GenericObj GenericObj;
typedef struct _NvRootObj NvRootObj;
typedef struct _MethodInfo MethodInfo;
typedef struct _ClassInfo ClassInfo;
typedef struct _NvSession NvSession;
typedef struct _NvDevice NvDevice;
typedef struct _NvDeviceInfo NvDeviceInfo;
typedef struct _NvArchInfo NvArchInfo;
typedef struct _NvMemoryObj NvMemoryObj;
typedef struct _EventObj EventObj;
typedef struct _NvDeviceType NvDeviceType;
typedef struct _VblankHandlerInfo VblankHandlerInfo;
typedef struct
{
	NvV32               classNumber;
	NvV32               status;
	NvV32               objectNew;
	NvV32               objectParent;
	NvV32               ignored[12];
} NvClassAllocParameters;
struct _ClassInfo
{
	NvV32               num;
	char               *label;
	int                 instanceSize;
	unsigned int        initialObjectMask;
	int                 maxErrors;
	ObjectInfo          objectInfo;
	NvV32               (*ctrlClassInstance) (GenericObj *, Nv0000ControlParameters *);
	NvV32               (*allocClassInstance) (GenericObj *, NvClassAllocParameters *);
	NvV32               (*attachClassInstance) (GenericObj *, NvClassAllocParameters *);
	NvV32               (*realizeClassInstance) (GenericObj *, NvClassAllocParameters *);
	NvV32               (*freeClassInstance) (GenericObj *);
	NvV32               (*detachClassInstance) (GenericObj *);
	NvV32               (*unrealizeClassInstance) (GenericObj *);
	unsigned int        classTableSize;
	ClassInfo         **classTable;
	unsigned int        methodListSize;
	MethodInfo         *methodList;
};
struct _GenericObj
{
	NvV32               name;
	ClassInfo          *classInfo;
	unsigned int        mask;
	GenericObj         *parent;
	NODE                node;
	GenericObj         *next;
	GenericObj         *prev;
	GenericObj         *childList;
	int                 refcnt;
	Nv0001Error        *errorBase;
	NvV32               errorBaseId;
	int                 errorWrite;
	int                 errorRead;
	NvV32               memoryId;
	NvV32               pad;
};
typedef struct _NvDeviceFuncTable
{
	NvV32               (*devSupported) (NvP64 *);
	NvV32               (*devInit) (NvDeviceInfo **, NvP64 *, NvP64 *);
	NvV32               (*devCleanup) (NvDeviceInfo *);
	NvV32               (*devIntrsAlloc) (NvDeviceInfo *);
	NvV32               (*devIntrsFree) (NvDeviceInfo *);
	NvV32               (*devIntrsPending) (NvDeviceInfo *, NvV32 *, NvV32 *);
	void                (*devServiceIntrs) (NvDeviceInfo *, NvV32);
	NvV32               (*devChangeState) (NvDeviceInfo *, int);
	int                 placeholder;
} NvDeviceFuncTable;
typedef struct _NvArchDevFuncTable
{
	int                 (*nvArchRegisterDeviceType) (NvDeviceType *);
	void                (*nvArchFreeObjectChildren) (GenericObj *);
	GenericObj         *(*nvArchLookupObjectByName) (NvSession *, NvV32);
	NvSession          *(*nvArchGetSessionFromObject) (GenericObj *);
	int                 placeholder;
} NvArchDevFuncTable;
extern NvArchDevFuncTable *nvArchDevFuncTable;
typedef struct _NvDeviceInterrupt
{
	NvV32               number;
	NvV32               interruptId;
	NvV32               latency;
} NvDeviceInterrupt;
struct _NvDeviceType
{
	int                 version;
	char               *label;
	NvArchInfo        **archAddr;
	NvArchDevFuncTable **archDevFuncAddr;
	NvDeviceFuncTable  *func;
	unsigned long      *chipIds;
};
struct _VblankHandlerInfo
{
	void                (*vblankHandler) (GenericObj *);
	GenericObj         *object;
	VblankHandlerInfo  *link;
};
struct _NvDeviceInfo
{
	NvV32               memoryId;
	ClassInfo          *classInfo;
	NvP64               nvPhysAddr;
	NvP64               fbPhysAddr;
	NvP64               imPhysAddr;
	NvV32               nvSize;
	NvV32               imSize;
	void               *nvAddr;
	NvV32               nvAddrId;
	void               *imAddr;
	NvV32               imAddrId;
	NvDeviceInterrupt  *interrupts;
	NvV32               interruptCount;
	NvV32               interruptsMemoryId;
	NvV32               fbmemLockId;
	VblankHandlerInfo  *vhandlers;
};
struct _NvDevice
{
	NvP64               deviceBase[6];
	NvV32               deviceId;
	NvDeviceInfo       *deviceInfo;
	NvDeviceType       *deviceType;
};
typedef struct _NvDeviceObj
{
	GenericObj          base;
	NvDevice           *device;
} NvDeviceObj;
struct _NvRootObj
{
	GenericObj          base;
	NvV32               flags;
	NvU32               errorCount;
	Nv0001Error        *errorTable;
	NvU32               errorTableSz;
	NvV32               errorTableId;
};
struct _NvMemoryObj
{
	GenericObj          base;
	NvU64               limit;
	NvP64               kernAddr;
	NvP64               usrAddr;
	NvP64               physAddr;
	NvV32               kernId;
	NvV32               usrId;
	NvMemoryObj        *link;
};
struct _NvSession
{
	NvRootObj           root;
	NvV32               memoryId;
	NODE               *objectSpace;
	NvV32               sessionId;
	NvV32               lockId;
	NvArchInfo         *arch;
	NvSession          *prev;
	NvSession          *next;
};
struct _NvArchInfo
{
	int                 state;
	int                 version;
	NvArchDevFuncTable *archDevFuncTable;
	int                 numDeviceTypes;
	NvDeviceType       *deviceTypeTable[4];
	int                 numDevices;
	NvDevice            deviceTable[8];
	NvSession          *sessionList;
	int                 numSessions;
};
extern NvArchInfo   nvArchInfo;
extern NvV32        nvArchLockIdNext;
extern NvV32        nvArchMemoryIdNext;
extern NvV32        nvArchMappingIdNext;
extern NvV32        nvArchRequestId (NvV32);
extern NvV32        nvArchInterruptAlloc (NvDeviceInfo *, NvV32);
extern NvV32        nvArchInterruptFree (NvDeviceInfo *, NvV32);
extern NvV32        nvArchLockAllocSpin (NvV32);
extern NvV32        nvArchLockAllocSleep (NvV32);
extern NvV32        nvArchLockFree (NvV32);
extern NvV32        nvArchLockAcquire (NvV32);
extern NvV32        nvArchLockRelease (NvV32);
extern NvV32        nvArchMemoryAllocKernel (NvP64 *, NvU64, NvV32 *);
extern NvV32        nvArchMemoryFree (NvV32);
extern NvV32        nvArchMappingAllocPhysToKern (NvP64 *, NvU64, NvV32, NvV32 *);
extern NvV32        nvArchMappingAllocUserToKern (NvP64 *, NvU64, NvV32, NvV32 *);
extern NvV32        nvArchMappingAllocPhysToUser (NvP64 *, NvU64, NvV32, NvV32 *);
extern NvV32        nvArchMappingFree (NvV32);
extern NvV32        nvArchContextDmaSystemAlloc (NvP64, NvU64, NvV32 *, NvP64, NvV32, NvV32 *);
extern NvV32        nvArchContextDmaSystemFree (NvV32);
extern NvV32        nvArchTime (NvU64 *);
extern NvSession   *nvArchGetSessionFromId (NvV32);
extern NvSession   *nvArchGetSessionFromObject (GenericObj *);
extern NvDevice    *nvArchGetDeviceFromId (NvV32);
extern NvDevice    *nvArchGetDeviceFromInfo (NvDeviceInfo *);
extern NvV32        nvArchAllocRoot (NvSession *, NvClassAllocParameters *);
extern NvV32        nvArchAllocObject (NvSession *, NvClassAllocParameters *, GenericObj **,
	GenericObj **);
extern NvV32        nvArchAttachObject (NvSession *, NvClassAllocParameters *, GenericObj *,
	GenericObj *);
extern NvV32        nvArchRealizeObject (NvSession *, NvClassAllocParameters *, GenericObj *);
extern void         nvArchFreeObject (NvSession *, GenericObj *);
extern void         nvArchDetachObject (NvSession *, GenericObj *);
extern void         nvArchUnrealizeObject (NvSession *, GenericObj *);
extern void         nvArchFreeAllObjects (NvSession *);
extern NvV32        nvArchDestroyObject (GenericObj *);
extern NvU32        nvArchGetErrors (NvRootObj *, NvV32);
extern ClassInfo    nvRootClassInfo;
extern ClassInfo    nvMappingSystemClassInfo;
extern ClassInfo   *nvRootChildClassTable[];
extern void         nvArchValidateDriver (NvSession *);
extern unsigned int osNumEventClasses;
extern ClassInfo   *osEventClassTable[];
extern NvU64        mulU64 (NvU64, NvU64);
extern NvU64        mulU64ULong (NvU64, unsigned long);
extern NvU64        addU64 (NvU64, NvU64);
extern NvU64        subU64 (NvU64, NvU64);
extern NvU64        addU64ULong (NvU64, unsigned long);
extern NvU64        subU64ULong (NvU64, unsigned long);
extern NvU64        shiftU64right (NvU64, unsigned long);
extern NvU64        shiftU64left (NvU64, unsigned long);
extern NvU64        andU64ULong (NvU64, unsigned long);
extern int          cmpU64 (NvU64, NvU64);
extern int          cmpU64ULong (NvU64, unsigned long);
typedef struct _EngineObj EngineObj;
typedef struct _EngineObjInfo EngineObjInfo;
typedef struct _NvChannelObj NvChannelObj;
typedef struct _NvChannelPioObj NvChannelPioObj;
typedef struct _Nv03ChannelDmaObj Nv03ChannelDmaObj;
typedef struct _Nv04ChannelDmaObj Nv04ChannelDmaObj;
typedef struct _TimerObj TimerObj;
typedef struct _CursorObj CursorObj;
typedef struct _DacObj DacObj;
typedef struct _NvContextDmaObj NvContextDmaObj;
typedef NvV32       (*MethodFunc) (EngineObj *object, MethodInfo *method, NvV32 offset, NvV32 data,
	int cause);
typedef int         (*ValidateGrObjectFunc) (EngineObj *obj);
struct _NvContextDmaObj
{
	GenericObj          base;
	NvV32               contextDmaId;
	NvV32               flags;
	NvV32               usrFlags;
	NvU64               offset;
	NvU64               limit;
	NvMemoryObj        *memoryObj;
	NvV32               instOffset;
	NvV32               pteCount;
	NvV32               pteAdjust;
	NvV32               pteLimit;
	NvP64               pteBase;
	NvOs8e0Info        *info;
	NvV32               infoId;
	NvV32               mappingId;
};
struct _EngineObjInfo
{
	NvV32               hashContextMask;
	NvV32               channelAllocMask;
	NvV32               instanceMem[3];
	ValidateGrObjectFunc validateForHardware;
};
struct _EngineObj
{
	GenericObj          base;
	NvV32               instMemLoc;
	NvV32               context;
	int                 hashEntry;
	NvU32               subChannel;
	NvContextDmaObj    *notifyCtxDma;
};
typedef struct
{
	NvDeviceInfo       *device;
	int                 inUse;
	unsigned int        id;
	EngineObj          *subChannel[8];
	NvChannelObj       *object;
} NvChannelInfo;
struct _NvChannelObj
{
	GenericObj          base;
	NvChannelInfo      *channel;
	EngineObj          *nullObj;
};
struct _NvChannelPioObj
{
	NvChannelObj        channel;
	NvU32               size;
	NvV32               flags;
	void               *kernAddr;
	NvV32               kernId;
	void               *usrAddr;
	NvV32               usrId;
	NvU64               limit;
};
typedef struct _JumpEntry JumpEntry;
struct _JumpEntry
{
	NvU32               dmaOffset;
	NvU32               jumpOffset;
};
struct _Nv03ChannelDmaObj
{
	NvChannelObj        channel;
	NvContextDmaObj    *pushBuffer;
	NvU32               put;
	NvU32               get;
	JumpEntry           jumpTable[1];
};
struct _Nv04ChannelDmaObj
{
	NvChannelObj        channel;
	NvContextDmaObj    *pushBuffer;
	NvU32               put;
	NvU32               get;
};
typedef struct _GrRenderObj
{
	EngineObj           base;
	NvV32               ctxSwitch;
	EngineObj          *ctxBeta1;
	EngineObj          *ctxPattern;
	EngineObj          *ctxClip;
	EngineObj          *ctxRop;
	EngineObj          *ctxSurfaces2d;
} GrRenderObj;
typedef struct _GrDxTexTriObj
{
	EngineObj           base;
	EngineObj          *ctxSurfaces3d;
} GrDxTexTriObj;
typedef struct _GrDx3TexTriObj
{
	GrDxTexTriObj       base;
	EngineObj          *ctxClip;
	NvContextDmaObj    *ctxDmaTexture;
} GrDx3TexTriObj;
typedef struct _GrDx5TexTriObj
{
	GrDxTexTriObj       base;
	NvContextDmaObj    *ctxDmaA;
	NvContextDmaObj    *ctxDmaB;
} GrDx5TexTriObj;
typedef struct _GrImageObj
{
	GrRenderObj         base;
	EngineObj          *ctxColorKey;
} GrImageObj;
typedef struct _GrImageFromMemObj
{
	GrRenderObj         base;
	NvContextDmaObj    *ctxDmaImage;
} GrImageFromMemObj;
typedef struct _GrNv03Surfaces2dObj
{
	EngineObj           base;
	NvU32               colorFormat;
	NvU32               srcPitch;
	NvU32               destPitch;
	NvU32               offsetSrc;
	NvU32               offsetDest;
	NvContextDmaObj    *ctxDmaDestin;
	NvContextDmaObj    *ctxDmaSource;
	NvV32               notifyType;
} GrNv03Surfaces2dObj;
typedef struct _GrNv03Surfaces3dObj
{
	EngineObj           base;
	NvU32               pitch;
	NvU32               offsetColor;
	NvU32               offsetZeta;
	NvContextDmaObj    *ctxDmaSurface;
	NvV32               notifyType;
} GrNv03Surfaces3dObj;
typedef struct _GrNv04Surfaces3dObj
{
	EngineObj           base;
	NvContextDmaObj    *ctxDmaColor;
	NvContextDmaObj    *ctxDmaZeta;
} GrNv04Surfaces3dObj;
typedef struct _GrMemToMemObj
{
	EngineObj           base;
	NvContextDmaObj    *ctxDmaBufferIn;
	NvContextDmaObj    *ctxDmaBufferOut;
} GrMemToMemObj;
struct _CursorObj
{
	EngineObj           base;
	NvV32               notifyType;
};
struct _DacObj
{
	EngineObj           base;
	NvU32               flags;
	NvU32               portId;
	NvContextDmaObj    *setCtxDmaImage[2];
	struct
	{
		NvU32               offset;
		NvU16               pitch;
		NvV16               color;
		NvV32               notifyType;
	} setImage[2];
	NvContextDmaObj    *setCtxDmaCursor[2];
	struct
	{
		NvU32               offset;
		NvU16               x;
		NvU16               y;
		NvV32               notifyType;
	} setCursor[2];
	struct
	{
		NvU16               imageWidth;
		NvU16               imageHeight;
		NvU16               hSyncWidth;
		NvU16               hSyncStart;
		NvU16               hSyncPolarity;
		NvU16               vSyncWidth;
		NvU16               vSyncStart;
		NvU16               vSyncPolarity;
		NvU16               totalHeight;
		NvU16               totalWidth;
		NvV32               notifyType;
		NvU16               cachedPitch;
	} setDac[2];
	NvContextDmaObj    *setCtxDmaLut[2];
	NvU32               setPixelClock;
	NvU32               limitBandwidth;
	NvU32               limitPixelClock;
	NvU32               overheadImage;
	NvU32               overheadCursor;
	VblankHandlerInfo   vinfo;
};
typedef NvV32       (*TimerProc) (TimerObj *object);
struct _TimerObj
{
	EngineObj           base;
	NvV32               flags;
	NvU32               state;
	NvU32               userLo;
	NvU32               userHi;
	NvU32               alarmLo;
	NvU32               alarmHi;
	TimerProc           callback;
	NvV32               notifyType;
};
typedef struct _TimerCallback TimerCallback;
struct _TimerCallback
{
	TimerProc           callback;
	TimerObj           *timerObj;
	NvU32               timeLo;
	NvU32               timeHi;
	TimerCallback      *next;
};
typedef struct _VideoVbiPortObj VideoVbiPortObj;
struct _VideoVbiPortObj
{
	EngineObj           base;
	NvU32               imageStartLine;
	struct
	{
		NvU32               state;
		NvContextDmaObj    *ctxDmaVbi;
		NvU32               firstLine;
		NvU32               height;
		NvU32               offset;
		NvU32               pitch;
		NvU32               field;
		NvV32               notifyType;
	} vbi[2];
	struct
	{
		NvU32               state;
		NvContextDmaObj    *ctxDmaImage;
		NvU32               widthIn;
		NvU32               heightIn;
		NvU32               widthOut;
		NvU32               heightOut;
		NvU32               offset;
		NvU32               pitch;
		NvU32               field;
		NvV32               notifyType;
	} image[2];
};
typedef struct _DataOutputPortObj DataOutputPortObj;
struct _DataOutputPortObj
{
	EngineObj           base;
	struct
	{
		NvU32               state;
		NvContextDmaObj    *ctxDmaData;
		NvU32               offset;
		NvU32               length;
		NvV32               notifyType;
	} data[2];
};
typedef struct _VideoInputPortObj VideoInputPortObj;
struct _VideoInputPortObj
{
	EngineObj           base;
	struct
	{
		NvU32               state;
		NvContextDmaObj    *ctxDmaImage;
		NvU32               field;
		NvU32               width;
		NvU32               height;
		NvU32               offset;
		NvU32               pitch;
		NvV32               notifyType;
	} image[2];
};
typedef struct _IntrPortObj IntrPortObj;
struct _IntrPortObj
{
	EngineObj           base;
	NvU32               state;
	NvV32               notifyType[2];
};
typedef struct _IoPortObj IoPortObj;
struct _IoPortObj
{
	EngineObj           base;
	struct
	{
		NvU32               dataSize;
		NvU32               addressSize;
		NvU32               address;
		NvU32               data;
	} write;
	struct
	{
		NvU32               dataSize;
		NvU32               addressSize;
		NvU32               address;
		NvV32               notifyType;
	} read;
};
struct _MethodInfo
{
	MethodFunc          func;
	char               *label;
	NvV32               begin;
	NvV32               end;
};
extern void         dmaPushSetParms (Nv03ChannelDmaObj *, NvU32 *, NvU32 *);
extern void         dmaPushStart (Nv03ChannelDmaObj *, NvU32, NvU32);
extern Nv03ChannelDmaObj *dmaPushSchedule (NvDeviceInfo *, NvU32);
extern NvV32        classSoftwareMethod (EngineObj *, NvU32, NvV32, int);
extern NvV32        ctrlSoftwareMethod (NvDeviceInfo *, NvU32, NvU32, NvU32, NvV32);
extern void         dacNotify (DacObj *, int, int, NvU32, NvV32);
extern void         dacCalcPClkVClkRatio (NvDeviceInfo *);
extern void         dacVblankHandler (GenericObj *);
extern NvU32        dacGetScanline (NvDeviceInfo *);
extern void         dacImageOnOff (NvDeviceInfo *, int);
extern void         dacCursorOnOff (NvDeviceInfo *, int);
extern void         dacOnOff (NvDeviceInfo *, int);
extern void         dacSetPixelClock (NvDeviceInfo *, NvU32);
extern int          dacEnableImageScan (DacObj *);
extern NvU32        dacCalcMNP (NvDeviceInfo *, NvU16 *);
extern NvV32        dacChangeState (NvDeviceInfo *, int);
extern unsigned int objectToChID (EngineObj *);
extern char        *objClassLabel (GenericObj *);
extern void         zeroMemory (NvU32 *, NvV32);
extern NvV32        devDmaAllocate (NvDeviceInfo *, NvContextDmaObj *);
extern void         devDmaFree (NvDeviceInfo *, NvContextDmaObj *);
extern NvV32        dmaChangeState (NvDeviceInfo *, int);
extern void         nvFunc313 (NvDeviceInfo *);
extern void         fbService (NvDeviceInfo *);
extern NvV32        fbAllocInstMemAlign (NvDeviceInfo *, NvV32 *, NvV32 *, NvV32, int);
extern NvV32        fbAllocInstMem (NvDeviceInfo *, NvV32 *, NvV32 *, int);
extern NvV32        fbFreeInstMem (NvDeviceInfo *, NvV32, NvV32);
extern NvV32        fbInit (NvDeviceInfo *);
extern NvV32        fbChangeState (NvDeviceInfo *, int);
extern NvS32        fbCalcScreenMemSize (NvDeviceInfo *);
extern NvV32        fifoService (NvDeviceInfo *);
extern void         fifoSetupNv03Channel (NvDeviceInfo *, unsigned int);
extern void         fifoCloseDownNv03Channel (NvChannelInfo *);
extern void         fifoSetupNv03ChannelPio (NvDeviceInfo *, unsigned int, NvV32);
extern void         fifoSetupNv04ChannelDma (NvDeviceInfo *, unsigned int, Nv04ChannelDmaObj *);
extern void         fifoCloseDownNv03Channel (NvChannelInfo *);
extern void         fifoAddHashEntry (NvDeviceInfo *, EngineObj *);
extern void         fifoRemoveHashEntry (NvDeviceInfo *, EngineObj *);
extern void         fifoRemoveObjectFromSubChannelCache (EngineObj *);
extern void         fifoInitSubChannelCache (NvChannelInfo *);
extern EngineObj   *fifoInstMemLocToObject (NvDeviceInfo *, NvU32, NvU32, NvU32);
extern NvContextDmaObj *fifoInstMemLocToContextDma (NvDeviceInfo *, NvU32, NvU32);
extern NvV32        fifoResend (NvDeviceInfo *, EngineObj *, NvU32, NvV32);
extern NvV32        fifoFlushContext (NvDeviceInfo *, NvU32);
extern NvV32        fifoInit (NvDeviceInfo *);
extern NvV32        fifoChangeState (NvDeviceInfo *, int);
extern void         grNotify (EngineObj *, int, int, NvV32);
extern NvV32        grService (NvDeviceInfo *);
extern NvV32        nvFunc461 (NvDeviceInfo *);
extern void         nvFunc464 (NvDeviceInfo *, EngineObj *);
extern void         grInitChannelContext (NvDeviceInfo *, NvU32);
extern NvV32        grLoadChannelContext (NvDeviceInfo *, NvU32);
extern NvV32        grInit (NvDeviceInfo *);
extern NvV32        grNv5HandleDataError (EngineObj *, NvU32, NvU32, NvU32);
extern NvV32        grNv5HandleStateInvalid (EngineObj *, NvU32, NvU32, NvU32);
NvV32               grAttachObject (EngineObj *);
NvV32               grDetachObject (GenericObj *);
extern NvV32        grChangeState (NvDeviceInfo *, int);
extern void         grUpdateSurfaceDest (EngineObj *);
extern void         grUpdateSurfaceSrc (EngineObj *);
extern void         grCanvasCtxSwitch (EngineObj *);
extern NvV32        i2cRead (NvDeviceInfo *, NvU8, NvU16, NvU8 *, NvU16, NvU8 *);
extern NvV32        i2cWrite (NvDeviceInfo *, NvU8, NvU16, NvU8 *, NvU16, NvU8 *);
extern NvV32        i2cRead_ALT (NvDeviceInfo *, NvU8, NvU16, NvU8 *);
extern NvV32        i2cWrite_ALT (NvDeviceInfo *, NvU8, NvU16, NvU8 *);
extern NvV32        i2cRead_ALT2 (NvDeviceInfo *, NvU8, NvU16, NvU8 *, NvU16, NvU8 *);
extern NvV32        devIntrsPending (NvDeviceInfo *, NvV32 *, NvV32 *);
extern void         devServiceIntrs (NvDeviceInfo *, NvV32);
extern void         mcService (NvDeviceInfo *);
extern NvV32        mcInit (NvDeviceInfo *);
extern NvV32        mcChangeState (NvDeviceInfo *, int);
extern NvV32        mpService (NvDeviceInfo *);
extern NvV32        mpInit (NvDeviceInfo *);
extern NvV32        mpChangeState (NvDeviceInfo *, int);
extern void         nvFunc727 (EngineObj *, NvContextDmaObj *, int, int, int, int, NvV32);
extern int          nvFunc544 (GenericObj *, int ndx);
extern NvV32        nvAllocNv01Null (NvChannelObj *);
extern NvV32        nvAttachNv01Null (NvChannelObj *);
extern NvV32        nvFreeNv01Null (NvChannelObj *);
extern NvV32        nvDetachNv01Null (NvChannelObj *);
extern void         errorWrite (GenericObj *, NvV32, NvV32, NvV32, NvU32, NvU32);
extern NvV32        devChangeState (NvDeviceInfo *, int);
extern NvV32        nvFunc608 (GenericObj *, NvClassAllocParameters *);
extern NvV32        swAttachEngineObject (GenericObj *, NvClassAllocParameters *);
extern NvV32        nvFunc611 (GenericObj *);
extern NvV32        swDetachEngineObject (GenericObj *);
extern void         tmrDelay (NvDeviceInfo *, unsigned int);
extern void         tmrGetCurrentTime (NvDeviceInfo *, NvU32 *, NvU32 *);
extern NvV32        tmrService (NvDeviceInfo *);
extern NvV32        tmrInit (NvDeviceInfo *);
extern NvV32        tmrChangeState (NvDeviceInfo *, int);
extern NvU64        devMulU64 (NvU64, NvU64);
extern NvU64        devMulU64ULong (NvU64, unsigned long);
extern NvU64        devAddU64 (NvU64, NvU64);
extern NvU64        devSubU64 (NvU64, NvU64);
extern NvU64        devAddU64ULong (NvU64, unsigned long);
extern NvU64        devSubU64ULong (NvU64, unsigned long);
extern NvU64        devShiftU64right (NvU64, unsigned long);
extern NvU64        devShiftU64left (NvU64, unsigned long);
extern NvU64        devAndU64ULong (NvU64, unsigned long);
extern int          devCmpU64 (NvU64, NvU64);
extern int          devCmpU64ULong (NvU64, unsigned long);
extern void         devAddVblankHandler (NvDeviceInfo *, GenericObj *, void (*)(GenericObj *),
	VblankHandlerInfo *);
extern void         devReleaseVblankHandler (NvDeviceInfo *, GenericObj *);
extern void         devVblank (NvDeviceInfo *);
extern void         nvFunc312 (NvDeviceInfo *);
extern void         nvFunc315 (NvDeviceInfo *);
extern void         nvFunc316 (NvDeviceInfo *);
extern void         nvFunc314 (NvDeviceInfo *);
