 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-2000 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/



#include <statements.h>
#include <nvtypes.h>
#include <nvhw32.h>
#include <nvos32.h>
#include "common1.h"
#include "common2.h"


static int
allocChannelId (NvDeviceInfo *device)
{
	HwDeviceInfo       *hwdev = (HwDeviceInfo *) device;
	HwChannelInfo      *channelList = hwdev->channel;
	int                 i;

	;
	for (i = 0; i < 16; i++)
	{
		if (!channelList[i].base.inUse)
		{
			int                 j;

			for (j = 0; j < 8; j++)
			{
				channelList[i].base.subChannel[j] = (void *) 0;
			}
			;
			return i;
		}
	}
	;
	return -1;
}
static NvV32
freeChannel (GenericObj *obj)
{
	(nvArchDevFuncTable->nvArchFreeObjectChildren) (obj);
	(void) nvFreeNv01Null ((NvChannelObj *) obj);
	return 0;
}
static NvV32
nv03AllocChannelPio (GenericObj *obj, NvClassAllocParameters *alloc)
{
	Nv006aAllocParameters *allocChannel = (Nv006aAllocParameters *) alloc;
	NvChannelPioObj    *channelObj = (NvChannelPioObj *) obj;
	NvV32               status;

	;
	if (devCmpU64ULong (allocChannel->limit, (0x7c - 1)) < 0)
	{
		;
		return (0x00000005);
	}
	if (devCmpU64ULong (allocChannel->limit, 0x1ff) > 0)
		(&allocChannel->limit)->high = 0, (&allocChannel->limit)->low = (NvU32) (0x1ff);
	else
		(&allocChannel->limit)->high = 0, (&allocChannel->limit)->low =
			(NvU32) ((0x7c - 1));
	channelObj->size = (unsigned long) (&allocChannel->limit)->low + 1;
	status = nvAllocNv01Null ((NvChannelObj *) obj);
	if (status != 0)
	{
		;
		return (0x00000002);
	}
	return (NV_PMC_BOOT_0);
}
static NvV32
nv03AttachChannelPio (GenericObj *obj, NvClassAllocParameters *alloc)
{
	NvChannelPioObj    *channelObj = (NvChannelPioObj *) obj;
	NvDeviceObj        *deviceObj = (NvDeviceObj *) channelObj->channel.base.parent;
	NvDeviceInfo       *deviceInfo;
	HwDeviceInfo       *hwdev;
	NvChannelInfo      *channelInfo;
	NvV32               status;
	int                 chid;

	;
	deviceInfo = deviceObj->device->deviceInfo;
	hwdev = (HwDeviceInfo *) deviceInfo;
	chid = allocChannelId (deviceInfo);
	if (chid < 0)
	{
		return (0x00000002);
	}
	fifoSetupNv03ChannelPio (deviceInfo, chid, channelObj->size);
	grInitChannelContext (deviceInfo, chid);
	channelInfo = &hwdev->channel[chid].base;
	fifoInitSubChannelCache (channelInfo);
	channelObj->channel.channel = channelInfo;
	channelObj->channel.channel->inUse = 1;
	channelObj->channel.channel->object = &channelObj->channel;
	status = nvAttachNv01Null ((NvChannelObj *) obj);
	if (status != 0)
	{
		;
		return (0x00000002);
	}
	return (NV_PMC_BOOT_0);
}
static NvV32
nv03RealizeChannelPio (GenericObj *obj, NvClassAllocParameters *alloc)
{
	NvChannelPioObj    *channelPioObj = (NvChannelPioObj *) obj;
	NvDeviceObj        *deviceObj;
	NvDeviceInfo       *deviceInfo;
	NvV32               status,
	                    mappingId;
	Nv006aAllocParameters *allocChannel = (Nv006aAllocParameters *) alloc;
	int                 chid = channelPioObj->channel.channel->id;
	void               *physAddr;
	NvP64               base;

	deviceObj = (NvDeviceObj *) channelPioObj->channel.base.parent;
	deviceInfo = deviceObj->device->deviceInfo;
	physAddr =
		(void *) ((&deviceInfo->nvPhysAddr)->low + (0 ? 0x00FFFFFF : 0x00800000) +
		(chid << 16));
	;
	(&channelPioObj->limit)->high = 0, (&channelPioObj->limit)->low = (NvU32) (64 * 1024 - 1);
	(&base)->low = (unsigned long) (physAddr);
	status = nvArchMappingAllocPhysToKern (&base, channelPioObj->limit, (NV_PMC_BOOT_0),
		&mappingId);
	if (status != (NV_PMC_BOOT_0))
	{
		;
		return (0x00000002);
	}
	channelPioObj->kernAddr = (void *) (&base)->low;
	channelPioObj->kernId = mappingId;
	(&base)->low = (unsigned long) (physAddr);
	status = nvArchMappingAllocPhysToUser (&base, channelPioObj->limit, (NV_PMC_BOOT_0),
		&mappingId);
	if (status != (NV_PMC_BOOT_0))
	{
		;
		return (0x00000002);
	}
	channelPioObj->usrAddr = (void *) (&base)->low;
	channelPioObj->usrId = mappingId;
	allocChannel->base = base;
	return (NV_PMC_BOOT_0);
}
static NvV32
nv03DetachChannelPio (GenericObj *obj)
{
	NvChannelPioObj    *channelPioObj = (NvChannelPioObj *) obj;

	;
	fifoCloseDownNv03Channel (channelPioObj->channel.channel);
	channelPioObj->channel.channel->inUse = 0;
	(void) nvDetachNv01Null ((NvChannelObj *) obj);
	return (NV_PMC_BOOT_0);
}
static NvV32
nv03UnrealizeChannelPio (GenericObj *obj)
{
	NvChannelPioObj    *channelPioObj = (NvChannelPioObj *) obj;

	;
	;
	;
	if (channelPioObj->usrAddr)
	{
		(void) nvArchMappingFree (channelPioObj->usrId);
		channelPioObj->usrAddr = 0;
	}
	if (channelPioObj->kernAddr)
	{
		(void) nvArchMappingFree (channelPioObj->kernId);
		channelPioObj->kernAddr = 0;
	}
	return (NV_PMC_BOOT_0);
}
extern void         nvFunc397 (NvDeviceInfo *);
static NvV32
nv03PioControl (GenericObj *obj, Nv0000ControlParameters * parms)
{
	NvChannelPioObj    *channelPioObj = (NvChannelPioObj *) obj;
	Nv006aControlParameters *params = (Nv006aControlParameters *) parms;
	NvChannelInfo      *channelInfo = channelPioObj->channel.channel;
	NvDeviceInfo       *device = channelInfo->device;
	HwReg              *hwreg = ((((HwDeviceInfo *) device))->base.nvAddr);
	Nv006aChannel      *channel;

	;
	channel = (Nv006aChannel *) channelPioObj->kernAddr;
	;
	;
	if ((channel->subchannel[0].Free == 0x7c)
		&& (((hwreg)->Reg32[(NV_PGRAPH_STATUS) / 4]) == 0))
		params->info = (NV_PMC_BOOT_0);
	else
		params->info = (0x00000001);
	return (NV_PMC_BOOT_0);
}
static NvV32
nv03AllocChannelDma (GenericObj *obj, NvClassAllocParameters *alloc)
{
	NvV32               status;

	;
	status = nvAllocNv01Null ((NvChannelObj *) obj);
	if (status != 0)
	{
		;
		return (0x00000002);
	}
	return (NV_PMC_BOOT_0);
}
static NvV32
nv03AttachChannelDma (GenericObj *obj, NvClassAllocParameters *alloc)
{
	Nv03ChannelDmaObj  *channelObj = (Nv03ChannelDmaObj *) obj;
	NvSession          *session = nvArchGetSessionFromObject (obj);
	Nv006bAllocParameters *allocChannel = (Nv006bAllocParameters *) alloc;
	NvDeviceObj        *deviceObj = (NvDeviceObj *) channelObj->channel.base.parent;
	NvDeviceInfo       *deviceInfo;
	HwDeviceInfo       *hwdev;
	NvChannelInfo      *channelInfo;
	GenericObj         *pushBufferObj;
	NvContextDmaObj    *ctxDmaObj;
	NvV32               status;
	int                 chid;

	;
	deviceInfo = deviceObj->device->deviceInfo;
	hwdev = (HwDeviceInfo *) deviceInfo;
	chid = allocChannelId (deviceInfo);
	if (chid < 0)
	{
		return (0x00000002);
	}
	pushBufferObj =
		(nvArchDevFuncTable->nvArchLookupObjectByName) (session,
		allocChannel->objectBuffer);
	if (pushBufferObj == (void *) 0)
	{
		;
		return (0x00000005);
	}
	if (pushBufferObj->classInfo->num != (0x00000002))
	{
		;
		return (0x00000005);
	}
	;
	ctxDmaObj = (NvContextDmaObj *) pushBufferObj;
	if (!(((ctxDmaObj->memoryObj->base.classInfo->num) == (0x0000003E))
			&& ((((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) % 32)) & (0xFFFFFFFF >> (31 -
								((1 ? 7 : 4) % 32) +
								((0 ? 7 : 4) % 32)))) ==
					(NV_PMC_BOOT_0))
				|| (((ctxDmaObj->usrFlags >> ((0 ? 7 : 4) %
								32)) & (0xFFFFFFFF >> (31 -
								((1 ? 7 : 4) % 32) +
								((0 ? 7 : 4) % 32)))) ==
					(0x00000001)))))
	{
		;
		;
		return (0x00000005);
	}
	if ((allocChannel->offset & 0x3)
		|| (allocChannel->offset > (unsigned long) (&ctxDmaObj->limit)->low - 3))
	{
		;
		return (0x00000006);
	}
	channelObj->get = allocChannel->offset;
	channelObj->put = channelObj->get;
	channelObj->jumpTable[0].dmaOffset = (NvU32) -1;
	channelObj->jumpTable[0].jumpOffset = 0;
	fifoSetupNv04ChannelDma (deviceInfo, chid, (Nv04ChannelDmaObj *) channelObj);
	grInitChannelContext (deviceInfo, chid);
	channelInfo = &hwdev->channel[chid].base;
	fifoInitSubChannelCache (channelInfo);
	channelObj->channel.channel = channelInfo;
	channelObj->channel.channel->inUse = 1;
	channelObj->channel.channel->object = &channelObj->channel;
	channelObj->pushBuffer = (NvContextDmaObj *) pushBufferObj;
	pushBufferObj->refcnt++;
	;
	status = nvAttachNv01Null ((NvChannelObj *) obj);
	if (status != 0)
	{
		;
		return (0x00000002);
	}
	return (NV_PMC_BOOT_0);
}
static NvV32
nv03DetachChannelDma (GenericObj *obj)
{
	Nv03ChannelDmaObj  *channelObj = (Nv03ChannelDmaObj *) obj;

	;
	fifoCloseDownNv03Channel (channelObj->channel.channel);
	channelObj->pushBuffer->base.refcnt--;
	;
	channelObj->pushBuffer = (void *) 0;
	channelObj->channel.channel->inUse = 0;
	(void) nvDetachNv01Null ((NvChannelObj *) obj);
	return 0;
}
static NvV32
nv03DmaControl (GenericObj *obj, Nv0000ControlParameters * parms)
{
	return 0;
}
ClassInfo          *Nv03ChannelChildClassTable[] =
	{ &Nv01ContextColorKeyClassInfo, &Nv01ContextBeta1ClassInfo, &Nv01ContextPatternClassInfo,
		&Nv01ContextClipRectClassInfo, &Nv01RenderSolidLinClassInfo,
		&Nv01RenderSolidTriClassInfo, &Nv01RenderSolidRectClassInfo,
		&Nv01ImageFromCpuClassInfo, &Nv01ContextRopClassInfo, &Nv03Surfaces2dClassInfo,
		&Nv03Surfaces3dClassInfo, &Nv03VideoLutCursorDacClassInfo, &Nv01TimerClassInfo,
		&Nv01ImageBlitClassInfo, &Nv03StretchedImageFromCpuClassInfo,
		&Nv03ScaledImageFromMemoryClassInfo, &Nv03Dx3TexturedTriangleClassInfo,
		&Nv03GdiRectangleTextClassInfo, };
ClassInfo           Nv03ChannelPioClassInfo = {
	(0x0000006A), "nv03 pio channel", sizeof (NvChannelPioObj), 0x4, 1, (void *) 0,
		nv03PioControl, nv03AllocChannelPio, nv03AttachChannelPio, nv03RealizeChannelPio,
		freeChannel, nv03DetachChannelPio, nv03UnrealizeChannelPio,
		(sizeof (Nv03ChannelChildClassTable) / sizeof (Nv03ChannelChildClassTable[0])),
		Nv03ChannelChildClassTable, 0, (void *) 0
};
ClassInfo           Nv03ChannelDmaClassInfo = {
	(0x0000006B), "nv03 dma channel", sizeof (Nv03ChannelDmaObj), 0x4, 1, (void *) 0,
		nv03DmaControl, nv03AllocChannelDma, nv03AttachChannelDma, (void *) 0, freeChannel,
		nv03DetachChannelDma, (void *) 0,
		(sizeof (Nv03ChannelChildClassTable) / sizeof (Nv03ChannelChildClassTable[0])),
		Nv03ChannelChildClassTable, 0, (void *) 0
};
