/*
   This file is based on:
   $XFree86: xc/programs/Xserver/hw/xfree86/drivers/chips/util/AsmMacros.h,v 1.1 2001/11/16 21:13:34 tsi Exp $
   Modified for readability by Nick Kurshev
*/

#ifndef __ASM_MACROS_POWERPC_H
#define __ASM_MACROS_POWERPC_H

#if defined(Lynx) || defined(__OpenBSD__)

extern unsigned char *ioBase;

static volatile void eieio()
{
	__asm__ __volatile__ ("eieio");
}

static void dha2_ports_direct_outb(unsigned port, unsigned char value)
{
	*(unsigned char *)(ioBase + port) = value; eieio();
}

static void dha2_ports_direct_outw(unsigned port, unsigned short value)
{
	*(unsigned short *)(ioBase + port) = value; eieio();
}

static void dha2_ports_direct_outl(unsigned port, unsigned long value)
{
	*(unsigned long *)(ioBase + port) = value; eieio();
}

static unsigned char dha2_ports_direct_inb(unsigned port)
{
	unsigned char val;
	val = *((unsigned char *)(ioBase + port)); eieio();
	return(val);
}

static unsigned short dha2_ports_direct_inw(unsigned port)
{
	unsigned short val;
	val = *((unsigned short *)(ioBase + port)); eieio();
	return(val);
}

static unsigned long dha2_ports_direct_inl(unsigned port)
{
	unsigned long val;
	val = *((unsigned long *)(ioBase + port)); eieio();
	return(val);
}

#endif

#endif
