#ifndef DIRECT_IO_H
#define DIRECT_IO_H

/* This header includes per-OS file which allow direct port access */

#if defined (linux)
#include "io/io_linux.c"
#elif defined (__NetBSD__) || defined (MACH386)
#include "io/io_devio.c"
#elif defined (__NetBSD__) || defined (__OpenBSD__)
#include "io/io_i386_iopl.c"
#elif defined (__FreeBSD__) || defined (__386BSD__) || defined (__bsdi__)
#include "io/io_kdenabio.c"
#elif defined (Lynx)
#include "io/io_lynx.c"
#elif defined (__EMX__)
#include "io/io_os2.c"
#elif defined (ISC) || defined (SCO) || defined (__SVR4)
#include "io/io_sysi86.c"
#elif defined (_WIN32) || defined(__CYGWIN__)
#include "io/io_win32.c"
#endif

#endif

