#if defined(__i386__) && defined (__linux__)
/*
    Direct Hardware Access library --- MTRR driver for Linux
    Copyright (C) 2002  Nick Kurshev
    Copyright (C) 2004  Dmitry Baryshkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "dha2.h"
#include "dha2_internal.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>


static int mtrr_fd = -1;

extern dha2_mtrr_driver_t dha2_mtrr_linux_mtrr;

static int dha2_mtrr_linux_init(void)
{
	errno = 0;

	if (mtrr_fd != -1)
		return 0;

	mtrr_fd = open ("/proc/mtrr", O_WRONLY);

	if (mtrr_fd == -1)
	{
		dha2_mtrr_linux_mtrr.status = -1;
		return -1;
	}

	dha2_mtrr_linux_mtrr.status = 1;
	return 0;
}

static void dha2_mtrr_linux_shutdown(void)
{
	if (mtrr_fd != -1)
	{
		dha2_mtrr_linux_mtrr.status = 0;
		close(mtrr_fd);
		mtrr_fd = -1;
	}
}

	
static int dha2_mtrr_linux_mtrr_set_type(unsigned base, unsigned size, int type)
{
	char * stype;
	char sout[256];
	switch(type)
	{
		case MTRR_TYPE_UNCACHABLE: stype = "uncachable"; break;
		case MTRR_TYPE_WRCOMB:     stype = "write-combining"; break;
		case MTRR_TYPE_WRTHROUGH:  stype = "write-through"; break;
		case MTRR_TYPE_WRPROT:     stype = "write-protect"; break;
		case MTRR_TYPE_WRBACK:     stype = "write-back"; break;
		default:                   return EINVAL;
	}

	snprintf(sout, 256, "base=0x%08X size=0x%08X type=%s\n", base, size, stype);
	
	write(mtrr_fd, sout, strlen(sout));

	return errno;
}

dha2_mtrr_driver_t dha2_mtrr_linux_mtrr =
{
	.name = "procfs linux driver (MTRR)",
	.status = 0,

	.init = dha2_mtrr_linux_init,
	.shutdown = dha2_mtrr_linux_shutdown,
	.mtrr_set_type = dha2_mtrr_linux_mtrr_set_type,
};

#endif /* __i386__  && __linux __ */
