package org.jbookreader.book.bom.impl;

import org.jbookreader.book.bom.IContainerNode;
import org.jbookreader.book.bom.IImageNode;
import org.jbookreader.book.bom.ISectioningNode;

/**
 * This class represents an abstract section.
 * 
 * @author Dmitry Baryshkov (dbaryshkov@gmail.com)
 *
 */
class SectioningNode extends ContainerNode implements ISectioningNode {
	
	/**
	 * The title of the section.
	 */
	private IContainerNode myTitle;
	/**
	 * The list of epigraphs.
	 */
//	private List<IContainerNode> myEpigraph = new LinkedList<IContainerNode>();
	/**
	 * Associated image.
	 */
	private IImageNode myImage;
	/**
	 * Annotation of the section.
	 */
	private IContainerNode myAnnotation;
	
	/**
	 * The parent sectioning node.
	 */
	private ISectioningNode myParentSection;

	public IContainerNode getTitle() {
		return this.myTitle;
	}
	
//	public Collection<IContainerNode> getEpigraph() {
//		return Collections.unmodifiableCollection(this.myEpigraph);
//	}

	public IImageNode getImage() {
		return this.myImage;
	}

	@Override
	public boolean isSectioningNode() {
		return true;
	}

	public IContainerNode getAnnotation() {
		return this.myAnnotation;
	}

	public ISectioningNode newSectioningNode(String tagName) {
		SectioningNode node = new SectioningNode();
		node.setTagName(tagName);
		this.addChildNode(node);
		node.myParentSection = this;
		return node;
	}

	public ISectioningNode getParentSection() {
		return this.myParentSection;
	}

	public IContainerNode newTitle(String tagName) {
		ContainerNode node = new ContainerNode();
		node.setTagName(tagName);
		this.addChildNode(node);
		this.myTitle = node;
		return node;
	}

//	public IContainerNode newEpigraph(String tagName) {
//		ContainerNode node = new ContainerNode();
//		node.setTagName(tagName);
//		this.addChildNode(node);
////		this.myEpigraph.add(node);
//		return node;
//	}

	public IImageNode newImage(String tagName) {
		ImageNode node = new ImageNode();
		node.setTagName(tagName);
		this.addChildNode(node);
		this.myImage = node;
		return node;
	}

	public IContainerNode newAnnotation(String tagName) {
		ContainerNode node = new ContainerNode();
		node.setTagName(tagName);
		this.addChildNode(node);
		this.myAnnotation = node;
		return node;
	}

}
