/*
   This file is based on:
   $XFree86: xc/programs/Xserver/hw/xfree86/drivers/chips/util/AsmMacros.h,v 1.1 2001/11/16 21:13:34 tsi Exp $
   Modified for readability by Nick Kurshev
*/

#ifndef __ASM_MACROS_X86_H
#define __ASM_MACROS_X86_H

static void dha2_ports_direct_outb(unsigned port, unsigned char  val)
{
   __asm__ __volatile__("outb %0,%w1" : :"a" (val), "d" (port));
    return;
}

static void dha2_ports_direct_outw(unsigned port, unsigned short  val)
{
   __asm__ __volatile__("outw %0,%w1" : :"a" (val), "d" (port));
    return;
}

static void dha2_ports_direct_outl(unsigned port, unsigned int  val)
{
   __asm__ __volatile__("outl %0,%w1" : :"a" (val), "d" (port));
    return;
}

static unsigned char dha2_ports_direct_inb(unsigned port)
{
   unsigned char ret = 0;

   __asm__ __volatile__("inb %w1,%0" :
       "=a" (ret) :
       "d" (port));
   return ret;
}

static unsigned short dha2_ports_direct_inw(unsigned port)
{
   unsigned short ret = 0;

   __asm__ __volatile__("inw %w1,%0" :
       "=a" (ret) :
       "d" (port));
   return ret;
}

static unsigned int dha2_ports_direct_inl(unsigned port)
{
   unsigned int ret = 0;

   __asm__ __volatile__("inl %w1,%0" :
       "=a" (ret) :
       "d" (port));
   return ret;
}

#endif
