/*
   This file is based on:
   $XFree86: xc/programs/Xserver/hw/xfree86/etc/scanpci.c,v 3.34.2.17 1998/11/10 11:55:40 dawes Exp $
   Modified for readability by Nick Kurshev
*/

#include <errno.h>
#include <sys/types.h>
#ifdef __NetBSD__
#include <sys/param.h>
#include <sys/file.h>
#ifndef GCCUSESGAS
#define GCCUSESGAS
#endif
#else
#define USE_I386_IOPL
#endif
#include <machine/sysarch.h>

#if defined (USE_I386_IOPL)
static int start_port_access(void)
{
    if (i386_iopl(1) < 0) {
	perror("i386_iopl");
	return(errno);
    }
    return(0);
}

static int stop_port_access(void)
{
    if (i386_iopl(0) < 0) {
	perror("i386_iopl");
	return(errno);
    }
    return(0);
}
#endif /* defined (USE_I386_IOPL) */
