/*
   This file is based on:
   $XFree86: xc/programs/Xserver/hw/xfree86/etc/scanpci.c,v 3.34.2.17 1998/11/10 11:55:40 dawes Exp $
   Modified for readability by Nick Kurshev
*/

#include <errno.h>

#ifdef __NetBSD__
#include <sys/param.h>
#include <sys/file.h>
#include <machine/sysarch.h>
#if !defined(USE_I386_IOPL)
#define DHA_DEV_IO "/dev/io"
#endif
#ifndef GCCUSESGAS
#define GCCUSESGAS
#endif
#else
#define DHA_DEV_IO "/dev/iopl"
#endif

static int io_fd;

static int start_port_access(void)
{
    io_fd = -1 ;
    if ((io_fd = open(DHA_DEV_IO, O_RDWR, 0)) < 0) {
        perror(DHA_DEV_IO);
        return(errno);
    }
    return(0);
}

static int stop_port_access(void)
{
    close(io_fd);
    return(0);
}
