#ifndef DHA2_H
#define DHA2_H

/*
    Direct Hardware Access library.
    Copyright (C) 2004  Dmitry Baryshkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#define DHA_PORTS_DRIVER	1
#define DHA_MTRR_DRIVER		2
#define DHA_PCI_DRIVER		4
#define DHA_MMAP_DRIVER		8

int init_drivers(void);		/* init drivers for all types of DHA.
				   returns a mask with failed drivers set. */

void close_drivers(void);	/* close all initialized drivers. */

/* In/out ports */
unsigned char dha2_inb(unsigned port);
unsigned short dha2_inw(unsigned port);
unsigned int dha2_inl(unsigned port);
void dha2_outb(unsigned port, unsigned char value);
void dha2_outw(unsigned port, unsigned short value);
void dha2_outl(unsigned port, unsigned int value);
/* Compatibility */
#define INPORT8 dha2_inb
#define INPORT16 dha2_inw
#define INPORT32 dha2_inl
#define OUTPORT8 dha2_outb
#define OUTPORT16 dha2_outw
#define OUTPORT32 dha2_outl

/*  These are the region types  */
#define MTRR_TYPE_UNCACHABLE 0
#define MTRR_TYPE_WRCOMB     1
#define MTRR_TYPE_WRTHROUGH  4
#define MTRR_TYPE_WRPROT     5
#define MTRR_TYPE_WRBACK     6
/* Set up MTRR */
int mtrr_set_type(unsigned base, unsigned size, int type);

#define MAX_DEV_PER_VENDOR_CFG1 64
#define MAX_PCI_DEVICES_PER_BUS 32
#define MAX_PCI_DEVICES         64
#define PCI_MULTIFUNC_DEV	0x80
#define PCI_COMMAND_IO          0x1     /* Enable response to I/O space */

typedef struct pciinfo_s
{
  int		bus,card,func;			/* PCI/AGP bus:card:func */
  unsigned short command;                       /* Device control register */
  unsigned short vendor,device;			/* Card vendor+device ID */
  unsigned	base0,base1,base2,baserom;	/* Memory and I/O base addresses */
//  unsigned	base0_limit, base1_limit, base2_limit, baserom_limit;
} pciinfo_t;

/* PCI functions */
int pci_scan(pciinfo_t *pci_list,unsigned *num_pci);
int pci_config_read_long(unsigned char bus, unsigned char dev, int func, unsigned cmd);

/* Memory mapping/unmapping */
void* map_phys_mem(unsigned long base, unsigned long size);
void unmap_phys_mem(void * base, unsigned long size);

/* Enables/disables accessing to IO space from application side.
   Should return 0 if o'k or errno on error. */
int enable_app_io(void);
int disable_app_io(void);

int pci_config_read(unsigned char bus, unsigned char dev, unsigned char func,
                    unsigned char cmd, int len, unsigned long *val);

#ifndef MAP_FAILED
#define MAP_FAILED	((void *) -1)
#endif

#endif
