/*
   This file is based on:
   $XFree86: xc/programs/Xserver/hw/xfree86/etc/scanpci.c,v 3.34.2.17 1998/11/10 11:55:40 dawes Exp $
   Modified for readability by Nick Kurshev
   Reworked by Dmitry Baryshkov
*/

/* Warning: It won't work if port access is done through svgalib kernel helper. */

#include "dha2.h"
#include "dha2_internal.h"

extern dha2_pci_driver_t dha2_pci_generic_pci;

static int dha2_pci_generic_init(void)
{
	dha2_pci_generic_pci.status = 1;
	return 0;
}

static void dha2_pci_generic_shutdown(void)
{
	dha2_pci_generic_pci.status = 0;
}

static int dha2_pci_generic_pci_config_type( void )
{
  unsigned long tmplong1, tmplong2;
  unsigned char tmp1, tmp2;
  int retval;
    retval = 0;
 
    dha2_outb(PCI_MODE2_ENABLE_REG, 0x00);
    dha2_outb(PCI_MODE2_FORWARD_REG, 0x00);
    tmp1 = dha2_inb(PCI_MODE2_ENABLE_REG);
    tmp2 = dha2_inb(PCI_MODE2_FORWARD_REG);
    if ((tmp1 == 0x00) && (tmp2 == 0x00)) {
	retval = 2;
        /*printf("PCI says configuration type 2\n");*/
    } else {
        tmplong1 = dha2_inl(PCI_MODE1_ADDRESS_REG);
        dha2_outl(PCI_MODE1_ADDRESS_REG, PCI_EN);
        tmplong2 = dha2_inl(PCI_MODE1_ADDRESS_REG);
        dha2_outl(PCI_MODE1_ADDRESS_REG, tmplong1);
        if (tmplong2 == PCI_EN) {
	    retval = 1;
            /*printf("PCI says configuration type 1\n");*/
	} else {
            /*printf("No PCI !\n");*/
	    disable_os_io();
	    /*exit(1);*/
	    retval = 0xFFFF;
	}
    }
  return retval;
}

static int dha2_pci_generic_pci_get_vendor
          (unsigned char bus,
          unsigned char dev,
          int func)
{
    unsigned long config_cmd;
    config_cmd = PCI_EN | (bus<<16) | (dev<<11) | (func<<8);
    dha2_outl(PCI_MODE1_ADDRESS_REG, config_cmd);
    return dha2_inl(PCI_MODE1_DATA_REG);
}

static int dha2_pci_generic_pci_config_read_long
          (unsigned char bus,
          unsigned char dev,
          int func, 
          unsigned cmd)
{
    unsigned long config_cmd;
    config_cmd = PCI_EN | (bus<<16) | (dev<<11) | (func<<8);
    dha2_outl(PCI_MODE1_ADDRESS_REG, config_cmd | cmd);
    return dha2_inl(PCI_MODE1_DATA_REG);
}

dha2_pci_driver_t dha2_pci_generic_pci =
{
	.name = "generic driver using port access (PCI)",
	.status = 0,
	.init = dha2_pci_generic_init,
	.shutdown = dha2_pci_generic_shutdown,

	.pci_config_type = dha2_pci_generic_pci_config_type,
	.pci_config_read_long = dha2_pci_generic_pci_config_read_long,
	.pci_get_vendor = dha2_pci_generic_pci_get_vendor,
};
