#if defined(__i386__) && defined (__NetBSd__)
/*
	Direct Hardware Access library --- MTRR driver for NetBSD
	Copyright (C) 2002  Nick Kurshev
	Copyright (C) 2004  Dmitry Baryshkov

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "dha2.h"
#include "dha2_internal.h"

#include <sys/param.h>
#if __NetBSD_Version__ > 105240000
#include <stdint.h>
#include <stdlib.h>
#include <machine/mtrr.h>
#include <machine/sysarch.h>
#endif

#include <errno.h>

extern dha2_mtrr_driver_t dha2_mtrr_netbsd_mtrr;

static int dha2_mtrr_netbsd_init(void)
{
#if __NetBSD_Version__ > 105240000
	errno = 0;
	dha2_mtrr_netbsd_mtrr.status = 1;
	return 0;
#else
	errno = ENOSYS;
	dha2_mtrr_netbsd_mtrr.status = -1;
	return -1;
#endif
}

static void dha2_mtrr_netbsd_shutdown(void)
{
	dha2_mtrr_netbsd_mtrr.status = 0;
}

	
static int dha2_mtrr_netbsd_mtrr_set_type(unsigned base, unsigned size, int type)
{
#if __NetBSD_Version__ > 105240000
	struct mtrr *mtrrp;
	int n;

	mtrrp = malloc(sizeof (struct mtrr));
	mtrrp->base = base;
	mtrrp->len = size;
	mtrrp->type = type;  
	mtrrp->flags = MTRR_VALID | MTRR_PRIVATE;
	n = 1;

	if (i386_set_mtrr(mtrrp, &n) < 0)
	{
		free(mtrrp);
		return errno;
	}
	free(mtrrp);
	return 0;
#else
	return ENOSYS;
#endif
}

dha2_mtrr_driver_t dha2_mtrr_netbsd_mtrr =
{
	.name = "NetBSD driver (MTRR)",
	.status = 0,

	.init = dha2_mtrr_netbsd_init,
	.shutdown = dha2_mtrr_netbsd_shutdown,
	.mtrr_set_type = dha2_mtrr_netbsd_mtrr_set_type,
};

#endif /* __i386__  && __linux __ */
