/*
 * mctun - mud compression tunnel.
 * Copyright (C) 2003 Dmitry Baryshkov <mitya@school.ioffe.ru>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef MCCP_H_

#ifdef __cplusplus
extern "C"
{
#endif

	struct mccp_handle_s;
	typedef struct mccp_handle_s mccp_handle;

	mccp_handle * mccp_init(int level, int windowBits);
	/* 
	 * level:
	 * 0-9 - compression levels
	 * -1 - default level
	 * -2 - uncomress
	 */

	void mccp_finalize(mccp_handle *mc);

	int mccp_recv(mccp_handle *mc, char *data, int len, char**answer);

	int mccp_send(mccp_handle *mc, char *data, int len, char**answer);

	void mccp_stats(mccp_handle *mc, int *ret_in, int *ret_out);
#ifdef __cplusplus
}
#endif

#endif
