/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.book.stylesheet.impl;

import java.util.HashMap;
import java.util.Map;
import org.jbookreader.book.bom.IContainerNode;
import org.jbookreader.book.bom.IImageNode;
import org.jbookreader.book.bom.INode;
import org.jbookreader.book.stylesheet.EDisplayType;
import org.jbookreader.book.stylesheet.IStyleSheet;

public class FB2StyleSheet
implements IStyleSheet {
    private Map<String, EDisplayType> myDisplayTypes = new HashMap<String, EDisplayType>();
    private static final String[] FB2_BLOCK_TAGS = new String[]{"body", "section", "title", "p", "v", "empty-line", "abstract", "epigraph"};
    private static final String[] FB2_INLINE_TAGS = new String[]{"strong", "emphasis", "strikethrough", "sub", "sup", "code", "a", "#text"};

    public FB2StyleSheet() {
        for (String s : FB2_INLINE_TAGS) {
            this.myDisplayTypes.put(s, EDisplayType.INLINE);
        }
        for (String s : FB2_BLOCK_TAGS) {
            this.myDisplayTypes.put(s, EDisplayType.BLOCK);
        }
    }

    public EDisplayType getNodeDisplayType(INode node) {
        if (this.myDisplayTypes.containsKey(node.getTagName())) {
            return this.myDisplayTypes.get(node.getTagName());
        }
        if (node instanceof IImageNode) {
            for (IContainerNode cnode = node.getParentNode(); cnode != null; cnode = cnode.getParentNode()) {
                if (this.getNodeDisplayType(cnode) == EDisplayType.INLINE) {
                    return EDisplayType.INLINE;
                }
                if (!cnode.getTagName().equals("p") && !cnode.getTagName().equals("v") && !cnode.getTagName().equals("subtitle") && !cnode.getTagName().equals("text-author") && !cnode.getTagName().equals("coverpage")) continue;
                return EDisplayType.INLINE;
            }
            return EDisplayType.BLOCK;
        }
        System.err.println("Got unknown tag: '" + node.getTagName() + "'! Check your parser version, please");
        return EDisplayType.BLOCK;
    }

    public double getLeftMargin(INode node) {
        return 5.0;
    }

    public double getFirstLineMargin(INode node) {
        return 10.0;
    }

    public double getRightMargin(INode node) {
        return 5.0;
    }
}

