/*
 * Decompiled with CFR 0.152.
 */
package org.jbookreader.book.bom.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jbookreader.book.bom.IBinaryData;
import org.jbookreader.book.bom.IBook;
import org.jbookreader.book.bom.IContainerNode;
import org.jbookreader.book.bom.INode;
import org.jbookreader.book.bom.impl.BinaryData;
import org.jbookreader.book.bom.impl.ContainerNode;
import org.jbookreader.book.stylesheet.IStyleSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Book
implements IBook {
    private IStyleSheet mySystemStyleSheet;
    private Map<String, IContainerNode> myBodies = new LinkedHashMap<String, IContainerNode>();
    private Map<String, INode> myIDmap = new LinkedHashMap<String, INode>();
    private Map<String, BinaryData> myBinaries = new LinkedHashMap<String, BinaryData>();

    @Override
    public IContainerNode newBody(String tagName, String name) {
        ContainerNode body = new ContainerNode();
        body.setTagName(tagName);
        body.setBook(this);
        this.myBodies.put(name, body);
        return body;
    }

    @Override
    public IContainerNode getMainBody() {
        IContainerNode node = this.myBodies.get(null);
        if (node == null) {
            throw new IllegalStateException("No main body provided");
        }
        return node;
    }

    @Override
    public Collection<IContainerNode> getBodies() {
        return Collections.unmodifiableCollection(this.myBodies.values());
    }

    @Override
    public IBinaryData newBinaryData(String id, String contentType) {
        BinaryData bdata = new BinaryData();
        bdata.setContentType(contentType);
        this.myBinaries.put(id, bdata);
        return bdata;
    }

    @Override
    public IBinaryData getBinaryData(String id) {
        return this.myBinaries.get(id);
    }

    @Override
    public Map<String, ? extends IBinaryData> getBinaryMap() {
        return Collections.unmodifiableMap(this.myBinaries);
    }

    @Override
    public IStyleSheet getSystemStyleSheet() {
        return this.mySystemStyleSheet;
    }

    @Override
    public void setSystemStyleSheet(IStyleSheet systemStyleSheet) {
        this.mySystemStyleSheet = systemStyleSheet;
    }

    @Override
    public INode getNodeByID(String id) {
        return this.myIDmap.get(id);
    }

    void mapIdNode(INode node) {
        String id = node.getID();
        if (id != null) {
            this.myIDmap.put(id, node);
        }
    }
}

