/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.rendering.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.IFont;
import jbookreader.rendering.IGraphicDriver;
import jbookreader.rendering.text.StringBox;
import jbookreader.rendering.text.TextFont;
import jbookreader.style.FontDescriptor;

public class TextRenderer
implements IGraphicDriver {
    private static final int WIDTH = 80;
    private float xPosition;
    private int realXPosition;
    private float yPosition;
    private int realYPosition;
    private PrintStream outStream;

    public TextRenderer() {
        this.outStream = System.out;
    }

    public TextRenderer(String name) throws IOException {
        this.outStream = new PrintStream(name);
    }

    public void addHorizontalSpace(float amount) {
        this.xPosition += amount;
    }

    public void addVerticalSpace(float amount) {
        this.yPosition += amount;
    }

    public void clear() {
        this.outStream.flush();
        this.xPosition = 0.0f;
        this.realXPosition = 0;
        this.yPosition = 0.0f;
        this.realYPosition = 0;
    }

    public int getPaperHeight() {
        return Integer.MAX_VALUE;
    }

    public float getHorizontalPosition() {
        return this.xPosition;
    }

    public float getVerticalPosition() {
        return this.yPosition;
    }

    public int getPaperWidth() {
        return 80;
    }

    public IDrawable renderBox(int width, int height, int depth) {
        throw new UnsupportedOperationException("boxes aren't supported");
    }

    public IDrawable renderString(String s, IFont font) {
        return new StringBox(this, s);
    }

    public IDrawable renderImage(String contentType, InputStream dataStream) {
        throw new UnsupportedOperationException("image rendering isn't supported");
    }

    private void fixPosition() {
        int xp = Math.round(this.xPosition);
        int yp = Math.round(this.yPosition);
        while (this.realYPosition < yp) {
            this.outStream.append('\n');
            ++this.realYPosition;
            this.realXPosition = 0;
        }
        while (this.realXPosition < xp) {
            this.outStream.append(' ');
            ++this.realXPosition;
        }
    }

    void append(String s) {
        this.fixPosition();
        this.outStream.append(s);
        this.xPosition += (float)s.length();
        this.realXPosition += s.length();
    }

    public IFont getFont(FontDescriptor fd) {
        return new TextFont(fd.getFamily(), fd.getSize());
    }
}

