/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.rendering.swing;

import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.Position;
import jbookreader.rendering.swing.AWTFontAdapter;
import jbookreader.rendering.swing.JGraphicDriver;

final class SwingString
implements IDrawable {
    private final JGraphicDriver driver;
    private final TextLayout layout;
    private final float depth;
    private final float height;
    private final float width;

    SwingString(JGraphicDriver driver, String s, AWTFontAdapter font) {
        this.driver = driver;
        this.layout = new TextLayout(s, font.getFont(), this.driver.getFontRC());
        this.depth = this.layout.getDescent();
        this.height = this.layout.getAscent();
        this.width = this.layout.getAdvance();
    }

    public void draw(Position position) {
        Graphics2D g2d = this.driver.getPaperGraphics();
        if (g2d == null) {
            throw new IllegalStateException("draw with g2d = null");
        }
        this.layout.draw(g2d, this.driver.horizontalPosition, this.driver.verticalPosition + this.height);
        this.driver.horizontalPosition += this.width;
    }

    public float getDepth() {
        return this.depth;
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth(Position position) {
        return this.width;
    }
}

