/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.rendering.swing;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import jbookreader.rendering.IFont;
import jbookreader.style.FontDescriptor;

class AWTFontAdapter
implements IFont {
    private final Font font;
    private final float spaceWidth;

    AWTFontAdapter(FontDescriptor fd, FontRenderContext frc) {
        int style = 0;
        if (fd.isBold()) {
            style |= 1;
        }
        if (fd.isItalic()) {
            style |= 2;
        }
        this.font = new Font(fd.getFamily(), style, fd.getSize());
        System.out.println(this.font);
        Rectangle2D r2d = this.font.createGlyphVector(frc, new char[]{' '}).getLogicalBounds();
        this.spaceWidth = (float)(r2d.getMaxX() - r2d.getMinX());
    }

    Font getFont() {
        return this.font;
    }

    public float getSpaceWidth() {
        return this.spaceWidth;
    }

    public String getFamily() {
        return this.font.getFamily();
    }

    public int getSize() {
        return this.font.getSize();
    }

    public boolean isBold() {
        return this.font.isBold();
    }

    public boolean isItalic() {
        return this.font.isItalic();
    }
}

