/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.fileformats.impl;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jbookreader.book.IBook;
import jbookreader.book.IBookFactory;
import jbookreader.book.IContainerNode;
import jbookreader.book.INode;
import jbookreader.book.IStylesheet;
import jbookreader.book.ITextNode;
import jbookreader.css.CSSParser;
import jbookreader.fileformats.IErrorHandler;
import jbookreader.fileformats.IFileFormatDescriptor;
import jbookreader.style.IStyleRule;
import lumag.rtf.IRTFContentHandler;
import lumag.rtf.RTFParser;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RichTextFormat
implements IFileFormatDescriptor {
    private final Collection<String> extensions = new ArrayList<String>();
    private IStylesheet stylesheet;

    public RichTextFormat() {
        this.extensions.add(".rtf");
    }

    @Override
    public IBook parse(String uri, IErrorHandler handler, IBookFactory factory) throws SAXException, IOException {
        int len;
        RTFParser parser = new RTFParser();
        RTFHandler rtfHandler = new RTFHandler(factory, parser);
        parser.setHandler(rtfHandler);
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(uri));
        byte[] buffer = new byte[1024];
        while ((len = ((InputStream)stream).read(buffer)) >= 0) {
            parser.process(buffer, 0, len);
        }
        ((InputStream)stream).close();
        return rtfHandler.getBook();
    }

    @Override
    public String getDescription() {
        return "Rich Text Format";
    }

    @Override
    public Collection<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public IStylesheet getStylesheet() {
        if (this.stylesheet == null) {
            try {
                this.stylesheet = CSSParser.parse("resources/css/rtf.css");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.stylesheet == null) {
            return new IStylesheet(){
                private List<IStyleRule> list = new LinkedList<IStyleRule>();

                @Override
                public List<IStyleRule> getApplicableRules(INode node) {
                    return Collections.unmodifiableList(this.list);
                }
            };
        }
        return this.stylesheet;
    }

    private static class RTFHandler
    implements IRTFContentHandler {
        private final IBookFactory factory;
        private final IBook book;
        private IContainerNode container;
        private final RTFParser parser;
        private Map<String, IControlHandler> controlHandlers = new HashMap<String, IControlHandler>();
        private int unicodeCharLength = 1;
        private int skipChars;
        private int ignoredLevel = Integer.MAX_VALUE;

        public RTFHandler(IBookFactory factory, RTFParser parser) {
            this.factory = factory;
            this.parser = parser;
            this.fillControlHandlers();
            this.book = factory.newBook();
            IContainerNode body = factory.newContainerNode();
            body.setNodeTag("rtf");
            this.book.addBody(body, "");
            this.container = factory.newContainerNode();
            this.container.setNodeTag("par");
            body.add(this.container);
        }

        private void fillControlHandlers() {
            this.controlHandlers.put("rtf", new IControlHandler(){

                public void control(String string, boolean hasParameter, int parameter) {
                    System.out.println("RTF version " + parameter);
                }
            });
            this.controlHandlers.put("ansicpg", new IControlHandler(){

                public void control(String string, boolean hasParameter, int parameter) {
                    RTFHandler.this.parser.setCharacterSet(parameter);
                }
            });
            this.controlHandlers.put("par", new IControlHandler(){

                public void control(String string, boolean hasParameter, int parameter) {
                    IContainerNode node = RTFHandler.this.factory.newContainerNode();
                    node.setNodeTag("par");
                    RTFHandler.this.container.getParentNode().add(node);
                    RTFHandler.this.container = node;
                }
            });
            this.controlHandlers.put("\n", new IControlHandler(){

                public void control(String string, boolean hasParameter, int parameter) {
                    IContainerNode node = RTFHandler.this.factory.newContainerNode();
                    node.setNodeTag("par");
                    RTFHandler.this.container.getParentNode().add(node);
                    RTFHandler.this.container = node;
                }
            });
            this.controlHandlers.put("\r", new IControlHandler(){

                public void control(String string, boolean hasParameter, int parameter) {
                    IContainerNode node = RTFHandler.this.factory.newContainerNode();
                    node.setNodeTag("par");
                    RTFHandler.this.container.getParentNode().add(node);
                    RTFHandler.this.container = node;
                }
            });
            this.controlHandlers.put("uc", new IControlHandler(){

                public void control(String string, boolean hasParameter, int parameter) {
                    RTFHandler.this.unicodeCharLength = parameter;
                }
            });
            this.controlHandlers.put("u", new IControlHandler(){

                public void control(String string, boolean hasParameter, int parameter) {
                    RTFHandler.this.string(Character.valueOf((char)parameter).toString());
                    RTFHandler.this.skipChars = RTFHandler.this.unicodeCharLength;
                }
            });
            this.controlHandlers.put("~", new IControlHandler(){

                public void control(String string, boolean hasParameter, int parameter) {
                    RTFHandler.this.string("\u00a0");
                }
            });
            this.controlHandlers.put(" ", new IControlHandler(){

                public void control(String string, boolean hasParameter, int parameter) {
                    RTFHandler.this.string("\u00a0");
                }
            });
            this.controlHandlers.put("_", new IControlHandler(){

                public void control(String string, boolean hasParameter, int parameter) {
                    RTFHandler.this.string("\u2011");
                }
            });
            this.controlHandlers.put("fonttbl", new IControlHandler(){

                public void control(String string, boolean hasParameter, int parameter) {
                    RTFHandler.this.ignoredLevel = RTFHandler.this.parser.getLevel();
                }
            });
            this.controlHandlers.put("stylesheet", new IControlHandler(){

                public void control(String string, boolean hasParameter, int parameter) {
                    RTFHandler.this.ignoredLevel = RTFHandler.this.parser.getLevel();
                }
            });
            this.controlHandlers.put("pict", new IControlHandler(){

                public void control(String string, boolean hasParameter, int parameter) {
                    RTFHandler.this.ignoredLevel = RTFHandler.this.parser.getLevel();
                }
            });
        }

        public boolean control(String string, boolean hasParameter, int parameter) {
            if (this.parser.getLevel() >= this.ignoredLevel) {
                return true;
            }
            if (this.controlHandlers.containsKey(string)) {
                this.controlHandlers.get(string).control(string, hasParameter, parameter);
                return true;
            }
            return false;
        }

        public void endGroup() {
            if (this.parser.getLevel() <= this.ignoredLevel) {
                this.ignoredLevel = Integer.MAX_VALUE;
            }
        }

        public void startGroup() {
        }

        public void string(String string) {
            if (this.parser.getLevel() >= this.ignoredLevel) {
                return;
            }
            if (string.length() == 0) {
                return;
            }
            if (this.skipChars >= string.length()) {
                this.skipChars -= string.length();
            } else {
                ITextNode node = this.factory.newTextNode();
                node.setText(string.substring(this.skipChars));
                this.container.add(node);
                this.skipChars = 0;
            }
        }

        public IBook getBook() {
            return this.book;
        }

        public void binaryBlob(byte[] bs) {
            --this.skipChars;
        }

        private static interface IControlHandler {
            public void control(String var1, boolean var2, int var3);
        }
    }
}

