/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.fileformats.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import jbookreader.fileformats.IFileFormatDescriptor;
import jbookreader.fileformats.UnknownFormatException;
import jbookreader.fileformats.impl.FictionBook2;
import jbookreader.fileformats.impl.RichTextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFormatsLibrary {
    private static final Collection<IFileFormatDescriptor> FILE_FORMATS = new ArrayList<IFileFormatDescriptor>();

    private FileFormatsLibrary() {
    }

    private static void populateFormats() {
        if (FILE_FORMATS.size() != 0) {
            return;
        }
        FILE_FORMATS.add(new FictionBook2());
        FILE_FORMATS.add(new RichTextFormat());
    }

    public static Collection<IFileFormatDescriptor> getFileFormats() {
        FileFormatsLibrary.populateFormats();
        return Collections.unmodifiableCollection(FILE_FORMATS);
    }

    public static IFileFormatDescriptor getDescriptorForFile(String file) throws UnknownFormatException {
        FileFormatsLibrary.populateFormats();
        for (IFileFormatDescriptor d : FILE_FORMATS) {
            for (String ext : d.getExtensions()) {
                if (!file.endsWith(ext)) continue;
                return d;
            }
        }
        throw new UnknownFormatException();
    }
}

