/*
 * Decompiled with CFR 0.152.
 */
package lumag.util;

import java.io.ByteArrayOutputStream;

public class Base64 {
    public static byte[] decode(String string) {
        int len = string.length();
        ByteArrayOutputStream output = new ByteArrayOutputStream(len * 3 / 4);
        long currentValue = 0L;
        int curChars = 0;
        int skipChars = 0;
        for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if ('A' <= ch && ch <= 'Z') {
                currentValue = (currentValue << 6) + (long)ch - 65L;
            } else if ('a' <= ch && ch <= 'z') {
                currentValue = (currentValue << 6) + (long)ch - 97L + 26L;
            } else if ('0' <= ch && ch <= '9') {
                currentValue = (currentValue << 6) + (long)ch - 48L + 26L + 26L;
            } else if (ch == '+') {
                currentValue = (currentValue << 6) + (long)ch - 43L + 26L + 26L + 10L;
            } else if (ch == '/') {
                currentValue = (currentValue << 6) + (long)ch - 47L + 26L + 26L + 10L + 1L;
            } else if (ch == '=') {
                currentValue <<= 6;
                ++skipChars;
            } else {
                throw new IllegalArgumentException("Bad character encountered: '" + ch + "' (0x" + Integer.toHexString(ch));
            }
            if (++curChars != 4) continue;
            output.write((int)(currentValue >> 16 & 0xFFL));
            if (skipChars < 2) {
                output.write((int)(currentValue >> 8 & 0xFFL));
            }
            if (skipChars < 2) {
                output.write((int)(currentValue >> 0 & 0xFFL));
            }
            curChars = 0;
            skipChars = 0;
            currentValue = 0L;
        }
        return output.toByteArray();
    }
}

