/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.formatengine.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import jbookreader.formatengine.IAdjustableDrawable;
import jbookreader.formatengine.ICompositor;
import jbookreader.formatengine.impl.HBox;
import jbookreader.formatengine.impl.SimpleWhitespace;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.IGraphicDriver;
import jbookreader.rendering.Position;
import jbookreader.style.Alignment;

public class SimpleCompositor
implements ICompositor {
    @Override
    public List<IDrawable> compose(List<IDrawable> particles, int width, Alignment alignment, IGraphicDriver driver) {
        ArrayList<IDrawable> result = new ArrayList<IDrawable>();
        ArrayList<IDrawable> line = new ArrayList<IDrawable>();
        int currentWidth = 0;
        for (IDrawable d : particles) {
            if (line.isEmpty()) {
                line.add(d);
                currentWidth = d.getWidth(Position.START);
                continue;
            }
            if (currentWidth + d.getWidth(Position.END) > width) {
                IDrawable last = (IDrawable)line.get(line.size() - 1);
                currentWidth = currentWidth - last.getWidth(Position.MIDDLE) + last.getWidth(Position.END);
                result.add(this.makeHBox(driver, line, width, alignment, false));
                line.clear();
                line.add(d);
                currentWidth = d.getWidth(Position.START);
                continue;
            }
            if (currentWidth + d.getWidth(Position.MIDDLE) > width) {
                line.add(d);
                currentWidth += d.getWidth(Position.END);
                result.add(this.makeHBox(driver, line, width, alignment, false));
                line.clear();
                currentWidth = 0;
                continue;
            }
            line.add(d);
            currentWidth += d.getWidth(Position.MIDDLE);
        }
        if (!line.isEmpty()) {
            IDrawable last = (IDrawable)line.get(line.size() - 1);
            currentWidth = currentWidth - last.getWidth(Position.MIDDLE) + last.getWidth(Position.END);
            result.add(this.makeHBox(driver, line, width, alignment, true));
            line.clear();
        }
        return result;
    }

    private IDrawable makeHBox(IGraphicDriver driver, List<IDrawable> line, int width, Alignment alignment, boolean last) {
        HBox hbox;
        switch (alignment) {
            case JUSTIFY: {
                hbox = this.makeJustifiedHBox(line, width, last);
                int boxWidth = hbox.getWidth(Position.MIDDLE);
                int defect = width - boxWidth;
                if (defect == 0) break;
                HBox wrapperBox = new HBox();
                wrapperBox.add(hbox);
                wrapperBox.add(new SimpleWhitespace(driver, defect));
                hbox = wrapperBox;
                break;
            }
            case LEFT: {
                hbox = new HBox();
                hbox.addAll(line);
                int boxWidth = hbox.getWidth(Position.MIDDLE);
                int defect = width - boxWidth;
                if (defect == 0) break;
                HBox wrapperBox = new HBox();
                wrapperBox.add(hbox);
                wrapperBox.add(new SimpleWhitespace(driver, defect));
                hbox = wrapperBox;
                break;
            }
            case RIGHT: {
                hbox = new HBox();
                hbox.addAll(line);
                int boxWidth = hbox.getWidth(Position.MIDDLE);
                int defect = width - boxWidth;
                if (defect == 0) break;
                HBox wrapperBox = new HBox();
                wrapperBox.add(new SimpleWhitespace(driver, defect));
                wrapperBox.add(hbox);
                hbox = wrapperBox;
                break;
            }
            case CENTER: {
                hbox = new HBox();
                hbox.addAll(line);
                int boxWidth = hbox.getWidth(Position.MIDDLE);
                int defect = width - boxWidth;
                if (defect == 0) break;
                HBox wrapperBox = new HBox();
                wrapperBox.add(new SimpleWhitespace(driver, defect / 2));
                wrapperBox.add(hbox);
                wrapperBox.add(new SimpleWhitespace(driver, (defect + 1) / 2));
                hbox = wrapperBox;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported alignment type: " + (Object)((Object)alignment));
            }
        }
        return hbox;
    }

    private HBox makeJustifiedHBox(List<IDrawable> line, int width, boolean last) {
        if (last) {
            HBox hbox = new HBox();
            hbox.addAll(line);
            return hbox;
        }
        int currentWidth = 0;
        int currentStretch = 0;
        ListIterator<IDrawable> iter = line.listIterator();
        while (iter.hasNext()) {
            IDrawable d = iter.next();
            currentWidth = iter.previousIndex() == 0 ? (currentWidth += d.getWidth(Position.START)) : (iter.hasNext() ? (currentWidth += d.getWidth(Position.MIDDLE)) : (currentWidth += d.getWidth(Position.END)));
            if (!(d instanceof IAdjustableDrawable)) continue;
            IAdjustableDrawable ad = (IAdjustableDrawable)d;
            if (iter.previousIndex() == 0) {
                currentStretch += ad.getStretch(Position.START);
                continue;
            }
            if (iter.hasNext()) {
                currentStretch += ad.getStretch(Position.MIDDLE);
                continue;
            }
            currentStretch += ad.getStretch(Position.END);
        }
        if (currentStretch == 0) {
            HBox hbox = new HBox();
            hbox.addAll(line);
            return hbox;
        }
        int adjust = width - currentWidth;
        if (adjust < 0) {
            throw new UnsupportedOperationException("Shrinking isn't supported yet");
        }
        int step = adjust / currentStretch;
        int err = 0;
        HBox hbox = new HBox();
        ListIterator<IDrawable> iter2 = line.listIterator();
        while (iter2.hasNext()) {
            IDrawable drawable = iter2.next();
            if (drawable instanceof IAdjustableDrawable) {
                IAdjustableDrawable d = (IAdjustableDrawable)drawable;
                int adj_i = iter2.previousIndex() == 0 ? d.getStretch(Position.START) : (iter2.hasNext() ? d.getStretch(Position.MIDDLE) : d.getStretch(Position.END));
                if (adj_i != 0) {
                    if ((err += 2 * adjust * adj_i - 2 * step * currentStretch) > currentStretch) {
                        err -= 2 * currentStretch;
                        d.adjust(step * adj_i + 1);
                    } else {
                        d.adjust(step * adj_i);
                    }
                }
            }
            hbox.add(drawable);
        }
        return hbox;
    }
}

