/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.formatengine.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jbookreader.book.IBinaryBlob;
import jbookreader.book.IContainerNode;
import jbookreader.book.IImageNode;
import jbookreader.book.INode;
import jbookreader.book.INodeVisitor;
import jbookreader.book.ITextNode;
import jbookreader.formatengine.ICompositor;
import jbookreader.formatengine.IFormatEngine;
import jbookreader.formatengine.impl.Glue;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.IFont;
import jbookreader.rendering.IGraphicDriver;
import jbookreader.style.Display;
import jbookreader.style.IStyleStack;
import jbookreader.style.IStylesheet;

public class FormatEngine
implements IFormatEngine {
    @Override
    public List<IDrawable> format(IGraphicDriver driver, ICompositor compositor, INode node, IStyleStack styleStack) {
        ArrayList<IDrawable> result = new ArrayList<IDrawable>();
        node.accept(new BlockFormattingVisitor(driver, compositor, result, styleStack));
        return result;
    }

    private static class InlineFormattingVisitor
    implements INodeVisitor {
        private final List<IDrawable> result;
        private final IGraphicDriver driver;
        private final IStyleStack styleStack;

        public InlineFormattingVisitor(IGraphicDriver driver, List<IDrawable> result, IStyleStack styleStack) {
            this.driver = driver;
            this.result = result;
            this.styleStack = styleStack;
        }

        @Override
        public boolean visitContainerNode(IContainerNode node) {
            this.styleStack.push(node);
            node.visitChildren(this);
            this.styleStack.pop();
            return false;
        }

        @Override
        public boolean visitTextNode(ITextNode node) {
            int start;
            this.styleStack.push(node);
            IFont font = this.driver.getFont(this.styleStack.getFirstFontFamily(), this.styleStack.getFontSize(), this.styleStack.getFontWeight() > 500, this.styleStack.getFontStyle() != IStylesheet.FontStyle.NORMAL);
            String text = node.getText();
            if (text == null) {
                this.styleStack.pop();
                return false;
            }
            char[] str = text.toCharArray();
            int size = str.length;
            int end = start = 0;
            while (end < size) {
                while (start < size && str[start] <= ' ') {
                    ++start;
                }
                if (start > end) {
                    this.result.add(new Glue(this.driver, font.getSpaceWidth(), 1, 1));
                }
                for (end = start; end < size && str[end] > ' '; ++end) {
                }
                if (end == start) continue;
                String s = new String(str, start, end - start);
                this.result.add(this.driver.renderString(s, font));
                start = end;
            }
            this.styleStack.pop();
            return false;
        }

        @Override
        public boolean visitImageNode(IImageNode node) {
            this.styleStack.push(node);
            String href = node.getHRef();
            if (href.length() >= 1 && href.charAt(0) == '#') {
                IBinaryBlob blob = node.getBook().getBinaryBlob(href.substring(1));
                if (blob != null) {
                    try {
                        this.result.add(this.driver.renderImage(blob.getContentType(), blob.getDataStream()));
                        this.styleStack.pop();
                        return false;
                    }
                    catch (UnsupportedOperationException e) {
                        System.err.println("Error: " + e.getMessage());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                System.err.println("Bad image HRef: " + href);
            }
            this.styleStack.pop();
            return this.visitTextNode(node);
        }
    }

    private static class BlockFormattingVisitor
    implements INodeVisitor {
        private final IGraphicDriver driver;
        private final List<IDrawable> result;
        private final ICompositor compositor;
        private final IStyleStack styleStack;

        public BlockFormattingVisitor(IGraphicDriver driver, ICompositor compositor, List<IDrawable> result, IStyleStack styleStack) {
            this.driver = driver;
            this.compositor = compositor;
            this.result = result;
            this.styleStack = styleStack;
        }

        @Override
        public boolean visitContainerNode(IContainerNode node) {
            this.styleStack.push(node);
            if (this.styleStack.getDisplay() == Display.INLINE) {
                this.styleStack.pop();
                this.formatInline(node.getParentNode());
                return true;
            }
            node.visitChildren(this);
            this.styleStack.pop();
            return false;
        }

        @Override
        public boolean visitTextNode(ITextNode node) {
            this.formatInline(node.getParentNode());
            return true;
        }

        private void formatInline(INode node) {
            ArrayList<IDrawable> drawables = new ArrayList<IDrawable>();
            this.styleStack.pop();
            InlineFormattingVisitor visitor = new InlineFormattingVisitor(this.driver, drawables, this.styleStack);
            node.accept(visitor);
            this.styleStack.push(node);
            List<IDrawable> lines = this.compositor.compose(drawables, this.driver.getPaperWidth(), this.styleStack.getTextAlign(), this.driver);
            this.result.addAll(lines);
        }

        @Override
        public boolean visitImageNode(IImageNode node) {
            this.styleStack.push(node);
            if (this.styleStack.getDisplay() == Display.INLINE) {
                this.styleStack.pop();
                this.formatInline(node.getParentNode());
                return true;
            }
            this.formatInline(node);
            this.styleStack.pop();
            return false;
        }
    }
}

