/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.book.impl;

import java.util.NoSuchElementException;
import jbookreader.book.IContainerNode;
import jbookreader.book.INode;
import jbookreader.book.INodeVisitor;
import jbookreader.book.impl.AbstractNamedNode;
import jbookreader.book.impl.AbstractNode;
import lumag.util.OrderedSet;

public class ContainerNodeImpl
extends AbstractNamedNode
implements IContainerNode {
    private OrderedSet<INode> children = new OrderedSet();

    @Override
    public void add(INode node) {
        if (node.getParentNode() != null) {
            throw new IllegalArgumentException("The node being added is already a part of some book");
        }
        ((AbstractNode)node).setParentNode(this);
        ((AbstractNode)node).setBook(this.getBook());
        this.children.add(node);
    }

    @Override
    public boolean accept(INodeVisitor visitor) {
        return visitor.visitContainerNode(this);
    }

    @Override
    public void visitChildren(INodeVisitor visitor) {
        for (INode node : this.children) {
            boolean stop = node.accept(visitor);
            if (!stop) continue;
            return;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public boolean contains(INode element) {
        return this.children.contains((Object)element);
    }

    @Override
    public INode getNext(INode element) throws NoSuchElementException {
        return this.children.getNext(element);
    }

    @Override
    public INode getPrevious(INode element) throws NoSuchElementException {
        return this.children.getPrevious(element);
    }

    @Override
    public boolean hasNext(INode element) throws NoSuchElementException {
        return this.children.hasNext(element);
    }

    @Override
    public boolean hasPrevious(INode element) throws NoSuchElementException {
        return this.children.hasPrevious(element);
    }

    public String toString() {
        if (this.nodeClass != null) {
            return this.nodeTag + "." + this.nodeClass;
        }
        return this.nodeTag;
    }
}

