/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.rendering.text;

import java.io.InputStream;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.IFont;
import jbookreader.rendering.IGraphicDriver;
import jbookreader.rendering.text.StringBox;

public class TextRenderer
implements IGraphicDriver {
    private static final int WIDTH = 80;
    private int xPosition;
    private int yPosition;
    private IFont textFont;

    @Override
    public void addHorizontalSpace(int amount) {
        for (int i = 0; i < amount; ++i) {
            this.append(" ");
        }
    }

    @Override
    public void addVerticalSpace(int amount) {
        this.yPosition += amount;
    }

    @Override
    public void clear() {
        this.xPosition = 0;
        this.yPosition = 0;
    }

    @Override
    public int getPaperHeight() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getHorizontalPosition() {
        return this.xPosition;
    }

    @Override
    public int getVerticalPosition() {
        return this.yPosition;
    }

    @Override
    public int getPaperWidth() {
        return 80;
    }

    @Override
    public IDrawable renderBox(int width, int height, int depth) {
        throw new UnsupportedOperationException("boxes aren't supported");
    }

    @Override
    public IDrawable renderString(String s, IFont font) {
        return new StringBox(this, s);
    }

    @Override
    public IDrawable renderImage(InputStream dataStream) {
        throw new UnsupportedOperationException("image rendering isn't supported");
    }

    void append(String s) {
        System.out.print(s);
        this.xPosition += s.length();
    }

    @Override
    public IFont getFont(String name, int size) {
        if (this.textFont == null) {
            this.textFont = new TextFont();
        }
        return this.textFont;
    }

    private static class TextFont
    implements IFont {
        private TextFont() {
        }

        @Override
        public int getSpaceWidth() {
            return 1;
        }
    }
}

