/*
 * Decompiled with CFR 0.152.
 */
package jbookreader.formatengine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jbookreader.book.IBinaryBlob;
import jbookreader.book.IContainerNode;
import jbookreader.book.IImageNode;
import jbookreader.book.INode;
import jbookreader.book.INodeVisitor;
import jbookreader.book.ITextNode;
import jbookreader.formatengine.Glue;
import jbookreader.formatengine.ICompositor;
import jbookreader.formatengine.IFormatEngine;
import jbookreader.rendering.IDrawable;
import jbookreader.rendering.IFont;
import jbookreader.rendering.IGraphicDriver;

public class FormatEngine
implements IFormatEngine {
    @Override
    public List<IDrawable> format(IGraphicDriver driver, ICompositor compositor, INode node) {
        ArrayList<IDrawable> result = new ArrayList<IDrawable>();
        node.accept(new BlockFormattingVisitor(driver, compositor, result));
        return result;
    }

    private static class InlineFormattingVisitor
    implements INodeVisitor {
        private final List<IDrawable> result;
        private final IGraphicDriver driver;
        private IFont font;

        public InlineFormattingVisitor(IGraphicDriver driver, List<IDrawable> result) {
            this.driver = driver;
            this.result = result;
            this.font = driver.getFont(null, 12);
        }

        @Override
        public boolean visitContainerNode(IContainerNode node) {
            node.visitChildren(this);
            return false;
        }

        @Override
        public boolean visitTextNode(ITextNode node) {
            int start;
            char[] str = node.getText().toCharArray();
            int size = str.length;
            int end = start = 0;
            while (end < size) {
                while (start < size && str[start] <= ' ') {
                    ++start;
                }
                if (start > end) {
                    this.result.add(new Glue(this.driver, this.font.getSpaceWidth(), 1, 1));
                }
                for (end = start; end < size && str[end] > ' '; ++end) {
                }
                if (end == start) continue;
                String s = new String(str, start, end - start);
                this.result.add(this.driver.renderString(s, this.font));
                start = end;
            }
            return false;
        }

        @Override
        public boolean visitImageNode(IImageNode node) {
            String href = node.getHRef();
            if (href.length() >= 1 && href.charAt(0) == '#') {
                IBinaryBlob blob = node.getBook().getBinaryBlob(href.substring(1));
                if (blob != null) {
                    try {
                        this.result.add(this.driver.renderImage(blob.getDataStream()));
                        return false;
                    }
                    catch (UnsupportedOperationException e) {
                        System.err.println("Error: " + e.getMessage());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                System.err.println("Bad image HRef: " + href);
            }
            return this.visitTextNode(node);
        }
    }

    private static class BlockFormattingVisitor
    implements INodeVisitor {
        private final IGraphicDriver driver;
        private final List<IDrawable> result;
        private final ICompositor compositor;

        public BlockFormattingVisitor(IGraphicDriver driver, ICompositor compositor, List<IDrawable> result) {
            this.driver = driver;
            this.compositor = compositor;
            this.result = result;
        }

        @Override
        public boolean visitContainerNode(IContainerNode node) {
            if (this.isInlineNode(node)) {
                this.formatInline(node.getParentNode());
                return true;
            }
            node.visitChildren(this);
            return false;
        }

        private boolean isInlineNode(IContainerNode node) {
            String tag = node.getNodeTag();
            return tag.equals("strong") || tag.equals("emphasis") || tag.equals("style") || tag.equals("a") || tag.equals("strikethrough") || tag.equals("sub") || tag.equals("sup") || tag.equals("code");
            {
            }
        }

        @Override
        public boolean visitTextNode(ITextNode node) {
            this.formatInline(node.getParentNode());
            return true;
        }

        private void formatInline(INode node) {
            ArrayList<IDrawable> drawables = new ArrayList<IDrawable>();
            InlineFormattingVisitor visitor = new InlineFormattingVisitor(this.driver, drawables);
            node.accept(visitor);
            List<IDrawable> lines = this.compositor.compose(drawables, this.driver.getPaperWidth(), this.driver);
            this.result.addAll(lines);
        }

        @Override
        public boolean visitImageNode(IImageNode node) {
            this.formatInline(node);
            return false;
        }
    }
}

